/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.Util;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class MutableStruct {
    int length;
    STRUCT pickled;
    Datum[] datums;
    Object[] attributes;
    CustomDatumFactory[] old_factories;
    ORADataFactory[] factories;
    int[] sqlTypes;
    boolean pickledCorrect;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    public MutableStruct(STRUCT sTRUCT, int[] nArray, ORADataFactory[] oRADataFactoryArray) {
        this.length = oRADataFactoryArray.length;
        this.pickled = sTRUCT;
        this.factories = oRADataFactoryArray;
        this.sqlTypes = nArray;
        this.pickledCorrect = true;
    }

    public MutableStruct(Object[] objectArray, int[] nArray, ORADataFactory[] oRADataFactoryArray) {
        this.length = oRADataFactoryArray.length;
        this.attributes = objectArray;
        this.factories = oRADataFactoryArray;
        this.sqlTypes = nArray;
        this.pickledCorrect = false;
    }

    public MutableStruct(STRUCT sTRUCT, int[] nArray, CustomDatumFactory[] customDatumFactoryArray) {
        this.length = customDatumFactoryArray.length;
        this.pickled = sTRUCT;
        this.old_factories = customDatumFactoryArray;
        this.sqlTypes = nArray;
        this.pickledCorrect = true;
    }

    public MutableStruct(Object[] objectArray, int[] nArray, CustomDatumFactory[] customDatumFactoryArray) {
        this.length = customDatumFactoryArray.length;
        this.attributes = objectArray;
        this.old_factories = customDatumFactoryArray;
        this.sqlTypes = nArray;
        this.pickledCorrect = false;
    }

    public Datum toDatum(Connection connection, String string) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = new STRUCT(StructDescriptor.createDescriptor(string, connection), connection, this.getDatumAttributes(connection));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Datum toDatum(oracle.jdbc.OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }

    public Datum toDatum(OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }

    public Object getAttribute(int n) throws SQLException {
        Object object = this.getLazyAttributes()[n];
        if (object == null) {
            Datum datum = this.getLazyDatums()[n];
            if (this.old_factories == null) {
                this.attributes[n] = object = Util.convertToObject(datum, this.sqlTypes[n], this.factories[n]);
                if (Util.isMutable(datum, this.factories[n])) {
                    this.resetDatum(n);
                }
            } else {
                this.attributes[n] = object = Util.convertToObject(datum, this.sqlTypes[n], this.old_factories[n]);
                if (Util.isMutable(datum, this.old_factories[n])) {
                    this.resetDatum(n);
                }
            }
        }
        return object;
    }

    public Object getOracleAttribute(int n) throws SQLException {
        Object object;
        if (this.old_factories == null) {
            if (this.factories[n] == null) {
                object = this.getDatumAttribute(n, null);
                Datum datum = this.getLazyDatums()[n];
                if (Util.isMutable(datum, this.factories[n])) {
                    this.pickledCorrect = false;
                }
            } else {
                object = this.getAttribute(n);
            }
        } else if (this.old_factories[n] == null) {
            object = this.getDatumAttribute(n, null);
            Datum datum = this.getLazyDatums()[n];
            if (Util.isMutable(datum, this.old_factories[n])) {
                this.pickledCorrect = false;
            }
        } else {
            object = this.getAttribute(n);
        }
        return object;
    }

    public Object[] getAttributes() throws SQLException {
        for (int i = 0; i < this.length; ++i) {
            this.getAttribute(i);
        }
        return this.attributes;
    }

    public Object[] getOracleAttributes() throws SQLException {
        Object[] objectArray = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            objectArray[i] = this.getOracleAttribute(i);
        }
        return objectArray;
    }

    public void setAttribute(int n, Object object) throws SQLException {
        if (object == null) {
            this.getLazyDatums();
        }
        this.resetDatum(n);
        this.getLazyAttributes()[n] = object;
    }

    public void setDoubleAttribute(int n, double d) throws SQLException {
        this.setAttribute(n, new Double(d));
    }

    public void setFloatAttribute(int n, float f) throws SQLException {
        this.setAttribute(n, new Float(f));
    }

    public void setIntAttribute(int n, int n2) throws SQLException {
        this.setAttribute(n, new Integer(n2));
    }

    public void setOracleAttribute(int n, Object object) throws SQLException {
        if (this.old_factories == null) {
            if (this.factories[n] == null) {
                this.setDatumAttribute(n, (Datum)object);
            } else {
                this.setAttribute(n, object);
            }
        } else if (this.old_factories[n] == null) {
            this.setDatumAttribute(n, (Datum)object);
        } else {
            this.setAttribute(n, object);
        }
    }

    Datum getDatumAttribute(int n, Connection connection) throws SQLException {
        Datum datum = this.getLazyDatums()[n];
        if (datum == null) {
            Object object = this.getLazyAttributes()[n];
            this.datums[n] = datum = Util.convertToOracle(object, connection);
        }
        return datum;
    }

    void setDatumAttribute(int n, Datum datum) throws SQLException {
        this.resetAttribute(n);
        this.getLazyDatums()[n] = datum;
        this.pickledCorrect = false;
    }

    Datum[] getDatumAttributes(Connection connection) throws SQLException {
        for (int i = 0; i < this.length; ++i) {
            this.getDatumAttribute(i, connection);
        }
        return (Datum[])this.datums.clone();
    }

    void resetAttribute(int n) throws SQLException {
        if (this.attributes != null) {
            this.attributes[n] = null;
        }
    }

    void resetDatum(int n) throws SQLException {
        if (this.datums != null) {
            this.datums[n] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyAttributes() {
        if (this.attributes == null) {
            this.attributes = new Object[this.length];
        }
        return this.attributes;
    }

    Datum[] getLazyDatums() throws SQLException {
        if (this.datums == null) {
            if (this.pickled != null) {
                this.datums = this.pickled.getOracleAttributes();
                this.pickledCorrect = true;
                if (this.attributes != null) {
                    for (int i = 0; i < this.length; ++i) {
                        if (this.attributes[i] == null) continue;
                        this.datums[i] = null;
                        this.pickledCorrect = false;
                    }
                }
            } else {
                this.datums = new Datum[this.length];
            }
        }
        return this.datums;
    }
}

