/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DTV;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.StreamRetValue;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;

final class Parameter {
    private TypeInfo typeInfo;
    private String typeDefinition = null;
    private int outScale = 4;
    private String name;
    private DTV getterDTV;
    private static final DTV DTV_NOT_SET_OR_REGISTERED = new DTV();
    private DTV registeredOutDTV = DTV_NOT_SET_OR_REGISTERED;
    private DTV setterDTV = DTV_NOT_SET_OR_REGISTERED;
    private DTV dtv = DTV_NOT_SET_OR_REGISTERED;

    Parameter() {
    }

    TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    boolean isOutput() {
        return DTV_NOT_SET_OR_REGISTERED != this.registeredOutDTV;
    }

    JDBCType getJdbcType() throws SQLServerException {
        return this.setterDTV.getJdbcType();
    }

    private static JDBCType getSSPAUJDBCType(JDBCType jDBCType) {
        switch (jDBCType) {
            case CHAR: {
                return JDBCType.NCHAR;
            }
            case VARCHAR: {
                return JDBCType.NVARCHAR;
            }
            case LONGVARCHAR: {
                return JDBCType.LONGNVARCHAR;
            }
            case CLOB: {
                return JDBCType.NCLOB;
            }
        }
        return jDBCType;
    }

    void registerForOutput(JDBCType jDBCType, SQLServerConnection sQLServerConnection) {
        if (sQLServerConnection.sendStringParametersAsUnicode()) {
            jDBCType = Parameter.getSSPAUJDBCType(jDBCType);
        }
        DTV dTV = this.registeredOutDTV;
        this.registeredOutDTV = new DTV();
        this.registeredOutDTV.setJdbcType(jDBCType);
        if (DTV_NOT_SET_OR_REGISTERED == this.setterDTV || dTV == this.setterDTV) {
            this.setterDTV = this.registeredOutDTV;
        }
        this.resetOutputValue();
    }

    int getOutScale() {
        return this.outScale;
    }

    void setOutScale(int n) {
        this.outScale = n;
    }

    final Parameter cloneForBatch() {
        Parameter parameter = new Parameter();
        parameter.typeInfo = this.typeInfo;
        parameter.typeDefinition = this.typeDefinition;
        parameter.outScale = this.outScale;
        parameter.name = this.name;
        parameter.registeredOutDTV = this.registeredOutDTV;
        parameter.getterDTV = this.getterDTV;
        parameter.setterDTV = this.setterDTV;
        parameter.dtv = this.dtv;
        return parameter;
    }

    final void skipValue(TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.getterDTV) {
            this.getterDTV = new DTV();
        }
        this.deriveTypeInfo(tDSReader);
        this.getterDTV.skipValue(this.typeInfo, tDSReader, bl);
    }

    final void skipRetValStatus(TDSReader tDSReader) throws SQLServerException {
        StreamRetValue streamRetValue = new StreamRetValue();
        streamRetValue.setFromTDS(tDSReader);
    }

    void clearInputValue() {
        this.dtv = this.getterDTV;
        this.setterDTV = this.registeredOutDTV;
    }

    void resetOutputValue() {
        this.getterDTV = null;
        this.dtv = this.setterDTV;
        this.typeInfo = null;
    }

    void deriveTypeInfo(TDSReader tDSReader) throws SQLServerException {
        if (null == this.typeInfo) {
            this.typeInfo = new TypeInfo();
            this.typeInfo.setFromTDS(tDSReader);
            this.dtv = this.getterDTV;
        }
    }

    void setFromReturnStatus(int n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (null == this.getterDTV) {
            this.getterDTV = new DTV();
        }
        this.getterDTV.setValue(null, JDBCType.INTEGER, new Integer(n), null, null, null, sQLServerConnection);
        this.dtv = this.getterDTV;
    }

    void setValue(JDBCType jDBCType, Object object, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (!sQLServerConnection.isYukonOrLater()) {
            switch (jDBCType) {
                case LONGVARBINARY: {
                    jDBCType = JDBCType.VARBINARY;
                    break;
                }
                case LONGVARCHAR: {
                    jDBCType = JDBCType.VARCHAR;
                    break;
                }
                case LONGNVARCHAR: {
                    jDBCType = JDBCType.NVARCHAR;
                    break;
                }
            }
        }
        if (sQLServerConnection.sendStringParametersAsUnicode() && (String.class.isInstance(object) || Reader.class.isInstance(object) || Clob.class.isInstance(object))) {
            jDBCType = Parameter.getSSPAUJDBCType(jDBCType);
        }
        DTV dTV = new DTV();
        dTV.setValue(sQLServerConnection.getDatabaseCollation(), jDBCType, object, streamSetterArgs, calendar, n, sQLServerConnection);
        this.dtv = this.setterDTV = dTV;
    }

    boolean isNull() {
        if (null != this.getterDTV) {
            return this.getterDTV.isNull();
        }
        return false;
    }

    boolean isValueGotten() {
        return null != this.getterDTV;
    }

    Object getValue(JDBCType jDBCType, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TDSReader tDSReader) throws SQLServerException {
        if (null == this.getterDTV) {
            this.getterDTV = new DTV();
        }
        this.deriveTypeInfo(tDSReader);
        return this.getterDTV.getValue(jDBCType, this.outScale, inputStreamGetterArgs, calendar, this.typeInfo, tDSReader);
    }

    int getInt(TDSReader tDSReader) throws SQLServerException {
        Integer n = (Integer)this.getValue(JDBCType.INTEGER, null, null, tDSReader);
        return null != n ? n : 0;
    }

    String getTypeDefinition(SQLServerConnection sQLServerConnection, TDSReader tDSReader) throws SQLServerException {
        if (DTV_NOT_SET_OR_REGISTERED == this.setterDTV) {
            return null;
        }
        this.setterDTV.executeOp(new GetTypeDefinitionOp(this, sQLServerConnection));
        return this.typeDefinition;
    }

    void sendByRPC(TDSWriter tDSWriter, SQLServerConnection sQLServerConnection) throws SQLServerException {
        this.setterDTV.sendByRPC(this.name, sQLServerConnection.getDatabaseCollation(), this.outScale, this.isOutput(), tDSWriter, sQLServerConnection);
    }

    static {
        DTV_NOT_SET_OR_REGISTERED.setJdbcType(JDBCType.UNKNOWN);
    }

    final class GetTypeDefinitionOp
    extends DTVExecuteOp {
        private static final String NVARCHAR_MAX = "nvarchar(max)";
        private static final String NVARCHAR_4K = "nvarchar(4000)";
        private static final String NTEXT = "ntext";
        private static final String VARCHAR_MAX = "varchar(max)";
        private static final String VARCHAR_8K = "varchar(8000)";
        private static final String TEXT = "text";
        private static final String VARBINARY_MAX = "varbinary(max)";
        private static final String VARBINARY_8K = "varbinary(8000)";
        private static final String IMAGE = "image";
        private final Parameter param;
        private final SQLServerConnection con;
        int scale = 0;

        GetTypeDefinitionOp(Parameter parameter2, SQLServerConnection sQLServerConnection) {
            this.param = parameter2;
            this.con = sQLServerConnection;
        }

        private void setTypeDefinition(DTV dTV) {
            switch (dTV.getJdbcType()) {
                case TINYINT: {
                    this.param.typeDefinition = "tinyint";
                    break;
                }
                case SMALLINT: {
                    this.param.typeDefinition = "smallint";
                    break;
                }
                case INTEGER: {
                    this.param.typeDefinition = "int";
                    break;
                }
                case BIGINT: {
                    this.param.typeDefinition = "bigint";
                    break;
                }
                case REAL: 
                case FLOAT: 
                case DOUBLE: {
                    this.param.typeDefinition = "float";
                    break;
                }
                case DECIMAL: 
                case NUMERIC: {
                    Integer n;
                    if (this.scale > 38) {
                        this.scale = 38;
                    }
                    if (null != dTV && null != (n = dTV.getScale()) && this.scale < n) {
                        this.scale = n;
                    }
                    if (this.param.isOutput() && this.scale < this.param.getOutScale()) {
                        this.scale = this.param.getOutScale();
                    }
                    this.param.typeDefinition = "decimal(38," + this.scale + ")";
                    break;
                }
                case BIT: 
                case BOOLEAN: {
                    this.param.typeDefinition = "bit";
                    break;
                }
                case LONGVARBINARY: 
                case BLOB: {
                    this.param.typeDefinition = this.con.isYukonOrLater() ? VARBINARY_MAX : IMAGE;
                    break;
                }
                case BINARY: 
                case VARBINARY: {
                    if (VARBINARY_MAX == this.param.typeDefinition || IMAGE == this.param.typeDefinition) break;
                    this.param.typeDefinition = VARBINARY_8K;
                    break;
                }
                case DATE: 
                case TIME: 
                case TIMESTAMP: {
                    this.param.typeDefinition = "datetime";
                    break;
                }
                case LONGVARCHAR: 
                case CLOB: {
                    this.param.typeDefinition = this.con.isYukonOrLater() ? VARCHAR_MAX : TEXT;
                    break;
                }
                case CHAR: 
                case VARCHAR: {
                    if (VARCHAR_MAX == this.param.typeDefinition || TEXT == this.param.typeDefinition) break;
                    this.param.typeDefinition = VARCHAR_8K;
                    break;
                }
                case LONGNVARCHAR: 
                case NCLOB: {
                    this.param.typeDefinition = this.con.isYukonOrLater() ? NVARCHAR_MAX : NTEXT;
                    break;
                }
                case NCHAR: 
                case NVARCHAR: {
                    if (NVARCHAR_MAX == this.param.typeDefinition || NTEXT == this.param.typeDefinition) break;
                    this.param.typeDefinition = NVARCHAR_4K;
                    break;
                }
                default: {
                    assert (false) : "Unexpected JDBC type " + (Object)((Object)dTV.getJdbcType());
                    break;
                }
            }
        }

        @Override
        void execute(DTV dTV, String string) throws SQLServerException {
            if (null != string && string.length() > 4000) {
                dTV.setJdbcType(JDBCType.LONGNVARCHAR);
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Clob clob) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Byte by) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Integer n) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Time time) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Date date) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Timestamp timestamp) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Float f) throws SQLServerException {
            this.scale = 4;
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Double d) throws SQLServerException {
            this.scale = 4;
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, BigDecimal bigDecimal) throws SQLServerException {
            if (null != bigDecimal) {
                this.scale = bigDecimal.scale();
                if (this.scale < 0) {
                    this.scale = 0;
                }
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Long l) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Short s) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Boolean bl) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, byte[] byArray) throws SQLServerException {
            if (null != byArray && byArray.length > 8000) {
                dTV.setJdbcType(dTV.getJdbcType().isBinary() ? JDBCType.LONGVARBINARY : JDBCType.LONGVARCHAR);
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Blob blob) throws SQLServerException {
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, InputStream inputStream) throws SQLServerException {
            StreamSetterArgs streamSetterArgs = dTV.getStreamSetterArgs();
            JDBCType jDBCType = dTV.getJdbcType();
            if (JDBCType.CHAR == jDBCType || JDBCType.VARCHAR == jDBCType || JDBCType.BINARY == jDBCType || JDBCType.VARBINARY == jDBCType) {
                if (streamSetterArgs.getLength() > 8000L) {
                    dTV.setJdbcType(jDBCType.isBinary() ? JDBCType.LONGVARBINARY : JDBCType.LONGVARCHAR);
                } else if (-1L == streamSetterArgs.getLength()) {
                    byte[] byArray = new byte[8001];
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, byArray.length);
                    int n = 0;
                    try {
                        bufferedInputStream.mark(byArray.length);
                        n = bufferedInputStream.read(byArray, 0, byArray.length);
                        if (-1 == n) {
                            n = 0;
                        }
                        bufferedInputStream.reset();
                    }
                    catch (IOException iOException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                        Object[] objectArray = new Object[]{iOException.toString()};
                        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
                    }
                    dTV.setValue(bufferedInputStream);
                    if (n > 8000) {
                        dTV.setJdbcType(jDBCType.isBinary() ? JDBCType.LONGVARBINARY : JDBCType.LONGVARCHAR);
                    } else {
                        streamSetterArgs.setLength(n);
                    }
                }
            }
            this.setTypeDefinition(dTV);
        }

        @Override
        void execute(DTV dTV, Reader reader) throws SQLServerException {
            if (JDBCType.NCHAR == dTV.getJdbcType() || JDBCType.NVARCHAR == dTV.getJdbcType()) {
                StreamSetterArgs streamSetterArgs = dTV.getStreamSetterArgs();
                if (streamSetterArgs.getLength() > 4000L) {
                    dTV.setJdbcType(JDBCType.LONGNVARCHAR);
                } else if (-1L == streamSetterArgs.getLength()) {
                    char[] cArray = new char[4001];
                    BufferedReader bufferedReader = new BufferedReader(reader, cArray.length);
                    int n = 0;
                    try {
                        bufferedReader.mark(cArray.length);
                        n = bufferedReader.read(cArray, 0, cArray.length);
                        if (-1 == n) {
                            n = 0;
                        }
                        bufferedReader.reset();
                    }
                    catch (IOException iOException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                        Object[] objectArray = new Object[]{iOException.toString()};
                        SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), "", true);
                    }
                    dTV.setValue(bufferedReader);
                    if (n > 4000) {
                        dTV.setJdbcType(JDBCType.LONGNVARCHAR);
                    } else {
                        streamSetterArgs.setLength(n);
                    }
                }
            }
            this.setTypeDefinition(dTV);
        }
    }
}

