/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc3.jdbc;

import com.sybase.jdbc3.jdbc.Convert;
import com.sybase.jdbc3.jdbc.DateObject;
import com.sybase.jdbc3.jdbc.ErrorMessage;
import com.sybase.jdbc3.jdbc.JdbcDataObject;
import com.sybase.jdbc3.jdbc.Param;
import com.sybase.jdbc3.jdbc.Protocol;
import com.sybase.jdbc3.jdbc.ProtocolContext;
import com.sybase.jdbc3.jdbc.SybStatement;
import com.sybase.jdbc3.tds.SybTimestamp;
import com.sybase.jdbc3.tds.TdsNumeric;
import com.sybase.jdbc3.utils.CacheManager;
import com.sybase.jdbc3.utils.Cacheable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ParamManager
implements Cacheable {
    public static final int PARAM_BY_NAME = 1;
    public static final int PARAM_BY_INDEX = 2;
    protected Param[] _params;
    protected int _next = -1;
    protected int _last = -1;
    private int x = -1;
    protected ArrayList _paramMdList = new ArrayList();
    protected SybStatement _stmt;
    protected ProtocolContext _context;
    protected Protocol _protocol;
    protected CacheManager _stmtMgr;
    private CacheManager v;
    private boolean z = false;
    private boolean C = false;
    private boolean B = false;
    protected boolean _hasLiteralParam = false;
    protected boolean _paramMarkersHaveBeenParsed = false;
    protected boolean _dontProcessParamMarkers = false;
    protected boolean _setHasBeenCalled = false;
    private String y = null;
    private boolean A = false;
    private ParamManager w = null;
    protected int _paramSetType = 0;

    public ParamManager(int n, int[] nArray, SybStatement sybStatement) throws SQLException {
        int n2;
        this._stmt = sybStatement;
        this._context = sybStatement._context;
        this._stmtMgr = sybStatement._statementManager;
        this._protocol = this._context._protocol;
        this._params = this._protocol.paramArray(this._context, n);
        for (n2 = 0; n2 < n; n2 += 1) {
            this._params[n2]._paramMarkerOffset = nArray[n2];
        }
        this.v = new CacheManager(this._context._is);
        n2 = this._context._conn._props.getBoolean(14) ? 1 : 0;
        this.v.setReReadable(n2 != 0);
        int n3 = this._context._conn._props.getInteger(13);
        if (n2) {
            n3 = -1;
        }
        this.v.setCacheSize(n3);
        this.v.setChunkSize(256);
        this.v.setAbortOnCacheOverflow(true);
    }

    public ParamManager(ParamManager paramManager, SybStatement sybStatement) throws SQLException {
        boolean bl;
        this._stmt = sybStatement;
        this._context = sybStatement._context;
        this._stmtMgr = sybStatement._statementManager;
        this._protocol = this._context._protocol;
        boolean bl2 = paramManager._params.length;
        this._params = this._protocol.paramArray(this._context, bl2 ? 1 : 0);
        for (bl = false; bl < bl2; bl += 1) {
            this._params[bl]._paramMarkerOffset = paramManager._params[bl]._paramMarkerOffset;
        }
        this.v = this._context._conn.getSharedCacheManager();
        if (this.v == null) {
            this.v = new CacheManager(this._context._is);
            bl = this._context._conn._props.getBoolean(14);
            this.v.setReReadable(bl);
            int n = this._context._conn._props.getInteger(13);
            if (bl) {
                n = -1;
            }
            this.v.setCacheSize(n);
            this.v.setChunkSize(256);
            this.v.setAbortOnCacheOverflow(true);
            this._context._conn.setSharedCacheManager(this.v);
        }
        if (paramManager.A) {
            this._hasLiteralParam = paramManager._hasLiteralParam;
            this.y = paramManager.y;
            this._paramMarkersHaveBeenParsed = true;
        }
        this.w = paramManager;
    }

    public ParamManager(int n, ProtocolContext protocolContext) throws SQLException {
        this._context = protocolContext;
        this._protocol = this._context._protocol;
        this._params = this._protocol.paramArray(n, this.v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        if (this.C) {
            return;
        }
        try {
            if (this.z) {
                if (this.x >= 0 && this._params[this.x]._outValue == null) {
                    this.getOutValueAt(this.x + 1);
                }
                if (!this.B) {
                    this.clearParams(false);
                }
            }
            this.v.clear();
        }
        catch (SQLException sQLException) {
            ErrorMessage.raiseIOECheckDead(sQLException);
        }
        finally {
            this._stmtMgr.dead(this);
        }
    }

    public void setManager(CacheManager cacheManager) {
    }

    public void reset() throws IOException {
    }

    public void resetInputStream(InputStream inputStream) {
    }

    public void cache() throws IOException {
        if (this.C) {
            return;
        }
        this.C = true;
        this.v.register(this);
        this.v.open(this);
        this.v.doneReading();
        this.v.dead(this);
        this.C = false;
        this._stmtMgr.doneReading();
    }

    public void open(boolean bl) {
    }

    public int getState() {
        return 1;
    }

    public int getNext() {
        return this._next;
    }

    public Param[] getParams() {
        return this._params;
    }

    public ProtocolContext getContext() {
        return this._context;
    }

    protected synchronized void clearParams(boolean bl) throws IOException {
        if (this.B) {
            return;
        }
        if (this.z) {
            this.B = true;
            this._stmtMgr.open(this);
            this.cache();
            this.B = false;
            this.z = false;
        }
        this.clearParamArray(bl);
        this.v.clear();
        this.v.allDead();
    }

    protected synchronized void clearParamArray(boolean bl) throws IOException {
        int n = 0;
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            n = 1;
            this._params[0].clear(false);
        }
        for (int i = n; i < this._params.length; ++i) {
            this._params[i].clear(bl);
        }
        this._next = -1;
        this._last = -1;
    }

    private void for(int n) throws SQLException {
        if (n < 1 || n > this._params.length) {
            ErrorMessage.raiseError("JZ0SB", "" + n);
        }
    }

    private void do(int n) throws SQLException {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 92: 
            case 93: 
            case 2000: {
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SL", "" + n);
            }
        }
    }

    public void setParamMd(ResultSet resultSet) throws SQLException {
        int n = 0;
        int n2 = 0;
        while (resultSet.next()) {
            if (n == 0) {
                if (!this._stmt._hasReturn) {
                    ++n;
                    continue;
                }
            } else if (this._stmt._rowFmtIdxList != null && this._stmt._rowFmtIdxList.size() > 0) {
                int n3;
                try {
                    n3 = (Integer)this._stmt._rowFmtIdxList.get(n2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    break;
                }
                if (n3 != n) continue;
                ++n2;
            }
            Param param = this._protocol.getParam();
            param._sqlType = resultSet.getInt(17);
            param._sqlTypeName = resultSet.getString(7);
            param._regType = this.if(resultSet.getString(22));
            param._precision = resultSet.getInt(8);
            param._scale = resultSet.getInt(10);
            switch (resultSet.getInt(12)) {
                case 0: {
                    param._isNullable = 0;
                    break;
                }
                case 1: {
                    param._isNullable = 1;
                    break;
                }
                default: {
                    param._isNullable = 2;
                }
            }
            switch (resultSet.getInt(14)) {
                case 38: 
                case 48: 
                case 52: 
                case 56: 
                case 59: 
                case 60: 
                case 62: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 122: 
                case 191: {
                    param._isSigned = true;
                    break;
                }
                default: {
                    param._isSigned = false;
                }
            }
            this._paramMdList.add(param);
            ++n;
        }
    }

    public void setParamMd(ResultSetMetaData resultSetMetaData, boolean bl) throws SQLException {
        block3: {
            block2: {
                if (bl) break block2;
                Vector vector = this._stmt._rowFmtIdxList;
                if (vector == null || vector.size() <= 0) break block3;
                for (int i = 0; i < vector.size(); ++i) {
                    int n = (Integer)vector.get(i);
                    this._paramMdList.add(i, this.a(resultSetMetaData, n, bl));
                }
                break block3;
            }
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                this._paramMdList.add(this.a(resultSetMetaData, i, bl));
            }
        }
    }

    private Param a(ResultSetMetaData resultSetMetaData, int n, boolean bl) throws SQLException {
        Param param = this._protocol.getParam();
        param._sqlType = resultSetMetaData.getColumnType(n);
        param._sqlTypeName = resultSetMetaData.getColumnTypeName(n);
        param._regType = 1;
        param._precision = resultSetMetaData.getPrecision(n);
        param._scale = resultSetMetaData.getScale(n);
        param._isSigned = resultSetMetaData.isSigned(n);
        param._isNullable = bl ? 2 : (resultSetMetaData.isNullable(n) == 1 ? 1 : 0);
        return param;
    }

    private int if(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equalsIgnoreCase("in")) {
            return 1;
        }
        if (string.equalsIgnoreCase("out")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Return Type")) {
            return 4;
        }
        return 0;
    }

    public void setParam(String string, int n, Object object, int n2) throws SQLException {
        this.try();
        int n3 = this.getParamIndexByName(string);
        this.doSetParam(n3, n, object, n2);
        this._params[n3 - 1]._name = string;
    }

    public void setParam(int n, int n2, Object object, int n3) throws SQLException {
        this.byte();
        this.doSetParam(n, n2, object, n3);
    }

    protected void doSetParam(int n, int n2, Object object, int n3) throws SQLException {
        this.for(n);
        Param param = this._params[--n];
        if (param._sqlType == -998) {
            ErrorMessage.raiseError("JZ0SC");
        }
        try {
            param.clear(false);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        switch (n2) {
            case 2: {
                if (!(object instanceof BigDecimal)) break;
                TdsNumeric.checkRange((BigDecimal)object, n3);
                break;
            }
            case 93: {
                try {
                    if (object == null) break;
                    SybTimestamp.checkNanos((DateObject)object);
                }
                catch (SQLException sQLException) {
                    this._stmt.handleSQLE(sQLException);
                }
                break;
            }
        }
        param._sqlType = n2;
        param._inValue = object;
        param._scale = n3;
        this._setHasBeenCalled = true;
    }

    public void registerParam(String string, int n, int n2) throws SQLException {
        this.try();
        int n3 = this.getParamIndexByName(string);
        this.doRegisterParam(n3, n);
        this._params[n3 - 1]._name = string;
        this._params[n3 - 1]._scale = n2;
    }

    public void registerParam(int n, int n2, int n3) throws SQLException {
        this.registerParam(n, n2);
        this._params[n - 1]._scale = n3;
    }

    public void registerParam(String string, int n) throws SQLException {
        this.try();
        int n2 = this.getParamIndexByName(string);
        this.doRegisterParam(n2, n);
        this._params[n2 - 1]._name = string;
    }

    public void registerParam(int n, int n2) throws SQLException {
        this.byte();
        this.doRegisterParam(n, n2);
    }

    protected void doRegisterParam(int n, int n2) throws SQLException {
        this.for(n);
        this.do(n2);
        if (--n > this.x) {
            this.x = n;
        }
        this._params[n]._regType = n2;
        if (this._stmt._hasReturn && n == 0) {
            this._stmt._returnHasBeenRegistered = true;
        }
    }

    public void registerParam(String string, int n, String string2) throws SQLException {
        this.try();
        int n2 = this.getParamIndexByName(string);
        this.doRegisterParam(n2, n);
        this._params[n2 - 1]._name = string;
        this._params[n2 - 1]._outParamClassName = string2;
    }

    public void registerParam(int n, int n2, String string) throws SQLException {
        this.registerParam(n, n2);
        this._params[--n]._outParamClassName = string;
    }

    private void int() throws SQLException {
        if (this._next < 0) {
            ErrorMessage.raiseError("JZ0SF");
        }
    }

    public JdbcDataObject getOutValueAt(String string) throws SQLException {
        this.try();
        int n = this.getParamIndexByName(string);
        return this.doGetOutValueAt(n);
    }

    public JdbcDataObject getOutValueAt(int n) throws SQLException {
        this.byte();
        return this.doGetOutValueAt(n);
    }

    protected JdbcDataObject doGetOutValueAt(int n) throws SQLException {
        this.int();
        this.for(n);
        if (this._params[--n]._regType == -999 || this._stmt._hasReturn && n == 0 && !this._stmt._returnHasBeenRegistered) {
            ErrorMessage.raiseError("JZ0SB", "" + n);
        }
        while (this._params[n]._outValue == null) {
            this.nextOutParam();
            while (this._params[n]._outValue == null) {
                this.new();
            }
        }
        this._last = n;
        return this._params[n]._outValue;
    }

    public Object getOutObjectAt(String string) throws SQLException {
        this.try();
        int n = this.getParamIndexByName(string);
        return this.doGetOutObjectAt(n);
    }

    public Object getOutObjectAt(int n) throws SQLException {
        this.byte();
        return this.doGetOutObjectAt(n);
    }

    protected Object doGetOutObjectAt(int n) throws SQLException {
        Object object = null;
        JdbcDataObject jdbcDataObject = this.doGetOutValueAt(n);
        switch (this._params[--n]._regType) {
            case -6: 
            case 5: {
                object = Convert.objectToShort(jdbcDataObject.getObject());
                break;
            }
            case -5: {
                Object object2 = jdbcDataObject.getObject();
                if (object2 == null) {
                    object = null;
                    break;
                }
                if (object2 instanceof Integer) {
                    object = new Long(((Integer)object2).longValue());
                    break;
                }
                if (object2 instanceof BigDecimal) {
                    object = new Long(((BigDecimal)object2).longValue());
                    break;
                }
                if (!(object2 instanceof Long)) break;
                object = object2;
                break;
            }
            case 2: 
            case 3: {
                if (this._params[n]._scale != -999) {
                    object = jdbcDataObject.getBigDecimal(this._params[n]._scale);
                    break;
                }
                object = jdbcDataObject.getBigDecimal(-1);
                break;
            }
            case 6: {
                object = Convert.objectToFloat(jdbcDataObject.getObject());
                break;
            }
            case 91: {
                object = Convert.objectToDate(jdbcDataObject.getDateObject(91, null));
                break;
            }
            case 92: {
                object = Convert.objectToTime(jdbcDataObject.getDateObject(92, null));
                break;
            }
            case 93: {
                object = Convert.objectToTimestamp(jdbcDataObject.getDateObject(93, null));
                break;
            }
            default: {
                object = jdbcDataObject.getObject();
            }
        }
        return object;
    }

    public boolean hasInParams() {
        if (this._params.length == 0) {
            return false;
        }
        return this._params.length > 1 || this._params[0]._sqlType != -998;
    }

    protected boolean wasNull() throws SQLException {
        this.int();
        if (this._last < 0 || this._params[this._last]._outValue == null) {
            ErrorMessage.raiseError("JZ0SD");
        }
        return this._params[this._last]._outValue.isNull();
    }

    protected void getParameter() throws SQLException {
        this.int();
        this._protocol.param(this);
    }

    public int nextOutParam(String string) {
        for (int i = 0; i < this._params.length; ++i) {
            if (this._params[i]._name == null || !this._params[i]._name.equalsIgnoreCase(string) || this._params[i]._regType == -999) continue;
            return i;
        }
        return -1;
    }

    public int nextOutParam() {
        if (this._next < this._params.length && this._params[this._next]._outValue != null) {
            ++this._next;
        }
        while (this._next < this._params.length && this._params[this._next]._regType == -999) {
            ++this._next;
        }
        return this._next;
    }

    public void registerParam(Cacheable cacheable) throws SQLException {
        this.nextOutParam();
        try {
            this.z = true;
            this.v.register(cacheable);
            this.v.open(cacheable);
            this._stmtMgr.register(this);
            this._stmtMgr.open(this);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
    }

    public void registerStatus(Cacheable cacheable) throws SQLException {
        if (this._params.length > 0 && this._params[0]._sqlType == -998) {
            this.registerParam(cacheable);
        } else {
            try {
                cacheable.clear();
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        }
    }

    private int new() throws SQLException {
        int n = this._next;
        while (true) {
            try {
                while (true) {
                    int n2 = this._stmt.nextResult();
                    switch (n2) {
                        case 3: {
                            return n2;
                        }
                        case 0: {
                            ErrorMessage.raiseError("JZ0SG");
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                this._stmt.handleSQLE(sQLException);
                continue;
            }
            break;
        }
    }

    public void checkParams(Protocol protocol, boolean bl) throws SQLException {
        boolean bl2 = false;
        for (int i = 0; i < this._params.length; ++i) {
            this._params[i].prepareForSend(protocol, i, bl);
            bl2 |= this._params[i]._sendAsLiteral;
        }
        if (this._paramMarkersHaveBeenParsed) {
            if (!this._setHasBeenCalled) {
                this._dontProcessParamMarkers = true;
            } else if (!bl2 && !this._hasLiteralParam) {
                this._dontProcessParamMarkers = true;
            }
        }
        this._hasLiteralParam = bl2;
    }

    public void parseParamsAgain() {
        this._paramMarkersHaveBeenParsed = false;
    }

    public void send(OutputStream outputStream) throws IOException, SQLException {
        this._next = 0;
        for (int i = 0; i < this._params.length; ++i) {
            this._params[i].send(outputStream, this._context._maxFieldSize);
        }
    }

    public int getLength() {
        int n = 0;
        for (int i = 0; i < this._params.length; ++i) {
            n += this._params[i].getLength();
        }
        return n;
    }

    public void adjustOffsets(int n) {
        for (int i = 0; i < this._params.length; ++i) {
            this._params[i]._paramMarkerOffset += n;
        }
    }

    protected void literalizeAll() {
        for (int i = 0; i < this._params.length; ++i) {
            this._params[i]._sendAsLiteral = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processParamMarkers(String string) throws SQLException {
        if (this._params.length == 0) {
            return null;
        }
        if (this._dontProcessParamMarkers) {
            this._dontProcessParamMarkers = false;
            this._setHasBeenCalled = false;
            return this.y;
        }
        int n = 0;
        if (this._params[n]._sqlType == -998) {
            ++n;
        }
        if (n == this._params.length) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        try {
            while (n < this._params.length) {
                if (this._params[n]._sqlType != -998) {
                    stringBuffer.append(string.substring(n2, this._params[n]._paramMarkerOffset));
                    stringBuffer.append(this._params[n].literalValue(this._protocol, n, this._context._maxFieldSize));
                    n2 = this._params[n]._paramMarkerOffset + 1;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        if (n2 < string.length()) {
            stringBuffer.append(string.substring(n2));
        }
        this.y = stringBuffer.toString();
        if (!this._hasLiteralParam && this.w != null && !this.w.A) {
            ParamManager paramManager = this.w;
            synchronized (paramManager) {
                if (!this.w.A) {
                    this.w.y = this.y;
                    this.w._hasLiteralParam = this._hasLiteralParam;
                    this.w.A = true;
                }
            }
        }
        this._dontProcessParamMarkers = false;
        this._setHasBeenCalled = false;
        this._paramMarkersHaveBeenParsed = true;
        return this.y;
    }

    public int makeFormats() throws IOException {
        int n = 0;
        for (int i = 0; i < this._params.length; ++i) {
            if (!this._params[i].makeFormat(this._protocol)) continue;
            ++n;
        }
        return n;
    }

    public void sendFormats(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this._params.length; ++i) {
            this._params[i].sendFormat(dataOutput);
        }
    }

    public int getParamIndexByName(String string) {
        for (int i = 0; i < this._params.length; ++i) {
            if (this._params[i]._name != null && !this._params[i]._name.equalsIgnoreCase(string)) continue;
            return i + 1;
        }
        return 0;
    }

    public int getParamSetType() {
        return this._paramSetType;
    }

    private void try() throws SQLException {
        if (this._paramSetType == 2) {
            ErrorMessage.raiseError("JZ0SV");
        }
        if (this._paramSetType != 1) {
            this._paramSetType = 1;
        }
    }

    private void byte() throws SQLException {
        if (this._paramSetType == 1) {
            ErrorMessage.raiseError("JZ0SV");
        } else if (this._paramSetType != 2) {
            this._paramSetType = 2;
        }
    }
}

