/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.shape;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.canvas.mxGraphicsCanvas2D;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.shape.mxStencilRegistry;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class mxStencil
implements mxIShape {
    private static final Logger log = Logger.getLogger(mxStencil.class.getName());
    protected Element desc;
    protected String aspect = null;
    protected double w0 = 100.0;
    protected double h0 = 100.0;
    protected Element bgNode = null;
    protected Element fgNode = null;
    protected String strokewidth = null;
    protected double lastMoveX = 0.0;
    protected double lastMoveY = 0.0;

    public mxStencil(Element element) {
        this.setDescription(element);
    }

    public Element getDescription() {
        return this.desc;
    }

    public void setDescription(Element element) {
        this.desc = element;
        this.parseDescription();
    }

    protected mxGraphicsCanvas2D createCanvas(mxGraphics2DCanvas mxGraphics2DCanvas2) {
        return new mxGraphicsCanvas2D(mxGraphics2DCanvas2.getGraphics());
    }

    @Override
    public void paintShape(mxGraphics2DCanvas mxGraphics2DCanvas2, mxCellState mxCellState2) {
        String string;
        String string2;
        Map<String, Object> map = mxCellState2.getStyle();
        mxGraphicsCanvas2D mxGraphicsCanvas2D2 = this.createCanvas(mxGraphics2DCanvas2);
        double d = mxUtils.getDouble(map, mxConstants.STYLE_ROTATION, 0.0);
        String string3 = mxUtils.getString(map, mxConstants.STYLE_DIRECTION, null);
        if (string3 != null) {
            if (string3.equals("north")) {
                d += 270.0;
            } else if (string3.equals("west")) {
                d += 180.0;
            } else if (string3.equals("south")) {
                d += 90.0;
            }
        }
        boolean bl = mxUtils.isTrue(map, mxConstants.STYLE_STENCIL_FLIPH, false);
        boolean bl2 = mxUtils.isTrue(map, mxConstants.STYLE_STENCIL_FLIPV, false);
        if (bl && bl2) {
            d += 180.0;
            bl = false;
            bl2 = false;
        }
        mxGraphicsCanvas2D2.save();
        if ((d %= 360.0) != 0.0 || bl || bl2) {
            mxGraphicsCanvas2D2.rotate(d, bl, bl2, mxCellState2.getCenterX(), mxCellState2.getCenterY());
        }
        mxRectangle mxRectangle2 = this.computeAspect(mxCellState2, mxCellState2, string3);
        double d2 = Math.min(mxRectangle2.getWidth(), mxRectangle2.getHeight());
        double d3 = this.strokewidth.equals("inherit") ? mxUtils.getDouble(mxCellState2.getStyle(), mxConstants.STYLE_STROKEWIDTH, 1.0) * mxCellState2.getView().getScale() : Double.parseDouble(this.strokewidth) * d2;
        mxGraphicsCanvas2D2.setStrokeWidth(d3);
        double d4 = mxUtils.getDouble(map, mxConstants.STYLE_OPACITY, 100.0) / 100.0;
        String string4 = mxUtils.getString(map, mxConstants.STYLE_GRADIENTCOLOR, null);
        if (string4 != null && string4.equals(mxConstants.NONE)) {
            string4 = null;
        }
        if ((string2 = mxUtils.getString(map, mxConstants.STYLE_FILLCOLOR, null)) != null && string2.equals(mxConstants.NONE)) {
            string2 = null;
        }
        if ((string = mxUtils.getString(map, mxConstants.STYLE_STROKECOLOR, null)) != null && string.equals(mxConstants.NONE)) {
            string = null;
        }
        if (mxUtils.isTrue(map, mxConstants.STYLE_SHADOW, false)) {
            this.drawShadow(mxGraphicsCanvas2D2, mxCellState2, d, bl, bl2, mxCellState2, d4, string2 != null, mxRectangle2);
        }
        mxGraphicsCanvas2D2.setAlpha(d4);
        if (mxUtils.isTrue(map, mxConstants.STYLE_DASHED, false)) {
            mxGraphicsCanvas2D2.setDashed(true);
        }
        if (string != null || string2 != null) {
            if (string != null) {
                mxGraphicsCanvas2D2.setStrokeColor(string);
            }
            if (string2 != null) {
                if (string4 != null && !string4.equals("transparent")) {
                    mxGraphicsCanvas2D2.setGradient(string2, string4, mxCellState2.getX(), mxCellState2.getY(), mxCellState2.getWidth(), mxCellState2.getHeight(), string3, 1.0, 1.0);
                } else {
                    mxGraphicsCanvas2D2.setFillColor(string2);
                }
            }
            this.drawShape(mxGraphicsCanvas2D2, mxCellState2, mxCellState2, mxRectangle2, true);
            this.drawShape(mxGraphicsCanvas2D2, mxCellState2, mxCellState2, mxRectangle2, false);
        }
    }

    protected void drawShadow(mxGraphicsCanvas2D mxGraphicsCanvas2D2, mxCellState mxCellState2, double d, boolean bl, boolean bl2, mxRectangle mxRectangle2, double d2, boolean bl3, mxRectangle mxRectangle3) {
        double d3 = d * Math.PI / 180.0;
        double d4 = Math.cos(-d3);
        double d5 = Math.sin(-d3);
        mxPoint mxPoint2 = mxUtils.getRotatedPoint(new mxPoint(mxConstants.SHADOW_OFFSETX, mxConstants.SHADOW_OFFSETY), d4, d5);
        if (bl) {
            mxPoint2.setX(mxPoint2.getX() * -1.0);
        }
        if (bl2) {
            mxPoint2.setY(mxPoint2.getY() * -1.0);
        }
        mxGraphicsCanvas2D2.translate(mxPoint2.getX(), mxPoint2.getY());
        if (this.drawShape(mxGraphicsCanvas2D2, mxCellState2, mxRectangle2, mxRectangle3, true)) {
            mxGraphicsCanvas2D2.setAlpha((double)mxConstants.STENCIL_SHADOW_OPACITY * d2);
        }
        mxGraphicsCanvas2D2.translate(-mxPoint2.getX(), -mxPoint2.getY());
    }

    public boolean drawShape(mxGraphicsCanvas2D mxGraphicsCanvas2D2, mxCellState mxCellState2, mxRectangle mxRectangle2, mxRectangle mxRectangle3, boolean bl) {
        Element element;
        Element element2 = element = bl ? this.bgNode : this.fgNode;
        if (element != null) {
            this.lastMoveX = 0.0;
            this.lastMoveY = 0.0;
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                this.drawElement(mxGraphicsCanvas2D2, mxCellState2, (Element)node, mxRectangle3);
            }
            return true;
        }
        return false;
    }

    protected mxRectangle computeAspect(mxCellState mxCellState2, mxRectangle mxRectangle2, String string) {
        boolean bl;
        double d = mxRectangle2.getX();
        double d2 = mxRectangle2.getY();
        double d3 = mxRectangle2.getWidth() / this.w0;
        double d4 = mxRectangle2.getHeight() / this.h0;
        boolean bl2 = bl = string != null && (string.equals("north") || string.equals("south"));
        if (bl) {
            d4 = mxRectangle2.getWidth() / this.h0;
            d3 = mxRectangle2.getHeight() / this.w0;
            double d5 = (mxRectangle2.getWidth() - mxRectangle2.getHeight()) / 2.0;
            d += d5;
            d2 -= d5;
        }
        if (this.aspect.equals("fixed")) {
            d3 = d4 = Math.min(d3, d4);
            if (bl) {
                d += (mxRectangle2.getHeight() - this.w0 * d3) / 2.0;
                d2 += (mxRectangle2.getWidth() - this.h0 * d4) / 2.0;
            } else {
                d += (mxRectangle2.getWidth() - this.w0 * d3) / 2.0;
                d2 += (mxRectangle2.getHeight() - this.h0 * d4) / 2.0;
            }
        }
        return new mxRectangle(d, d2, d3, d4);
    }

    protected void drawElement(mxGraphicsCanvas2D mxGraphicsCanvas2D2, mxCellState mxCellState2, Element element, mxRectangle mxRectangle2) {
        String string = element.getNodeName();
        double d = mxRectangle2.getX();
        double d2 = mxRectangle2.getY();
        double d3 = mxRectangle2.getWidth();
        double d4 = mxRectangle2.getHeight();
        double d5 = Math.min(d3, d4);
        if (string.equals("save")) {
            mxGraphicsCanvas2D2.save();
        } else if (string.equals("restore")) {
            mxGraphicsCanvas2D2.restore();
        } else if (string.equals("path")) {
            mxGraphicsCanvas2D2.begin();
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                this.drawElement(mxGraphicsCanvas2D2, mxCellState2, (Element)node, mxRectangle2);
            }
        } else if (string.equals("close")) {
            mxGraphicsCanvas2D2.close();
        } else if (string.equals("move")) {
            this.lastMoveX = d + this.getDouble(element, "x") * d3;
            this.lastMoveY = d2 + this.getDouble(element, "y") * d4;
            mxGraphicsCanvas2D2.moveTo(this.lastMoveX, this.lastMoveY);
        } else if (string.equals("line")) {
            this.lastMoveX = d + this.getDouble(element, "x") * d3;
            this.lastMoveY = d2 + this.getDouble(element, "y") * d4;
            mxGraphicsCanvas2D2.lineTo(this.lastMoveX, this.lastMoveY);
        } else if (string.equals("quad")) {
            this.lastMoveX = d + this.getDouble(element, "x2") * d3;
            this.lastMoveY = d2 + this.getDouble(element, "y2") * d4;
            mxGraphicsCanvas2D2.quadTo(d + this.getDouble(element, "x1") * d3, d2 + this.getDouble(element, "y1") * d4, this.lastMoveX, this.lastMoveY);
        } else if (string.equals("curve")) {
            this.lastMoveX = d + this.getDouble(element, "x3") * d3;
            this.lastMoveY = d2 + this.getDouble(element, "y3") * d4;
            mxGraphicsCanvas2D2.curveTo(d + this.getDouble(element, "x1") * d3, d2 + this.getDouble(element, "y1") * d4, d + this.getDouble(element, "x2") * d3, d2 + this.getDouble(element, "y2") * d4, this.lastMoveX, this.lastMoveY);
        } else if (string.equals("arc")) {
            double d6 = this.getDouble(element, "rx") * d3;
            double d7 = this.getDouble(element, "ry") * d4;
            double d8 = this.getDouble(element, "x-axis-rotation");
            double d9 = this.getDouble(element, "large-arc-flag");
            double d10 = this.getDouble(element, "sweep-flag");
            double d11 = d + this.getDouble(element, "x") * d3;
            double d12 = d2 + this.getDouble(element, "y") * d4;
            double[] dArray = mxUtils.arcToCurves(this.lastMoveX, this.lastMoveY, d6, d7, d8, d9, d10, d11, d12);
            for (int i = 0; i < dArray.length; i += 6) {
                mxGraphicsCanvas2D2.curveTo(dArray[i], dArray[i + 1], dArray[i + 2], dArray[i + 3], dArray[i + 4], dArray[i + 5]);
                this.lastMoveX = dArray[i + 4];
                this.lastMoveY = dArray[i + 5];
            }
        } else if (string.equals("rect")) {
            mxGraphicsCanvas2D2.rect(d + this.getDouble(element, "x") * d3, d2 + this.getDouble(element, "y") * d4, this.getDouble(element, "w") * d3, this.getDouble(element, "h") * d4);
        } else if (string.equals("roundrect")) {
            double d13 = this.getDouble(element, "arcsize");
            if (d13 == 0.0) {
                d13 = mxConstants.RECTANGLE_ROUNDING_FACTOR * 100.0;
            }
            double d14 = this.getDouble(element, "w") * d3;
            double d15 = this.getDouble(element, "h") * d4;
            double d16 = d13 / 100.0;
            double d17 = Math.min(d14 * d16, d15 * d16);
            mxGraphicsCanvas2D2.roundrect(d + this.getDouble(element, "x") * d3, d2 + this.getDouble(element, "y") * d4, this.getDouble(element, "w") * d3, this.getDouble(element, "h") * d4, d17, d17);
        } else if (string.equals("ellipse")) {
            mxGraphicsCanvas2D2.ellipse(d + this.getDouble(element, "x") * d3, d2 + this.getDouble(element, "y") * d4, this.getDouble(element, "w") * d3, this.getDouble(element, "h") * d4);
        } else if (string.equals("image")) {
            String string2 = this.evaluateAttribute(element, "src", mxCellState2);
            mxGraphicsCanvas2D2.image(d + this.getDouble(element, "x") * d3, d2 + this.getDouble(element, "y") * d4, this.getDouble(element, "w") * d3, this.getDouble(element, "h") * d4, string2, false, this.getString(element, "flipH", "0").equals("1"), this.getString(element, "flipV", "0").equals("1"));
        } else if (string.equals("text")) {
            String string3 = this.evaluateAttribute(element, "str", mxCellState2);
            double d18 = this.getString(element, "vertical", "0").equals("1") ? -90.0 : 0.0;
            mxGraphicsCanvas2D2.text(d + this.getDouble(element, "x") * d3, d2 + this.getDouble(element, "y") * d4, 0.0, 0.0, string3, element.getAttribute("align"), element.getAttribute("valign"), false, "", null, false, d18, null);
        } else if (string.equals("include-shape")) {
            mxStencil mxStencil2 = mxStencilRegistry.getStencil(element.getAttribute("name"));
            if (mxStencil2 != null) {
                double d19 = d + this.getDouble(element, "x") * d3;
                double d20 = d2 + this.getDouble(element, "y") * d4;
                double d21 = this.getDouble(element, "w") * d3;
                double d22 = this.getDouble(element, "h") * d4;
                mxRectangle mxRectangle3 = new mxRectangle(d19, d20, d21, d22);
                mxStencil2.drawShape(mxGraphicsCanvas2D2, mxCellState2, mxRectangle3, mxRectangle2, true);
                mxStencil2.drawShape(mxGraphicsCanvas2D2, mxCellState2, mxRectangle3, mxRectangle2, false);
            }
        } else if (string.equals("fillstroke")) {
            mxGraphicsCanvas2D2.fillAndStroke();
        } else if (string.equals("fill")) {
            mxGraphicsCanvas2D2.fill();
        } else if (string.equals("stroke")) {
            mxGraphicsCanvas2D2.stroke();
        } else if (string.equals("strokewidth")) {
            double d23 = this.getInt(element, "fixed", 0) == 1 ? 1.0 : d5;
            mxGraphicsCanvas2D2.setStrokeWidth(this.getDouble(element, "width") * d23);
        } else if (string.equals("dashed")) {
            String string4 = element.getAttribute("dashed");
            if (string4 != null) {
                mxGraphicsCanvas2D2.setDashed(string4.equals("1"));
            }
        } else if (string.equals("dashpattern")) {
            String string5 = element.getAttribute("pattern");
            if (string5 != null) {
                String[] stringArray = string5.split(" ");
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].length() <= 0) continue;
                    stringBuffer.append(Double.parseDouble(stringArray[i]) * d5);
                    stringBuffer.append(" ");
                }
                string5 = stringBuffer.toString();
            }
            mxGraphicsCanvas2D2.setDashPattern(string5);
        } else if (string.equals("strokecolor")) {
            mxGraphicsCanvas2D2.setStrokeColor(element.getAttribute("color"));
        } else if (string.equals("linecap")) {
            mxGraphicsCanvas2D2.setLineCap(element.getAttribute("cap"));
        } else if (string.equals("linejoin")) {
            mxGraphicsCanvas2D2.setLineJoin(element.getAttribute("join"));
        } else if (string.equals("miterlimit")) {
            mxGraphicsCanvas2D2.setMiterLimit(this.getDouble(element, "limit"));
        } else if (string.equals("fillcolor")) {
            mxGraphicsCanvas2D2.setFillColor(element.getAttribute("color"));
        } else if (string.equals("fontcolor")) {
            mxGraphicsCanvas2D2.setFontColor(element.getAttribute("color"));
        } else if (string.equals("fontstyle")) {
            mxGraphicsCanvas2D2.setFontStyle(this.getInt(element, "style", 0));
        } else if (string.equals("fontfamily")) {
            mxGraphicsCanvas2D2.setFontFamily(element.getAttribute("family"));
        } else if (string.equals("fontsize")) {
            mxGraphicsCanvas2D2.setFontSize(this.getDouble(element, "size") * d5);
        }
    }

    protected int getInt(Element element, String string, int n) {
        String string2 = element.getAttribute(string);
        if (string2 != null && string2.length() > 0) {
            try {
                n = (int)Math.floor(Float.parseFloat(string2));
            }
            catch (NumberFormatException numberFormatException) {
                log.log(Level.SEVERE, "Invalid value for attribute " + string + " in " + element.getTagName(), numberFormatException);
            }
        }
        return n;
    }

    protected double getDouble(Element element, String string) {
        return this.getDouble(element, string, 0.0);
    }

    protected double getDouble(Element element, String string, double d) {
        String string2 = element.getAttribute(string);
        if (string2 != null && string2.length() > 0) {
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                log.log(Level.SEVERE, "Invalid value for attribute " + string + " in " + element.getTagName(), numberFormatException);
            }
        }
        return d;
    }

    protected String getString(Element element, String string, String string2) {
        String string3 = element.getAttribute(string);
        if (string3 != null && string3.length() > 0) {
            string2 = string3;
        }
        return string2;
    }

    protected void parseDescription() {
        this.fgNode = (Element)this.desc.getElementsByTagName("foreground").item(0);
        this.bgNode = (Element)this.desc.getElementsByTagName("background").item(0);
        this.w0 = this.getDouble(this.desc, "w", this.w0);
        this.h0 = this.getDouble(this.desc, "h", this.h0);
        this.aspect = this.getString(this.desc, "aspect", "variable");
        this.strokewidth = this.getString(this.desc, "strokewidth", "1");
    }

    public String evaluateAttribute(Element element, String string, mxCellState mxCellState2) {
        String string2 = element.getAttribute(string);
        if (string2 == null) {
            // empty if block
        }
        return string2;
    }
}

