/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class mxXmlUtils {
    private static final Logger log = Logger.getLogger(mxXmlUtils.class.getName());
    private static DocumentBuilder documentBuilder = null;

    public static DocumentBuilder getDocumentBuilder() {
        if (documentBuilder == null) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setValidating(false);
            try {
                documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                log.log(Level.SEVERE, "Failed to set feature", parserConfigurationException);
            }
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Failed to construct a document builder", exception);
            }
        }
        return documentBuilder;
    }

    public static Document parseXml(String string) {
        try {
            return mxXmlUtils.getDocumentBuilder().parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Failed to parse XML", exception);
            return null;
        }
    }

    public static String getXml(Node node) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            StreamResult streamResult = new StreamResult(new StringWriter());
            transformer.transform(new DOMSource(node), streamResult);
            return streamResult.getWriter().toString();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, "Failed to convert XML object to string", exception);
            return "";
        }
    }
}

