/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.InputOutput;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4Properties;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;

abstract class Address {
    protected Locale m_locale;
    protected T4Properties m_t4props;
    protected String m_ipAddress;
    protected String m_machineName;
    protected String m_processName;
    protected Integer m_portNumber;
    protected Properties m_properties;
    InetAddress[] m_inetAddrs;
    protected int m_type;
    protected String m_url;
    protected InputOutput m_io;

    Address(T4Properties t4props, Locale locale, String addr) throws SQLException {
        this.m_t4props = t4props;
        this.m_locale = locale;
        this.m_url = addr;
    }

    abstract String recreateAddress();

    String getIPorName() {
        if (this.m_machineName != null) {
            return this.m_machineName;
        }
        return this.m_ipAddress;
    }

    protected boolean validateAddress() throws SQLException {
        String IPorName = this.getIPorName();
        try {
            this.m_inetAddrs = InetAddress.getAllByName(IPorName);
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_lookup_error", this.m_url, e.getMessage());
            se.initCause(e);
            throw se;
        }
        return true;
    }

    Integer getPort() {
        return this.m_portNumber;
    }

    void setInputOutput() {
        this.m_io = new InputOutput(this.m_locale, this);
    }

    InputOutput getInputOutput() {
        return this.m_io;
    }
}

