/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

class Bytes {
    Bytes() {
    }

    static short extractShort(byte[] array, int offset, boolean swap) {
        short value = swap ? (short)(array[offset] & 0xFF | array[offset + 1] << 8 & 0xFF00) : (short)(array[offset + 1] & 0xFF | array[offset] << 8 & 0xFF00);
        return value;
    }

    static int extractUShort(byte[] array, int offset, boolean swap) {
        int value = swap ? array[offset] & 0xFF | array[offset + 1] << 8 & 0xFF00 : array[offset + 1] & 0xFF | array[offset] << 8 & 0xFF00;
        return value & 0xFFFF;
    }

    static int extractInt(byte[] array, int offset, boolean swap) {
        int value = swap ? array[offset] & 0xFF | array[offset + 1] << 8 & 0xFF00 | array[offset + 2] << 16 & 0xFF0000 | array[offset + 3] << 24 & 0xFF000000 : array[offset + 3] & 0xFF | array[offset + 2] << 8 & 0xFF00 | array[offset + 1] << 16 & 0xFF0000 | array[offset] << 24 & 0xFF000000;
        return value;
    }

    static long extractUInt(byte[] array, int offset, boolean swap) {
        long value = swap ? (long)(array[offset] & 0xFF | array[offset + 1] << 8 & 0xFF00 | array[offset + 2] << 16 & 0xFF0000 | array[offset + 3] << 24 & 0xFF000000) : (long)(array[offset + 3] & 0xFF | array[offset + 2] << 8 & 0xFF00 | array[offset + 1] << 16 & 0xFF0000 | array[offset] << 24 & 0xFF000000);
        return value & 0xFFFFFFFFL;
    }

    static long extractLong(byte[] array, int offset, boolean swap) {
        long value = 0L;
        int i = offset;
        if (swap) {
            for (int shift = 0; shift < 64; shift += 8) {
                value |= (long)(array[i] & 0xFF) << shift;
                ++i;
            }
        } else {
            for (int shift = 56; shift >= 0; shift -= 8) {
                value |= (long)(array[i] & 0xFF) << shift;
                ++i;
            }
        }
        return value;
    }

    static int insertShort(byte[] array, int offset, short value, boolean swap) {
        if (swap) {
            array[offset + 1] = (byte)(value >>> 8 & 0xFF);
            array[offset] = (byte)(value & 0xFF);
        } else {
            array[offset] = (byte)(value >>> 8 & 0xFF);
            array[offset + 1] = (byte)(value & 0xFF);
        }
        return offset + 2;
    }

    static int insertInt(byte[] array, int offset, int value, boolean swap) {
        if (swap) {
            array[offset + 3] = (byte)(value >>> 24 & 0xFF);
            array[offset + 2] = (byte)(value >>> 16 & 0xFF);
            array[offset + 1] = (byte)(value >>> 8 & 0xFF);
            array[offset] = (byte)(value & 0xFF);
        } else {
            array[offset] = (byte)(value >>> 24 & 0xFF);
            array[offset + 1] = (byte)(value >>> 16 & 0xFF);
            array[offset + 2] = (byte)(value >>> 8 & 0xFF);
            array[offset + 3] = (byte)(value & 0xFF);
        }
        return offset + 4;
    }

    static int insertLong(byte[] array, int offset, long value, boolean swap) {
        if (swap) {
            array[offset + 7] = (byte)(value >>> 56 & 0xFFL);
            array[offset + 6] = (byte)(value >>> 48 & 0xFFL);
            array[offset + 5] = (byte)(value >>> 40 & 0xFFL);
            array[offset + 4] = (byte)(value >>> 32 & 0xFFL);
            array[offset + 3] = (byte)(value >>> 24 & 0xFFL);
            array[offset + 2] = (byte)(value >>> 16 & 0xFFL);
            array[offset + 1] = (byte)(value >>> 8 & 0xFFL);
            array[offset] = (byte)(value & 0xFFL);
        } else {
            array[offset] = (byte)(value >>> 56 & 0xFFL);
            array[offset + 1] = (byte)(value >>> 48 & 0xFFL);
            array[offset + 2] = (byte)(value >>> 40 & 0xFFL);
            array[offset + 3] = (byte)(value >>> 32 & 0xFFL);
            array[offset + 4] = (byte)(value >>> 24 & 0xFFL);
            array[offset + 5] = (byte)(value >>> 16 & 0xFFL);
            array[offset + 6] = (byte)(value >>> 8 & 0xFFL);
            array[offset + 7] = (byte)(value & 0xFFL);
        }
        return offset + 8;
    }

    static byte[] createShortBytes(short value, boolean swap) {
        byte[] b = new byte[2];
        Bytes.insertShort(b, 0, value, swap);
        return b;
    }

    static byte[] createIntBytes(int value, boolean swap) {
        byte[] b = new byte[4];
        Bytes.insertInt(b, 0, value, swap);
        return b;
    }

    static byte[] createLongBytes(long value, boolean swap) {
        byte[] b = new byte[8];
        Bytes.insertLong(b, 0, value, swap);
        return b;
    }

    static char[] read_chars(byte[] buffer, int index) {
        int len = 0;
        while (buffer[index + len] != 0) {
            ++len;
        }
        char[] temp1 = Bytes.read_chars(buffer, index, len);
        return temp1;
    }

    static char[] read_chars(byte[] buffer, int index, int tLen) {
        int len = tLen;
        if (len == -1) {
            int ii = index;
            while (buffer[ii] != 0) {
                ++ii;
            }
            len = ii - index;
        }
        char[] la_chars = new char[len];
        int i = 0;
        while (i < len) {
            la_chars[i] = (char)(buffer[index] & 0xFF);
            ++i;
            ++index;
        }
        return la_chars;
    }
}

