/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Descriptor2;
import com.tandem.t4jdbc.Header;
import com.tandem.t4jdbc.InterfaceConnection;
import com.tandem.t4jdbc.InterfaceStatement;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.SQLWarningOrError;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;

class ExecuteReply {
    int returnCode;
    int totalErrorLength;
    SQLWarningOrError[] errorList;
    long rowsAffected;
    int queryType;
    int estimatedCost;
    byte[] outValues;
    int numResultSets;
    Descriptor2[][] outputDesc;
    String[] stmtLabels;
    int outputParamLength;
    int outputNumberParams;
    String[] proxySyntax;
    int rowsAffectedArrayLength;
    int[] rowsAffectedArray;
    int outValuesFormat_;

    ExecuteReply(LogicalByteArray buf, InterfaceConnection ic) throws CharacterCodingException, UnsupportedCharsetException {
        int i;
        int outputDescLength;
        int errorCharset = ic.getWmsMode() ? 15 : ic.getISOMapping();
        buf.setLocation(Header.sizeOf());
        this.returnCode = buf.extractInt();
        this.totalErrorLength = buf.extractInt();
        if (this.totalErrorLength > 0) {
            this.errorList = new SQLWarningOrError[buf.extractInt()];
            for (int i2 = 0; i2 < this.errorList.length; ++i2) {
                this.errorList[i2] = new SQLWarningOrError(buf, ic, errorCharset);
            }
        }
        if ((outputDescLength = buf.extractInt()) > 0) {
            this.outputDesc = new Descriptor2[1][];
            this.outputParamLength = buf.extractInt();
            this.outputNumberParams = buf.extractInt();
            this.outputDesc[0] = new Descriptor2[this.outputNumberParams];
            for (i = 0; i < this.outputNumberParams; ++i) {
                this.outputDesc[0][i] = new Descriptor2(buf, ic);
                this.outputDesc[0][i].setRowLength(this.outputParamLength);
            }
        }
        this.rowsAffected = buf.extractUnsignedInt();
        this.queryType = buf.extractInt();
        this.estimatedCost = buf.extractInt();
        this.rowsAffected |= (long)this.estimatedCost << 32;
        this.outValues = buf.extractByteArray();
        this.numResultSets = buf.extractInt();
        if (this.numResultSets > 0) {
            this.outputDesc = new Descriptor2[this.numResultSets][];
            this.stmtLabels = new String[this.numResultSets];
            this.proxySyntax = new String[this.numResultSets];
            for (i = 0; i < this.numResultSets; ++i) {
                buf.extractInt();
                this.stmtLabels[i] = ic.decodeBytes(buf.extractString(), 1);
                buf.extractInt();
                outputDescLength = buf.extractInt();
                int outputParamsLength = 0;
                int outputNumberParams = 0;
                Descriptor2[] outputParams = null;
                if (outputDescLength > 0) {
                    outputParamsLength = buf.extractInt();
                    outputNumberParams = buf.extractInt();
                    outputParams = new Descriptor2[outputNumberParams];
                    for (int j = 0; j < outputNumberParams; ++j) {
                        outputParams[j] = new Descriptor2(buf, ic);
                        outputParams[j].setRowLength(outputParamsLength);
                    }
                }
                this.outputDesc[i] = outputParams;
                this.proxySyntax[i] = ic.decodeBytes(buf.extractString(), 15);
            }
        }
        String singleSyntax = ic.decodeBytes(buf.extractString(), 15);
        if (ic.t4props_.getExecuteBatchWithRowsAffected().equalsIgnoreCase("ON") && InterfaceStatement.rowWiseData) {
            this.rowsAffectedArrayLength = buf.extractInt();
            if (this.rowsAffectedArrayLength > 0) {
                this.rowsAffectedArray = new int[this.rowsAffectedArrayLength];
                for (int i3 = 0; i3 < this.rowsAffectedArrayLength; ++i3) {
                    this.rowsAffectedArray[i3] = buf.extractInt();
                }
            }
        } else {
            this.outValuesFormat_ = buf.extractInt();
        }
        if (this.proxySyntax == null) {
            this.proxySyntax = new String[1];
            this.proxySyntax[0] = singleSyntax;
        }
    }
}

