/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.CachedPreparedStatement;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXHandle;
import com.tandem.t4jdbc.SQLMXPreparedStatement;
import com.tandem.t4jdbc.SQLMXStatement;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.logging.Level;

public abstract class PreparedStatementManager
extends SQLMXHandle
implements Comparator {
    protected Hashtable prepStmtsInCache_;
    protected Hashtable sqlStringWeight;
    private ArrayList thrownPrepStmts_;
    private int maxStatements_;
    private int count_;
    private boolean mfu;
    Level traceLevel_;
    PrintWriter out_;
    String traceId_;

    boolean isStatementCachingEnabled() {
        return this.maxStatements_ >= 1;
    }

    public int compare(Object arg0, Object arg1) {
        int result = 0;
        if (!this.mfu) {
            if (((CachedPreparedStatement)arg0).getLastUsedTime() < ((CachedPreparedStatement)arg1).getLastUsedTime()) {
                result = -1;
            }
            if (((CachedPreparedStatement)arg0).getLastUsedTime() > ((CachedPreparedStatement)arg1).getLastUsedTime()) {
                result = 1;
            }
            if (((CachedPreparedStatement)arg0).getLastUsedTime() == ((CachedPreparedStatement)arg1).getLastUsedTime()) {
                result = 0;
            }
        } else {
            if (((CachedPreparedStatement)arg0).getNoOfTimesUsed() < ((CachedPreparedStatement)arg1).getNoOfTimesUsed()) {
                result = -1;
            }
            if (((CachedPreparedStatement)arg0).getNoOfTimesUsed() > ((CachedPreparedStatement)arg1).getNoOfTimesUsed()) {
                result = 1;
            }
            if (((CachedPreparedStatement)arg0).getNoOfTimesUsed() == ((CachedPreparedStatement)arg1).getNoOfTimesUsed()) {
                result = 0;
            }
        }
        return result;
    }

    boolean makeRoom(String sql, int resultSetHoldability) throws SQLException {
        String lookupKey = this.createKey((SQLMXConnection)this, sql, resultSetHoldability);
        if (this.out_ != null && this.traceLevel_ != Level.OFF) {
            this.out_.println(this.traceId_ + "makeRoom()");
        }
        CachedPreparedStatement cs2 = null;
        String key = null;
        if (this.isStatementCachingEnabled() && this.prepStmtsInCache_.isEmpty()) {
            return true;
        }
        if (this.isStatementCachingEnabled() && this.prepStmtsInCache_.size() < this.maxStatements_ && !this.prepStmtsInCache_.containsKey(lookupKey)) {
            return true;
        }
        ArrayList<CachedPreparedStatement> list = new ArrayList<CachedPreparedStatement>();
        if (this.prepStmtsInCache_.size() == this.maxStatements_ && !this.prepStmtsInCache_.containsKey(lookupKey)) {
            for (CachedPreparedStatement cs2 : this.prepStmtsInCache_.values()) {
                Integer weightOfStmtNotInUse;
                if (SQLMXConnection.sqlStatementsContainingScalarFunctions.contains(cs2.getLookUpKey())) continue;
                if (!cs2.isInUse_() && !this.mfu) {
                    list.add(cs2);
                    continue;
                }
                if (cs2.isInUse_() || !this.mfu || (weightOfStmtNotInUse = (Integer)this.sqlStringWeight.get(cs2.getLookUpKey())) == null) continue;
                cs2.setNoOfTimesUsed(weightOfStmtNotInUse.intValue());
                list.add(cs2);
            }
        }
        cs2 = null;
        Collections.sort(list, this);
        if (list.size() > 0) {
            key = ((CachedPreparedStatement)list.get(0)).getLookUpKey();
        }
        if (key != null) {
            cs2 = (CachedPreparedStatement)this.prepStmtsInCache_.remove(key);
        }
        if (cs2 != null) {
            if (((SQLMXConnection)this).props_.t4Logger_.isLoggable(Level.INFO)) {
                Object[] p1 = T4LoggingUtilities.makeParams(((SQLMXConnection)this).props_, ((SQLMXPreparedStatement)cs2.getPreparedStatement()).stmtLabel_);
                ((SQLMXConnection)this).props_.t4Logger_.logp(Level.INFO, "PreparedStatementManager", "makeRoom", "STATEMENT CACHING INFO:STMT REMOVED FROM CACHE", p1);
            }
            cs2.close(true);
            return true;
        }
        return false;
    }

    void closePreparedStatementsAll() throws SQLException {
        CachedPreparedStatement cs;
        if (this.out_ != null && this.traceLevel_ != Level.OFF) {
            this.out_.println(this.traceId_ + "closePreparedStatementsAll()");
        }
        int i = 0;
        Object[] csArray = this.prepStmtsInCache_.values().toArray();
        for (i = 0; i < csArray.length; ++i) {
            cs = (CachedPreparedStatement)csArray[i];
            if (cs == null) continue;
            cs.close(false);
        }
        int count = this.thrownPrepStmts_.size();
        for (i = 0; i < count; ++i) {
            cs = (CachedPreparedStatement)this.thrownPrepStmts_.get(i);
            if (cs == null) continue;
            cs.close(true);
        }
        this.thrownPrepStmts_.clear();
    }

    private String createKey(SQLMXConnection connect, String sql, int resultSetHoldability) throws SQLException {
        String lookupKey = sql + connect.getCatalog() + connect.getSchema() + connect.getTransactionIsolation() + resultSetHoldability;
        return lookupKey;
    }

    boolean closePreparedStatement(SQLMXConnection connect, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String lookupKey;
        CachedPreparedStatement cs;
        if (this.out_ != null && this.traceLevel_ != Level.OFF) {
            this.out_.println(this.traceId_ + "closePreparedStatement(" + connect + ",\"" + sql + "\"," + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + ")");
        }
        if ((cs = (CachedPreparedStatement)this.prepStmtsInCache_.get(lookupKey = this.createKey(connect, sql, resultSetHoldability))) != null) {
            cs.inUse_ = false;
            return true;
        }
        return false;
    }

    void clearPreparedStatementsAll() {
        if (this.out_ != null && this.traceLevel_ != Level.OFF) {
            this.out_.println(this.traceId_ + "clearPreparedStatementsAll()");
        }
        if (this.prepStmtsInCache_ != null) {
            this.prepStmtsInCache_.clear();
        }
        this.count_ = 0;
    }

    void addPreparedStatement(SQLMXConnection connect, String sql, PreparedStatement pStmt, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String lookupKey;
        CachedPreparedStatement cachedStmt;
        if (connect.props_.t4Logger_.isLoggable(Level.INFO)) {
            Object[] p1 = T4LoggingUtilities.makeParams(connect.props_, (Object)((SQLMXStatement)((Object)pStmt)).stmtLabel_, resultSetType, resultSetConcurrency, resultSetHoldability);
            connect.props_.t4Logger_.logp(Level.INFO, "PreparedStatementManager", "addPreparedStatement", "STATEMENT CACHING INFO: STMT ADDED TO CACHE", p1);
        }
        if (this.out_ != null && this.traceLevel_ != Level.OFF) {
            this.out_.println(this.traceId_ + "addPreparedStatement(" + connect + ",\"" + sql + "\"," + pStmt + "," + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + ")");
        }
        if ((cachedStmt = (CachedPreparedStatement)this.prepStmtsInCache_.get(lookupKey = this.createKey(connect, sql, resultSetHoldability))) != null) {
            cachedStmt.setLastUsedInfo();
        } else if (this.count_ < this.maxStatements_ && !this.prepStmtsInCache_.contains(lookupKey)) {
            cachedStmt = new CachedPreparedStatement(pStmt, lookupKey, sql);
            this.prepStmtsInCache_.put(lookupKey, cachedStmt);
            ++this.count_;
            if (connect.props_.t4Logger_.isLoggable(Level.INFO)) {
                Object[] p2 = T4LoggingUtilities.makeParams(connect.props_);
                connect.props_.t4Logger_.logp(Level.INFO, "PreparedStatementManager", "addPreparedStatement", "STATEMENT CACHING INFO: IN USE " + this.count_ + " out of " + this.maxStatements_, p2);
            }
        } else if (this.makeRoom(sql, resultSetHoldability)) {
            cachedStmt = new CachedPreparedStatement(pStmt, lookupKey, sql);
            this.prepStmtsInCache_.put(lookupKey, cachedStmt);
        }
    }

    PreparedStatement getPreparedStatement(SQLMXConnection connect, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.out_ != null && this.traceLevel_ != Level.OFF) {
            this.out_.println(this.traceId_ + "getPreparedStatement(" + connect + ",\"" + sql + "\"," + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + ")");
        }
        PreparedStatement pStmt = null;
        String lookupKey = this.createKey(connect, sql, resultSetHoldability);
        if (this.prepStmtsInCache_ != null) {
            CachedPreparedStatement cachedStmt = (CachedPreparedStatement)this.prepStmtsInCache_.get(lookupKey);
            if (cachedStmt != null) {
                if (!cachedStmt.inUse_) {
                    cachedStmt.setInUse_(true);
                    pStmt = cachedStmt.getPreparedStatement();
                    ((SQLMXPreparedStatement)pStmt).reuse(connect, resultSetType, resultSetConcurrency, resultSetHoldability);
                    if (connect.props_.t4Logger_.isLoggable(Level.INFO)) {
                        Object[] p1 = T4LoggingUtilities.makeParams(connect.props_, ((SQLMXStatement)((Object)pStmt)).stmtLabel_);
                        connect.props_.t4Logger_.logp(Level.INFO, "PreparedStatementManager", "getPreparedStatement", "STATEMENT CACHING INFO: RETRIVED STATEMENT FROM CACHE", p1);
                    }
                } else {
                    pStmt = null;
                    if (connect.props_.t4Logger_.isLoggable(Level.INFO)) {
                        Object[] p1 = T4LoggingUtilities.makeParams(connect.props_);
                        connect.props_.t4Logger_.logp(Level.INFO, "PreparedStatementManager", "getPreparedStatement", "STATEMENT CACHING INFO: STATEMENT IN USE", p1);
                    }
                }
            } else if (connect.props_.t4Logger_.isLoggable(Level.INFO)) {
                Object[] p1 = T4LoggingUtilities.makeParams(connect.props_);
                connect.props_.t4Logger_.logp(Level.INFO, "PreparedStatementManager", "getPreparedStatement", "STATEMENT CACHING INFO: STATEMENT NOT FOUND IN CACHE", p1);
            }
        }
        return pStmt;
    }

    void setLogInfo(Level traceLevel, PrintWriter out) {
        this.traceLevel_ = traceLevel;
        this.out_ = out;
    }

    PreparedStatementManager() {
        String className = this.getClass().getName();
        this.traceId_ = "jdbcTrace:[" + Thread.currentThread() + "]:[" + this.hashCode() + "]:" + className + ".";
        this.sqlStringWeight = new Hashtable();
    }

    PreparedStatementManager(T4Properties t4props) {
        String className = this.getClass().getName();
        if (t4props != null) {
            this.maxStatements_ = t4props.getMaxStatements();
            if (t4props.getMfuStatementCache().equals("YES")) {
                this.setMfu(true);
            } else {
                this.setMfu(false);
            }
        }
        if (this.maxStatements_ > 0) {
            this.prepStmtsInCache_ = new Hashtable();
            this.thrownPrepStmts_ = new ArrayList();
        }
        this.sqlStringWeight = new Hashtable();
        this.traceId_ = "jdbcTrace:[" + Thread.currentThread() + "]:[" + this.hashCode() + "]:" + className + ".";
    }

    public void setMfu(boolean mfcEnabled) {
        this.mfu = mfcEnabled;
    }

    public boolean isMfu() {
        return this.mfu;
    }

    public void setWeight(String sqlString, int resultSetHoldability) throws SQLException {
        String lookupKey = this.createKey((SQLMXConnection)this, sqlString, resultSetHoldability);
        int weight = 1;
        if (this.sqlStringWeight.containsKey(lookupKey)) {
            Integer currentWeight = (Integer)this.sqlStringWeight.get(lookupKey);
            weight = currentWeight + 1;
            this.sqlStringWeight.remove(lookupKey);
        }
        this.sqlStringWeight.put(lookupKey, new Integer(Math.abs(weight)));
    }
}

