/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.BaseRow;
import com.tandem.t4jdbc.SQLMXLob;
import com.tandem.t4jdbc.SQLMXMessages;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Locale;

class Row
extends BaseRow
implements Serializable,
Cloneable {
    private Object[] currentVals;
    private BitSet colsChanged;
    private boolean deleted;
    private boolean updated;
    private boolean inserted;
    private int numCols;

    Row(int i) {
        this.origVals = new Object[i];
        this.currentVals = new Object[i];
        this.colsChanged = new BitSet(i);
        this.numCols = i;
    }

    Row(int i, Object[] aobj) {
        this.origVals = new Object[i];
        for (int j = 0; j < i; ++j) {
            this.origVals[j] = aobj[j];
        }
        this.currentVals = new Object[i];
        this.colsChanged = new BitSet(i);
        this.numCols = i;
    }

    protected void clearDeleted() {
        this.deleted = false;
    }

    protected void clearInserted() {
        this.inserted = false;
    }

    protected void clearUpdated() {
        this.updated = false;
        for (int i = 0; i < this.numCols; ++i) {
            this.currentVals[i] = null;
            this.colsChanged.clear(i);
        }
    }

    protected boolean getColUpdated(int i) {
        return this.colsChanged.get(i);
    }

    protected Object getColumnObject(int i) throws SQLException {
        if (this.getColUpdated(i - 1)) {
            return this.currentVals[i - 1];
        }
        return this.origVals[i - 1];
    }

    protected boolean getDeleted() {
        return this.deleted;
    }

    protected boolean getInserted() {
        return this.inserted;
    }

    protected boolean getUpdated() {
        return this.updated;
    }

    protected void initColumnObject(int i, Object obj) {
        this.origVals[i - 1] = obj;
    }

    protected void moveCurrentToOrig() {
        for (int i = 0; i < this.numCols; ++i) {
            if (!this.getColUpdated(i)) continue;
            this.origVals[i] = this.currentVals[i];
            this.currentVals[i] = null;
            this.colsChanged.clear(i);
        }
    }

    private void setColUpdated(int i) {
        this.colsChanged.set(i);
    }

    protected void setColumnObject(int i, Object obj) {
        this.currentVals[i - 1] = obj;
        this.setColUpdated(i - 1);
    }

    protected void setLobObject(int i, Object obj) {
        this.currentVals[i - 1] = obj;
        this.origVals[i - 1] = obj;
    }

    protected void setDeleted() {
        this.deleted = true;
    }

    protected void setInserted() {
        this.inserted = true;
    }

    protected void setUpdated() {
        this.updated = true;
    }

    protected void deleteRow(Locale locale, PreparedStatement deleteStmt, BitSet paramCols) throws SQLException {
        int j = 1;
        for (int i = 0; i < this.numCols; ++i) {
            if (!paramCols.get(i)) continue;
            deleteStmt.setObject(j++, this.origVals[i]);
        }
        int count = deleteStmt.executeUpdate();
        if (count == 0) {
            throw SQLMXMessages.createSQLException(null, locale, "row_modified", null);
        }
    }

    protected void updateRow(Locale locale, PreparedStatement updateStmt, BitSet paramCols, BitSet keyCols) throws SQLException {
        Object obj;
        int i;
        int j = 1;
        for (i = 0; i < this.numCols; ++i) {
            if (keyCols.get(i)) {
                if (!this.getColUpdated(i)) continue;
                throw SQLMXMessages.createSQLException(null, locale, "primary_key_not_updateable", null);
            }
            if (!paramCols.get(i)) continue;
            obj = this.getColumnObject(i + 1);
            if (obj instanceof SQLMXLob && obj == this.origVals[i]) {
                updateStmt.setObject(j++, new Long(((SQLMXLob)obj).dataLocator_));
                continue;
            }
            updateStmt.setObject(j++, this.getColumnObject(i + 1));
        }
        for (i = 0; i < this.numCols; ++i) {
            if (!keyCols.get(i)) continue;
            obj = this.origVals[i];
            if (obj instanceof SQLMXLob) {
                updateStmt.setObject(j++, new Long(((SQLMXLob)obj).dataLocator_));
                continue;
            }
            updateStmt.setObject(j++, this.origVals[i]);
        }
        int count = updateStmt.executeUpdate();
        if (count == 0) {
            throw SQLMXMessages.createSQLException(null, locale, "row_modified", null);
        }
        this.moveCurrentToOrig();
        this.setUpdated();
    }

    protected void refreshRow(Locale locale, PreparedStatement selectStmt, BitSet selectCols, BitSet keyCols) throws SQLException {
        int i;
        this.clearUpdated();
        int j = 1;
        for (i = 0; i < this.numCols; ++i) {
            if (!keyCols.get(i)) continue;
            selectStmt.setObject(j++, this.origVals[i]);
        }
        ResultSet rs = selectStmt.executeQuery();
        if (rs != null) {
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCount = rsmd.getColumnCount();
                rs.next();
                j = 1;
                for (i = 0; i < this.numCols; ++i) {
                    if (!selectCols.get(i)) continue;
                    this.origVals[i] = rs.getObject(j++);
                }
            }
            catch (SQLException ex) {
                throw ex;
            }
            finally {
                rs.close();
            }
        }
    }

    protected void closeLobObjects() {
        for (int i = 0; i < this.numCols; ++i) {
            if (!(this.currentVals[i] instanceof SQLMXLob)) continue;
            SQLMXLob lob = (SQLMXLob)this.currentVals[i];
            lob.close();
        }
    }
}

