/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXLob;
import com.tandem.t4jdbc.SQLMXLobOutputStream;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SQLMXBlob
extends SQLMXLob
implements Blob {
    Blob inputLob_;
    byte[] b_;

    public InputStream getBinaryStream() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "getBinaryStream", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXBlob");
            lr.setSourceClassName("getBinaryStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        this.checkIfCurrent();
        return this.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, length);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "getBytes", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXBlob");
            lr.setSourceMethodName("getBytes");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (pos <= 0L || length < 0) {
            Object[] messageArguments = new Object[]{"Blob.getBytes(long, int)"};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_input_value", messageArguments);
        }
        this.checkIfCurrent();
        int startChunkNo = (int)((pos - 1L) / (long)this.chunkSize_);
        int endChunkNo = (int)((pos - 1L + (long)length) / (long)this.chunkSize_);
        int copyLen = length;
        int offset = (int)((pos - 1L) % (long)this.chunkSize_);
        int copyOffset = 0;
        int readLen = 0;
        byte[] b = new byte[length];
        this.prepareGetLobDataStmt();
        PreparedStatement preparedStatement = this.conn_.LobPreparedStatements[8];
        synchronized (preparedStatement) {
            this.conn_.LobPreparedStatements[8].setString(1, this.tableName_);
            this.conn_.LobPreparedStatements[8].setLong(2, this.dataLocator_);
            this.conn_.LobPreparedStatements[8].setInt(3, startChunkNo);
            this.conn_.LobPreparedStatements[8].setInt(4, endChunkNo);
            ResultSet rs = this.conn_.LobPreparedStatements[8].executeQuery();
            try {
                while (rs.next()) {
                    byte[] data = rs.getBytes(1);
                    int dataLength = data.length - offset;
                    if (dataLength >= copyLen) {
                        System.arraycopy(data, offset, b, copyOffset, copyLen);
                        readLen += copyLen;
                        break;
                    }
                    System.arraycopy(data, offset, b, copyOffset, dataLength);
                    copyLen -= dataLength;
                    copyOffset += dataLength;
                    readLen += dataLength;
                    offset = 0;
                }
            }
            finally {
                rs.close();
            }
        }
        if (readLen == length) {
            return b;
        }
        byte[] b1 = new byte[readLen];
        System.arraycopy(b, 0, b1, 0, readLen);
        return b1;
    }

    public long position(Blob pattern, long start) throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)pattern, start);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "position", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)pattern, start);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXBlob");
            lr.setSourceMethodName("position");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (start <= 0L) {
            Object[] messageArguments = new Object[]{"Blob.position(Blob, long)"};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_input_value", messageArguments);
        }
        this.checkIfCurrent();
        byte[] searchPattern = pattern.getBytes(1L, (int)pattern.length());
        return this.position(searchPattern, start);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)pattern, start);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "position", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)pattern, start);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXBlob");
            lr.setSourceMethodName("position");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (start <= 0L) {
            Object[] messageArguments = new Object[]{"Blob.position(byte[], long)"};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_input_value", messageArguments);
        }
        this.checkIfCurrent();
        byte[] blobData = this.getBytes(start, (int)this.length());
        long retValue = SQLMXBlob.findBytes(blobData, 0, blobData.length, pattern);
        if (retValue != -1L) {
            retValue += start;
        }
        return retValue;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "setBinaryStream", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXBlob");
            lr.setSourceMethodName("setBinaryStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        this.checkAutoCommitExtTxn();
        this.checkIfCurrent();
        return this.setOutputStream(pos);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, (Object)bytes);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "setBytes", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, (Object)bytes);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXBlob");
            lr.setSourceMethodName("setBytes");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (bytes == null) {
            Object[] messageArguments = new Object[]{"Blob.setBytes(long, byte[])"};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_input_value", messageArguments);
        }
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        PreparedStatement preparedStatement;
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, (Object)bytes, offset, len);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "setBytes", "", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, pos, (Object)bytes, offset, len);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXBlob");
            lr.setSourceMethodName("setBytes");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        byte[] tempChunk = null;
        if (pos <= 0L || len < 0 || offset < 0 || bytes == null) {
            Object[] messageArguments = new Object[]{"Blob.setBytes(long, byte[], int, int)"};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_input_value", messageArguments);
        }
        this.checkIfCurrent();
        long lobLen = this.length();
        if (pos > lobLen + 1L) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_position_value", null);
        }
        int copyLen = len;
        long remLen = pos - 1L + (long)len;
        int byteOffset = offset;
        int totalRetLen = 0;
        int chunkNo = (int)((pos - 1L) / (long)this.chunkSize_);
        long lobLenForUpd = lobLen % (long)this.chunkSize_ == 0L ? lobLen / (long)this.chunkSize_ * (long)this.chunkSize_ : (lobLen / (long)this.chunkSize_ + 1L) * (long)this.chunkSize_;
        int updLen = remLen <= lobLenForUpd ? len : (int)(lobLenForUpd - (pos - 1L));
        if (updLen > 0) {
            int updOffset = (int)((pos - 1L) % (long)this.chunkSize_);
            this.prepareUpdLobDataStmt();
            preparedStatement = this.conn_.LobPreparedStatements[12];
            synchronized (preparedStatement) {
                this.conn_.LobPreparedStatements[12].setString(4, this.tableName_);
                this.conn_.LobPreparedStatements[12].setLong(5, this.dataLocator_);
                while (true) {
                    this.conn_.LobPreparedStatements[12].setInt(6, chunkNo);
                    this.conn_.LobPreparedStatements[12].setInt(1, updOffset);
                    if (updOffset + updLen <= this.chunkSize_) {
                        this.conn_.LobPreparedStatements[12].setInt(3, updOffset + updLen + 1);
                        if (byteOffset == 0 && updLen - updOffset == bytes.length) {
                            this.conn_.LobPreparedStatements[12].setBytes(2, bytes);
                        } else {
                            tempChunk = new byte[updLen];
                            System.arraycopy(bytes, byteOffset, tempChunk, 0, updLen);
                            this.conn_.LobPreparedStatements[12].setBytes(2, tempChunk);
                        }
                        this.conn_.LobPreparedStatements[12].executeUpdate();
                        totalRetLen += updLen;
                        byteOffset += updLen;
                        ++chunkNo;
                        break;
                    }
                    this.conn_.LobPreparedStatements[12].setInt(3, this.chunkSize_ + 1);
                    if (tempChunk == null || tempChunk.length != this.chunkSize_ - updOffset) {
                        tempChunk = new byte[this.chunkSize_ - updOffset];
                    }
                    System.arraycopy(bytes, byteOffset, tempChunk, 0, this.chunkSize_ - updOffset);
                    this.conn_.LobPreparedStatements[12].setBytes(2, tempChunk);
                    this.conn_.LobPreparedStatements[12].executeUpdate();
                    totalRetLen += this.chunkSize_ - updOffset;
                    byteOffset += this.chunkSize_ - updOffset;
                    updLen -= this.chunkSize_ - updOffset;
                    ++chunkNo;
                    updOffset = 0;
                }
            }
            copyLen = (int)(remLen - lobLenForUpd);
        }
        tempChunk = null;
        if (remLen > lobLenForUpd) {
            while (true) {
                this.prepareInsLobDataStmt();
                preparedStatement = this.conn_.LobPreparedStatements[7];
                synchronized (preparedStatement) {
                    this.conn_.LobPreparedStatements[7].setString(1, this.tableName_);
                    this.conn_.LobPreparedStatements[7].setLong(2, this.dataLocator_);
                    this.conn_.LobPreparedStatements[7].setInt(3, chunkNo);
                    if (copyLen <= this.chunkSize_) {
                        if (byteOffset == 0 && copyLen == bytes.length) {
                            this.conn_.LobPreparedStatements[7].setBytes(4, bytes);
                        } else {
                            tempChunk = new byte[copyLen];
                            System.arraycopy(bytes, byteOffset, tempChunk, 0, copyLen);
                            this.conn_.LobPreparedStatements[7].setBytes(4, tempChunk);
                        }
                        this.conn_.LobPreparedStatements[7].executeUpdate();
                        totalRetLen += copyLen;
                        break;
                    }
                    if (tempChunk == null) {
                        tempChunk = new byte[this.chunkSize_];
                    }
                    System.arraycopy(bytes, byteOffset, tempChunk, 0, this.chunkSize_);
                    this.conn_.LobPreparedStatements[7].setBytes(4, tempChunk);
                    this.conn_.LobPreparedStatements[7].executeUpdate();
                    byteOffset += this.chunkSize_;
                    copyLen -= this.chunkSize_;
                    totalRetLen += this.chunkSize_;
                    ++chunkNo;
                }
            }
        }
        return totalRetLen;
    }

    void populate() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "populate", "", p);
        }
        if (this.is_ != null) {
            SQLMXLobOutputStream os = (SQLMXLobOutputStream)this.setOutputStream(1L);
            if (this.conn_.isCallProc_) {
                os.populate2(this.is_, this.isLength_);
            } else {
                os.populate(this.is_, this.isLength_);
            }
            this.is_ = null;
        } else if (this.inputLob_ != null) {
            this.populateFromBlob();
            this.inputLob_ = null;
        } else if (this.b_ != null) {
            this.setBytes(1L, this.b_);
            this.b_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populateFromBlob() throws SQLException {
        byte[] b;
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "populateFromBlob", "", p);
        }
        int chunkNo = 0;
        long pos = 1L;
        if (this.inputLob_ instanceof SQLMXBlob) {
            SQLMXBlob inputBlob = (SQLMXBlob)this.inputLob_;
            this.prepareGetLobDataStmt();
            this.prepareInsLobDataStmt();
            PreparedStatement preparedStatement = this.conn_.LobPreparedStatements[8];
            synchronized (preparedStatement) {
                this.conn_.LobPreparedStatements[8].setString(1, inputBlob.tableName_);
                this.conn_.LobPreparedStatements[8].setLong(2, inputBlob.dataLocator_);
                this.conn_.LobPreparedStatements[8].setInt(3, 0);
                this.conn_.LobPreparedStatements[8].setInt(4, Integer.MAX_VALUE);
                ResultSet rs = this.conn_.LobPreparedStatements[8].executeQuery();
                PreparedStatement preparedStatement2 = this.conn_.LobPreparedStatements[7];
                synchronized (preparedStatement2) {
                    try {
                        this.conn_.LobPreparedStatements[7].setString(1, this.tableName_);
                        this.conn_.LobPreparedStatements[7].setLong(2, this.dataLocator_);
                        while (rs.next()) {
                            byte[] b2 = rs.getBytes(1);
                            this.conn_.LobPreparedStatements[7].setInt(3, chunkNo);
                            this.conn_.LobPreparedStatements[7].setBytes(4, b2);
                            this.conn_.LobPreparedStatements[7].executeUpdate();
                            ++chunkNo;
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
            }
        }
        while ((b = this.inputLob_.getBytes(pos, this.chunkSize_)).length != 0) {
            int ret = this.setBytes(pos, b);
            pos += (long)b.length;
        }
    }

    static final int findBytes(byte[] buf, int off, int len, byte[] ptrn) {
        int buf_len = off + len;
        int ptrn_len = ptrn.length;
        byte b = ptrn[0];
        int i = off;
        while (i < buf_len) {
            int j;
            for (j = 0; i < buf_len && j < ptrn_len && buf[i] == ptrn[j]; ++i, ++j) {
            }
            if (i == buf_len || j == ptrn_len) {
                return i - j;
            }
            i = i - j + 1;
        }
        return -1;
    }

    void prepareGetLobLenStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "prepareGetLobLenStmt", "", p);
        }
        this.conn_.prepareGetLobLenStmt(this.lobTableName_, true);
    }

    void prepareDelLobDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "prepareDelLobDataStmt", "", p);
        }
        this.conn_.prepareDelLobDataStmt(this.lobTableName_, true);
    }

    void prepareGetLobDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "prepareGetLobDataStmt", "", p);
        }
        this.conn_.prepareGetLobDataStmt(this.lobTableName_, true);
    }

    void prepareUpdLobDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "prepareUpdLobDataStmt", "", p);
        }
        this.conn_.prepareUpdLobDataStmt(this.lobTableName_, true);
    }

    void prepareInsLobDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "prepareInsLobDatStmt", "", p);
        }
        this.conn_.prepareInsLobDataStmt(this.lobTableName_, true);
    }

    void prepareTrunLobDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "prepareTrunLobDataStmt", "", p);
        }
        this.conn_.prepareTrunLobDataStmt(this.lobTableName_, true);
    }

    void prepareInsSpjLobDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "prepareInsSpjLobDatStmt", "", p);
        }
        this.conn_.prepareInsSpjLobDataStmt(true);
    }

    PreparedStatement getSpjInsLobDataStmt() {
        return this.conn_.SpjLobPreparedStatements[0];
    }

    void prepareInsSpjBaseDataStmt() throws SQLException {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "prepareInsSpjBaseDataStmt", "", p);
        }
        this.conn_.prepareInsSpjBaseDataStmt(true);
    }

    PreparedStatement getSpjInsBaseDataStmt() {
        return this.conn_.SpjLobPreparedStatements[2];
    }

    PreparedStatement getGetLobLenStmt() {
        return this.conn_.LobPreparedStatements[9];
    }

    PreparedStatement getDelLobDataStmt() {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "getDelLobDataStmt", "", p);
        }
        return this.conn_.LobPreparedStatements[10];
    }

    PreparedStatement getTrunLobDataStmt() {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "getTrunLobDataStmt", "", p);
        }
        return this.conn_.LobPreparedStatements[11];
    }

    PreparedStatement getInsLobDataStmt() {
        return this.conn_.LobPreparedStatements[7];
    }

    PreparedStatement getUpdLobDataStmt() {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "getUpdLobDataStmt", "", p);
        }
        return this.conn_.LobPreparedStatements[12];
    }

    PreparedStatement getGetLobDataStmt() {
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_);
            this.conn_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "getGetLobDataStmt", "", p);
        }
        return this.conn_.LobPreparedStatements[8];
    }

    SQLMXBlob(SQLMXConnection connection, String tableName, long dataLocator) throws SQLException {
        super(connection, tableName, dataLocator, connection.blobTableName_, true);
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "", "Note, this constructor was called before the previous constructor", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXBlob");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (connection.blobTableName_ == null) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "no_blobTableName", null);
        }
    }

    SQLMXBlob(SQLMXConnection connection, String tableName, long dataLocator, InputStream x, int length) throws SQLException {
        super(connection, tableName, dataLocator, x, length, connection.blobTableName_, true);
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)x, length);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "", "Note, this constructor was called before the previous constructor", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXBlob");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (connection.blobTableName_ == null) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "no_blobTableName", null);
        }
    }

    SQLMXBlob(SQLMXConnection connection, String tableName, long dataLocator, Blob inputLob) throws SQLException {
        super(connection, tableName, dataLocator, connection.blobTableName_, true);
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)inputLob);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "", "Note, this constructor was called before the previous constructor", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)inputLob);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXBlob");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (connection.blobTableName_ == null) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "no_blobTableName", null);
        }
        this.inputLob_ = inputLob;
    }

    SQLMXBlob(SQLMXConnection connection, String tableName, long dataLocator, byte[] b) throws SQLException {
        super(connection, tableName, dataLocator, connection.blobTableName_, true);
        if (this.conn_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)b);
            this.conn_.props_.t4Logger_.logp(Level.FINE, "SQLMXBlob", "", "Note, this constructor was called before the previous constructor", p);
        }
        if (this.conn_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.conn_.props_, (Object)connection, (Object)tableName, dataLocator, (Object)b);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXBlob");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.conn_.props_.getLogWriter().println(temp);
        }
        if (connection.blobTableName_ == null) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "no_blobTableName", null);
        }
        this.b_ = b;
    }
}

