/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.InterfaceUtilities;
import com.tandem.t4jdbc.SQLMXBlob;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXPreparedStatement;
import com.tandem.t4jdbc.SQLMXResultSet;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SQLMXCallableStatement
extends SQLMXPreparedStatement
implements CallableStatement {
    boolean wasNull_;
    short returnResultSet_;

    public Array getArray(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getArray", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getArray");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "getArray()");
        return null;
    }

    public Array getArray(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getArray", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getArray");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getArray(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        BigDecimal retValue;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getString(parameterIndex);
        if (data == null) {
            this.wasNull_ = true;
            return null;
        }
        this.wasNull_ = false;
        try {
            retValue = new BigDecimal(data);
        }
        catch (NumberFormatException e) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
        }
        return retValue;
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        BigDecimal retValue;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, scale);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, scale);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if ((retValue = this.getBigDecimal(parameterIndex)) != null) {
            return retValue.setScale(scale);
        }
        return null;
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getBigDecimal(parameterIndex);
    }

    public BigDecimal getBigDecimal(String parameterName, int scale) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, scale);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, scale);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getBigDecimal(parameterIndex, scale);
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getBlob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getBlob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        boolean isSpj = true;
        this.validateGetInvocation(parameterIndex);
        int targetSqlType = this.inputDesc_[parameterIndex - 1].dataType_;
        int sqlCharset = this.inputDesc_[parameterIndex - 1].sqlCharset_;
        if (targetSqlType != 2004) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        long data_locator = this.getLong(parameterIndex);
        Blob data = this.readSpjBlob(data_locator);
        return data;
    }

    public Blob getBlob(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getBlob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getBlob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getBlob(parameterIndex);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getBoolean", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getBoolean");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getString(parameterIndex);
        if (data != null) {
            this.wasNull_ = false;
            return !data.equals("0");
        }
        this.wasNull_ = true;
        return false;
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getBoolean", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getBoolean");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getBoolean(parameterIndex);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getByte", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getByte");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getString(parameterIndex);
        if (data != null) {
            this.wasNull_ = false;
            return Byte.parseByte(data);
        }
        this.wasNull_ = true;
        return 0;
    }

    public byte getByte(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getByte", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getByte");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getByte(parameterIndex);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getBytes", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getBytes");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        switch (dataType) {
            case -4: 
            case -3: 
            case -2: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
            }
            case 2004: {
                Blob blob = this.getBlob(parameterIndex);
                if (blob == null) {
                    return null;
                }
                return blob.getBytes(1L, (int)blob.length());
            }
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "datatype_not_supported", null);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getBytes", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getBytes");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getBytes(parameterIndex);
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getClob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getClob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "getClob()");
        return null;
    }

    public Clob getClob(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getClob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getClob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getClob(parameterIndex);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 91 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        String dateStr = this.getString(parameterIndex);
        if (dateStr != null) {
            Date retValue;
            this.wasNull_ = false;
            try {
                boolean convertDate = this.connection_.getDateConversion();
                if (convertDate) {
                    String dt = SQLMXResultSet.convertDateFormat(dateStr);
                    retValue = SQLMXResultSet.valueOf(dt);
                } else {
                    retValue = Date.valueOf(dateStr);
                }
            }
            catch (IllegalArgumentException e) {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
            }
            return retValue;
        }
        this.wasNull_ = true;
        return null;
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Date sqlDate;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if ((sqlDate = this.getDate(parameterIndex)) != null) {
            if (cal != null) {
                cal.setTime(sqlDate);
                java.util.Date d = cal.getTime();
                sqlDate = new Date(d.getTime());
            }
            return sqlDate;
        }
        return sqlDate;
    }

    public Date getDate(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getDate(parameterIndex);
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getDate(parameterIndex, cal);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getDouble", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getDouble");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getString(parameterIndex);
        if (data != null) {
            this.wasNull_ = false;
            return Double.parseDouble(data);
        }
        this.wasNull_ = true;
        return 0.0;
    }

    public double getDouble(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getDouble", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getDouble");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getDouble(parameterIndex);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getFloat", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getFloat");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getString(parameterIndex);
        if (data != null) {
            this.wasNull_ = false;
            return Float.parseFloat(data);
        }
        this.wasNull_ = true;
        return 0.0f;
    }

    public float getFloat(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getFloat", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getFloat");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getFloat(parameterIndex);
    }

    public int getInt(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getInt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getInt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getString(parameterIndex);
        if (data != null) {
            this.wasNull_ = false;
            return Integer.parseInt(data);
        }
        this.wasNull_ = true;
        return 0;
    }

    public int getInt(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getInt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getInt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getInt(parameterIndex);
    }

    public long getLong(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getLong", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getLong");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getString(parameterIndex);
        if (data != null) {
            this.wasNull_ = false;
            return Long.parseLong(data);
        }
        this.wasNull_ = true;
        return 0L;
    }

    public long getLong(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getLong", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getLong");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getLong(parameterIndex);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        switch (dataType) {
            case -6: {
                byte byteValue = this.getByte(parameterIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Byte(byteValue);
            }
            case 5: {
                short intValue = this.getShort(parameterIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Integer(intValue);
            }
            case 4: {
                int intValue = this.getInt(parameterIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Integer(intValue);
            }
            case -5: {
                long longValue = this.getLong(parameterIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Long(longValue);
            }
            case 7: {
                float floatValue = this.getFloat(parameterIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Float(floatValue);
            }
            case 6: 
            case 8: {
                double doubleValue = this.getDouble(parameterIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Double(doubleValue);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(parameterIndex);
            }
            case -7: {
                boolean booleanValue = this.getBoolean(parameterIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Boolean(booleanValue);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(parameterIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(parameterIndex);
            }
            case 91: {
                return this.getDate(parameterIndex);
            }
            case 92: {
                return this.getTime(parameterIndex);
            }
            case 93: {
                return this.getTimestamp(parameterIndex);
            }
            case 2004: {
                return this.getBlob(parameterIndex);
            }
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)map);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)map);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "getObject()");
        return null;
    }

    public Object getObject(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getOjbect", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getOjbect");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getObject(parameterIndex);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)map);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)map);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getObject(parameterIndex, map);
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getRef", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getRef");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "getRef()");
        return null;
    }

    public Ref getRef(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getRef", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getRef");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getRef(parameterIndex);
    }

    public short getShort(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getShort", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getShort");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        this.inputDesc_[parameterIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getString(parameterIndex);
        if (data != null) {
            this.wasNull_ = false;
            return Short.parseShort(data);
        }
        this.wasNull_ = true;
        return 0;
    }

    public short getShort(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getShort", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getShort");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getShort(parameterIndex);
    }

    public String getString(int parameterIndex) throws SQLException {
        String data;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getString", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        int targetSqlType = this.inputDesc_[parameterIndex - 1].dataType_;
        int sqlCharset = this.inputDesc_[parameterIndex - 1].sqlCharset_;
        Object x = this.inputDesc_[parameterIndex - 1].paramValue_;
        if (x == null) {
            this.wasNull_ = true;
            data = null;
        } else if (x instanceof byte[]) {
            try {
                if (this.ist_.ic_.getISOMapping() == 1 && !this.ist_.ic_.getEnforceISO() && sqlCharset == 1) {
                    data = new String((byte[])x, this.ist_.ic_.t4props_.getISO88591());
                } else if (sqlCharset == -1 || sqlCharset == -2 || sqlCharset == 11) {
                    String charSet = InterfaceUtilities.getEncodingTranslation(this.connection_, sqlCharset);
                    data = new String((byte[])x, charSet);
                } else {
                    data = this.ist_.ic_.decodeBytes((byte[])x, sqlCharset);
                }
                this.wasNull_ = false;
            }
            catch (CharacterCodingException e) {
                SQLMXException se = SQLMXMessages.createSQLException(this.connection_.ic_.t4props_, this.connection_.getLocale(), "translation_of_parameter_failed", "getLocalString", e.getMessage());
                se.initCause(e);
                throw se;
            }
            catch (UnsupportedCharsetException e) {
                SQLMXException se = SQLMXMessages.createSQLException(this.connection_.ic_.t4props_, this.connection_.getLocale(), "unsupported_encoding", e.getCharsetName());
                se.initCause(e);
                throw se;
            }
            catch (UnsupportedEncodingException e) {
                SQLMXException se = SQLMXMessages.createSQLException(this.connection_.ic_.t4props_, this.connection_.getLocale(), "unsupported_encoding", e.getMessage());
                se.initCause(e);
                throw se;
            }
        } else {
            data = x.toString();
            this.wasNull_ = false;
        }
        return data;
    }

    public String getString(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getString", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getString(parameterIndex);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 92 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        String timeStr = this.getString(parameterIndex);
        if (timeStr != null) {
            Time retValue;
            try {
                this.wasNull_ = false;
                retValue = Time.valueOf(timeStr);
            }
            catch (IllegalArgumentException e) {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
            }
            return retValue;
        }
        this.wasNull_ = true;
        return null;
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Time sqlTime;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if ((sqlTime = this.getTime(parameterIndex)) != null) {
            if (cal != null) {
                cal.setTime(sqlTime);
                java.util.Date d = cal.getTime();
                sqlTime = new Time(d.getTime());
            }
            return sqlTime;
        }
        return sqlTime;
    }

    public Time getTime(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getTime(parameterIndex);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getTime(parameterIndex, cal);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 91 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        String timestampStr = this.getString(parameterIndex);
        if (timestampStr != null) {
            Timestamp retValue;
            try {
                this.wasNull_ = false;
                retValue = Timestamp.valueOf(timestampStr);
            }
            catch (IllegalArgumentException e) {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
            }
            return retValue;
        }
        this.wasNull_ = true;
        return null;
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp sqlTimestamp;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if ((sqlTimestamp = this.getTimestamp(parameterIndex)) != null) {
            if (cal != null) {
                int nanos = sqlTimestamp.getNanos();
                cal.setTime(sqlTimestamp);
                java.util.Date d = cal.getTime();
                sqlTimestamp = new Timestamp(d.getTime());
                sqlTimestamp.setNanos(nanos);
            }
            return sqlTimestamp;
        }
        return sqlTimestamp;
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getTimestamp(parameterIndex);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getTimestamp(parameterIndex, cal);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getURL", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getURL");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "getURL()");
        return null;
    }

    public URL getURL(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "getURL", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("getURL");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        return this.getURL(parameterName);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, sqlType);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "registerOutParameter", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, sqlType);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("registerOutParameter");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        if (this.inputDesc_[parameterIndex - 1].paramMode_ == 4) {
            this.inputDesc_[parameterIndex - 1].isValueSet_ = true;
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, sqlType, scale);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "registerOutParameter", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, sqlType, scale);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("registerOutParameter");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        if (this.inputDesc_[parameterIndex - 1].paramMode_ == 4) {
            this.inputDesc_[parameterIndex - 1].isValueSet_ = true;
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, sqlType, (Object)typeName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "registerOutParameter", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex, sqlType, (Object)typeName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("registerOutParameter");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(parameterIndex);
        if (this.inputDesc_[parameterIndex - 1].paramMode_ == 4) {
            this.inputDesc_[parameterIndex - 1].isValueSet_ = true;
        }
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, sqlType);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "registerOutParameter", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, sqlType);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("registerOutParameter");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        this.registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, sqlType, scale);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "registerOutParameter", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, sqlType, scale);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("registerOutParameter");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        this.registerOutParameter(parameterIndex, sqlType, scale);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, sqlType, (Object)typeName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "registerOutParameter", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, sqlType, (Object)typeName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("registerOutParameter");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateGetInvocation(parameterName);
        this.registerOutParameter(parameterIndex, sqlType, typeName);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setAsciiStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setAsciiStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setAsciiStream(parameterIndex, x, length);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setBigDecimal(parameterIndex, x);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setBinaryStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setBinaryStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        String paramName = null;
        String tempstr = " - BLOB";
        this.connection_.isCallProc_ = true;
        if (true) {
            paramName = parameterName.indexOf(tempstr) > 0 ? parameterName : parameterName.concat(tempstr);
        }
        int parameterIndex = this.validateSetInvocation(paramName);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        this.setBinaryStream(parameterIndex, x, length);
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setBlob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setBlob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        String paramName = null;
        String tempstr = " - BLOB";
        this.connection_.isCallProc_ = true;
        if (true) {
            paramName = parameterName.indexOf(tempstr) > 0 ? parameterName : parameterName.concat(tempstr);
        }
        int parameterIndex = this.validateSetInvocation(paramName);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        this.setBlob(parameterIndex, x);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setBoolean", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setBoolean");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setBoolean(parameterIndex, x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setByte", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setByte");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setByte(parameterIndex, x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setBytes", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setBytes");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        String paramName = null;
        String tempstr = " - BLOB";
        this.connection_.isCallProc_ = true;
        if (true) {
            paramName = parameterName.indexOf(tempstr) > 0 ? parameterName : parameterName.concat(tempstr);
        }
        int parameterIndex = this.validateSetInvocation(paramName);
        int dataType = this.inputDesc_[parameterIndex - 1].dataType_;
        this.setBytes(parameterIndex, x);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)reader, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setCharacterStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)reader, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setCharacterStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setCharacterStream(parameterIndex, reader, length);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setDate(parameterIndex, x);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setDate(parameterIndex, x, cal);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setDouble", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setDouble");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setDouble(parameterIndex, x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (double)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setFloat", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (double)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setFloat");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setFloat(parameterIndex, x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setInt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setInt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setInt(parameterIndex, x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setLong", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setLong");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setLong(parameterIndex, x);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, sqlType);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setNull", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, sqlType);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setNull");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setNull(parameterIndex, sqlType);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, sqlType, (Object)typeName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setNull", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, sqlType, (Object)typeName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setNull");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setNull(parameterIndex, sqlType, typeName);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setObject(parameterIndex, x);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x, targetSqlType);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x, targetSqlType);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x, targetSqlType, scale);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x, targetSqlType, scale);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setShort", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setShort");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setShort(parameterIndex, x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setString", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setString(parameterIndex, x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setTime(parameterIndex, x);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setTimestamp(parameterIndex, x);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setTimestamp(parameterIndex, x, cal);
    }

    public void setUnicodeStream(String parameterName, InputStream x, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setUnicodeStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setUnicodeStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setUnicodeStream(parameterIndex, x, length);
    }

    public void setURL(String parameterName, URL x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "setURL", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)parameterName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("setURL");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int parameterIndex = this.validateSetInvocation(parameterName);
        this.setURL(parameterIndex, x);
    }

    public boolean wasNull() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "wasNull", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("wasNull");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.wasNull_;
    }

    public boolean execute() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, this.stmtLabel_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "execute", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("execute");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        Object[] valueArray = null;
        int inDescLength = 0;
        if (this.inputDesc_ != null) {
            valueArray = this.getValueArray();
            inDescLength = this.inputDesc_.length;
        }
        this.validateExecuteInvocation();
        valueArray = this.getValueArray();
        if (this.inputDesc_ != null && this.connection_.isCallProc_) {
            this.populateSpjLob();
        }
        if (!this.connection_.getAutoCommit()) {
            this.connection_.isActiveTrans = true;
        }
        this.ist_.execute((short)3025, this.paramRowCount_, inDescLength, valueArray, this.queryTimeout_, null, this);
        return this.resultSet_[this.result_set_offset] != null && this.resultSet_[this.result_set_offset].spj_rs_;
    }

    public int[] executeBatch() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "executeBatch", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("executeBatch");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.batchCommands_ == null || this.paramRowCount_ < 1) {
            return new int[0];
        }
        if (this.batchCommands_.isEmpty()) {
            return new int[0];
        }
        this.clearWarnings();
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "executeBatch()");
        return null;
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, this.stmtLabel_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "executeQuery", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("executeQuery");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        Object[] valueArray = null;
        int inDescLength = 0;
        if (this.inputDesc_ != null) {
            valueArray = this.getValueArray();
            inDescLength = this.inputDesc_.length;
        }
        this.validateExecuteInvocation();
        if (!this.connection_.getAutoCommit()) {
            this.connection_.isActiveTrans = true;
        }
        this.ist_.execute((short)3025, this.paramRowCount_, inDescLength, valueArray, this.queryTimeout_, null, this);
        return this.resultSet_[this.result_set_offset];
    }

    public int executeUpdate() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, this.stmtLabel_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "executeUpdate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("executeUpdate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        Object[] valueArray = null;
        int inDescLength = 0;
        if (this.inputDesc_ != null) {
            valueArray = this.getValueArray();
            inDescLength = this.inputDesc_.length;
        }
        this.validateExecuteInvocation();
        valueArray = this.getValueArray();
        if (this.inputDesc_ != null && this.connection_.isCallProc_) {
            this.populateSpjLob();
        }
        if (!this.connection_.getAutoCommit()) {
            this.connection_.isActiveTrans = true;
        }
        this.ist_.execute((short)3025, this.paramRowCount_, inDescLength, valueArray, this.queryTimeout_, null, this);
        return 1;
    }

    protected void validateGetInvocation(int parameterIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXCallableStatement", "validateGetInvocation", "", p);
        }
        this.clearWarnings();
        this.connection_.isConnectionOpen();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_statement", null);
        }
        if (this.inputDesc_ == null) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "not_a_output_parameter", null);
        }
        if (parameterIndex < 1 || parameterIndex > this.inputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_parameter_index", null);
        }
        if (this.inputDesc_[parameterIndex - 1].paramMode_ != 2 && this.inputDesc_[parameterIndex - 1].paramMode_ != 4) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "not_a_output_parameter", null);
        }
    }

    protected int validateGetInvocation(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXCallableStatement", "validateGetInvocation", "", p);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_statement", null);
        }
        if (this.inputDesc_ == null) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "not_a_output_parameter", null);
        }
        for (int i = 0; i < this.inputDesc_.length; ++i) {
            if (!parameterName.equalsIgnoreCase(this.inputDesc_[i].name_)) continue;
            return i + 1;
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_parameter_name", null);
    }

    private int validateSetInvocation(String parameterName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, parameterName);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXCallableStatement", "validateSetInvocation", "", p);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "stmt_closed", null);
        }
        if (this.inputDesc_ == null) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_parameter_index", null);
        }
        for (int i = 0; i < this.inputDesc_.length; ++i) {
            if (!parameterName.equalsIgnoreCase(this.inputDesc_[i].name_)) continue;
            return i + 1;
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_parameter_name", null);
    }

    void setExecuteCallOutputs(Object[] outputValues, short rowsAffected) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)outputValues, rowsAffected);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXCallableStatement", "setExecuteCallOutputs", "", p);
        }
        if (outputValues != null) {
            for (int i = 0; i < outputValues.length; ++i) {
                this.inputDesc_[i].paramValue_ = outputValues[i] == null ? null : (outputValues[i] instanceof byte[] ? outputValues[i] : outputValues[i].toString());
            }
        }
        this.returnResultSet_ = rowsAffected;
    }

    SQLMXCallableStatement(SQLMXConnection connection, String sql) throws SQLException {
        super(connection, sql);
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
    }

    SQLMXCallableStatement(SQLMXConnection connection, String sql, String stmtLabel) throws SQLException {
        super(connection, sql, stmtLabel);
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
    }

    SQLMXCallableStatement(SQLMXConnection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(connection, sql, resultSetType, resultSetConcurrency);
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql, resultSetType);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql, resultSetType);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
    }

    SQLMXCallableStatement(SQLMXConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
    }

    SQLMXCallableStatement(SQLMXConnection connection, String moduleName, int moduleVersion, long moduleTimestamp, String stmtName) throws SQLException {
        super(connection, moduleName, moduleVersion, moduleTimestamp, stmtName, false, connection.holdability_);
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)moduleName, moduleVersion, moduleTimestamp, (Object)stmtName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)connection, (Object)moduleName, moduleVersion, moduleTimestamp, (Object)stmtName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXCallableStatement");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
    }

    void populateSpjLob() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "populateSpjLob", "", p);
        }
        if (this.connection_.isCallProc_) {
            for (int i = 0; i < this.inputDesc_.length; ++i) {
                if (this.inputDesc_[i].paramValue_ == null) continue;
                Object lob = this.inputDesc_[i].paramValue_;
                ((SQLMXBlob)lob).populate();
            }
        }
    }

    Blob readSpjBlob(long data_locator) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXCallableStatement", "readSpjBlob", "", p);
        }
        Blob data = null;
        for (int i = 0; i < this.inputDesc_.length; ++i) {
            if (this.inputDesc_[i].paramValue_ == null) continue;
            long dataloc = data_locator;
            data = this.readSpjLobData(dataloc);
        }
        return data;
    }

    void prepareCall(String sql, int queryTimeout, int holdability) throws SQLException {
        this.ist_.prepare(sql, queryTimeout, this);
        if (this.inputDesc_ != null && this.inputDesc_[0].dataType_ == 2004) {
            this.connection_.isCallProc_ = true;
            this.connection_.spjBlobTableName_ = "spjcat.spjsch.spj_table";
            this.connection_.spjClobTableName_ = "spjcat.spjsch.spj_table";
        }
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, queryTimeout, holdability);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXCallableStatement", "prepareCall", "", p);
        }
    }

    void executeCall(int inputParamCount, Object[] inputParamValues, int queryTimeout) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, inputParamCount, (Object)inputParamValues, queryTimeout);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXCallableStatement", "ececuteCall", "", p);
        }
    }

    void cpqPrepareCall(String moduleName, int moduleVersion, long moduleTimestamp, String stmtName, int queryTimeout, int holdability) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)moduleName, moduleVersion, moduleTimestamp, (Object)stmtName, queryTimeout, holdability);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXCallableStatement", "cpqPrepareCall", "", p);
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "unsupported_feature", new Object[]{"cpqPrepareCall"});
    }

    Blob readSpjLobData(long datalocator) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXBlob", "readSpjLobData", "", p);
        }
        String tableName = "SPJ_BASE_TABLE";
        this.connection_.prepareGetSpjLobDataStmt();
        this.connection_.SpjLobPreparedStatements[3].setString(1, "SPJ_BASE_TABLE");
        this.connection_.SpjLobPreparedStatements[3].setLong(2, datalocator);
        this.connection_.SpjLobPreparedStatements[3].setInt(3, 0);
        this.connection_.SpjLobPreparedStatements[3].setInt(4, Integer.MAX_VALUE);
        ResultSet rs = this.connection_.SpjLobPreparedStatements[3].executeQuery();
        rs.next();
        byte[] b = rs.getBytes(1);
        SQLMXBlob blobdata = new SQLMXBlob(this.connection_, tableName, datalocator, b);
        rs.close();
        return blobdata;
    }
}

