/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXClob;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXLob;
import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SQLMXClobReader
extends Reader {
    SQLMXClob clob_;
    SQLMXConnection conn_;
    boolean isClosed_;
    char[] chunk_;
    int currentChar_;
    int currentChunkNo_;
    int charsRead_;

    public void close() throws IOException {
        this.isClosed_ = true;
    }

    public void mark(int readAheadLimit) throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int retValue = 0;
        if (this.isClosed_) {
            throw new IOException("Reader is in closed state");
        }
        if (this.currentChar_ == this.charsRead_) {
            retValue = this.readChunkThrowIO(null, 0, this.clob_.chunkSize_);
        }
        if (retValue != -1) {
            retValue = this.chunk_[this.currentChar_];
            if (this.currentChar_ != this.charsRead_) {
                ++this.currentChar_;
            }
        }
        return retValue;
    }

    public int read(char[] cbuf) throws IOException {
        if (cbuf == null) {
            throw new IOException("Invalid input value");
        }
        return this.read(cbuf, 0, cbuf.length);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int retLen;
        int tempLen = 0;
        if (this.isClosed_) {
            throw new IOException("Reader is in closed state");
        }
        if (cbuf == null) {
            throw new IOException("Invalid input value");
        }
        int copyLen = len;
        int copyOffset = off;
        int readLen = 0;
        if (this.currentChar_ < this.charsRead_) {
            if (copyLen + this.currentChar_ <= this.charsRead_) {
                System.arraycopy(this.chunk_, this.currentChar_, cbuf, copyOffset, copyLen);
                this.currentChar_ += copyLen;
                readLen = copyLen;
                return readLen;
            }
            tempLen = this.charsRead_ - this.currentChar_;
            System.arraycopy(this.chunk_, this.currentChar_, cbuf, copyOffset, tempLen);
            copyOffset += tempLen;
            copyLen -= tempLen;
            this.currentChar_ += tempLen;
        }
        if ((retLen = (readLen = this.readChunkThrowIO(cbuf, copyOffset, copyLen)) != -1 ? readLen + tempLen : tempLen) == 0) {
            return -1;
        }
        return retLen;
    }

    public void reset() throws IOException {
        if (this.isClosed_) {
            throw new IOException("Reader is in closed state");
        }
        this.currentChar_ = 0;
        this.currentChunkNo_ = 0;
        this.charsRead_ = 0;
    }

    public long skip(long n) throws IOException {
        int noOfChunks = 0;
        long retLen = 0L;
        long charsSkipped = 0L;
        if (this.isClosed_) {
            throw new IOException("Reader is in closed state");
        }
        if (n <= 0L) {
            return 0L;
        }
        if ((long)this.currentChar_ + n <= (long)this.charsRead_) {
            this.currentChar_ = (int)((long)this.currentChar_ + n);
            return n;
        }
        charsSkipped = this.charsRead_ - this.currentChar_;
        long charsToSkip = n - charsSkipped;
        this.currentChar_ = (int)((long)this.currentChar_ + charsSkipped);
        int remChars = charsToSkip % (long)this.clob_.chunkSize_ == 0L ? this.clob_.chunkSize_ : (int)(charsToSkip % (long)this.clob_.chunkSize_);
        int oldChunkNo = this.currentChunkNo_;
        this.currentChunkNo_ += (noOfChunks += (int)((charsToSkip - 1L) / (long)this.clob_.chunkSize_));
        retLen = this.readChunkThrowIO(null, 0, this.clob_.chunkSize_);
        if (retLen != -1L) {
            charsSkipped += (long)((this.currentChunkNo_ - oldChunkNo - 1) * this.clob_.chunkSize_);
            if (retLen < (long)remChars) {
                remChars = (int)retLen;
            }
            this.currentChar_ = remChars;
            charsSkipped += (long)remChars;
        } else {
            int readLen = this.currentChunkNo_ > 0 ? (this.currentChunkNo_ - 1) * this.clob_.chunkSize_ + this.currentChar_ : this.currentChar_;
            try {
                charsSkipped = charsSkipped + this.clob_.length() - (long)readLen;
            }
            catch (SQLException e) {
                throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
            }
            remChars = (int)(charsSkipped - (long)(this.charsRead_ - this.currentChar_));
            this.currentChunkNo_ = oldChunkNo + (noOfChunks += (remChars - 1) / this.clob_.chunkSize_);
            if (remChars == 0) {
                this.currentChar_ = 0;
                this.charsRead_ = 0;
            } else {
                this.currentChar_ = remChars % this.clob_.chunkSize_ == 0 ? this.clob_.chunkSize_ : remChars % this.clob_.chunkSize_;
                this.charsRead_ = this.currentChar_;
            }
        }
        return charsSkipped;
    }

    int readChunkThrowIO(char[] c, int off, int len) throws IOException {
        int readLen;
        try {
            readLen = this.readChunk(c, off, len);
        }
        catch (SQLException e) {
            throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
        }
        return readLen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readChunk(char[] c, int off, int len) throws SQLException {
        int readLen = 0;
        int rowsToRead = (len - 1) / this.clob_.chunkSize_;
        this.clob_.prepareGetLobDataStmt();
        PreparedStatement preparedStatement = this.clob_.getGetLobDataStmt();
        synchronized (preparedStatement) {
            this.clob_.getGetLobDataStmt().setString(1, this.clob_.tableName_);
            this.clob_.getGetLobDataStmt().setLong(2, this.clob_.dataLocator_);
            this.clob_.getGetLobDataStmt().setInt(3, this.currentChunkNo_);
            this.clob_.getGetLobDataStmt().setInt(4, this.currentChunkNo_ + rowsToRead);
            ResultSet rs = this.clob_.getGetLobDataStmt().executeQuery();
            if (rowsToRead > 1) {
                rs.setFetchSize(rowsToRead >= 8 ? 8 : rowsToRead);
            }
            int copyLen = len;
            int copyOffset = off;
            try {
                while (rs.next()) {
                    String data = rs.getString(1);
                    ++this.currentChunkNo_;
                    int dataLen = this.charsRead_ = data.length();
                    if (c == null) {
                        data.getChars(0, dataLen, this.chunk_, 0);
                        readLen += dataLen;
                        this.currentChar_ = 0;
                    } else {
                        if (copyLen >= dataLen) {
                            data.getChars(0, dataLen, c, copyOffset);
                            copyLen -= dataLen;
                            readLen += dataLen;
                            copyOffset += dataLen;
                            this.currentChar_ = dataLen;
                            continue;
                        }
                        data.getChars(0, copyLen, c, copyOffset);
                        data.getChars(copyLen, dataLen, this.chunk_, copyLen);
                        readLen += copyLen;
                        this.currentChar_ = copyLen;
                    }
                    break;
                }
            }
            finally {
                rs.close();
            }
        }
        if (readLen == 0) {
            return -1;
        }
        return readLen;
    }

    SQLMXClobReader(SQLMXConnection connection, SQLMXClob clob) {
        this.clob_ = clob;
        this.conn_ = connection;
        this.chunk_ = new char[this.clob_.chunkSize_];
    }
}

