/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXClob;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXLob;
import com.tandem.t4jdbc.SQLMXMessages;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SQLMXClobWriter
extends Writer {
    SQLMXClob clob_;
    long startingPos_;
    SQLMXConnection conn_;
    boolean isClosed_;
    char[] chunk_;
    int currentChar_;
    int currentChunkNo_;
    boolean isFlushed_;
    int updChunkNo_;
    int updOffset_;

    public void close() throws IOException {
        if (!this.isClosed_) {
            this.flush();
            this.isClosed_ = true;
        }
    }

    public void flush() throws IOException {
        if (this.isClosed_) {
            throw new IOException("Output stream is in closed state");
        }
        if (!this.isFlushed_) {
            this.writeChunkThrowIO(null);
        }
    }

    public void write(char[] cbuf) throws IOException {
        if (cbuf == null) {
            throw new IOException("Invalid input value");
        }
        this.write(cbuf, 0, cbuf.length);
    }

    /*
     * Unable to fully structure code
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.isClosed_) {
            throw new IOException("Writer is in closed state");
        }
        if (cbuf == null) {
            throw new IOException("Invalid input value");
        }
        if (off < 0 || len < 0 || off > cbuf.length) {
            throw new IndexOutOfBoundsException("length or offset is less than 0 or offset is greater than the length of array");
        }
        srcOffset = off;
        copyLen = len;
        writesBatched = false;
        isUpdate = false;
        isInsert = false;
        if (copyLen + this.currentChar_ < 2 * this.clob_.chunkSize_) {
            writesBatched = false;
        } else {
            writesBatched = true;
            try {
                if (this.currentChunkNo_ > this.updChunkNo_) {
                    this.clob_.prepareInsLobDataStmt();
                    isInsert = true;
                } else {
                    this.clob_.prepareUpdLobDataStmt();
                    isUpdate = true;
                }
            }
            catch (SQLException e) {
                throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
            }
        }
        rowsBatched = 0;
        while (true) {
            if (copyLen + this.currentChar_ < this.clob_.chunkSize_) {
                System.arraycopy(cbuf, srcOffset, this.chunk_, this.currentChar_, copyLen);
                this.currentChar_ += copyLen;
                break;
            }
            if (this.currentChar_ != 0) {
                tempLen = this.clob_.chunkSize_ - this.currentChar_;
                System.arraycopy(cbuf, srcOffset, this.chunk_, this.currentChar_, tempLen);
                this.currentChar_ += tempLen;
                this.writeChunkThrowIO(null);
            } else {
                tempLen = this.clob_.chunkSize_;
                this.currentChar_ += tempLen;
                if (writesBatched) {
                    if (!isInsert && this.currentChunkNo_ <= this.updChunkNo_) {
                        try {
                            this.clob_.prepareInsLobDataStmt();
                            isInsert = true;
                        }
                        catch (SQLException e) {
                            throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
                        }
                    }
                    this.writeBatchChunkThrowIO(new String(cbuf, srcOffset, tempLen));
                    if (++rowsBatched >= 100) {
                        rowsBatched = 0;
                        try {
                            if (isUpdate) {
                                this.clob_.getUpdLobDataStmt().executeBatch();
                                this.clob_.getUpdLobDataStmt().clearBatch();
                            }
                            if (!isInsert) ** GOTO lbl65
                            this.clob_.getInsLobDataStmt().executeBatch();
                            this.clob_.getInsLobDataStmt().clearBatch();
                        }
                        catch (SQLException e) {
                            throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
                        }
                    }
                } else {
                    this.writeChunkThrowIO(new String(cbuf, srcOffset, tempLen));
                }
            }
lbl65:
            // 5 sources

            copyLen -= tempLen;
            srcOffset += tempLen;
            this.currentChar_ = 0;
        }
        this.isFlushed_ = false;
        if (writesBatched && rowsBatched > 0) {
            rowsBatched = 0;
            try {
                if (isUpdate) {
                    this.clob_.getUpdLobDataStmt().executeBatch();
                    this.clob_.getUpdLobDataStmt().clearBatch();
                }
                if (isInsert) {
                    this.clob_.getInsLobDataStmt().executeBatch();
                    this.clob_.getInsLobDataStmt().clearBatch();
                }
            }
            catch (SQLException e) {
                throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
            }
        }
    }

    public void write(int c) throws IOException {
        if (this.isClosed_) {
            throw new IOException("Writer is in closed state");
        }
        this.chunk_[this.currentChar_] = (char)c;
        this.isFlushed_ = false;
        ++this.currentChar_;
        if (this.currentChar_ == this.clob_.chunkSize_) {
            this.writeChunkThrowIO(null);
        }
    }

    public void write(String str) throws IOException {
        if (str == null) {
            throw new IOException("Invalid input value");
        }
        this.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
        int writeLen = len;
        int srcOff = off;
        if (this.isClosed_) {
            throw new IOException("Writer is in closed state");
        }
        if (str == null) {
            throw new IOException("Invalid input value");
        }
        char[] cbuf = new char[len];
        str.getChars(srcOff, srcOff + len, cbuf, 0);
        this.write(cbuf, 0, cbuf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeChunk(String str) throws SQLException {
        if (this.currentChunkNo_ > this.updChunkNo_) {
            this.clob_.prepareInsLobDataStmt();
            PreparedStatement preparedStatement = this.clob_.getInsLobDataStmt();
            synchronized (preparedStatement) {
                this.clob_.getInsLobDataStmt().setString(1, this.clob_.tableName_);
                this.clob_.getInsLobDataStmt().setLong(2, this.clob_.dataLocator_);
                this.clob_.getInsLobDataStmt().setInt(3, this.currentChunkNo_);
                String tempStr = str == null ? (this.currentChar_ != this.clob_.chunkSize_ ? new String(this.chunk_, 0, this.currentChar_) : new String(this.chunk_)) : str;
                this.clob_.getInsLobDataStmt().setString(4, tempStr);
                this.clob_.getInsLobDataStmt().executeUpdate();
                ++this.currentChunkNo_;
                this.currentChar_ = 0;
            }
        }
        this.clob_.prepareUpdLobDataStmt();
        PreparedStatement preparedStatement = this.clob_.getUpdLobDataStmt();
        synchronized (preparedStatement) {
            this.clob_.getUpdLobDataStmt().setString(4, this.clob_.tableName_);
            this.clob_.getUpdLobDataStmt().setLong(5, this.clob_.dataLocator_);
            this.clob_.getUpdLobDataStmt().setInt(6, this.currentChunkNo_);
            this.clob_.getUpdLobDataStmt().setInt(1, this.updOffset_);
            String tempStr = str == null ? (this.updOffset_ != 0 || this.currentChar_ != this.clob_.chunkSize_ ? new String(this.chunk_, this.updOffset_, this.currentChar_ - this.updOffset_) : new String(this.chunk_)) : str;
            this.clob_.getUpdLobDataStmt().setInt(3, this.currentChar_ + 1);
            this.clob_.getUpdLobDataStmt().setString(2, tempStr);
            this.clob_.getUpdLobDataStmt().executeUpdate();
            ++this.currentChunkNo_;
            this.currentChar_ = 0;
            this.updOffset_ = 0;
        }
        this.isFlushed_ = true;
    }

    void writeChunkThrowIO(String str) throws IOException {
        try {
            this.writeChunk(str);
        }
        catch (SQLException e) {
            throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
        }
    }

    void writeBatchChunkThrowIO(String str) throws IOException {
        try {
            this.writeBatchChunk(str);
        }
        catch (SQLException e) {
            throw new IOException(SQLMXLob.convSQLExceptionToIO(e));
        }
    }

    void writeBatchChunk(String str) throws SQLException {
        if (this.currentChunkNo_ > this.updChunkNo_) {
            this.clob_.getInsLobDataStmt().setString(1, this.clob_.tableName_);
            this.clob_.getInsLobDataStmt().setLong(2, this.clob_.dataLocator_);
            this.clob_.getInsLobDataStmt().setInt(3, this.currentChunkNo_);
            String tempStr = str == null ? (this.currentChar_ != this.clob_.chunkSize_ ? new String(this.chunk_, 0, this.currentChar_) : new String(this.chunk_)) : str;
            this.clob_.getInsLobDataStmt().setString(4, tempStr);
            this.clob_.getInsLobDataStmt().addBatch();
            ++this.currentChunkNo_;
            this.currentChar_ = 0;
        } else {
            this.clob_.prepareUpdLobDataStmt();
            this.clob_.getUpdLobDataStmt().setString(4, this.clob_.tableName_);
            this.clob_.getUpdLobDataStmt().setLong(5, this.clob_.dataLocator_);
            this.clob_.getUpdLobDataStmt().setInt(6, this.currentChunkNo_);
            this.clob_.getUpdLobDataStmt().setInt(1, this.updOffset_);
            String tempStr = str == null ? (this.updOffset_ != 0 || this.currentChar_ != this.clob_.chunkSize_ ? new String(this.chunk_, this.updOffset_, this.currentChar_ - this.updOffset_) : new String(this.chunk_)) : str;
            this.clob_.getUpdLobDataStmt().setInt(3, this.currentChar_ + 1);
            this.clob_.getUpdLobDataStmt().setString(2, tempStr);
            this.clob_.getUpdLobDataStmt().addBatch();
            ++this.currentChunkNo_;
            this.currentChar_ = 0;
            this.updOffset_ = 0;
        }
        this.isFlushed_ = true;
    }

    /*
     * Unable to fully structure code
     */
    void populate(Reader ir, int length) throws SQLException {
        isInsert = false;
        isUpdate = false;
        readLen = length;
        try {
            if (this.currentChunkNo_ > this.updChunkNo_) {
                this.clob_.prepareInsLobDataStmt();
                isInsert = true;
            } else {
                this.clob_.prepareUpdLobDataStmt();
                isUpdate = true;
            }
            writesBatched = false;
            if (readLen >= 2 * this.clob_.chunkSize_) {
                writesBatched = true;
            }
            rowsBatched = 0;
            while (readLen > 0) {
                if (!isInsert && this.currentChunkNo_ <= this.updChunkNo_) {
                    this.clob_.prepareInsLobDataStmt();
                    isInsert = true;
                }
                if ((retLen = ir.read(this.chunk_, 0, tempLen = readLen <= this.clob_.chunkSize_ ? readLen : this.clob_.chunkSize_)) == -1) break;
                this.currentChar_ = retLen;
                if (writesBatched) {
                    try {
                        this.writeBatchChunk(null);
                        if (++rowsBatched < 100) ** GOTO lbl42
                        rowsBatched = 0;
                        if (isUpdate) {
                            this.clob_.getUpdLobDataStmt().executeBatch();
                            this.clob_.getUpdLobDataStmt().clearBatch();
                        }
                        if (!isInsert) ** GOTO lbl42
                        this.clob_.getInsLobDataStmt().executeBatch();
                        this.clob_.getInsLobDataStmt().clearBatch();
                    }
                    catch (SQLException se) {
                        if (isInsert) {
                            this.clob_.getInsLobDataStmt().clearBatch();
                        }
                        if (isUpdate) {
                            this.clob_.getUpdLobDataStmt().clearBatch();
                        }
                        throw se;
                    }
                } else {
                    this.writeChunk(null);
                }
lbl42:
                // 4 sources

                readLen -= retLen;
            }
            if (writesBatched && rowsBatched > 0) {
                rowsBatched = 0;
                if (isUpdate) {
                    this.clob_.getUpdLobDataStmt().executeBatch();
                    this.clob_.getUpdLobDataStmt().clearBatch();
                }
                if (isInsert) {
                    this.clob_.getInsLobDataStmt().executeBatch();
                    this.clob_.getInsLobDataStmt().clearBatch();
                }
            }
        }
        catch (IOException e) {
            messageArguments = new Object[]{e.getMessage()};
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "io_exception", messageArguments);
        }
    }

    SQLMXClobWriter(SQLMXConnection connection, SQLMXClob clob, long pos) throws SQLException {
        this.clob_ = clob;
        long length = this.clob_.length();
        this.conn_ = connection;
        if (pos < 1L || pos > length + 1L) {
            throw SQLMXMessages.createSQLException(this.conn_.props_, this.conn_.getLocale(), "invalid_position_value", null);
        }
        this.startingPos_ = pos;
        this.chunk_ = new char[this.clob_.chunkSize_];
        this.isFlushed_ = false;
        this.updChunkNo_ = length == 0L ? -1 : (length % (long)this.clob_.chunkSize_ == 0L ? (int)(length / (long)this.clob_.chunkSize_) - 1 : (int)(length / (long)this.clob_.chunkSize_));
        this.currentChunkNo_ = (int)((pos - 1L) / (long)this.clob_.chunkSize_);
        this.currentChar_ = (int)((pos - 1L) % (long)this.clob_.chunkSize_);
        this.updOffset_ = (int)((pos - 1L) % (long)this.clob_.chunkSize_);
    }
}

