/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Bytes;
import com.tandem.t4jdbc.InterfaceConnection;
import com.tandem.t4jdbc.PreparedStatementManager;
import com.tandem.t4jdbc.SQLMXCallableStatement;
import com.tandem.t4jdbc.SQLMXDataLocator;
import com.tandem.t4jdbc.SQLMXDataSource;
import com.tandem.t4jdbc.SQLMXDatabaseMetaData;
import com.tandem.t4jdbc.SQLMXDriver;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXPooledConnection;
import com.tandem.t4jdbc.SQLMXPreparedStatement;
import com.tandem.t4jdbc.SQLMXStatement;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.sql.PooledConnection;

public class SQLMXConnection
extends PreparedStatementManager
implements Connection {
    private Logger log_;
    static Hashtable lobTableToDataLoc_;
    boolean erroredConnection = false;
    PreparedStatement[] LobPreparedStatements = new PreparedStatement[14];
    PreparedStatement[] SpjLobPreparedStatements = new PreparedStatement[4];
    String spjBlobTableName_;
    String spjClobTableName_;
    String spjBaseTableName_;
    boolean isCallProc_;
    String catalog_;
    String schema_;
    String clobTableName_;
    String blobTableName_;
    static final int CLOB_INS_LOB_DATA_STMT = 0;
    static final int CLOB_GET_LOB_DATA_STMT = 1;
    static final int CLOB_GET_LOB_LEN_STMT = 2;
    static final int CLOB_DEL_LOB_DATA_STMT = 3;
    static final int CLOB_TRUN_LOB_DATA_STMT = 4;
    static final int CLOB_UPD_LOB_DATA_STMT = 5;
    static final int CLOB_GET_STRT_DATA_LOC_STMT = 6;
    static final int BLOB_INS_LOB_DATA_STMT = 7;
    static final int BLOB_GET_LOB_DATA_STMT = 8;
    static final int BLOB_GET_LOB_LEN_STMT = 9;
    static final int BLOB_DEL_LOB_DATA_STMT = 10;
    static final int BLOB_TRUN_LOB_DATA_STMT = 11;
    static final int BLOB_UPD_LOB_DATA_STMT = 12;
    static final int BLOB_GET_STRT_DATA_LOC_STMT = 13;
    static Logger dummyLogger_;
    boolean[] bLobStatementPrepared = new boolean[14];
    boolean[] spjLobStatementPrepared = new boolean[4];
    static final int SPJ_INS_BLOB_STMT = 0;
    static final int SPJ_INS_CLOB_STMT = 1;
    static final int SPJ_INS_BASE_STMT = 2;
    static final int SPJ_GET_LOB_DATA_STMT = 3;
    InterfaceConnection ic_;
    Map userMap_;
    ReferenceQueue refStmtQ_;
    Hashtable refToStmt_;
    Hashtable refToRS_;
    int holdability_;
    SQLMXDataSource ds_;
    SQLMXPooledConnection pc_;
    SQLMXDriver driver_;
    WeakReference pRef_;
    T4Properties props_;
    boolean m_isXA_ = false;
    boolean isActiveTrans = false;
    static HashSet sqlStatementsContainingScalarFunctions;
    static HashSet sqlStatementsThatCanBeMFCed;
    static HashSet scalarFunctionsSet;
    private int stmtLabelHandleCount = 0;
    byte[] transactionToJoin;

    private static CallableStatement createExternalCallableStatement(String className, String call) throws SQLException {
        Class<?> classX = null;
        try {
            classX = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Specified Class not found: " + e.getLocalizedMessage());
        }
        boolean blnIsCallableStatement = false;
        if (classX != null) {
            Class<?>[] interfaces = classX.getInterfaces();
            for (int nfor = 0; nfor < interfaces.length; ++nfor) {
                if (!interfaces[nfor].getName().equals(CallableStatement.class.getName())) continue;
                blnIsCallableStatement = true;
                break;
            }
        }
        if (!blnIsCallableStatement) {
            throw new SQLException("The Specified Class does not implement java.sql.CallableStatement interface.");
        }
        Constructor<?>[] array = null;
        if (classX != null) {
            array = classX.getDeclaredConstructors();
        }
        if (array != null) {
            boolean blnPublic = false;
            for (int nfor = 0; nfor < array.length; ++nfor) {
                if (array[nfor].getModifiers() != 1) continue;
                blnPublic = true;
                Class<?>[] params = array[nfor].getParameterTypes();
                if (params == null || params.length != 1 || !params[0].getName().equals(String.class.getName())) continue;
                Object[] initVar = new Object[]{call};
                Object o = null;
                try {
                    o = array[nfor].newInstance(initVar);
                }
                catch (IllegalArgumentException e) {
                    throw new SQLException(e.getMessage());
                }
                catch (InstantiationException e) {
                    throw new SQLException(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new SQLException(e.getMessage());
                }
                catch (InvocationTargetException e) {
                    throw new SQLException(e.getMessage());
                }
                return o;
            }
            if (!blnPublic) {
                throw new SQLException("No Public Constructors available in the Specified Class.");
            }
        } else {
            throw new SQLException("No Constructors available in the Specified Class.");
        }
        throw new SQLException("No Constructor available accepting ONLY java.lang.String parameter in the Specified Class.");
    }

    private void validateConnection() throws SQLException {
        this.clearWarnings();
        if (this.ic_ == null || this.ic_.isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, this.getLocale(), "invalid_connection", null);
        }
    }

    public String getRemoteProcess() throws SQLException {
        String url = this.ic_.getUrl();
        return url.substring(url.indexOf(36), url.indexOf(47));
    }

    public synchronized void close() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "close", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("close");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.close(this.pc_ == null, true);
    }

    public void commit() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "commit", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("commit");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.validateConnection();
        if (this.props_.getUseExternalTransaction().equalsIgnoreCase("YES")) {
            return;
        }
        if (!this.getAutoCommit()) {
            this.isActiveTrans = false;
        }
        try {
            this.ic_.commit();
        }
        catch (SQLException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    public String getApplicationName() throws SQLException {
        this.validateConnection();
        return this.ic_.getApplicationName();
    }

    public String getServerDataSource() throws SQLException {
        this.validateConnection();
        return this.ic_.getServerDataSource();
    }

    public boolean getEnforceISO() throws SQLException {
        this.validateConnection();
        return this.ic_.getEnforceISO();
    }

    public int getISOMapping() throws SQLException {
        this.validateConnection();
        return this.ic_.getISOMapping();
    }

    public String getRoleName() throws SQLException {
        this.validateConnection();
        return this.ic_.getRoleName();
    }

    public int getTerminalCharset() throws SQLException {
        this.validateConnection();
        return this.ic_.getTerminalCharset();
    }

    public T4Properties getT4Properties() throws SQLException {
        this.validateConnection();
        return this.ic_.t4props_;
    }

    public String getSessionName() throws SQLException {
        this.validateConnection();
        return this.ic_.getSessionName();
    }

    public String getMXCSVersion() throws SQLException {
        this.validateConnection();
        return this.props_.getMxcsVersion().toString();
    }

    public String getSQLMXVersion() throws SQLException {
        this.validateConnection();
        String mxversion = this.props_.getSqlmxMajorVersion() + "." + this.props_.getSqlmxMinorVersion();
        return mxversion;
    }

    public Statement createStatement() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "createStatement", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("createStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.validateConnection();
        try {
            SQLMXStatement stmt = new SQLMXStatement(this);
            if (this.props_.getEnableMFC().equalsIgnoreCase("OFF")) {
                stmt.removeMFCFromStmtLabel();
            }
            return stmt;
        }
        catch (SQLException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, resultSetType, resultSetConcurrency);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "createStatement", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, resultSetType, resultSetConcurrency);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("createStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.validateConnection();
        try {
            SQLMXStatement stmt = new SQLMXStatement(this, resultSetType, resultSetConcurrency);
            if (this.props_.getEnableMFC().equalsIgnoreCase("OFF")) {
                stmt.removeMFCFromStmtLabel();
            }
            return stmt;
        }
        catch (SQLException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "createStatement", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, resultSetType, resultSetHoldability);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("createStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.validateConnection();
        try {
            SQLMXStatement stmt = new SQLMXStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (this.props_.getEnableMFC().equalsIgnoreCase("OFF")) {
                stmt.removeMFCFromStmtLabel();
            }
            return stmt;
        }
        catch (SQLException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    Locale getLocale() {
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "getLocale", "", p);
        }
        if (this.ic_ != null) {
            return this.ic_.getLocale();
        }
        return null;
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "getAutoCommit", "getAutoCommit", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("getAutoCommit");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.validateConnection();
        return this.ic_.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "getCatalog", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("getCatalog");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.validateConnection();
        return this.ic_.getCatalog();
    }

    public String getSchema() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "getSchema", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("getSchema");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.validateConnection();
        return this.ic_.getSchema();
    }

    public int getHoldability() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "getHoldability", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("getHoldability");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        return this.holdability_;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "getMetaData", "getMetaData", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("getMetaData");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.validateConnection();
        return new SQLMXDatabaseMetaData(this);
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "getTransactionIsolation", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("getTransactionIsolation");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.validateConnection();
        return this.ic_.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "getTypeMap", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("getTypeMap");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        return this.userMap_;
    }

    void isConnectionOpen() throws SQLException {
        this.validateConnection();
    }

    public boolean isClosed() throws SQLException {
        Object[] p;
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p2 = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "isClosed", "", p2);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("isClosed");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        boolean rv = true;
        if (this.ic_ == null) {
            rv = true;
        } else {
            this.clearWarnings();
            rv = this.ic_.getIsClosed();
        }
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "isClosed", "At exit return = " + rv, p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p3 = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p3);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("isClosed");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        return rv;
    }

    boolean _isClosed() throws SQLException {
        Object[] p;
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p2 = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "_isClosed", "", p2);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("_isClosed");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        boolean rv = true;
        rv = this.ic_ == null ? true : this.ic_.getIsClosed();
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "_isClosed", "At exit return = " + rv, p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p3 = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p3);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("_isClosed");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        return rv;
    }

    public String getServiceName() throws SQLException {
        return "";
    }

    public void setServiceName(String serviceName) throws SQLException {
    }

    public boolean isReadOnly() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "isReadOnly", "", p);
        }
        this.validateConnection();
        return this.ic_.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, sql);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "nativeSQL", "", p);
        }
        this.validateConnection();
        return sql;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        SQLMXCallableStatement stmt;
        String sqlX;
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, sql);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "prepareCall", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("prepareCall");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        if (!this.props_.getExternalCallHandler().equals("NONE") && (sqlX = sql).trim().startsWith("{") && (sqlX = sqlX.trim().substring(1).trim()).toUpperCase().startsWith(this.props_.getExternalCallPrefix().toUpperCase())) {
            CallableStatement externalCallStmt = SQLMXConnection.createExternalCallableStatement(this.props_.getExternalCallHandler(), sql);
            return externalCallStmt;
        }
        this.setWeight(sql, this.holdability_);
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            if (this.isStatementCachingEnabled() && (stmt = (SQLMXCallableStatement)this.getPreparedStatement(this, sql, 1003, 1007, this.holdability_)) != null) {
                return stmt;
            }
            stmt = new SQLMXCallableStatement(this, sql);
            stmt.prepareCall(stmt.sql_, stmt.queryTimeout_, stmt.resultSetHoldability_);
            if (this.isStatementCachingEnabled()) {
                this.addPreparedStatement(this, sql, stmt, 1003, 1007, this.holdability_);
            }
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return stmt;
    }

    public CallableStatement prepareCall(String sql, String stmtLabel) throws SQLException {
        SQLMXCallableStatement stmt;
        String QUOTE = "\"";
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, sql);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "prepareCall", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("prepareCall");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        if (stmtLabel == null || stmtLabel.length() == 0) {
            throw SQLMXMessages.createSQLException(this.props_, null, "null_data", null);
        }
        if (stmtLabel.startsWith("\"") && stmtLabel.endsWith("\"")) {
            int len = stmtLabel.length();
            if (len == 2) {
                throw SQLMXMessages.createSQLException(this.props_, null, "null_data", null);
            }
            stmtLabel = stmtLabel.substring(1, len - 1);
        } else {
            stmtLabel = stmtLabel.toUpperCase();
        }
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            SQLMXCallableStatement stmt2;
            if (this.isStatementCachingEnabled() && (stmt2 = (SQLMXCallableStatement)this.getPreparedStatement(this, sql, 1003, 1007, this.holdability_)) != null) {
                return stmt2;
            }
            stmt = new SQLMXCallableStatement(this, sql, stmtLabel);
            if (this.props_.getEnableMFC().equalsIgnoreCase("OFF")) {
                stmt.removeMFCFromStmtLabel();
            }
            stmt.prepareCall(stmt.sql_, stmt.queryTimeout_, stmt.resultSetHoldability_);
            if (this.isStatementCachingEnabled()) {
                this.addPreparedStatement(this, sql, stmt, 1003, 1007, this.holdability_);
            }
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return stmt;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        SQLMXCallableStatement stmt;
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, resultSetType, resultSetConcurrency);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "prepaseCall", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, resultSetType, resultSetConcurrency);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("prepaseCall");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.setWeight(sql, this.holdability_);
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            if (this.isStatementCachingEnabled() && (stmt = (SQLMXCallableStatement)this.getPreparedStatement(this, sql, resultSetType, resultSetConcurrency, this.holdability_)) != null) {
                return stmt;
            }
            stmt = new SQLMXCallableStatement(this, sql, resultSetType, resultSetConcurrency);
            if (this.props_.getEnableMFC().equalsIgnoreCase("OFF")) {
                stmt.removeMFCFromStmtLabel();
            }
            stmt.prepareCall(stmt.sql_, stmt.queryTimeout_, stmt.resultSetHoldability_);
            if (this.isStatementCachingEnabled()) {
                this.addPreparedStatement(this, sql, stmt, resultSetType, resultSetConcurrency, this.holdability_);
            }
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return stmt;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        SQLMXCallableStatement stmt;
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "prepareCall", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, resultSetType, resultSetHoldability);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("prepareCall");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.setWeight(sql, resultSetHoldability);
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            if (this.isStatementCachingEnabled() && (stmt = (SQLMXCallableStatement)this.getPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability)) != null) {
                return stmt;
            }
            stmt = new SQLMXCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (this.props_.getEnableMFC().equalsIgnoreCase("OFF")) {
                stmt.removeMFCFromStmtLabel();
            }
            stmt.prepareCall(stmt.sql_, stmt.queryTimeout_, stmt.resultSetHoldability_);
            if (this.isStatementCachingEnabled()) {
                this.addPreparedStatement(this, sql, stmt, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, String stmtLabel) throws SQLException {
        SQLMXPreparedStatement stmt;
        String QUOTE = "\"";
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, sql);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "prepareStatement", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("prepareStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        if (stmtLabel == null || stmtLabel.length() == 0) {
            throw SQLMXMessages.createSQLException(this.props_, null, "null_data", null);
        }
        if (stmtLabel.startsWith("\"") && stmtLabel.endsWith("\"")) {
            int len = stmtLabel.length();
            if (len == 2) {
                throw SQLMXMessages.createSQLException(this.props_, null, "null_data", null);
            }
            stmtLabel = stmtLabel.substring(1, len - 1);
        } else {
            stmtLabel = stmtLabel.toUpperCase();
        }
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            SQLMXPreparedStatement stmt2;
            if (this.isStatementCachingEnabled() && (stmt2 = (SQLMXPreparedStatement)this.getPreparedStatement(this, sql, 1003, 1007, this.holdability_)) != null) {
                return stmt2;
            }
            stmt = new SQLMXPreparedStatement(this, sql, stmtLabel);
            stmt.prepare(stmt.sql_, stmt.queryTimeout_, stmt.resultSetHoldability_);
            if (this.isStatementCachingEnabled()) {
                this.addPreparedStatement(this, sql, stmt, 1003, 1007, this.holdability_);
            }
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        SQLMXPreparedStatement stmt;
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, sql);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "prepareStatement", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("prepareStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.setWeight(sql, this.holdability_);
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            if (this.isStatementCachingEnabled() && (stmt = (SQLMXPreparedStatement)this.getPreparedStatement(this, sql, 1003, 1007, this.holdability_)) != null) {
                return stmt;
            }
            stmt = new SQLMXPreparedStatement(this, sql);
            if (this.props_.getEnableMFC().equalsIgnoreCase("OFF") || stmt.sqlStmtType_ == 9) {
                stmt.removeMFCFromStmtLabel();
            }
            stmt.prepare(stmt.sql_, stmt.queryTimeout_, stmt.resultSetHoldability_);
            if (this.isStatementCachingEnabled()) {
                this.addPreparedStatement(this, sql, stmt, 1003, 1007, this.holdability_);
            }
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return stmt;
    }

    PreparedStatement prepareLobStatement(String sql) throws SQLException {
        SQLMXPreparedStatement stmt;
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, sql);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "prepareLobStatement", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("prepareLobStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            stmt = new SQLMXPreparedStatement(this, sql);
            stmt.prepare(stmt.sql_, stmt.queryTimeout_, stmt.resultSetHoldability_);
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, autoGeneratedKeys);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "prepareStatement", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, autoGeneratedKeys);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("prepareStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        if (autoGeneratedKeys == 2) {
            return this.prepareStatement(sql);
        }
        throw SQLMXMessages.createSQLException(this.props_, this.getLocale(), "auto_generated_keys_not_supported", null);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, (Object)columnIndexes);
            this.props_.t4Logger_.logp(Level.FINE, "SQLConnection", "prepareStatement", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, (Object)columnIndexes);
            lr.setParameters(p);
            lr.setSourceClassName("SQLConnection");
            lr.setSourceMethodName("prepareStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        if (columnIndexes != null && columnIndexes.length > 0) {
            throw SQLMXMessages.createSQLException(this.props_, this.getLocale(), "auto_generated_keys_not_supported", null);
        }
        return this.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        SQLMXPreparedStatement stmt;
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, resultSetType, resultSetConcurrency);
            this.props_.t4Logger_.logp(Level.FINE, "SQLConnection", "prepareStatement", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, resultSetType, resultSetConcurrency);
            lr.setParameters(p);
            lr.setSourceClassName("SQLConnection");
            lr.setSourceMethodName("prepareStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.setWeight(sql, this.holdability_);
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            if (this.isStatementCachingEnabled() && (stmt = (SQLMXPreparedStatement)this.getPreparedStatement(this, sql, resultSetType, resultSetConcurrency, this.holdability_)) != null) {
                return stmt;
            }
            stmt = new SQLMXPreparedStatement(this, sql, resultSetType, resultSetConcurrency);
            if (this.props_.getEnableMFC().equalsIgnoreCase("OFF") || stmt.sqlStmtType_ == 9) {
                stmt.removeMFCFromStmtLabel();
            }
            stmt.prepare(stmt.sql_, stmt.queryTimeout_, stmt.resultSetHoldability_);
            if (this.isStatementCachingEnabled()) {
                this.addPreparedStatement(this, sql, stmt, resultSetType, resultSetConcurrency, this.holdability_);
            }
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        SQLMXPreparedStatement stmt;
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            this.props_.t4Logger_.logp(Level.FINE, "SQLConnection", "prepareStatement", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, resultSetType, resultSetHoldability);
            lr.setParameters(p);
            lr.setSourceClassName("SQLConnection");
            lr.setSourceMethodName("prepareStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.setWeight(sql, resultSetHoldability);
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            if (this.isStatementCachingEnabled() && (stmt = (SQLMXPreparedStatement)this.getPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability)) != null) {
                return stmt;
            }
            stmt = new SQLMXPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            if (this.props_.getEnableMFC().equalsIgnoreCase("OFF") || stmt.sqlStmtType_ == 9) {
                stmt.removeMFCFromStmtLabel();
            }
            stmt.prepare(stmt.sql_, stmt.queryTimeout_, stmt.resultSetHoldability_);
            if (this.isStatementCachingEnabled()) {
                this.addPreparedStatement(this, sql, stmt, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, (Object)columnNames);
            this.props_.t4Logger_.logp(Level.FINE, "SQLConnection", "prepareStatement", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)sql, (Object)columnNames);
            lr.setParameters(p);
            lr.setSourceClassName("SQLConnection");
            lr.setSourceMethodName("prepareStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        if (columnNames != null && columnNames.length > 0) {
            throw SQLMXMessages.createSQLException(this.props_, this.getLocale(), "auto_generated_keys_not_supported", null);
        }
        return this.prepareStatement(sql);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, savepoint);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "releaseSavepoint", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, savepoint);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("releaseSavepoint");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        SQLMXMessages.throwUnsupportedFeatureException(this.props_, this.getLocale(), "releaseSavepoint()");
    }

    public void rollback() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "rollback", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("rollback");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        if (this.props_.getUseExternalTransaction().equalsIgnoreCase("YES")) {
            return;
        }
        if (!this.getAutoCommit()) {
            this.isActiveTrans = false;
        }
        try {
            this.ic_.rollback();
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, savepoint);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "rollback", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, savepoint);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("rollback");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        SQLMXMessages.throwUnsupportedFeatureException(this.props_, this.getLocale(), "rollback(Savepoint)");
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, autoCommit);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "setAutoCommit", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, autoCommit);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("setAutoCommit");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        if (this.props_.getUseExternalTransaction().equalsIgnoreCase("YES")) {
            return;
        }
        if (this.getAutoCommit() == autoCommit) {
            return;
        }
        if (!this.getAutoCommit() && this.isActiveTrans) {
            this.commit();
        }
        try {
            this.ic_.setAutoCommit(this, autoCommit);
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, catalog);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "setCalalog", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, catalog);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("setCalalog");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        if (catalog != null) {
            try {
                this.ic_.setCatalog(this, catalog);
            }
            catch (SQLMXException se) {
                this.performConnectionErrorChecks(se);
                throw se;
            }
        }
    }

    public void setHoldability(int holdability) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, holdability);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "setHoldability", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, holdability);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("setHoldability");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        if (holdability != 2) {
            throw SQLMXMessages.createSQLException(this.props_, this.getLocale(), "invalid_holdability", null);
        }
        this.holdability_ = holdability;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, readOnly);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "setReadOnly", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, readOnly);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("setReadOnly");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            this.ic_.setReadOnly(this, readOnly);
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    public void setConnectionAttr(short attr, int valueNum, String valueString) throws SQLException {
        this.ic_.setConnectionAttr(this, attr, valueNum, valueString);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, name);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "setSavepoint", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, name);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("setSavepoint");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        SQLMXMessages.throwUnsupportedFeatureException(this.props_, this.getLocale(), "setSavepoint");
        return null;
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "setSavepoint", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("setSavepoint");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        SQLMXMessages.throwUnsupportedFeatureException(this.props_, this.getLocale(), "setSavepoint");
        return null;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, level);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "setTransactionIsolation", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, level);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("setTransactionIsolation");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            this.ic_.setTransactionIsolation(this, level);
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, map);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "setTypeMap", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, map);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("setTypeMap");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        this.userMap_ = map;
    }

    public void begintransaction() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "begintransaction", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("begintransaction");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        try {
            this.ic_.beginTransaction();
            if (this.ic_.beginTransaction() == 0L) {
                return;
            }
            this.setAutoCommit(false);
        }
        catch (SQLMXException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    public long getCurrentTransaction() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "getTxid", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("getTxid");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        return this.ic_.getTxid();
    }

    public void setTxid(long txid) throws SQLException {
        this.setTransactionToJoin(Bytes.createLongBytes(txid, this.ic_.getByteSwap()));
    }

    public void setTransactionToJoin(byte[] txid) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, txid);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "setTxid", "", p);
        }
        if (this._isClosed()) {
            throw SQLMXMessages.createSQLException(this.props_, null, "invalid_connection", null);
        }
        this.transactionToJoin = txid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gcStmts() {
        Reference pRef;
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "gcStmt", "", p);
        }
        while ((pRef = this.refStmtQ_.poll()) != null) {
            String stmtLabel = (String)this.refToStmt_.get(pRef);
            if (stmtLabel == null) continue;
            try {
                SQLMXStatement stmt = new SQLMXStatement(this, stmtLabel);
                stmt.close();
                stmt = null;
            }
            catch (SQLException e) {
                this.performConnectionErrorChecks(e);
            }
            finally {
                this.refToStmt_.remove(pRef);
            }
        }
    }

    void removeElement(Reference pRef) {
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, pRef);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "removeElement", "", p);
        }
        this.refToStmt_.remove(pRef);
        pRef.clear();
    }

    void addElement(Reference pRef, String stmtLabel) {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, stmtLabel);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "addElement", "", p);
        }
        this.refToStmt_.put(pRef, stmtLabel);
    }

    private void physicalCloseStatements() {
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "physicalCloseStatement", "", p);
        }
        ArrayList stmts = new ArrayList(this.refToStmt_.values());
        int size = stmts.size();
        for (int i = 0; i < size; ++i) {
            try {
                String stmtLabel = (String)stmts.get(i);
                SQLMXStatement stmt = new SQLMXStatement(this, stmtLabel);
                stmt.close();
                stmt = null;
                continue;
            }
            catch (SQLException se) {
                // empty catch block
            }
        }
        this.refToStmt_.clear();
        this.closeLobStatements();
    }

    private void rollbackAndIgnoreError() {
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "rollbackAndIgnoreError", "", p);
        }
        try {
            if (this.props_.getUseExternalTransaction().equalsIgnoreCase("YES")) {
                return;
            }
            if (!this.getAutoCommit() && !this.m_isXA_ && this.isActiveTrans) {
                this.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLobStatements() {
        for (int i = 0; i < this.LobPreparedStatements.length; ++i) {
            try {
                if (!this.bLobStatementPrepared[i]) continue;
                this.LobPreparedStatements[i].close();
                continue;
            }
            catch (SQLException sqes) {
                continue;
            }
            finally {
                this.bLobStatementPrepared[i] = false;
            }
        }
        if (!lobTableToDataLoc_.isEmpty()) {
            for (SQLMXDataLocator entry : lobTableToDataLoc_.values()) {
                entry.closeLobStatements();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean hardClose, boolean sendEvents) throws SQLException {
        Object[] p;
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            p = T4LoggingUtilities.makeParams(this.props_, hardClose, sendEvents);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "close", "", p);
        }
        this.clearWarnings();
        try {
            if (this.ic_ != null) {
                this.ic_.setReadOnly(this, false);
            }
            if (!hardClose) {
                if (this.props_.t4Logger_.isLoggable(Level.INFO)) {
                    p = T4LoggingUtilities.makeParams(this.props_, hardClose, sendEvents);
                    this.props_.t4Logger_.logp(Level.INFO, "SQLMXConnection", "logicalClose()", "", p);
                }
                if (this.ic_ != null && this.ic_.getIsClosed()) {
                    return;
                }
                if (this.isStatementCachingEnabled()) {
                    this.closePreparedStatementsAll();
                } else {
                    this.physicalCloseStatements();
                }
                this.rollbackAndIgnoreError();
                this.pc_.logicalClose(sendEvents);
                if (this.ic_ != null) {
                    this.ic_.setIsClosed(true);
                }
            }
        }
        catch (SQLException e) {
            this.performConnectionErrorChecks(e);
            throw e;
        }
        finally {
            if (this.ic_ != null && this.ic_.getT4Connection() != null) {
                this.ic_.getT4Connection().closeTimers();
            }
        }
    }

    protected void finalize() {
        if (this.ic_ != null && this.ic_.getT4Connection() != null) {
            this.ic_.getT4Connection().closeTimers();
        }
    }

    void reuse() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "resue", "", p);
        }
        this.ic_.reuse();
    }

    int getChunkSize(String lobTableName, boolean isBlob) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)lobTableName, isBlob);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "getDataLocator", "", p);
        }
        if (lobTableName == null) {
            if (isBlob) {
                throw SQLMXMessages.createSQLException(this.props_, this.getLocale(), "no_blobTableName", null);
            }
            throw SQLMXMessages.createSQLException(this.props_, this.getLocale(), "no_clobTableName", null);
        }
        SQLMXDataLocator dataLoc = (SQLMXDataLocator)lobTableToDataLoc_.get(lobTableName);
        if (dataLoc == null) {
            dataLoc = new SQLMXDataLocator(this, lobTableName);
            lobTableToDataLoc_.put(lobTableName, dataLoc);
        }
        return dataLoc.chunkSize_;
    }

    long getDataLocator(String lobTableName, boolean isBlob) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)lobTableName, isBlob);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "getDataLocator", "", p);
        }
        if (lobTableName == null) {
            if (isBlob) {
                throw SQLMXMessages.createSQLException(this.props_, this.getLocale(), "no_blobTableName", null);
            }
            throw SQLMXMessages.createSQLException(this.props_, this.getLocale(), "no_clobTableName", null);
        }
        SQLMXDataLocator dataLoc = (SQLMXDataLocator)lobTableToDataLoc_.get(lobTableName);
        if (dataLoc == null) {
            dataLoc = new SQLMXDataLocator(this, lobTableName);
            lobTableToDataLoc_.put(lobTableName, dataLoc);
        }
        return dataLoc.getDataLocator(this, isBlob);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "getPooledConnection", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("getPooledConnection");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        if (this.pc_ != null) {
            return this.pc_;
        }
        throw SQLMXMessages.createSQLException(this.props_, this.getLocale(), "null_pooled_connection", null);
    }

    SQLMXConnection(SQLMXDriver driver, String url, T4Properties t4props) throws SQLException {
        super(t4props);
        t4props.setConnectionID(Integer.toString(this.hashCode()));
        this.setupLogging(t4props);
        if (t4props.getQueryExecuteTime() > 0L) {
            this.setupSlowQueryLogging(t4props);
        }
        if (t4props.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)driver, (Object)url, (Object)t4props);
            t4props.t4Logger_.logp(Level.FINE, "SQLMXConnection", "<init>", "", p);
        }
        if (t4props.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)driver, (Object)url, (Object)t4props);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("<init>");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            t4props.getLogWriter().println(temp);
        }
        this.driver_ = driver;
        t4props.setURL(url);
        t4props.setLoginTimeout(DriverManager.getLoginTimeout());
        if (t4props.getCatalog() == null) {
            t4props.setCatalog(driver.getCatalog());
        }
        if (t4props.getSchema() == null) {
            t4props.setSchema(driver.getSchema());
        }
        this.clobTableName_ = t4props.getClobTableName();
        this.blobTableName_ = t4props.getBlobTableName();
        this.catalog_ = t4props.getCatalog();
        this.schema_ = t4props.getSchema();
        this.spjBlobTableName_ = this.blobTableName_;
        this.spjClobTableName_ = this.clobTableName_;
        this.spjBaseTableName_ = "spjcat.spjsch.spj_base_table";
        this.makeConnection(t4props);
        this.holdability_ = 2;
    }

    SQLMXConnection(SQLMXDataSource ds, T4Properties t4props) throws SQLException {
        super(t4props);
        t4props.setConnectionID(Integer.toString(this.hashCode()));
        this.setupLogging(t4props);
        if (t4props.getQueryExecuteTime() > 0L) {
            this.setupSlowQueryLogging(t4props);
        }
        if (t4props.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)ds, (Object)t4props);
            t4props.t4Logger_.logp(Level.FINE, "SQLMXConnection", "<init>", "", p);
        }
        if (t4props.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)ds, (Object)t4props);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("<init>");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            t4props.getLogWriter().println(temp);
        }
        this.ds_ = ds;
        this.clobTableName_ = t4props.getClobTableName();
        this.blobTableName_ = t4props.getBlobTableName();
        this.catalog_ = t4props.getCatalog();
        this.schema_ = t4props.getSchema();
        this.spjBlobTableName_ = this.blobTableName_;
        this.spjClobTableName_ = this.clobTableName_;
        this.spjBaseTableName_ = "spjcat.spjsch.spj_base_table";
        this.makeConnection(t4props);
        this.holdability_ = 2;
    }

    SQLMXConnection(SQLMXPooledConnection poolConn, T4Properties t4props) throws SQLException {
        super(t4props);
        t4props.setConnectionID(Integer.toString(this.hashCode()));
        this.setupLogging(t4props);
        if (t4props.getQueryExecuteTime() > 0L) {
            this.setupSlowQueryLogging(t4props);
        }
        if (t4props.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)poolConn, (Object)t4props);
            t4props.t4Logger_.logp(Level.FINE, "SQLMXConnection", "<init>", "", p);
        }
        if (t4props.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)poolConn, (Object)t4props);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("<init>");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            t4props.getLogWriter().println(temp);
        }
        this.pc_ = poolConn;
        this.clobTableName_ = t4props.getClobTableName();
        this.blobTableName_ = t4props.getBlobTableName();
        this.catalog_ = t4props.getCatalog();
        this.schema_ = t4props.getSchema();
        this.spjBlobTableName_ = this.blobTableName_;
        this.spjClobTableName_ = this.clobTableName_;
        this.spjBaseTableName_ = "spjcat.spjsch.spj_base_table";
        this.makeConnection(t4props);
        this.holdability_ = 2;
    }

    private void makeConnection(T4Properties t4props) throws SQLException {
        if (t4props.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, t4props);
            t4props.t4Logger_.logp(Level.FINER, "SQLMXConnection", "makeConnection", "", p);
        }
        this.clearWarnings();
        try {
            this.ic_ = new InterfaceConnection(t4props);
            if (this.ic_.sqlwarning_ != null) {
                this.setSqlWarning(this.ic_.sqlwarning_);
            }
            this.refStmtQ_ = new ReferenceQueue();
            this.refToStmt_ = new Hashtable();
            this.pRef_ = new WeakReference<SQLMXConnection>(this, InterfaceConnection.refQ_);
            InterfaceConnection.refTosrvrCtxHandle_.put(this.pRef_, this.ic_);
            this.props_ = t4props;
            this.ic_.enableNARSupport(this, this.props_.getBatchRecovery());
            if (this.props_.getSPJEnv()) {
                this.ic_.enableProxySyntax(this);
            }
            short majorVersion = this.props_.getMxcsMajorVersion();
            short minorVersion = this.props_.getMxcsMinorVersion();
            if (t4props.t4Logger_.isLoggable(Level.FINER)) {
                Object[] p = T4LoggingUtilities.makeParams(this.props_, t4props);
                String temp = "ncsMajorVersion=" + majorVersion + ", ncsMinorVersion=" + minorVersion;
                t4props.t4Logger_.logp(Level.FINER, "SQLMXConnection", "makeConnection", temp, p);
            }
        }
        catch (SQLException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    private void setupLogging(T4Properties t4props) {
        String ID = T4LoggingUtilities.getUniqueID();
        String name = T4LoggingUtilities.getUniqueLoggerName(ID);
        if (Level.parse(t4props.getT4LogLevel()) == Level.OFF) {
            if (dummyLogger_ == null) {
                dummyLogger_ = Logger.getLogger(name);
            }
            t4props.t4Logger_ = dummyLogger_;
        } else {
            t4props.t4Logger_ = Logger.getLogger(name);
        }
        t4props.t4Logger_.setUseParentHandlers(false);
        t4props.t4Logger_.setLevel(Level.parse(t4props.getT4LogLevel()));
        if (Level.parse(t4props.getT4LogLevel()) != Level.OFF) {
            FileHandler fh1 = t4props.getT4LogFileHandler();
            t4props.t4Logger_.addHandler(fh1);
        }
    }

    private void setupSlowQueryLogging(T4Properties t4props) {
        try {
            if (t4props.getT4QueryExecuteLogFile() == null) {
                t4props.setT4QueryExecuteLogFile(t4props.getT4SlowQueryGlobalLogFile());
                t4props.setT4SlowQueryLogFileHandler(t4props.getT4SlowQueryGlobalLogFileHandler());
            } else if (t4props.getT4SlowQueryLogFileHandler() == null) {
                String temp = t4props.getT4QueryExecuteLogFile();
                FileHandler fh1 = new FileHandler(temp);
                T4LogFormatter ff1 = new T4LogFormatter();
                fh1.setFormatter(ff1);
                t4props.setT4SlowQueryLogFileHandler(fh1);
            } else {
                T4Properties.t4SlowQueryGlobalLogger.addHandler(t4props.getT4SlowQueryLogFileHandler());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    InterfaceConnection getServerHandle() {
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "getServerHandle", "", p);
        }
        return this.ic_;
    }

    public int getDialogueId() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            this.props_.t4Logger_.logp(Level.FINE, "SQLMXConnection", "getDialogueId", "", p);
        }
        if (this.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXConnection");
            lr.setSourceMethodName("getDialogueId");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.props_.getLogWriter().println(temp);
        }
        return this.getServerHandle().getDialogueId();
    }

    public boolean getDateConversion() throws SQLException {
        this.validateConnection();
        return this.ic_.getDateConversion();
    }

    int getServerMajorVersion() throws SQLException {
        this.validateConnection();
        return this.ic_.getServerMajorVersion();
    }

    int getServerMinorVersion() throws SQLException {
        this.validateConnection();
        return this.ic_.getServerMinorVersion();
    }

    void prepareGetLobLenStmt(String lobTableName, boolean isBlob) throws SQLException {
        String lobLenSQL;
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)lobTableName, isBlob);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "prepareGetLobLenStmt", "", p);
        }
        if (isBlob && !this.bLobStatementPrepared[9]) {
            lobLenSQL = "select sum(char_length(lob_data)) from " + lobTableName + " where table_name = ? and data_locator = ?";
            this.LobPreparedStatements[9] = this.prepareLobStatement(lobLenSQL);
            this.bLobStatementPrepared[9] = true;
        } else if (!isBlob && !this.bLobStatementPrepared[2]) {
            lobLenSQL = "select sum(char_length(lob_data)) from " + lobTableName + " where table_name = ? and data_locator = ?";
            this.LobPreparedStatements[2] = this.prepareLobStatement(lobLenSQL);
            this.bLobStatementPrepared[2] = true;
        }
    }

    void prepareDelLobDataStmt(String lobTableName, boolean isBlob) throws SQLException {
        String lobDelSQL;
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)lobTableName, isBlob);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "prepareDelLobDataStmt", "", p);
        }
        if (isBlob && !this.bLobStatementPrepared[10]) {
            lobDelSQL = "delete from " + lobTableName + " where table_name = ? and data_locator = ? and chunk_no >= ? and chunk_no <= ?";
            this.LobPreparedStatements[10] = this.prepareLobStatement(lobDelSQL);
            this.bLobStatementPrepared[10] = true;
        } else if (!isBlob && !this.bLobStatementPrepared[3]) {
            lobDelSQL = "delete from " + lobTableName + " where table_name = ? and data_locator = ? and chunk_no >= ? and chunk_no <= ?";
            this.LobPreparedStatements[3] = this.prepareLobStatement(lobDelSQL);
            this.bLobStatementPrepared[3] = true;
        }
    }

    void prepareGetLobDataStmt(String lobTableName, boolean isBlob) throws SQLException {
        String lobGetSQL;
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)lobTableName, isBlob);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "prepareGetLobDataStmt", "", p);
        }
        if (isBlob && !this.bLobStatementPrepared[8]) {
            lobGetSQL = "select lob_data from " + lobTableName + " where table_name = ? and data_locator = ? and chunk_no >= ? and chunk_no <= ?" + " order by chunk_no";
            this.LobPreparedStatements[8] = this.prepareLobStatement(lobGetSQL);
            this.bLobStatementPrepared[8] = true;
        } else if (!isBlob && !this.bLobStatementPrepared[1]) {
            lobGetSQL = "select lob_data from " + lobTableName + " where table_name = ? and data_locator = ? and chunk_no >= ? and chunk_no <= ?" + " order by chunk_no";
            this.LobPreparedStatements[1] = this.prepareLobStatement(lobGetSQL);
            this.bLobStatementPrepared[1] = true;
        }
    }

    void prepareUpdLobDataStmt(String lobTableName, boolean isBlob) throws SQLException {
        String lobUpdSQL;
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)lobTableName, isBlob);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "prepareUpdLobDataStmt", "", p);
        }
        if (isBlob) {
            if (!this.bLobStatementPrepared[12]) {
                lobUpdSQL = "update " + lobTableName + " set lob_data = subString(lob_data, 1, ?) || cast (? as varchar(24000)) || substring(lob_data from ?) where table_name = ? and data_locator = ? and chunk_no = ?";
                this.LobPreparedStatements[12] = this.prepareLobStatement(lobUpdSQL);
                this.bLobStatementPrepared[12] = true;
            } else {
                this.LobPreparedStatements[12].clearBatch();
            }
        } else if (!this.bLobStatementPrepared[5]) {
            lobUpdSQL = "update " + lobTableName + " set lob_data = subString(lob_data, 1, ?) || cast (? as varchar(24000)) || substring(lob_data from ?) where table_name = ? and data_locator = ? and chunk_no = ?";
            this.LobPreparedStatements[5] = this.prepareLobStatement(lobUpdSQL);
            this.bLobStatementPrepared[5] = true;
        } else {
            this.LobPreparedStatements[5].clearBatch();
        }
    }

    void prepareInsLobDataStmt(String lobTableName, boolean isBlob) throws SQLException {
        String lobInsSQL;
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)lobTableName, isBlob);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "prepareInsLobDataStmt", "", p);
        }
        if (isBlob) {
            if (!this.bLobStatementPrepared[7]) {
                lobInsSQL = "insert into " + lobTableName + " (table_name, data_locator, chunk_no, lob_data) values (?,?,?,?)";
                this.LobPreparedStatements[7] = this.prepareLobStatement(lobInsSQL);
                this.bLobStatementPrepared[7] = true;
            } else {
                this.LobPreparedStatements[7].clearBatch();
            }
        } else if (!this.bLobStatementPrepared[0]) {
            lobInsSQL = "insert into " + lobTableName + " (table_name, data_locator, chunk_no, lob_data) values (?,?,?,?)";
            this.LobPreparedStatements[0] = this.prepareLobStatement(lobInsSQL);
            this.bLobStatementPrepared[0] = true;
        } else {
            this.LobPreparedStatements[0].clearBatch();
        }
    }

    void prepareTrunLobDataStmt(String lobTableName, boolean isBlob) throws SQLException {
        String lobTrunSQL;
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)lobTableName, isBlob);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "prepareTrunLobDataStmt", "", p);
        }
        if (isBlob && !this.bLobStatementPrepared[11]) {
            lobTrunSQL = "update " + lobTableName + " set lob_data = substring(lob_data, 1, ?) where table_name = ? and data_locator = ? and chunk_no = ?";
            this.LobPreparedStatements[11] = this.prepareLobStatement(lobTrunSQL);
            this.bLobStatementPrepared[11] = true;
        } else if (!isBlob && !this.bLobStatementPrepared[4]) {
            lobTrunSQL = "update " + lobTableName + " set lob_data = substring(lob_data, 1, ?) where table_name = ? and data_locator = ? and chunk_no = ?";
            this.LobPreparedStatements[4] = this.prepareLobStatement(lobTrunSQL);
            this.bLobStatementPrepared[4] = true;
        }
    }

    boolean prepareGetStrtDataLocStmt(String lobTableName, boolean isBlob, int charset) throws SQLException {
        String lobGetStrtDataLocSQL;
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)lobTableName, isBlob);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "prepareGetStrtDataLocStmt", "", p);
        }
        if (isBlob && !this.bLobStatementPrepared[13]) {
            lobGetStrtDataLocSQL = charset == 11 ? "select * from (update " + lobTableName + " set lob_data = cast(cast(lob_data as largeint) + ? as varchar(100) character set UCS2) where table_name = 'ZZDATA_LOCATOR' and data_locator = 0 and chunk_no = 0 return cast(old.lob_data as largeint)+1) as tab1" : "select * from (update " + lobTableName + " set lob_data = cast(cast(lob_data as largeint) + ? as varchar(100) character set ISO88591) where table_name = 'ZZDATA_LOCATOR' and data_locator = 0 and chunk_no = 0 return cast(old.lob_data as largeint)+1) as tab1";
            this.LobPreparedStatements[13] = this.prepareLobStatement(lobGetStrtDataLocSQL);
            this.bLobStatementPrepared[13] = true;
            return true;
        }
        if (!isBlob && !this.bLobStatementPrepared[6]) {
            lobGetStrtDataLocSQL = charset == 11 ? "select * from (update " + lobTableName + " set lob_data = cast(cast(cast(lob_data as largeint) + ? as largeint) as varchar(100) character set UCS2) where table_name = 'ZZDATA_LOCATOR' and data_locator = 0 and chunk_no = 0 return cast(old.lob_data as largeint)+1) as tab1" : "select * from (update " + lobTableName + " set lob_data = cast(cast(cast(lob_data as largeint) + ? as largeint) as varchar(100) character set ISO88591) where table_name = 'ZZDATA_LOCATOR' and data_locator = 0 and chunk_no = 0 return cast(old.lob_data as largeint)+1) as tab1";
            this.LobPreparedStatements[6] = this.prepareLobStatement(lobGetStrtDataLocSQL);
            this.bLobStatementPrepared[6] = true;
            return true;
        }
        return false;
    }

    void prepareInsSpjLobDataStmt(boolean isBlob) throws SQLException {
        String lobInsSQL;
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)this.spjBlobTableName_, isBlob);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "prepareInsSpjLobDataStmt", "", p);
        }
        if (isBlob) {
            if (!this.spjLobStatementPrepared[0]) {
                lobInsSQL = "insert into " + this.spjBlobTableName_ + " (table_name, data_locator, chunk_no, lob_data) values (?,?,?,?)";
                this.SpjLobPreparedStatements[0] = this.prepareLobStatement(lobInsSQL);
                this.spjLobStatementPrepared[0] = true;
            } else {
                this.SpjLobPreparedStatements[0].clearBatch();
            }
        } else if (!this.spjLobStatementPrepared[1]) {
            lobInsSQL = "insert into " + this.spjBlobTableName_ + " (table_name, data_locator, chunk_no, lob_data) values (?,?,?,?)";
            this.SpjLobPreparedStatements[1] = this.prepareLobStatement(lobInsSQL);
            this.spjLobStatementPrepared[1] = true;
        } else {
            this.SpjLobPreparedStatements[1].clearBatch();
        }
    }

    void prepareInsSpjBaseDataStmt(boolean isBlob) throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, (Object)this.spjBlobTableName_, isBlob);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "prepareInsSpjBaseDataStmt", "", p);
        }
        if (isBlob) {
            if (!this.spjLobStatementPrepared[2]) {
                String lobInsSQL = "insert into " + this.spjBaseTableName_ + "(blob_col)" + " values (?)";
                this.SpjLobPreparedStatements[2] = this.prepareLobStatement(lobInsSQL);
                this.spjLobStatementPrepared[2] = true;
            } else {
                this.SpjLobPreparedStatements[2].clearBatch();
            }
        }
    }

    void prepareGetSpjLobDataStmt() throws SQLException {
        if (this.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_, this.spjBlobTableName_);
            this.props_.t4Logger_.logp(Level.FINER, "SQLMXConnection", "prepareGetSpjLobDataStmt", "", p);
        }
        if (!this.spjLobStatementPrepared[3]) {
            String lobGetSQL = "select lob_data from " + this.spjBlobTableName_ + " where table_name = ? and data_locator = ? and chunk_no >= ? and chunk_no <= ?";
            this.SpjLobPreparedStatements[3] = this.prepareLobStatement(lobGetSQL);
            this.spjLobStatementPrepared[3] = true;
        } else {
            this.SpjLobPreparedStatements[3].clearBatch();
        }
    }

    void closeErroredConnection(SQLMXException se) {
        if (this.props_ != null && this.props_.t4Logger_.isLoggable(Level.SEVERE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.props_);
            String errMsg = "Connection is closed due to unrecoverable error ";
            try {
                if (se.getMessage() != null) {
                    errMsg = errMsg + "  " + se.getMessage();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.props_.t4Logger_.logp(Level.SEVERE, "SQLMXConnection", "closeErroredConnection", errMsg, p);
        }
        try {
            if (!this.erroredConnection) {
                this.erroredConnection = true;
                if (this.pc_ != null) {
                    this.pc_.sendConnectionErrorEvent(se);
                } else {
                    this.close(true, true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized int incrementAndGetStmtLabelHandleCount() {
        if (this.stmtLabelHandleCount == 99999999) {
            this.stmtLabelHandleCount = 0;
        }
        return ++this.stmtLabelHandleCount;
    }

    public boolean containsScalarFunctions(String sqlStatement) {
        String sqlStatementInternal = sqlStatement.toUpperCase().trim();
        if (sqlStatementsThatCanBeMFCed.contains(sqlStatementInternal)) {
            return false;
        }
        if (sqlStatementsContainingScalarFunctions.contains(sqlStatementInternal)) {
            return true;
        }
        boolean result = false;
        if (sqlStatementInternal.startsWith("SELECT")) {
            int indexOfFrom = sqlStatementInternal.indexOf("FROM");
            String sqlStmtFragment = sqlStatementInternal.substring("SELECT".length(), indexOfFrom);
            String[] array = sqlStmtFragment.split("[ \t,]");
            for (int nfor = 0; nfor < array.length; ++nfor) {
                if (!scalarFunctionsSet.contains(array[nfor].trim())) continue;
                result = true;
                break;
            }
            if (!result) {
                for (String scalarFunction : scalarFunctionsSet) {
                    for (int nfor = 0; nfor < array.length; ++nfor) {
                        String subString;
                        if (!array[nfor].trim().startsWith(scalarFunction) || !(subString = array[nfor].trim().substring(scalarFunction.length())).startsWith("(")) continue;
                        result = true;
                        break;
                    }
                    if (!result) continue;
                    break;
                }
            }
        }
        if (result) {
            sqlStatementsContainingScalarFunctions.add(sqlStatementInternal);
        } else {
            sqlStatementsThatCanBeMFCed.add(sqlStatementInternal);
        }
        return result;
    }

    static {
        dummyLogger_ = null;
        sqlStatementsContainingScalarFunctions = new HashSet();
        sqlStatementsThatCanBeMFCed = new HashSet();
        scalarFunctionsSet = new HashSet();
        lobTableToDataLoc_ = new Hashtable(2);
    }
}

