/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXConnectionPoolDataSource;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXPooledConnectionManager;
import com.tandem.t4jdbc.T4DSProperties;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.DataSource;

public class SQLMXDataSource
extends T4DSProperties
implements DataSource,
Serializable,
Referenceable {
    SQLMXPooledConnectionManager poolManager;

    public synchronized Connection getConnection() throws SQLException {
        SQLMXConnection t4Conn;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering("SQLMXDataSource", "getConnection");
        }
        if (this.getSQLException() != null) {
            throw SQLMXMessages.createSQLException(null, this.getLocale(), "invalid_property", this.getSQLException());
        }
        if (this.getMaxPoolSize() == -1) {
            t4Conn = new SQLMXConnection(this, this.getT4Properties());
        } else if (this.poolManager != null) {
            t4Conn = (SQLMXConnection)this.poolManager.getConnection();
        } else {
            SQLMXConnectionPoolDataSource pds = new SQLMXConnectionPoolDataSource(this.getProperties());
            this.poolManager = new SQLMXPooledConnectionManager(pds, Level.parse(this.getT4LogLevel()));
            t4Conn = (SQLMXConnection)this.poolManager.getConnection();
        }
        if (this.getLogWriter() == null) {
            this.setLogWriter(DriverManager.getLogWriter());
        }
        t4Conn.setLogInfo(Level.parse(this.getT4LogLevel()), this.getLogWriter());
        SQLMXConnection conn = t4Conn;
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting("SQLMXDataSource", "getConnection", conn);
        }
        return conn;
    }

    public synchronized Connection getConnection(String username, String password) throws SQLException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering("SQLMXDataSource", "getConnection", new Object[]{this, username, password});
        }
        this.setUser(username);
        this.setPassword(password);
        Connection conn = this.getConnection();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting("SQLMXDataSource", "getConnection", conn);
        }
        return conn;
    }

    public Reference getReference() throws NamingException {
        if (this.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null);
            this.t4Logger_.logp(Level.FINE, "SQLMXDataSource", "Reference", "", p);
        }
        try {
            if (this.getLogWriter() != null) {
                LogRecord lr = new LogRecord(Level.FINE, "");
                Object[] p = T4LoggingUtilities.makeParams(null);
                lr.setParameters(p);
                lr.setSourceClassName("SQLMXDataSource");
                lr.setSourceMethodName("Reference");
                T4LogFormatter lf = new T4LogFormatter();
                String temp = lf.format(lr);
                this.getLogWriter().println(temp);
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        Reference ref = new Reference(this.getClass().getName(), "com.tandem.t4jdbc.SQLMXDataSourceFactory", null);
        return this.addReferences(ref);
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        super.setLogWriter(out);
        if (this.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null, out);
            this.t4Logger_.logp(Level.FINE, "SQLMXDataSource", "setLogWriter", "Note, this constructor was called before the previous constructor", p);
        }
        if (this.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(null, out);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXDataSource");
            lr.setSourceMethodName("setLogWriter");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.getLogWriter().println(temp);
        }
        if (this.poolManager != null) {
            this.poolManager.setLogWriter(this.getLogWriter());
        }
    }

    void setPoolManager(Context nameCtx, String dataSourceName) throws Exception {
        if (this.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(null, (Object)nameCtx, (Object)dataSourceName);
            this.t4Logger_.logp(Level.FINER, "SQLMXDataSource", "setPoolManager", "", p);
        }
        try {
            Object pds = nameCtx.lookup(dataSourceName);
            if (pds instanceof SQLMXConnectionPoolDataSource) {
                this.poolManager = new SQLMXPooledConnectionManager((SQLMXConnectionPoolDataSource)pds, Level.parse(this.getT4LogLevel()));
            }
        }
        catch (NameNotFoundException nnfe) {
            // empty catch block
        }
    }

    void setupLogFileHandler() {
        try {
            if (this.getT4LogFile() == null) {
                this.setT4LogFile(this.getT4GlobalLogFile());
                this.setT4LogFileHandler(this.getT4GlobalLogFileHandler());
            } else if (this.getT4LogFileHandler() == null) {
                String temp = this.getT4LogFile();
                if (temp.contains("%u")) {
                    temp = temp.replace("%u", T4LoggingUtilities.getUniqueID());
                }
                FileHandler fh1 = new FileHandler(temp);
                T4LogFormatter ff1 = new T4LogFormatter();
                fh1.setFormatter(ff1);
                this.setT4LogFileHandler(fh1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setupSlowQueryLogFileHandler() {
        try {
            if (this.getT4QueryExecuteLogFile() == null) {
                this.setT4QueryExecuteLogFile(this.getT4SlowQueryGlobalLogFile());
                this.setT4SlowQueryLogFileHandler(this.getT4SlowQueryGlobalLogFileHandler());
            } else if (this.getT4SlowQueryLogFileHandler() == null) {
                String temp = this.getT4QueryExecuteLogFile();
                FileHandler fh1 = new FileHandler(temp);
                T4LogFormatter ff1 = new T4LogFormatter();
                fh1.setFormatter(ff1);
                this.setT4SlowQueryLogFileHandler(fh1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SQLMXDataSource() {
        if (this.getQueryExecuteTime() > 0L) {
            this.setupSlowQueryLogFileHandler();
        }
        if (Level.parse(this.getT4LogLevel()) != Level.OFF) {
            this.setupLogFileHandler();
        }
        if (this.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null);
            this.t4Logger_.logp(Level.FINE, "SQLMXDataSource", "<init>", "Note, this constructor was called before the previous constructor", p);
        }
        try {
            if (this.getLogWriter() != null) {
                LogRecord lr = new LogRecord(Level.FINE, "");
                Object[] p = T4LoggingUtilities.makeParams(null);
                lr.setParameters(p);
                lr.setSourceClassName("SQLMXDataSource");
                lr.setSourceMethodName("<init>");
                T4LogFormatter lf = new T4LogFormatter();
                String temp = lf.format(lr);
                this.getLogWriter().println(temp);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public SQLMXDataSource(Properties info) {
        super(info);
        if (this.getQueryExecuteTime() > 0L) {
            this.setupSlowQueryLogFileHandler();
        }
        if (Level.parse(this.getT4LogLevel()) != Level.OFF) {
            this.setupLogFileHandler();
        }
        if (this.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null);
            this.t4Logger_.logp(Level.FINE, "SQLMXDataSource", "<init>", "Note, this constructor was called before the previous constructor", p);
        }
        try {
            if (this.getLogWriter() != null) {
                LogRecord lr = new LogRecord(Level.FINE, "");
                Object[] p = T4LoggingUtilities.makeParams(null);
                lr.setParameters(p);
                lr.setSourceClassName("SQLMXDataSource");
                lr.setSourceMethodName("<init>");
                T4LogFormatter lf = new T4LogFormatter();
                String temp = lf.format(lr);
                this.getLogWriter().println(temp);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setNameType(String nameType) {
    }

    public String getNameType() {
        return null;
    }
}

