/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXDataSource;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4Address;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SQLMXDriver
extends T4Properties
implements Driver {
    private static SQLMXDriver singleton_;
    static Hashtable dsCache_;

    public boolean acceptsURL(String url) throws SQLException {
        if (t4GlobalLogger.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null, url);
            t4GlobalLogger.logp(Level.FINE, "SQLMXDriver", "acceptsURL", "", p);
        }
        if (this.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(null, url);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXDriver");
            lr.setSourceMethodName("acceptsURL");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.getLogWriter().println(temp);
        }
        return T4Address.acceptsURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Connection connect(String url, Properties info) throws SQLException {
        if (t4GlobalLogger.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null, (Object)url, (Object)T4LoggingUtilities.makeProperties(info));
            t4GlobalLogger.logp(Level.CONFIG, "SQLMXDriver", "connect", "", p);
        }
        if (this.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.CONFIG, "");
            Object[] p = T4LoggingUtilities.makeParams(null, (Object)url, (Object)T4LoggingUtilities.makeProperties(info));
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXDriver");
            lr.setSourceMethodName("connect");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.getLogWriter().println(temp);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.entering("SQLMXDataSource", "getConnection");
        }
        String key = null;
        SQLMXDataSource ds = null;
        if (this.acceptsURL(url)) {
            SQLMXDriver sQLMXDriver = this;
            synchronized (sQLMXDriver) {
                Properties urlProps = this.setURL(url);
                if (urlProps != null && info != null) {
                    Enumeration<?> en1 = urlProps.propertyNames();
                    String key1 = null;
                    while (en1 != null && en1.hasMoreElements()) {
                        key1 = (String)en1.nextElement();
                        if (info.getProperty(key1) != null) continue;
                        info.setProperty(key1, urlProps.getProperty(key1));
                    }
                }
                if (info != null) {
                    this.initialize(info);
                    if (this.getSQLException() != null) {
                        throw SQLMXMessages.createSQLException(null, this.getLocale(), "invalid_property", this.getSQLException());
                    }
                }
                if (this.getMaxPoolSize() != -1) {
                    key = this.getUrl() + this.getCatalog() + this.getSchema() + this.getUser() + this.getPassword() + this.getServerDataSource() + this.getBlobTableName() + this.getClobTableName();
                    ds = (SQLMXDataSource)dsCache_.get(key);
                    if (ds == null) {
                        ds = new SQLMXDataSource(this.getProperties());
                        dsCache_.put(key, ds);
                    }
                } else {
                    ds = new SQLMXDataSource(this.getProperties());
                }
            }
            return ds.getConnection(ds.getUser(), ds.getPassword());
        }
        return null;
    }

    public int getMajorVersion() {
        if (t4GlobalLogger.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null);
            t4GlobalLogger.logp(Level.FINE, "SQLMXDriver", "getMajorVersion", "", p);
        }
        try {
            if (this.getLogWriter() != null) {
                LogRecord lr = new LogRecord(Level.FINE, "");
                Object[] p = T4LoggingUtilities.makeParams(null);
                lr.setParameters(p);
                lr.setSourceClassName("SQLMXDriver");
                lr.setSourceMethodName("getMajorVersion");
                T4LogFormatter lf = new T4LogFormatter();
                String temp = lf.format(lr);
                this.getLogWriter().println(temp);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 3;
    }

    public int getMinorVersion() {
        if (t4GlobalLogger.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null);
            t4GlobalLogger.logp(Level.FINE, "SQLMXDriver", "getMinorVersion", "", p);
        }
        try {
            if (this.getLogWriter() != null) {
                LogRecord lr = new LogRecord(Level.FINE, "");
                Object[] p = T4LoggingUtilities.makeParams(null);
                lr.setParameters(p);
                lr.setSourceClassName("SQLMXDriver");
                lr.setSourceMethodName("getMinorVersion");
                T4LogFormatter lf = new T4LogFormatter();
                String temp = lf.format(lr);
                this.getLogWriter().println(temp);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 11;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties prop = new Properties();
        if (info != null) {
            Enumeration<?> e = info.propertyNames();
            String pkey = null;
            while (e != null && e.hasMoreElements()) {
                pkey = (String)e.nextElement();
                if (pkey.equalsIgnoreCase("password")) {
                    prop.setProperty(pkey, "*****");
                    continue;
                }
                prop.setProperty(pkey, info.getProperty(pkey));
            }
        }
        if (t4GlobalLogger.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null, (Object)url, (Object)info);
            t4GlobalLogger.logp(Level.FINE, "SQLMXDriver", "getPropertyInfo", "", p);
        }
        if (this.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(null, (Object)url, (Object)info);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXDriver");
            lr.setSourceMethodName("getPropertyInfo");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.getLogWriter().println(temp);
        }
        if (this.acceptsURL(url)) {
            return super.getPropertyInfo(url, info);
        }
        return null;
    }

    public boolean jdbcCompliant() {
        if (t4GlobalLogger.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null);
            t4GlobalLogger.logp(Level.FINE, "SQLMXDriver", "jdbcCompliant", "", p);
        }
        try {
            if (this.getLogWriter() != null) {
                LogRecord lr = new LogRecord(Level.FINE, "");
                Object[] p = T4LoggingUtilities.makeParams(null);
                lr.setParameters(p);
                lr.setSourceClassName("SQLMXDriver");
                lr.setSourceMethodName("jdbcCompliant");
                T4LogFormatter lf = new T4LogFormatter();
                String temp = lf.format(lr);
                this.getLogWriter().println(temp);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return true;
    }

    public SQLMXDriver() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.entering("SQLMXDataSource", "getConnection");
        }
    }

    static {
        try {
            singleton_ = new SQLMXDriver();
            DriverManager.registerDriver(singleton_);
        }
        catch (SQLException e) {
            singleton_ = null;
            e.printStackTrace();
        }
        dsCache_ = new Hashtable();
    }
}

