/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.ERROR_DESC_LIST_def;
import com.tandem.t4jdbc.ERROR_DESC_def;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXHandle;
import com.tandem.t4jdbc.SQLWarningOrError;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

class SQLMXMessages {
    SQLMXMessages() {
    }

    static Logger getMessageLogger(T4Properties t4props) {
        return t4props != null ? t4props.t4Logger_ : T4Properties.t4GlobalLogger;
    }

    static void setSQLWarning(T4Properties t4props, SQLMXHandle handle, ERROR_DESC_LIST_def sqlWarning) {
        Logger log = SQLMXMessages.getMessageLogger(t4props);
        if (sqlWarning.length == 0) {
            handle.setSqlWarning(null);
            return;
        }
        ERROR_DESC_def[] error_desc_def = sqlWarning.buffer;
        for (int curErrorNo = 0; curErrorNo < sqlWarning.length; ++curErrorNo) {
            if (log != null && log.isLoggable(Level.WARNING)) {
                Object[] p = new Object[]{t4props, "Text: " + error_desc_def[curErrorNo].errorText, "SQLState: " + error_desc_def[curErrorNo].sqlstate, "SQLCode: " + error_desc_def[curErrorNo].sqlcode};
                log.logp(Level.WARNING, "SQLMXMessages", "setSQLWarning", "", p);
            }
            SQLWarning sqlWarningLeaf = new SQLWarning(error_desc_def[curErrorNo].errorText, error_desc_def[curErrorNo].sqlstate, error_desc_def[curErrorNo].sqlcode);
            handle.setSqlWarning(sqlWarningLeaf);
        }
    }

    static void throwSQLException(T4Properties t4props, ERROR_DESC_LIST_def SQLError) throws SQLMXException {
        Logger log = SQLMXMessages.getMessageLogger(t4props);
        Locale locale = t4props != null ? t4props.getLocale() : Locale.getDefault();
        SQLMXException sqlException = null;
        SQLMXException sqlExceptionHead = null;
        if (SQLError.length == 0) {
            throw SQLMXMessages.createSQLException(t4props, locale, "No messages in the Error description", null);
        }
        for (int curErrorNo = 0; curErrorNo < SQLError.length; ++curErrorNo) {
            if (log != null && log.isLoggable(Level.SEVERE)) {
                Object[] p = new Object[]{t4props, "Text: " + SQLError.buffer[curErrorNo].errorText, "SQLState: " + SQLError.buffer[curErrorNo].sqlstate, "SQLCode: " + SQLError.buffer[curErrorNo].sqlcode};
                log.logp(Level.SEVERE, "SQLMXMessages", "throwSQLException", "", p);
            }
            sqlException = SQLError.buffer[curErrorNo].errorCodeType == 2 ? SQLMXMessages.createSQLException(t4props, locale, "resource_governing", null) : new SQLMXException(SQLError.buffer[curErrorNo].errorText, SQLError.buffer[curErrorNo].sqlstate, SQLError.buffer[curErrorNo].sqlcode, null);
            if (curErrorNo == 0) {
                sqlExceptionHead = sqlException;
                continue;
            }
            sqlExceptionHead.setNextException(sqlException);
        }
        throw sqlExceptionHead;
    }

    static void throwSQLException(T4Properties t4props, SQLWarningOrError[] we1) throws SQLMXException {
        Logger log = SQLMXMessages.getMessageLogger(t4props);
        Locale locale = t4props != null ? t4props.getLocale() : Locale.getDefault();
        SQLMXException sqlException = null;
        SQLMXException sqlExceptionHead = null;
        if (we1.length == 0) {
            throw SQLMXMessages.createSQLException(t4props, locale, "No messages in the Error description", null);
        }
        for (int curErrorNo = 0; curErrorNo < we1.length; ++curErrorNo) {
            if (log != null && log.isLoggable(Level.SEVERE)) {
                Object[] p = new Object[]{t4props, "Text: " + we1[curErrorNo].text, "SQLState: " + we1[curErrorNo].sqlState, "SQLCode: " + we1[curErrorNo].sqlCode};
                log.logp(Level.SEVERE, "SQLMXMessages", "throwSQLException", "", p);
            }
            sqlException = new SQLMXException(we1[curErrorNo].text, we1[curErrorNo].sqlState, we1[curErrorNo].sqlCode, null);
            if (curErrorNo == 0) {
                sqlExceptionHead = sqlException;
                continue;
            }
            sqlExceptionHead.setNextException(sqlException);
        }
        throw sqlExceptionHead;
    }

    static void setSQLWarning(T4Properties t4props, SQLMXHandle handle, SQLWarningOrError[] we1) {
        Logger log = SQLMXMessages.getMessageLogger(t4props);
        if (we1.length == 0) {
            handle.setSqlWarning(null);
            return;
        }
        for (int curErrorNo = 0; curErrorNo < we1.length; ++curErrorNo) {
            if (log != null && log.isLoggable(Level.WARNING)) {
                Object[] p = new Object[]{t4props, "Text: " + we1[curErrorNo].text, "SQLState: " + we1[curErrorNo].sqlState, "SQLCode: " + we1[curErrorNo].sqlCode};
                log.logp(Level.WARNING, "SQLMXMessages", "setSQLWarning", "", p);
            }
            SQLWarning sqlWarningLeaf = new SQLWarning(we1[curErrorNo].text, we1[curErrorNo].sqlState, we1[curErrorNo].sqlCode);
            handle.setSqlWarning(sqlWarningLeaf);
        }
    }

    static SQLWarning createSQLWarning(T4Properties t4props, String messageId, Object[] messageArguments) {
        Logger log = SQLMXMessages.getMessageLogger(t4props);
        if (log != null && log.isLoggable(Level.WARNING)) {
            Object[] p = T4LoggingUtilities.makeParams(t4props, (Object)messageId, (Object)messageArguments);
            log.logp(Level.WARNING, "SQLMXMessages", "createSQLWarning", "", p);
        }
        Locale currentLocale = t4props != null ? t4props.getLocale() : Locale.getDefault();
        int sqlcode = 1;
        SQLWarning ret = null;
        try {
            PropertyResourceBundle messageBundle = (PropertyResourceBundle)ResourceBundle.getBundle("SQLMXMessages", currentLocale);
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(currentLocale);
            formatter.applyPattern(messageBundle.getString(messageId + "_msg"));
            String message = formatter.format(messageArguments);
            String sqlState = messageBundle.getString(messageId + "_sqlstate");
            String sqlcodeStr = messageBundle.getString(messageId + "_sqlcode");
            if (sqlcodeStr != null) {
                try {
                    sqlcode = Integer.parseInt(sqlcodeStr);
                }
                catch (NumberFormatException e1) {
                    // empty catch block
                }
            }
            ret = new SQLWarning(message, sqlState, sqlcode);
        }
        catch (MissingResourceException e) {
            int i = 0;
            String message = "The message id: " + messageId;
            if (messageArguments != null) {
                message = message.concat(" With parameters: ");
                while (true) {
                    message = message.concat(messageArguments[i++].toString());
                    if (i >= messageArguments.length) break;
                    message = message.concat(",");
                }
            }
            ret = new SQLWarning(message, "01000", 1);
        }
        return ret;
    }

    static SQLMXException createSQLException(T4Properties t4props, Locale msgLocale, String messageId, Object mA1, Object mA2) {
        Object[] mAs = new Object[]{mA1, mA2};
        return SQLMXMessages.createSQLException(t4props, msgLocale, messageId, mAs);
    }

    static SQLMXException createSQLException(T4Properties t4props, Locale msgLocale, String messageId, Object messageArgument) {
        Object[] mAs = new Object[]{messageArgument};
        return SQLMXMessages.createSQLException(t4props, msgLocale, messageId, mAs);
    }

    static SQLMXException createSQLException(T4Properties t4props, Locale msgLocale, String messageId, Object[] messageArguments) {
        Logger log = SQLMXMessages.getMessageLogger(t4props);
        if (log != null && log.isLoggable(Level.SEVERE)) {
            Object[] p = T4LoggingUtilities.makeParams(t4props, (Object)messageId, (Object)messageArguments);
            log.logp(Level.SEVERE, "SQLMXMessages", "createSQLException", "", p);
        }
        Locale currentLocale = msgLocale == null ? Locale.getDefault() : msgLocale;
        try {
            int sqlcode;
            PropertyResourceBundle messageBundle = null;
            try {
                messageBundle = (PropertyResourceBundle)ResourceBundle.getBundle("SQLMXMessages", currentLocale);
            }
            catch (MissingResourceException me) {
                if (currentLocale.getLanguage() != "en") {
                    Locale tmpLocale;
                    currentLocale = tmpLocale = new Locale("en", "US");
                }
                messageBundle = (PropertyResourceBundle)ResourceBundle.getBundle("SQLMXMessages", currentLocale);
            }
            MessageFormat formatter = new MessageFormat("");
            formatter.setLocale(currentLocale);
            formatter.applyPattern(messageBundle.getString(messageId + "_msg"));
            String message = formatter.format(messageArguments);
            String sqlState = messageBundle.getString(messageId + "_sqlstate");
            String sqlcodeStr = messageBundle.getString(messageId + "_sqlcode");
            if (sqlcodeStr != null) {
                try {
                    sqlcode = Integer.parseInt(sqlcodeStr);
                    sqlcode = -sqlcode;
                }
                catch (NumberFormatException e1) {
                    sqlcode = -1;
                }
            } else {
                sqlcode = -1;
            }
            return new SQLMXException(message, sqlState, sqlcode, messageId);
        }
        catch (Exception e) {
            int i = 0;
            String message = "The message id: " + messageId;
            if (messageArguments != null) {
                message = message.concat(" With parameters: ");
                while (true) {
                    message = message.concat(messageArguments[i++].toString());
                    if (i >= messageArguments.length) break;
                    message = message.concat(",");
                }
            }
            return new SQLMXException(message, "HY000", -1, messageId);
        }
    }

    static void throwUnsupportedFeatureException(T4Properties t4props, Locale locale, String s) throws SQLMXException {
        Object[] messageArguments = new Object[]{s};
        throw SQLMXMessages.createSQLException(t4props, locale, "unsupported_feature", messageArguments);
    }

    static void throwDeprecatedMethodException(T4Properties t4props, Locale locale, String s) throws SQLMXException {
        Object[] messageArguments = new Object[]{s};
        throw SQLMXMessages.createSQLException(t4props, locale, "deprecated_method", messageArguments);
    }
}

