/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXConnectionPoolDataSource;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class SQLMXPooledConnection
implements PooledConnection {
    private LinkedList listenerList_;
    private boolean isClosed_ = false;
    private SQLMXConnectionPoolDataSource pds_;
    private SQLMXConnection connection_;
    private Locale locale_;
    private boolean LogicalConnectionInUse_ = false;

    public void addConnectionEventListener(ConnectionEventListener listener) {
        try {
            if (this.connection_ != null && this.connection_.props_.t4Logger_.isLoggable(Level.INFO)) {
                Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, listener);
                this.connection_.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnecton", "addConnectionEventListener", "", p);
            }
            if (this.connection_ != null && this.connection_.props_.getLogWriter() != null) {
                LogRecord lr = new LogRecord(Level.INFO, "");
                Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, listener);
                lr.setParameters(p);
                lr.setSourceClassName("SQLMXPooledConnection");
                lr.setSourceMethodName("addConnectionEventListener");
                T4LogFormatter lf = new T4LogFormatter();
                String temp = lf.format(lr);
                this.connection_.props_.getLogWriter().println(temp);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.isClosed_ || this.connection_ == null) {
            return;
        }
        this.listenerList_.add(listener);
    }

    public void close() throws SQLException {
        if (this.connection_ != null && this.connection_.props_.t4Logger_.isLoggable(Level.INFO)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnecton", "close", "", p);
        }
        if (this.connection_ != null && this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.INFO, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPooledConnection");
            lr.setSourceMethodName("close");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            return;
        }
        this.connection_.close(true, true);
    }

    public Connection getConnection() throws SQLException {
        if (this.connection_ != null && this.connection_.props_.t4Logger_.isLoggable(Level.INFO)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnecton", "getConnection", "", p);
        }
        if (this.connection_ != null && this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.INFO, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPooledConnection");
            lr.setSourceMethodName("getConnection");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_ || this.connection_ == null) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.locale_, "invalid_connection", null);
        }
        if (this.LogicalConnectionInUse_) {
            this.connection_.close(false, false);
        }
        this.LogicalConnectionInUse_ = true;
        this.connection_.reuse();
        return this.connection_;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        try {
            if (this.connection_ != null && this.connection_.props_.t4Logger_.isLoggable(Level.INFO)) {
                Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, listener);
                this.connection_.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnecton", "removeConnectionEventListener", "", p);
            }
            if (this.connection_ != null && this.connection_.props_.getLogWriter() != null) {
                LogRecord lr = new LogRecord(Level.INFO, "");
                Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, listener);
                lr.setParameters(p);
                lr.setSourceClassName("SQLMXPooledConnection");
                lr.setSourceMethodName("removeConnectionEventListener");
                T4LogFormatter lf = new T4LogFormatter();
                String temp = lf.format(lr);
                this.connection_.props_.getLogWriter().println(temp);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.isClosed_ || this.connection_ == null) {
            return;
        }
        this.listenerList_.remove(listener);
    }

    void logicalClose(boolean sendEvents) {
        this.LogicalConnectionInUse_ = false;
        if (sendEvents) {
            int totalListener = this.listenerList_.size();
            ConnectionEvent event = new ConnectionEvent(this);
            for (int i = 0; i < totalListener; ++i) {
                ConnectionEventListener listener = (ConnectionEventListener)this.listenerList_.get(i);
                listener.connectionClosed(event);
            }
        }
    }

    void sendConnectionErrorEvent(SQLException ex) throws SQLException {
        this.LogicalConnectionInUse_ = false;
        int totalListener = this.listenerList_.size();
        ConnectionEvent event = new ConnectionEvent(this, ex);
        for (int i = 0; i < totalListener; ++i) {
            ConnectionEventListener listener = (ConnectionEventListener)this.listenerList_.get(i);
            listener.connectionErrorOccurred(event);
        }
        this.close();
    }

    SQLMXPooledConnection(SQLMXConnectionPoolDataSource pds, T4Properties t4props) throws SQLException {
        T4Properties t4LocalProps;
        this.pds_ = pds;
        if (t4props != null) {
            t4LocalProps = t4props;
            this.locale_ = t4props.getLocale();
        } else {
            t4LocalProps = new T4Properties();
            this.locale_ = Locale.getDefault();
        }
        this.listenerList_ = new LinkedList();
        this.connection_ = new SQLMXConnection(this, t4LocalProps);
        try {
            if (this.connection_ != null && this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
                Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)pds, (Object)t4props);
                this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPooledConnecton", "", "", p);
            }
            if (this.connection_ != null && this.connection_.props_.getLogWriter() != null) {
                LogRecord lr = new LogRecord(Level.FINE, "");
                Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)pds, (Object)t4props);
                lr.setParameters(p);
                lr.setSourceClassName("SQLMXPooledConnection");
                lr.setSourceMethodName("");
                T4LogFormatter lf = new T4LogFormatter();
                String temp = lf.format(lr);
                this.connection_.props_.getLogWriter().println(temp);
            }
        }
        catch (SQLException se) {
            // empty catch block
        }
    }

    SQLMXConnection getSQLMXConnectionReference() {
        return this.connection_;
    }

    protected boolean isClosed() throws SQLException {
        return this.connection_ == null || this.isClosed_;
    }
}

