/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.InterfaceConnection;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXConnectionPoolDataSource;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXPooledConnection;
import com.tandem.t4jdbc.T4Connection;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class SQLMXPooledConnectionManager
implements ConnectionEventListener {
    ConnectionPoolDataSource pds_;
    List inUse_;
    List free_;
    int count_;
    int maxPoolSize_;
    int minPoolSize_;
    long maxIdleTime_;
    int connectionTimeout_;
    Level traceLevel_;
    PrintWriter out_;
    String traceId_;
    Timer timer_;
    Hashtable hashTab_ = new Hashtable();
    boolean initialPoolCreationFlag_ = false;

    public void connectionClosed(ConnectionEvent event) {
        boolean wasPresent;
        if (T4Properties.t4GlobalLogger.isLoggable(Level.INFO)) {
            Object[] p = T4LoggingUtilities.makeParams(null, event);
            T4Properties.t4GlobalLogger.logp(Level.INFO, "SQLMXPooledConnectionManager", "connectionClosed", "", p);
        }
        if (this.out_ != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(null, event);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXPooledConnectionManager");
            lr.setSourceMethodName("connectionClosed");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.out_.println(temp);
        }
        if (this.out_ != null && this.traceLevel_ != Level.OFF) {
            this.out_.println(this.traceId_ + "connectionClosed(" + event + ")");
        }
        PooledConnection pc = (PooledConnection)event.getSource();
        boolean addToFreePool = true;
        if (this.minPoolSize_ > 0 && this.free_.size() >= this.minPoolSize_) {
            addToFreePool = false;
        }
        if (this.initialPoolCreationFlag_) {
            addToFreePool = true;
        }
        if ((wasPresent = this.removeInUseConnection(pc, addToFreePool)) && !addToFreePool) {
            try {
                pc.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this.out_ != null && this.traceLevel_ != Level.OFF) {
            this.out_.println(this.traceId_ + "connectionErrorOccurred(" + event + ")");
        }
        PooledConnection pc = (PooledConnection)event.getSource();
        try {
            pc.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.removeInUseConnection(pc, false);
    }

    public Connection getConnection() throws SQLException {
        PooledConnection pc;
        if (this.out_ != null && this.traceLevel_ != Level.OFF) {
            this.out_.println(this.traceId_ + "getConnection()");
        }
        boolean validConnection = false;
        do {
            Object[] p;
            SQLMXConnection c;
            if (this.free_.size() == 0) {
                if (this.maxPoolSize_ == 0 || this.count_ < this.maxPoolSize_) {
                    pc = this.pds_.getPooledConnection();
                    ++this.count_;
                    pc.addConnectionEventListener(this);
                    this.inUse_.add(pc);
                    c = (SQLMXConnection)pc.getConnection();
                    if (c.props_.t4Logger_.isLoggable(Level.INFO)) {
                        p = T4LoggingUtilities.makeParams(c.props_, "CONNECTION POOL INFO");
                        if (this.maxPoolSize_ > 0) {
                            c.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnectionManager", "getConnection", "IN USE " + this.inUse_.size() + " OF MAXPOOL " + this.maxPoolSize_, p);
                        } else {
                            c.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnectionManager", "getConnection", "IN USE " + this.inUse_.size() + " OF UNLIMITED MAXPOOL", p);
                        }
                    }
                    try {
                        c.ic_.enforceT4ConnectionTimeout(c);
                        validConnection = true;
                    }
                    catch (SQLException sqlEx) {
                        try {
                            pc.close();
                        }
                        catch (Exception e) {}
                    }
                    continue;
                }
                throw SQLMXMessages.createSQLException(null, null, "max_pool_size_reached", null);
            }
            pc = (PooledConnection)this.free_.get(0);
            if (!this.removeFreeConnection(pc, true)) continue;
            c = (SQLMXConnection)pc.getConnection();
            if (c.props_.t4Logger_.isLoggable(Level.INFO)) {
                p = T4LoggingUtilities.makeParams(c.props_, "CONNECTION POOL INFO");
                c.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnectionManager", "getConnection", "Retrived Connection from the Pool", p);
            }
            if (c.props_.t4Logger_.isLoggable(Level.INFO)) {
                p = T4LoggingUtilities.makeParams(c.props_, "CONNECTION POOL INFO");
                if (this.maxPoolSize_ > 0) {
                    c.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnectionManager", "getConnection", "IN USE " + this.inUse_.size() + " OF MAXPOOL " + this.maxPoolSize_, p);
                } else {
                    c.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnectionManager", "getConnection", "IN USE " + this.inUse_.size() + " UNLIMITED MAXPOOL", p);
                }
            }
            try {
                c.ic_.enforceT4ConnectionTimeout(c);
                validConnection = true;
            }
            catch (SQLException sqlEx) {
                try {
                    pc.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } while (!validConnection);
        return pc.getConnection();
    }

    private synchronized boolean removeFreeConnection(PooledConnection pc, boolean addToUsePool) {
        boolean wasPresent = this.free_.remove(pc);
        this.hashTab_.remove(pc);
        if (wasPresent) {
            if (addToUsePool) {
                this.inUse_.add(pc);
            } else {
                --this.count_;
            }
        }
        return wasPresent;
    }

    private synchronized boolean removeInUseConnection(PooledConnection pc, boolean addToFreePool) {
        boolean wasPresent = this.inUse_.remove(pc);
        this.hashTab_.remove(pc);
        if (wasPresent) {
            if (addToFreePool) {
                SQLMXConnection c = null;
                try {
                    c = (SQLMXConnection)pc.getConnection();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                if (c != null) {
                    Object[] p;
                    if (c.props_.t4Logger_.isLoggable(Level.INFO)) {
                        p = T4LoggingUtilities.makeParams(c.props_, "CONNECTION POOL INFO");
                        c.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnectionManager", "removeInUseConnection", "Added Connection to the Free Pool", p);
                    }
                    if (c.props_.t4Logger_.isLoggable(Level.INFO)) {
                        p = T4LoggingUtilities.makeParams(c.props_, "CONNECTION POOL INFO");
                        if (this.maxPoolSize_ > 0) {
                            c.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnectionManager", "removeInUseConnection", "IN USE " + this.inUse_.size() + " OF MAXPOOL " + this.maxPoolSize_, p);
                        } else {
                            c.props_.t4Logger_.logp(Level.INFO, "SQLMXPooledConnectionManager", "removeInUseConnection", "IN USE " + this.inUse_.size() + " UNLIMITED MAXPOOL", p);
                        }
                    }
                }
                this.hashTab_.put(pc, new Long(System.currentTimeMillis() + 1000L * this.maxIdleTime_));
                this.free_.add(pc);
            } else {
                --this.count_;
            }
        }
        return wasPresent;
    }

    private void createInitialPool(int initialPoolSize) throws SQLException {
        if (initialPoolSize <= 0) {
            return;
        }
        int limit = initialPoolSize > this.maxPoolSize_ ? this.maxPoolSize_ : initialPoolSize;
        Connection[] initPool_ = new Connection[limit];
        int created = 0;
        try {
            this.initialPoolCreationFlag_ = true;
            for (int i = 0; i < limit; ++i) {
                initPool_[i] = this.getConnection();
                ++created;
            }
        }
        catch (SQLException se) {
            SQLMXException head = SQLMXMessages.createSQLException(null, null, "initial_pool_creation_error", "" + limit);
            head.setNextException(se);
            throw head;
        }
        finally {
            for (int i = 0; i < created; ++i) {
                try {
                    if (initPool_[i] == null) continue;
                    initPool_[i].close();
                    continue;
                }
                catch (SQLException se) {}
            }
            this.initialPoolCreationFlag_ = false;
        }
    }

    void setLogWriter(PrintWriter out) {
        this.out_ = out;
    }

    SQLMXPooledConnectionManager(SQLMXConnectionPoolDataSource pds, Level traceLevel) throws SQLException {
        TimerTask timerTask_;
        String className = this.getClass().getName();
        this.pds_ = pds;
        this.inUse_ = Collections.synchronizedList(new LinkedList());
        this.free_ = Collections.synchronizedList(new LinkedList());
        this.maxPoolSize_ = pds.getMaxPoolSize();
        this.minPoolSize_ = pds.getMinPoolSize();
        this.maxIdleTime_ = pds.getMaxIdleTime();
        this.connectionTimeout_ = pds.getConnectionTimeout();
        this.traceLevel_ = traceLevel;
        this.timer_ = null;
        if (this.maxIdleTime_ > 0L && this.maxPoolSize_ > 0) {
            timerTask_ = new IdleConnectionCleanupTask();
            this.timer_ = new Timer(true);
            this.timer_.schedule(timerTask_, this.maxIdleTime_ * 1000L, this.maxIdleTime_ * 500L);
        }
        if (this.connectionTimeout_ > 0 && this.maxPoolSize_ > 0) {
            timerTask_ = new ConnectionTimeoutCleanupTask();
            if (this.timer_ == null) {
                this.timer_ = new Timer(true);
            }
            this.timer_.schedule(timerTask_, this.connectionTimeout_ * 1000, (long)(this.connectionTimeout_ * 500));
        }
        this.createInitialPool(pds.getInitialPoolSize());
        this.traceId_ = "jdbcTrace:[" + Thread.currentThread() + "]:[" + this.hashCode() + "]:" + className + ".";
    }

    private class ConnectionTimeoutCleanupTask
    extends TimerTask {
        Vector toRemove = new Vector();

        ConnectionTimeoutCleanupTask() {
        }

        public void run() {
            this.cleanUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUp() {
            this.toRemove.clear();
            List list = SQLMXPooledConnectionManager.this.inUse_;
            synchronized (list) {
                Iterator it_ = SQLMXPooledConnectionManager.this.inUse_.iterator();
                while (it_.hasNext()) {
                    try {
                        T4Connection tconn;
                        PooledConnection tempPC = (PooledConnection)it_.next();
                        InterfaceConnection ic = ((SQLMXPooledConnection)tempPC).getSQLMXConnectionReference().ic_;
                        if (ic == null || (tconn = ic.getT4Connection()) == null || !tconn.connectionIdleTimeoutOccured()) continue;
                        this.toRemove.add(tempPC);
                    }
                    catch (Throwable t) {
                        if (!T4Properties.t4GlobalLogger.isLoggable(Level.WARNING)) continue;
                        T4Properties.t4GlobalLogger.logp(Level.WARNING, "ConnectionTimeoutCleanupTask", "cleanUp", t.getMessage());
                    }
                }
            }
            for (int i = 0; i < this.toRemove.size(); ++i) {
                PooledConnection pc = (PooledConnection)this.toRemove.get(i);
                SQLMXPooledConnectionManager.this.removeInUseConnection(pc, false);
            }
        }
    }

    private class IdleConnectionCleanupTask
    extends TimerTask {
        Vector toRemove = new Vector();

        IdleConnectionCleanupTask() {
        }

        public void run() {
            this.cleanUp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanUp() {
            this.toRemove.clear();
            List list = SQLMXPooledConnectionManager.this.free_;
            synchronized (list) {
                block9: {
                    try {
                        for (PooledConnection tempPC : SQLMXPooledConnectionManager.this.free_) {
                            Long timeOutVal = (Long)SQLMXPooledConnectionManager.this.hashTab_.get(tempPC);
                            if (System.currentTimeMillis() <= timeOutVal) continue;
                            this.toRemove.add(tempPC);
                        }
                    }
                    catch (Throwable t) {
                        if (!T4Properties.t4GlobalLogger.isLoggable(Level.WARNING)) break block9;
                        T4Properties.t4GlobalLogger.logp(Level.WARNING, "IdleConnectionCleanupTask", "cleanUp", t.getMessage());
                    }
                }
            }
            for (int i = 0; i < this.toRemove.size(); ++i) {
                PooledConnection pc = (PooledConnection)this.toRemove.get(i);
                boolean wasPresent = SQLMXPooledConnectionManager.this.removeFreeConnection(pc, false);
                if (!wasPresent) continue;
                try {
                    pc.close();
                    continue;
                }
                catch (SQLException se) {
                    // empty catch block
                }
            }
        }
    }
}

