/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.BaseRow;
import com.tandem.t4jdbc.Bytes;
import com.tandem.t4jdbc.CancelReply;
import com.tandem.t4jdbc.InsertRow;
import com.tandem.t4jdbc.InterfaceResultSet;
import com.tandem.t4jdbc.InterfaceUtilities;
import com.tandem.t4jdbc.Row;
import com.tandem.t4jdbc.SQLMXBlob;
import com.tandem.t4jdbc.SQLMXClob;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXDatabaseMetaData;
import com.tandem.t4jdbc.SQLMXDesc;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXHandle;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXPreparedStatement;
import com.tandem.t4jdbc.SQLMXResultSetMetaData;
import com.tandem.t4jdbc.SQLMXStatement;
import com.tandem.t4jdbc.SQLMX_AssociationServer_Cancel;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SQLMXResultSet
extends SQLMXHandle
implements ResultSet {
    InterfaceResultSet irs_;
    SQLMXDesc[] outputDesc_;
    SQLMXStatement stmt_;
    SQLMXConnection connection_;
    boolean isClosed_;
    int currentRow_;
    boolean endOfData_;
    boolean wasNull_;
    int totalRowsFetched_;
    int fetchSize_;
    int fetchDirection_;
    String stmtLabel_;
    ArrayList cachedRows_;
    boolean onInsertRow_;
    InsertRow insertRow_;
    int savedCurrentRow_;
    boolean showInserted_;
    int numRows_;
    boolean isAfterLast_;
    boolean isBeforeFirst_;
    float _javaVersion;
    Method _toPlainString;
    boolean noKeyFound_;
    StringBuffer deleteCmd_;
    StringBuffer insertCmd_;
    StringBuffer updateCmd_;
    StringBuffer selectCmd_;
    PreparedStatement deleteStmt_;
    PreparedStatement insertStmt_;
    PreparedStatement updateStmt_;
    PreparedStatement selectStmt_;
    BitSet paramCols_;
    BitSet keyCols_;
    int holdability_;
    int currentRowCount_ = 0;
    static final int DEFAULT_FETCH_SIZE = 1;
    static final String hyphen_string = new String("-");
    static long seqCount_ = 0L;
    long seqNum_ = 0L;
    String proxySyntax_ = "";
    boolean useOldDateFormat_ = false;
    boolean isAnyLob_;
    boolean spj_rs_;
    boolean keepRawBuffer_;
    byte[] rawBuffer_;
    boolean fetchComplete_;

    public boolean absolute(int row) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, row);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "absolute", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, row);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("absolute");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        boolean flag = false;
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getType() == 1003) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "forward_only_cursor", null);
        }
        if (row == 0) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_row_number", null);
        }
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
        if (row > 0) {
            if (row <= this.numRows_) {
                this.currentRow_ = row;
                this.isBeforeFirst_ = false;
                this.isAfterLast_ = false;
                this.onInsertRow_ = false;
                flag = true;
            } else {
                while ((flag = this.next()) && this.currentRow_ < row) {
                }
            }
        } else {
            int absRow = -row;
            this.afterLast();
            if (absRow <= this.numRows_) {
                this.currentRow_ = this.numRows_ - absRow + 1;
                this.isAfterLast_ = false;
                this.isBeforeFirst_ = false;
                this.onInsertRow_ = false;
                flag = true;
            } else {
                this.beforeFirst();
            }
        }
        return flag;
    }

    public void afterLast() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "afterLast", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("afterLast");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getType() == 1003) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "forward_only_cursor", null);
        }
        this.last();
        this.isAfterLast_ = true;
        this.isBeforeFirst_ = false;
    }

    public void beforeFirst() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "beforeFirst", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("beforeFirst");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getType() == 1003) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "forward_only_cursor", null);
        }
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
        this.currentRow_ = 0;
        this.isBeforeFirst_ = true;
        this.isAfterLast_ = false;
        this.onInsertRow_ = false;
    }

    public void cancelRowUpdates() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "cancelRowUpdates", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("cancelRowUpdates");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getConcurrency() == 1007) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "read_only_concur", null);
        }
        if (this.onInsertRow_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_position", null);
        }
        Row row = (Row)this.getCurrentRow();
        if (!row.getUpdated()) {
            row.clearUpdated();
        }
    }

    public synchronized void close() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "close", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("close");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            return;
        }
        if (this.connection_._isClosed()) {
            this.connection_.closeErroredConnection(null);
            return;
        }
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
        if (this.stmt_ instanceof SQLMXPreparedStatement) {
            this.close(false);
        } else {
            this.close(true);
        }
    }

    public void deleteRow() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "deleteRow", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("deleteRow");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getConcurrency() == 1007) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "read_only_concur", null);
        }
        if (this.onInsertRow_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_position", null);
        }
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
        try {
            this.prepareDeleteStmt();
            Row row = (Row)this.getCurrentRow();
            row.deleteRow(this.connection_.getLocale(), this.deleteStmt_, this.paramCols_);
            this.cachedRows_.remove(--this.currentRow_);
            --this.numRows_;
            if (this.getType() == 1003 && this.getConcurrency() == 1008) {
                int temp = this.currentRowCount_--;
                if (!this.next()) {
                    if (temp == 1) {
                        this.isBeforeFirst_ = true;
                    }
                    this.currentRowCount_ = 0;
                }
            } else if (this.currentRow_ == 0) {
                this.isBeforeFirst_ = true;
            }
        }
        catch (SQLException e) {
            this.performConnectionErrorChecks(e);
            throw e;
        }
    }

    public int findColumn(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "findColumn", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("findColumn");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        for (int i = 0; i < this.outputDesc_.length; ++i) {
            if (!columnName.equalsIgnoreCase(this.outputDesc_[i].name_)) continue;
            return i + 1;
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_name", null);
    }

    public boolean first() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "first", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("first");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        boolean flag = true;
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getType() == 1003) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "forward_only_cursor", null);
        }
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
        if (this.isBeforeFirst_) {
            flag = this.next();
        }
        if (this.numRows_ > 0) {
            this.currentRow_ = 1;
            this.isAfterLast_ = false;
            this.isBeforeFirst_ = false;
            this.onInsertRow_ = false;
        }
        return flag;
    }

    public Array getArray(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getArray", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getArray");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "getArray()");
        return null;
    }

    public Array getArray(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getArray", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getArray");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getArray(columnIndex);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getAsciiStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getAsciiStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int dataType = this.outputDesc_[columnIndex - 1].dataType_;
        switch (dataType) {
            case 2005: {
                Clob clob = this.getClob(columnIndex);
                if (clob != null) {
                    return clob.getAsciiStream();
                }
                return null;
            }
            case 2004: {
                Blob blob = this.getBlob(columnIndex);
                if (blob != null) {
                    return blob.getBinaryStream();
                }
                return null;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                String data = this.getLocalString(columnIndex);
                if (data != null) {
                    try {
                        return new DataInputStream(new ByteArrayInputStream(data.getBytes("ASCII")));
                    }
                    catch (UnsupportedEncodingException e) {
                        Object[] messageArguments = new Object[]{e.getMessage()};
                        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "unsupported_encoding", messageArguments);
                    }
                }
                return null;
            }
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getAsciiStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getAsciiStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getAsciiStream(columnIndex);
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        this.outputDesc_[columnIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getLocalString(columnIndex);
        if (data != null) {
            BigDecimal retValue;
            data = data.trim();
            try {
                retValue = new BigDecimal(data);
            }
            catch (NumberFormatException e) {
                Double d;
                try {
                    d = new Double(data);
                }
                catch (NumberFormatException e1) {
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
                }
                retValue = new BigDecimal(d);
            }
            return retValue;
        }
        return null;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal retValue;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, scale);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, scale);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if ((retValue = this.getBigDecimal(columnIndex)) != null) {
            return retValue.setScale(scale);
        }
        return null;
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getBigDecimal(columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, scale);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, scale);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getBigDecimal(columnIndex, scale);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBinaryStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBinaryStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        int dataType = this.outputDesc_[columnIndex - 1].dataType_;
        switch (dataType) {
            case 2005: {
                Clob clob = this.getClob(columnIndex);
                if (clob != null) {
                    return clob.getAsciiStream();
                }
                return null;
            }
            case 2004: {
                Blob blob = this.getBlob(columnIndex);
                if (blob != null) {
                    return blob.getBinaryStream();
                }
                return null;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                byte[] data = this.getBytes(columnIndex);
                if (data != null) {
                    return new ByteArrayInputStream(data);
                }
                return null;
            }
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBinaryStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBinaryStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getBinaryStream(columnIndex);
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        Blob data;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBlob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBlob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        int dataType = this.outputDesc_[columnIndex - 1].dataType_;
        if (dataType != 2004) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        Row row = (Row)this.getCurrentRow();
        Object x = this.getCurrentRow().getColumnObject(columnIndex);
        if (x == null) {
            this.wasNull_ = true;
            data = null;
        } else {
            this.wasNull_ = false;
            if (x instanceof Blob) {
                data = (Blob)x;
            } else if (x instanceof BigInteger) {
                long data_locator = ((BigInteger)x).longValue();
                String tableName = this.outputDesc_[columnIndex - 1].tableName_;
                data = new SQLMXBlob(this.connection_, tableName, data_locator);
                row.setLobObject(columnIndex, data);
                this.isAnyLob_ = true;
            } else if (x instanceof Long) {
                long data_locator = (Long)x;
                String tableName = this.outputDesc_[columnIndex - 1].tableName_;
                data = new SQLMXBlob(this.connection_, tableName, data_locator);
                row.setLobObject(columnIndex, data);
                this.isAnyLob_ = true;
            } else {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
            }
        }
        return data;
    }

    public Blob getBlob(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBlob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBlob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getBlob(columnIndex);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBoolean", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBoolean");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        this.outputDesc_[columnIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getLocalString(columnIndex);
        if (data != null) {
            short shortValue;
            if ((data = data.trim()).equalsIgnoreCase("true") || data.equalsIgnoreCase("1")) {
                return true;
            }
            if (data.equalsIgnoreCase("false") || data.equalsIgnoreCase("false")) {
                return false;
            }
            try {
                shortValue = this.getShort(columnIndex);
            }
            catch (NumberFormatException e) {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
            }
            switch (shortValue) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "numeric_out_of_range", null);
        }
        return false;
    }

    public boolean getBoolean(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBoolean", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBoolean");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getBoolean(columnIndex);
    }

    public byte getByte(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getByte", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getByte");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        this.outputDesc_[columnIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getLocalString(columnIndex);
        if (data != null) {
            byte retValue;
            try {
                retValue = Byte.parseByte(data);
            }
            catch (NumberFormatException e) {
                Double d;
                try {
                    d = new Double(data);
                }
                catch (NumberFormatException e1) {
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
                }
                double d1 = d;
                if (d1 > -129.0 && d1 < 128.0) {
                    retValue = d.byteValue();
                    if ((double)retValue != d1) {
                        this.setSQLWarning(null, "data_truncation", null);
                    }
                }
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "numeric_out_of_range", null);
            }
            return retValue;
        }
        return 0;
    }

    public byte getByte(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getByte", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getByte");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getByte(columnIndex);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBytes", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBytes");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        int dataType = this.outputDesc_[columnIndex - 1].dataType_;
        switch (dataType) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                Object x = this.getCurrentRow().getColumnObject(columnIndex);
                if (x == null) {
                    this.wasNull_ = true;
                    return null;
                }
                this.wasNull_ = false;
                if (x instanceof byte[]) {
                    return (byte[])x;
                }
                if (x instanceof String) {
                    int sqlCharset = this.outputDesc_[columnIndex - 1].sqlCharset_;
                    if (sqlCharset == -1 || sqlCharset == -2 || sqlCharset == 11) {
                        String charSet = InterfaceUtilities.getEncodingTranslation(this.connection_, sqlCharset);
                        try {
                            String data = new String((byte[])x, charSet);
                            return data.getBytes();
                        }
                        catch (Exception e) {
                            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "unsupported_encoding", charSet);
                        }
                    }
                    return ((String)x).getBytes();
                }
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
            }
            case 2004: {
                Blob blob = this.getBlob(columnIndex);
                if (blob == null) {
                    return null;
                }
                return blob.getBytes(1L, (int)blob.length());
            }
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getBytes", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getBytes");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getBytes(columnIndex);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getCharacterStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getCharacterStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        int dataType = this.outputDesc_[columnIndex - 1].dataType_;
        switch (dataType) {
            case 2005: {
                Clob clob = this.getClob(columnIndex);
                if (clob != null) {
                    return clob.getCharacterStream();
                }
                return null;
            }
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                String data = this.getString(columnIndex);
                if (data != null) {
                    return new StringReader(data);
                }
                return null;
            }
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getCharacterStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getCharacterStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getCharacterStream(columnIndex);
    }

    public Clob getClob(int columnIndex) throws SQLException {
        Clob data;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getClob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getClob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        int dataType = this.outputDesc_[columnIndex - 1].dataType_;
        if (dataType != 2005) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        Row row = (Row)this.getCurrentRow();
        Object x = row.getColumnObject(columnIndex);
        if (x == null) {
            this.wasNull_ = true;
            data = null;
        } else {
            this.wasNull_ = false;
            if (x instanceof Clob) {
                data = (Clob)x;
            } else if (x instanceof BigInteger) {
                long data_locator = ((BigInteger)x).longValue();
                String tableName = this.outputDesc_[columnIndex - 1].tableName_;
                data = new SQLMXClob(this.connection_, tableName, data_locator);
                row.setLobObject(columnIndex, data);
                this.isAnyLob_ = true;
            } else if (x instanceof Long) {
                long data_locator = (Long)x;
                String tableName = this.outputDesc_[columnIndex - 1].tableName_;
                data = new SQLMXClob(this.connection_, tableName, data_locator);
                row.setLobObject(columnIndex, data);
                this.isAnyLob_ = true;
            } else {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
            }
        }
        return data;
    }

    public Clob getClob(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getClob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getClob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getClob(columnIndex);
    }

    public int getConcurrency() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getConcurrency", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getConcurrency");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.stmt_ != null) {
            return this.stmt_.resultSetConcurrency_;
        }
        return 1007;
    }

    public String getCursorName() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getCursorName", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getCursorName");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.spj_rs_ && this.stmtLabel_ != null) {
            return this.stmtLabel_;
        }
        if (this.stmt_ != null) {
            String cursorName = this.stmt_.cursorName_;
            if (cursorName == null) {
                cursorName = this.stmt_.stmtLabel_;
            }
            return cursorName;
        }
        return null;
    }

    static String convertDateFormat(String dt) {
        String[] tokens = dt.split("[/]", 3);
        if (tokens.length != 3) {
            return dt;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(tokens[0]).append("-").append(tokens[1]).append("-").append(tokens[2]);
        return sb.toString();
    }

    public Date getDate(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        int dataType = this.outputDesc_[columnIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 91 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        String data = this.getLocalString(columnIndex);
        if (data != null) {
            Date retValue;
            try {
                boolean convertDate = this.connection_.getDateConversion();
                if (this.connection_.props_.t4Logger_.isLoggable(Level.FINEST)) {
                    Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
                    String temp = "Convert Date=" + convertDate;
                    this.connection_.props_.t4Logger_.logp(Level.FINEST, "SQLMXResultSet", "getDate", temp, p);
                }
                if (convertDate) {
                    String dt = SQLMXResultSet.convertDateFormat(data);
                    retValue = SQLMXResultSet.valueOf(dt);
                } else {
                    retValue = Date.valueOf(data);
                }
            }
            catch (IllegalArgumentException e) {
                data = data.trim();
                int endIndex = data.indexOf(32);
                if (endIndex != -1) {
                    data = data.substring(0, endIndex);
                }
                try {
                    retValue = Date.valueOf(data);
                    this.setSQLWarning(null, "data_truncation", null);
                }
                catch (IllegalArgumentException ex) {
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
                }
            }
            return retValue;
        }
        return null;
    }

    static Date valueOf(String s) {
        int year;
        int secondDash;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        int firstDash = s.indexOf(45);
        if (firstDash > 0 & (secondDash = s.indexOf(45, firstDash + 1)) > 0 & secondDash < s.length() - 1) {
            year = Integer.parseInt(s.substring(0, firstDash));
            if (year < 50) {
                year += 100;
            } else if (year >= 100) {
                year -= 1900;
            }
        } else {
            throw new IllegalArgumentException();
        }
        int month = Integer.parseInt(s.substring(firstDash + 1, secondDash)) - 1;
        int day = Integer.parseInt(s.substring(secondDash + 1));
        return new Date(year, month, day);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date sqlDate;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if ((sqlDate = this.getDate(columnIndex)) != null) {
            if (cal != null) {
                Calendar targetCalendar = Calendar.getInstance(cal.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(sqlDate);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(sqlDate);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                sqlDate.setTime(sqlDate.getTime() - timeZoneOffset);
            }
            return sqlDate;
        }
        return sqlDate;
    }

    public Date getDate(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getDate(columnIndex);
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getDate(columnIndex, cal);
    }

    public double getDouble(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getDouble", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getDouble");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        this.outputDesc_[columnIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getLocalString(columnIndex);
        if (data != null) {
            try {
                return Double.parseDouble(data);
            }
            catch (NumberFormatException e1) {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
            }
        }
        return 0.0;
    }

    public double getDouble(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getDouble", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getDouble");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getDouble(columnIndex);
    }

    public int getFetchDirection() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getFetchDirection", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getFetchDirection");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        return this.fetchDirection_;
    }

    public int getFetchSize() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getFetchSize", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getFetchSize");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        return this.fetchSize_;
    }

    public float getFloat(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getFloat", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getFloat");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        this.outputDesc_[columnIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        double data = this.getDouble(columnIndex);
        if (data >= Double.NEGATIVE_INFINITY && data <= Double.POSITIVE_INFINITY) {
            return (float)data;
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "numeric_out_of_range", null);
    }

    public float getFloat(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getFloat", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getFloat");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getFloat(columnIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getInt(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getInt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getInt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        this.outputDesc_[columnIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getLocalString(columnIndex);
        if (data == null) return 0;
        try {
            return Integer.parseInt(data);
        }
        catch (NumberFormatException e) {
            double d;
            try {
                d = new Double(data);
            }
            catch (NumberFormatException e1) {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
            }
            if (!(d > -2.147483649E9)) throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "numeric_out_of_range", null);
            if (!(d < 2.147483648E9)) throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "numeric_out_of_range", null);
            int retValue = (int)d;
            if ((double)retValue == d) return retValue;
            this.setSQLWarning(null, "data_truncation", null);
            return retValue;
        }
    }

    public int getInt(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getInt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getInt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getInt(columnIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLong(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getLong", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getLong");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        this.outputDesc_[columnIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getLocalString(columnIndex);
        if (data == null) return 0L;
        try {
            return Long.parseLong(data);
        }
        catch (NumberFormatException e) {
            long retValue;
            try {
                BigDecimal bd = new BigDecimal(data);
                retValue = bd.longValue();
                if (bd.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0) throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "numeric_out_of_range", null);
                if (bd.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0) throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "numeric_out_of_range", null);
                if (bd.compareTo(BigDecimal.valueOf(retValue)) == 0) return retValue;
                this.setSQLWarning(null, "data_truncation", null);
                return retValue;
            }
            catch (NumberFormatException e2) {
                double d;
                try {
                    d = new Double(data);
                }
                catch (NumberFormatException e1) {
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
                }
                if (!(d >= -9.223372036854776E18)) throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "numeric_out_of_range", null);
                if (!(d <= 9.223372036854776E18)) throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "numeric_out_of_range", null);
                retValue = (long)d;
                if ((double)retValue == d) return retValue;
                this.setSQLWarning(null, "data_truncation", null);
                return retValue;
            }
        }
    }

    public long getLong(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getLong", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getLong");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getLong(columnIndex);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getMetaData", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getMetaData");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        return new SQLMXResultSetMetaData(this, this.outputDesc_);
    }

    public Object getObject(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        int dataType = this.outputDesc_[columnIndex - 1].dataType_;
        short precision = this.outputDesc_[columnIndex - 1].sqlPrecision_;
        switch (dataType) {
            case -6: {
                byte byteValue = this.getByte(columnIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Byte(byteValue);
            }
            case 5: {
                short shortValue = this.getShort(columnIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Short(shortValue);
            }
            case 4: {
                int intValue = this.getInt(columnIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Integer(intValue);
            }
            case -5: {
                long longValue = this.getLong(columnIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Long(longValue);
            }
            case 7: {
                float floatValue = this.getFloat(columnIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Float(floatValue);
            }
            case 6: 
            case 8: {
                double doubleValue = this.getDouble(columnIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Double(doubleValue);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(columnIndex);
            }
            case -7: {
                boolean booleanValue = this.getBoolean(columnIndex);
                if (this.wasNull_) {
                    return null;
                }
                return new Boolean(booleanValue);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.getString(columnIndex);
            }
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
            case -4: {
                return this.getBinaryStream(columnIndex);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                if (precision > 0) {
                    return this.getString(columnIndex);
                }
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case 2004: {
                return this.getBlob(columnIndex);
            }
            case 2005: {
                return this.getClob(columnIndex);
            }
            case 1111: {
                return this.getString(columnIndex);
            }
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
    }

    public Object getObject(int columnIndex, Map map) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "getObject()");
        return null;
    }

    public Object getObject(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getObject(columnIndex);
    }

    public Object getObject(String columnName, Map map) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)map);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)map);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getObject(columnIndex, map);
    }

    public Ref getRef(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getRef", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getRef");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "getRef()");
        return null;
    }

    public Ref getRef(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getRef", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getRef");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getRef(columnIndex);
    }

    public int getRow() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getRow", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getRow");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.isBeforeFirst_ || this.isAfterLast_ || this.onInsertRow_) {
            return 0;
        }
        if (this.getType() == 1003 && this.getConcurrency() == 1008) {
            return this.currentRowCount_;
        }
        return this.currentRow_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short getShort(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getShort", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getShort");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        this.outputDesc_[columnIndex - 1].checkValidNumericConversion(this.connection_.getLocale());
        String data = this.getLocalString(columnIndex);
        if (data == null) return 0;
        try {
            return Short.parseShort(data);
        }
        catch (NumberFormatException e) {
            double d;
            try {
                d = new Double(data);
            }
            catch (NumberFormatException e1) {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
            }
            if (!(d > -32769.0)) throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "numeric_out_of_range", null);
            if (!(d < 32768.0)) throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "numeric_out_of_range", null);
            short retValue = (short)d;
            if ((double)retValue == d) return retValue;
            this.setSQLWarning(null, "data_truncation", null);
            return retValue;
        }
    }

    public short getShort(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getShort", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getShort");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getShort(columnIndex);
    }

    public Statement getStatement() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getStatement", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getStatement");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        return this.stmt_;
    }

    public String getString(int columnIndex) throws SQLException {
        String data;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getString", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        BaseRow currentRow = this.getCurrentRow();
        Object x = currentRow.getColumnObject(columnIndex);
        if (x == null) {
            this.wasNull_ = true;
            return null;
        }
        this.wasNull_ = false;
        int targetSqlType = this.outputDesc_[columnIndex - 1].dataType_;
        short precision = this.outputDesc_[columnIndex - 1].sqlPrecision_;
        block2 : switch (targetSqlType) {
            case 2005: {
                Clob clob = this.getClob(columnIndex);
                return clob.getSubString(1L, (int)clob.length());
            }
            case -1: 
            case 1: 
            case 12: {
                data = this.getLocalString(columnIndex);
                if (this.stmt_ == null || this.stmt_.maxFieldSize_ == 0 || data.length() <= this.stmt_.maxFieldSize_) break;
                data = data.substring(0, this.stmt_.maxFieldSize_);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                data = String.valueOf(this.getBytes(columnIndex));
                break;
            }
            case 93: {
                Timestamp t = this.getTimestamp(columnIndex);
                data = "" + t.getNanos();
                int l = data.length();
                data = t.toString();
                if (precision > 0) {
                    for (int i = 0; i < precision - l; ++i) {
                        data = data + '0';
                    }
                    break;
                }
                data = data.substring(0, data.lastIndexOf(46));
                break;
            }
            case 92: {
                if (precision > 0) {
                    data = x.toString();
                    break;
                }
                data = String.valueOf(this.getTime(columnIndex));
                break;
            }
            case 91: {
                data = String.valueOf(this.getDate(columnIndex));
                break;
            }
            case 16: {
                data = String.valueOf(this.getBoolean(columnIndex));
                break;
            }
            case 5: {
                data = String.valueOf(this.getShort(columnIndex));
                break;
            }
            case -6: {
                data = String.valueOf(this.getByte(columnIndex));
                break;
            }
            case 7: {
                data = String.valueOf(this.getFloat(columnIndex));
                break;
            }
            case 6: 
            case 8: {
                data = String.valueOf(this.getDouble(columnIndex));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bd = this.getBigDecimal(columnIndex);
                if ((double)this._javaVersion >= 1.5) {
                    try {
                        data = (String)this._toPlainString.invoke((Object)bd, (Object[])null);
                    }
                    catch (Exception e) {
                        data = bd.toString();
                    }
                    break;
                }
                data = bd.toString();
                break;
            }
            case -5: {
                data = String.valueOf(this.getLong(columnIndex));
                break;
            }
            case 4: {
                data = String.valueOf(this.getInt(columnIndex));
                break;
            }
            case 1111: {
                if (x instanceof byte[]) {
                    try {
                        data = new String((byte[])x, "ASCII");
                    }
                    catch (Exception e) {
                        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "unsupported_encoding", "ASCII");
                    }
                } else {
                    data = x.toString();
                }
                switch (this.outputDesc_[columnIndex - 1].fsDataType_) {
                    case 10: {
                        if (data.startsWith(hyphen_string)) break block2;
                        data = data.substring(1);
                        break block2;
                    }
                    case 9: {
                        switch (this.outputDesc_[columnIndex - 1].sqlDatetimeCode_) {
                            case 2: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 17: 
                            case 18: 
                            case 19: 
                            case 20: 
                            case 22: 
                            case 23: 
                            case 24: {
                                break block2;
                            }
                        }
                        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "object_type_not_supported", null);
                    }
                    default: {
                        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "object_type_not_supported", null);
                    }
                }
            }
            default: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "object_type_not_supported", null);
            }
        }
        return data;
    }

    public String getString(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getString", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getString(columnIndex);
    }

    public Time getTime(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        int dataType = this.outputDesc_[columnIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 92 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        String data = this.getLocalString(columnIndex);
        if (data != null) {
            Time retValue;
            switch (dataType) {
                case 93: {
                    Timestamp timestamp;
                    try {
                        timestamp = Timestamp.valueOf(data);
                        retValue = new Time(timestamp.getTime());
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
                    }
                }
                case -1: 
                case 1: 
                case 12: {
                    data = data.trim();
                }
                case 92: {
                    Timestamp timestamp;
                    try {
                        retValue = Time.valueOf(data);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            timestamp = Timestamp.valueOf(data);
                            retValue = new Time(timestamp.getTime());
                            break;
                        }
                        catch (IllegalArgumentException ex) {
                            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
                        }
                    }
                }
                default: {
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
                }
            }
            return retValue;
        }
        return null;
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time sqlTime;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if ((sqlTime = this.getTime(columnIndex)) != null) {
            if (cal != null) {
                Calendar targetCalendar = Calendar.getInstance(cal.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(sqlTime);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(sqlTime);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                sqlTime.setTime(sqlTime.getTime() - timeZoneOffset);
            }
            return sqlTime;
        }
        return sqlTime;
    }

    public Time getTime(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getTime(columnIndex);
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getTime(columnIndex, cal);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        int dataType = this.outputDesc_[columnIndex - 1].dataType_;
        if (dataType != 1 && dataType != 12 && dataType != -1 && dataType != 91 && dataType != 92 && dataType != 93) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
        }
        String data = this.getLocalString(columnIndex);
        if (data != null) {
            Timestamp retValue;
            switch (dataType) {
                case 91: {
                    Date dateValue;
                    try {
                        dateValue = Date.valueOf(data);
                        retValue = new Timestamp(dateValue.getTime());
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
                    }
                }
                case -1: 
                case 1: 
                case 12: {
                    data = data.trim();
                }
                case 92: 
                case 93: {
                    Date dateValue;
                    try {
                        retValue = Timestamp.valueOf(data);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            dateValue = Date.valueOf(data);
                            retValue = new Timestamp(dateValue.getTime());
                            break;
                        }
                        catch (IllegalArgumentException e1) {
                            try {
                                int nano = 0;
                                if (this.outputDesc_[columnIndex - 1].sqlPrecision_ > 0) {
                                    nano = Integer.parseInt(data.substring(data.indexOf(".") + 1));
                                    nano = (int)((double)nano * Math.pow(10.0, 9 - this.outputDesc_[columnIndex - 1].sqlPrecision_));
                                    data = data.substring(0, data.indexOf("."));
                                }
                                Time timeValue = Time.valueOf(data);
                                retValue = new Timestamp(timeValue.getTime());
                                retValue.setNanos(nano);
                                break;
                            }
                            catch (IllegalArgumentException e2) {
                                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cast_specification", null);
                            }
                        }
                    }
                }
                default: {
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "restricted_data_type", null);
                }
            }
            return retValue;
        }
        return null;
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp sqlTimestamp;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if ((sqlTimestamp = this.getTimestamp(columnIndex)) != null) {
            if (cal != null) {
                int nano = sqlTimestamp.getNanos();
                Calendar targetCalendar = Calendar.getInstance(cal.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(sqlTimestamp);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(sqlTimestamp);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                sqlTimestamp.setTime(sqlTimestamp.getTime() - timeZoneOffset);
                sqlTimestamp.setNanos(nano);
            }
            return sqlTimestamp;
        }
        return sqlTimestamp;
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getTimestamp(columnIndex);
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)cal);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)cal);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getTimestamp(columnIndex, cal);
    }

    public int getType() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getType", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getType");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.stmt_ != null) {
            return this.stmt_.resultSetType_;
        }
        return 1003;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getUnicodeStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getUnicodeStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        String data = this.getLocalString(columnIndex);
        if (data != null) {
            try {
                return new ByteArrayInputStream(data.getBytes(InterfaceUtilities.getCharsetName(11)));
            }
            catch (UnsupportedEncodingException e) {
                Object[] messageArguments = new Object[]{e.getMessage()};
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "unsupported_encoding", messageArguments);
            }
        }
        return null;
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getUnicodeStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getUnicodeStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getUnicodeStream(columnIndex);
    }

    public URL getURL(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getURL", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getURL");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateGetInvocation(columnIndex);
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "getURL()");
        return null;
    }

    public URL getURL(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getURL", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getURL");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateGetInvocation(columnName);
        return this.getURL(columnIndex);
    }

    public byte[] getRawBytes(int columnIndex) throws SQLException {
        byte[] ret;
        if (!this.keepRawBuffer_) {
            SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "getRawBytes()");
        }
        this.validateGetInvocation(columnIndex);
        SQLMXDesc desc = this.outputDesc_[columnIndex - 1];
        int rowOffset = (this.currentRow_ - 1) * desc.rowLength_;
        if (desc.nullValue_ != -1 && Bytes.extractShort(this.rawBuffer_, desc.nullValue_ + rowOffset, this.stmt_.connection_.ic_.getByteSwap()) == -1) {
            ret = null;
        } else {
            int maxLen = desc.sqlDataType_ != -601 ? desc.maxLen_ : desc.maxLen_ + 2;
            ret = new byte[maxLen];
            System.arraycopy(this.rawBuffer_, desc.noNullValue_ + rowOffset, ret, 0, maxLen);
        }
        return ret;
    }

    public byte[] getNextFetchBuffer() throws SQLException {
        boolean done = false;
        byte[] retValue = null;
        this.keepRawBuffer_ = true;
        while (!this.fetchComplete_ && !done) {
            done = this.next();
        }
        this.fetchComplete_ = false;
        retValue = !done ? null : this.rawBuffer_;
        return retValue;
    }

    public void insertRow() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "insertRow", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("insertRow");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getConcurrency() == 1007) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "read_only_concur", null);
        }
        if (!this.onInsertRow_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_position", null);
        }
        this.prepareInsertStmt();
        InsertRow insertRow = (InsertRow)this.getCurrentRow();
        insertRow.insertRow(this.insertStmt_, this.paramCols_);
        Row row = new Row(this.outputDesc_.length, insertRow.getOrigRow());
        row.setInserted();
        int i = this.isBeforeFirst_ || this.isAfterLast_ ? this.currentRow_ : this.currentRow_ - 1;
        this.cachedRows_.add(i, row);
        ++this.numRows_;
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
    }

    public boolean isAfterLast() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "isAfterLast", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("isAfterLast");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        return this.isAfterLast_;
    }

    public boolean isBeforeFirst() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "isBeforeFirst", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("isBeforeFirst");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        return this.isBeforeFirst_;
    }

    public boolean isFirst() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "isFirst", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("isFirst");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getType() == 1003 && this.getConcurrency() == 1008) {
            return !this.onInsertRow_ && this.currentRowCount_ == 1;
        }
        return !this.onInsertRow_ && this.currentRow_ == 1;
    }

    public boolean isLast() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "isLast", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("isLast");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (!this.onInsertRow_ && this.endOfData_) {
            if (this.currentRow_ == this.numRows_) {
                return !this.isAfterLast_;
            }
            return false;
        }
        boolean found = this.next();
        if (found) {
            --this.currentRow_;
        } else {
            this.isAfterLast_ = false;
        }
        return !found;
    }

    public boolean last() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "last", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("last");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getType() == 1003) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "forward_only_cursor", null);
        }
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
        this.onInsertRow_ = false;
        if (this.endOfData_) {
            this.currentRow_ = this.numRows_;
            this.isBeforeFirst_ = false;
            this.isAfterLast_ = false;
        } else {
            while (this.next()) {
            }
        }
        if (this.currentRow_ != 0) {
            this.isAfterLast_ = false;
            return true;
        }
        return false;
    }

    public void moveToCurrentRow() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "moveToCurrentRow", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("moveToCurrentRow");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (!this.onInsertRow_) {
            return;
        }
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
        this.currentRow_ = this.savedCurrentRow_;
        this.onInsertRow_ = false;
    }

    public void moveToInsertRow() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "moveToInsertRow", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("moveToInsertRow");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getConcurrency() == 1007) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "read_only_concur", null);
        }
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
        if (this.insertRow_ == null && this.outputDesc_.length > 0) {
            this.insertRow_ = new InsertRow(this.outputDesc_.length);
        }
        if (this.insertRow_ != null) {
            this.onInsertRow_ = true;
            this.savedCurrentRow_ = this.currentRow_;
            this.insertRow_.initInsertRow();
        }
    }

    public boolean next() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "next", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("next");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        boolean validRow = false;
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
        this.onInsertRow_ = false;
        if (this.currentRow_ < this.numRows_) {
            validRow = true;
            ++this.currentRow_;
            this.isBeforeFirst_ = false;
        } else if (this.endOfData_) {
            this.isAfterLast_ = true;
            this.isBeforeFirst_ = false;
        } else {
            int queryTimeout;
            int maxRows;
            if (this.stmt_ != null) {
                maxRows = this.stmt_.maxRows_;
                queryTimeout = this.stmt_.queryTimeout_;
            } else {
                maxRows = 0;
                queryTimeout = 0;
            }
            int maxRowCnt = maxRows == 0 || maxRows > this.totalRowsFetched_ + this.fetchSize_ ? this.fetchSize_ : maxRows - this.totalRowsFetched_;
            if (maxRowCnt == 0) {
                validRow = false;
            } else {
                try {
                    try {
                        validRow = this.irs_.fetch(this.stmtLabel_, maxRowCnt, queryTimeout, this.holdability_, this);
                        this.fetchComplete_ = true;
                    }
                    catch (SQLException e) {
                        if (this.connection_.props_.getCloseConnectionUponQueryTimeout().equals("ON") && e.getCause() instanceof SocketTimeoutException) {
                            if (e.getCause().getMessage().equals("Read timed out")) {
                                CancelReply cr_ = null;
                                cr_ = SQLMX_AssociationServer_Cancel.cancel(this.connection_.props_, this.connection_.ic_, this.connection_.ic_.getDialogueId(), 2, this.connection_.ic_.mxcsAddr_.m_url + "", 0);
                                SQLMXException ex = SQLMXMessages.createSQLException(this.connection_.ic_.t4props_, this.connection_.ic_.getLocale(), "AS_API_STOPSRVR", null);
                                this.connection_.ic_.setIsClosed(true);
                                ex.initCause(e.getCause());
                                throw ex;
                            }
                            throw e;
                        }
                        throw e;
                    }
                }
                catch (SQLException e) {
                    this.performConnectionErrorChecks(e);
                    throw e;
                }
            }
            if (validRow) {
                ++this.currentRow_;
                this.isAfterLast_ = false;
                this.isBeforeFirst_ = false;
            } else {
                this.endOfData_ = true;
                this.isAfterLast_ = true;
                this.isBeforeFirst_ = false;
            }
        }
        this.currentRowCount_ = validRow ? ++this.currentRowCount_ : 0;
        return validRow;
    }

    public boolean previous() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "previous", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("previous");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        boolean validRow = false;
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getType() == 1003) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "forward_only_cursor", null);
        }
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
        this.onInsertRow_ = false;
        if (this.currentRow_ > 1) {
            this.currentRow_ = this.isAfterLast_ ? this.currentRow_ : (this.currentRow_ = this.currentRow_ - 1);
            validRow = true;
            this.isBeforeFirst_ = false;
            this.isAfterLast_ = false;
        } else {
            this.currentRow_ = 0;
            this.isBeforeFirst_ = true;
            this.isAfterLast_ = false;
        }
        return validRow;
    }

    public void refreshRow() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "refreshRow", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("refreshRow");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.onInsertRow_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_operation", null);
        }
        this.prepareSelectStmt();
        Row row = (Row)this.getCurrentRow();
        try {
            row.refreshRow(this.connection_.getLocale(), this.selectStmt_, this.paramCols_, this.keyCols_);
        }
        catch (SQLException e) {
            this.performConnectionErrorChecks(e);
            throw e;
        }
    }

    public boolean relative(int row) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, row);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "relative", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, row);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("relative");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        boolean flag = false;
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.getType() == 1003) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "forward_only_cursor", null);
        }
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
        this.onInsertRow_ = false;
        if (row > 0) {
            int rowInc = 0;
            while ((flag = this.next()) && ++rowInc < row) {
            }
        } else {
            int absRow = -row;
            if (absRow < this.currentRow_) {
                this.currentRow_ -= absRow;
                this.isAfterLast_ = false;
                this.isBeforeFirst_ = false;
                flag = true;
            } else {
                this.beforeFirst();
            }
        }
        return flag;
    }

    public boolean rowDeleted() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "rowDeleted", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("rowDeleted");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.onInsertRow_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_operation", null);
        }
        BaseRow row = this.getCurrentRow();
        if (row instanceof Row) {
            return ((Row)row).getDeleted();
        }
        return false;
    }

    public boolean rowInserted() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "rowInserted", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("rowInserted");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.onInsertRow_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_operation", null);
        }
        BaseRow row = this.getCurrentRow();
        if (row instanceof Row) {
            return ((Row)row).getInserted();
        }
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "rowUpdated", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("rowUpdated");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (this.onInsertRow_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_operation", null);
        }
        BaseRow row = this.getCurrentRow();
        if (row instanceof Row) {
            return ((Row)row).getUpdated();
        }
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, direction);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "setFetchDirection", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, direction);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("setFetchDirection");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        switch (direction) {
            case 1000: {
                this.fetchDirection_ = direction;
                break;
            }
            case 1001: 
            case 1002: {
                this.fetchDirection_ = 1000;
                break;
            }
            default: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_fetch_direction", null);
            }
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, rows);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "setFetchSize", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, rows);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("setFetchSize");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (rows < 0) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_fetch_size", null);
        }
        this.fetchSize_ = rows == 0 ? 1 : rows;
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateArray", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateArray");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "updateArray()");
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateArray", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateArray");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateArray(columnIndex, x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateAsciiStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateAsciiStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        byte[] value = new byte[length];
        try {
            int k = 0;
            int bytesRead = 0;
            while (bytesRead != -1 && (k += (bytesRead = x.read(value, k, length - k)) > 0 ? bytesRead : 0) < length) {
            }
        }
        catch (IOException e) {
            Object[] messageArguments = new Object[]{e.getMessage()};
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "io_exception", messageArguments);
        }
        try {
            this.getCurrentRow().setColumnObject(columnIndex, new String(value, "ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            Object[] messageArguments = new Object[]{e.getMessage()};
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "unsupported_encoding", messageArguments);
        }
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateAsciiStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateAsciiStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateAsciiStream(columnIndex, x, length);
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateBigDecimal", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateBigDecimal");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateBigDecimal(columnIndex, x);
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateBinaryStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateBinaryStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        byte[] value = new byte[length];
        try {
            int k = 0;
            int bytesRead = 0;
            while (bytesRead != -1 && (k += (bytesRead = x.read(value, k, length - k)) > 0 ? bytesRead : 0) < length) {
            }
        }
        catch (IOException e) {
            Object[] messageArguments = new Object[]{e.getMessage()};
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "io_exception", messageArguments);
        }
        this.getCurrentRow().setColumnObject(columnIndex, value);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateBinaryStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateBinaryStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateBinaryStream(columnIndex, x, length);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateBlob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateBlob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateBlob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateBlob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateBlob(columnIndex, x);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateBoolean", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateBoolean");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, new Boolean(x));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateBoolean", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateBoolean");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateBoolean(columnIndex, x);
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (int)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateByte", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (int)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateByte");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, new Byte(x));
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateByte", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateByte");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateByte(columnIndex, x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateBytes", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateBytes");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateBytes", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateBytes");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateBytes(columnIndex, x);
    }

    public void updateCharacterStream(int columnIndex, Reader reader, int length) throws SQLException {
        Object[] messageArguments;
        Object temp;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)reader, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateCharacterStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)reader, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateCharacterStream");
            T4LogFormatter lf = new T4LogFormatter();
            temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println((String)temp);
        }
        this.validateUpdInvocation(columnIndex);
        char[] value = new char[length];
        try {
            int valuePos;
            if (valuePos < 1) {
                messageArguments = new Object[]{"No data to read from the Reader"};
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "io_exception", messageArguments);
            }
            int tempReadLen = 0;
            for (valuePos = reader.read(value); valuePos < length && tempReadLen != -1; valuePos += tempReadLen > 0 ? tempReadLen : 0) {
                temp = new char[length - valuePos];
                tempReadLen = reader.read((char[])temp, 0, length - valuePos);
                System.arraycopy(temp, 0, value, valuePos, tempReadLen);
            }
        }
        catch (IOException e) {
            messageArguments = new Object[]{e.getMessage()};
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "io_exception", messageArguments);
        }
        this.getCurrentRow().setColumnObject(columnIndex, new String(value));
    }

    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x, length);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateCharacterStream", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x, length);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateCharacterStream");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateCharacterStream(columnIndex, x, length);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateClob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateClob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateClob", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateClob");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateClob(columnIndex, x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateDate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateDate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateDate(columnIndex, x);
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateDouble", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateDouble");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, new Double(x));
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateDouble", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateDouble");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateDouble(columnIndex, x);
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (double)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateFloat", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (double)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateFloat");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, new Float(x));
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (double)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateFloat", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (double)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateFloat");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateDouble(columnIndex, (double)x);
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateInt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateInt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, new Integer(x));
    }

    public void updateInt(String columnName, int x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateInt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateInt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateDouble(columnIndex, (double)x);
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (double)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateLong", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (double)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateLong");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, new Long(x));
    }

    public void updateLong(String columnName, long x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateLong", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateLong");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateLong(columnIndex, x);
    }

    public void updateNull(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateNull", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateNull");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, null);
    }

    public void updateNull(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateNull", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateNull");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateNull(columnIndex);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.updateObject(columnIndex, x, 0);
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, x, scale);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, x, scale);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateObject(columnIndex, x);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x, scale);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateObject", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x, scale);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateObject");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateObject(columnIndex, x, scale);
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateRef", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateRef");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "updateRef()");
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateRef", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateRef");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateRef(columnIndex, x);
    }

    public void updateRow() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateRow", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateRow");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.clearWarnings();
        if (this.getConcurrency() == 1007) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "read_only_concur", null);
        }
        if (this.onInsertRow_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_position", null);
        }
        if (this.connection_.getAutoCommit()) {
            this.setSQLWarning(this.connection_.props_, "resultSet_updateRow_with_autocommit", null);
        }
        this.prepareUpdateStmt();
        Row row = (Row)this.getCurrentRow();
        row.updateRow(this.connection_.getLocale(), this.updateStmt_, this.paramCols_, this.keyCols_);
        if (this.isAnyLob_) {
            this.closeLobObjects();
        }
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (int)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateShort", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (int)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateShort");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, new Short(x));
    }

    public void updateShort(String columnName, short x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateShort", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateShort");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateShort(columnIndex, x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateString", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateString", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateString(columnIndex, x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateTime", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateTime");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateTime(columnIndex, x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateUpdInvocation(columnIndex);
        this.getCurrentRow().setColumnObject(columnIndex, x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "updateTimestamp", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)columnName, (Object)x);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("updateTimestamp");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int columnIndex = this.validateUpdInvocation(columnName);
        this.updateTimestamp(columnIndex, x);
    }

    public boolean wasNull() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "wasNull", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("wasNull");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        return this.wasNull_;
    }

    void setColumnName(int columnIndex, String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "setColumnName", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex, (Object)columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("setColumnName");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (columnIndex < 1 || columnIndex > this.outputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_index", null);
        }
        this.outputDesc_[columnIndex - 1].name_ = columnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void close(boolean dropStmt) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, dropStmt);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "close", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, dropStmt);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("close");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) return;
        this.clearWarnings();
        try {
            this.irs_.close();
            this.isClosed_ = true;
            this.irs_ = null;
            if (this.stmt_ == null || !dropStmt) return;
        }
        catch (Throwable throwable) {
            this.isClosed_ = true;
            this.irs_ = null;
            if (this.stmt_ == null || !dropStmt) throw throwable;
            for (int i = 0; i < this.stmt_.num_result_sets_; ++i) {
                this.stmt_.resultSet_[i] = null;
            }
            this.stmt_.result_set_offset = 0;
            throw throwable;
        }
        for (int i = 0; i < this.stmt_.num_result_sets_; ++i) {
            this.stmt_.resultSet_[i] = null;
        }
        this.stmt_.result_set_offset = 0;
        return;
    }

    private int validateGetInvocation(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "validateGetInvocation", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("validateGetInvocation");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        for (int i = 0; i < this.outputDesc_.length; ++i) {
            if (!columnName.equalsIgnoreCase(this.outputDesc_[i].name_)) continue;
            return i + 1;
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_name", null);
    }

    private void validateGetInvocation(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "validateGetInvocation", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("validateGetInvocation");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_cursor_state", null);
        }
        if (columnIndex < 1 || columnIndex > this.outputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_index", null);
        }
    }

    public Connection getConnection() {
        return this.connection_;
    }

    private int validateUpdInvocation(String columnName) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "validateUpdInvocation", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnName);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("validateUpdInvocation");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.getConcurrency() == 1007) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "read_only_concur", null);
        }
        for (int i = 0; i < this.outputDesc_.length; ++i) {
            if (!columnName.equalsIgnoreCase(this.outputDesc_[i].name_)) continue;
            return i + 1;
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_name", null);
    }

    private void validateUpdInvocation(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "validateUpdInvocation", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("validateUpdInvocation");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.getConcurrency() == 1007) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "read_only_concur", null);
        }
        if (columnIndex < 1 || columnIndex > this.outputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_index", null);
        }
    }

    private BaseRow getCurrentRow() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getCurrentRow", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getCurrentRow");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.onInsertRow_) {
            return this.insertRow_;
        }
        if (this.isBeforeFirst_ || this.isAfterLast_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_row", null);
        }
        return (BaseRow)this.cachedRows_.get(this.currentRow_ - 1);
    }

    private int getRowCount() {
        return this.numRows_;
    }

    void getKeyColumns() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getKeyColumns", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getKeyColumns");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        int index = 0;
        int rowCount = 0;
        ArrayList<String> keyColumns = null;
        if (this.noKeyFound_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "no_primary_key", null);
        }
        try {
            String columnName;
            int colNo;
            DatabaseMetaData dbmd = this.connection_.getMetaData();
            ResultSetMetaData rsmd = this.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String keyCatalogNm = rsmd.getCatalogName(1);
            String keySchemaNm = rsmd.getSchemaName(1);
            String keyTableNm = rsmd.getTableName(1);
            if (this.stmt_ instanceof SQLMXPreparedStatement) {
                keyColumns = ((SQLMXPreparedStatement)this.stmt_).getKeyColumns();
            }
            if (keyColumns == null) {
                ResultSet rs = dbmd.getPrimaryKeys(keyCatalogNm, keySchemaNm, keyTableNm);
                keyColumns = new ArrayList<String>();
                while (rs.next()) {
                    ++rowCount;
                    String colName = rs.getString(4);
                    keyColumns.add(index++, colName);
                }
                rowCount = ((SQLMXResultSet)rs).getRowCount();
                if (rowCount == 0) {
                    this.noKeyFound_ = true;
                    this.stmt_.resultSetConcurrency_ = 1007;
                    throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "no_primary_key", null);
                }
                if (this.stmt_ instanceof SQLMXPreparedStatement) {
                    ((SQLMXPreparedStatement)this.stmt_).setKeyColumns(keyColumns);
                }
            }
            this.keyCols_ = new BitSet(columnCount);
            for (index = 0; index < keyColumns.size(); ++index) {
                int colNo2;
                for (colNo2 = 1; colNo2 <= columnCount; ++colNo2) {
                    if (!rsmd.getColumnName(colNo2).equals((String)keyColumns.get(index)) || !rsmd.getTableName(colNo2).equals(keyTableNm) || !rsmd.getSchemaName(colNo2).equals(keySchemaNm) || !rsmd.getCatalogName(colNo2).equals(keyCatalogNm)) continue;
                    this.keyCols_.set(colNo2 - 1);
                    break;
                }
                if (colNo2 <= columnCount) continue;
                this.noKeyFound_ = true;
                this.stmt_.resultSetConcurrency_ = 1007;
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "no_primary_key", null);
            }
            this.paramCols_ = new BitSet(columnCount);
            StringBuffer whereClause = new StringBuffer(2048).append(" where ");
            StringBuffer deleteWhereClause = new StringBuffer(2048).append(" where ");
            StringBuffer insertColsStr = new StringBuffer(2048).append("(");
            StringBuffer insertValueStr = new StringBuffer(2048).append(" values (");
            StringBuffer updateStr = new StringBuffer(2048).append(" set ");
            StringBuffer selectWhereClause = new StringBuffer(2048).append(" where ");
            StringBuffer selectClause = new StringBuffer(2048).append("select ");
            for (colNo = 1; colNo < columnCount; ++colNo) {
                if (!rsmd.getTableName(colNo).equals(keyTableNm) || !rsmd.getSchemaName(colNo).equals(keySchemaNm) || !rsmd.getCatalogName(colNo).equals(keyCatalogNm)) continue;
                this.paramCols_.set(colNo - 1);
                columnName = rsmd.getColumnName(colNo);
                insertColsStr = insertColsStr.append(columnName).append(", ");
                insertValueStr = insertValueStr.append("?, ");
                if (!this.keyCols_.get(colNo - 1)) {
                    updateStr = updateStr.append(columnName).append(" = ?, ");
                } else {
                    selectWhereClause = selectWhereClause.append(columnName).append(" = ? and ");
                    whereClause = whereClause.append(columnName).append(" = ? and ");
                }
                deleteWhereClause = deleteWhereClause.append(columnName).append(" = ? and ");
                selectClause = selectClause.append(columnName).append(", ");
            }
            this.paramCols_.set(colNo - 1);
            columnName = rsmd.getColumnName(colNo);
            insertColsStr = insertColsStr.append(columnName).append(")");
            insertValueStr = insertValueStr.append("?)");
            if (!this.keyCols_.get(colNo - 1)) {
                updateStr = updateStr.append(columnName).append(" = ? ");
                int selectWhereClause_len = selectWhereClause.length();
                selectWhereClause.delete(selectWhereClause_len - 5, selectWhereClause_len);
                int whereClause_len = whereClause.length();
                whereClause.delete(whereClause_len - 5, whereClause_len);
            } else {
                updateStr.setCharAt(updateStr.length() - 2, ' ');
                selectWhereClause = selectWhereClause.append(columnName).append(" = ? ");
                whereClause = whereClause.append(columnName).append(" = ? ");
            }
            deleteWhereClause = deleteWhereClause.append(columnName).append(" = ? ");
            selectClause = selectClause.append(columnName).append(" from ");
            this.selectCmd_ = new StringBuffer(2048).append(selectClause).append(keyCatalogNm).append(".").append(keySchemaNm).append(".").append(keyTableNm).append(selectWhereClause);
            this.deleteCmd_ = new StringBuffer(2048).append("delete from ").append(keyCatalogNm).append(".").append(keySchemaNm).append(".").append(keyTableNm).append(deleteWhereClause);
            this.insertCmd_ = new StringBuffer(2048).append("insert into ").append(keyCatalogNm).append(".").append(keySchemaNm).append(".").append(keyTableNm).append(insertColsStr).append(insertValueStr);
            this.updateCmd_ = new StringBuffer(2048).append("update ").append(keyCatalogNm).append(".").append(keySchemaNm).append(".").append(keyTableNm).append(updateStr).append(whereClause);
        }
        catch (SQLException e) {
            this.performConnectionErrorChecks(e);
            throw e;
        }
    }

    void prepareDeleteStmt() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "prepareDeleteStmt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("prepareDeleteStmt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.deleteStmt_ == null) {
            if (this.deleteCmd_ == null) {
                this.getKeyColumns();
            }
            this.deleteStmt_ = this.connection_.prepareStatement(this.deleteCmd_.toString());
        }
    }

    void prepareInsertStmt() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "prepareInsertStmt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("prepareInsertStmt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.insertStmt_ == null) {
            if (this.insertCmd_ == null) {
                this.getKeyColumns();
            }
            this.insertStmt_ = this.connection_.prepareStatement(this.insertCmd_.toString());
        }
    }

    void prepareUpdateStmt() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "prepareUpdateStmt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("prepareUpdateStmt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.updateStmt_ == null) {
            if (this.updateCmd_ == null) {
                this.getKeyColumns();
            }
            this.updateStmt_ = this.connection_.prepareStatement(this.updateCmd_.toString());
        }
    }

    void prepareSelectStmt() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "prepareSelectStmt", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("prepareSelectStmt");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.selectStmt_ == null) {
            if (this.selectCmd_ == null) {
                this.getKeyColumns();
            }
            this.selectStmt_ = this.connection_.prepareStatement(this.selectCmd_.toString());
        }
    }

    void closeLobObjects() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "closeLobObjects", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("closeLobObjects");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        try {
            ((Row)this.getCurrentRow()).closeLobObjects();
            this.isAnyLob_ = false;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void setFetchOutputs(Row[] row, int rowsFetched, boolean endOfData) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)row, rowsFetched, endOfData, 0);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "setFetchOutputs", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)row, rowsFetched, endOfData, 0);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("setFetchOutputs");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.getType() == 1003) {
            this.cachedRows_.clear();
            this.numRows_ = 0;
            this.currentRow_ = 0;
        }
        for (int i = 0; i < row.length; ++i) {
            this.cachedRows_.add(row[i]);
        }
        this.totalRowsFetched_ += rowsFetched;
        this.numRows_ += rowsFetched;
        this.endOfData_ = endOfData;
        this.isBeforeFirst_ = false;
    }

    void setDataTruncation(int index, boolean parameter, boolean read, int dataSize, int transferSize) {
        DataTruncation dtLeaf = new DataTruncation(index, parameter, read, dataSize, transferSize);
        if (this.sqlWarning_ == null) {
            this.sqlWarning_ = dtLeaf;
        } else {
            this.sqlWarning_.setNextWarning(dtLeaf);
        }
    }

    int getFSDataType(int ColumnCount) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getFSDataType", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getFSDataType");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (ColumnCount >= this.outputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_index", null);
        }
        return this.outputDesc_[ColumnCount].fsDataType_;
    }

    int getSQLDataType(int ColumnCount) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getSQLDataType", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getSQLDataType");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (ColumnCount >= this.outputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_index", null);
        }
        return this.outputDesc_[ColumnCount].sqlDataType_;
    }

    int getPrecision(int ColumnCount) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getPrecision", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getPrecision");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (ColumnCount >= this.outputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_index", null);
        }
        return this.outputDesc_[ColumnCount].precision_;
    }

    int getScale(int ColumnCount) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getScale", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getScale");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (ColumnCount >= this.outputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_index", null);
        }
        return this.outputDesc_[ColumnCount].scale_;
    }

    int getSqlDatetimeCode(int ColumnCount) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getSqlDatetimeCode", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getSqlDatetimeCode");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (ColumnCount >= this.outputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_index", null);
        }
        return this.outputDesc_[ColumnCount].sqlDatetimeCode_;
    }

    int getNoOfColumns() {
        return this.outputDesc_.length;
    }

    int getSqlOctetLength(int ColumnCount) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getSqlOctetLength", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getSqlOctetLength");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (ColumnCount >= this.outputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_index", null);
        }
        return this.outputDesc_[ColumnCount].sqlOctetLength_;
    }

    boolean getSigned(int ColumnCount) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getSigned", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, ColumnCount);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getSigned");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (ColumnCount >= this.outputDesc_.length) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_column_index", null);
        }
        return this.outputDesc_[ColumnCount].isSigned_;
    }

    private String getLocalString(int columnIndex) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "getLocalString", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, columnIndex);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("getLocalString");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        Object obj = null;
        String data = null;
        int sqlCharset = this.outputDesc_[columnIndex - 1].sqlCharset_;
        this.wasNull_ = true;
        BaseRow row = this.getCurrentRow();
        if (row != null && (obj = row.getColumnObject(columnIndex)) != null) {
            if (obj instanceof byte[]) {
                try {
                    if (this.irs_.ic_.getISOMapping() == 1 && !this.irs_.ic_.getEnforceISO() && sqlCharset == 1) {
                        data = new String((byte[])obj, this.irs_.ic_.t4props_.getISO88591());
                    } else if (sqlCharset == -1 || sqlCharset == -2 || sqlCharset == 11) {
                        String charSet = InterfaceUtilities.getEncodingTranslation(this.connection_, sqlCharset);
                        data = new String((byte[])obj, charSet);
                    } else {
                        data = this.irs_.ic_.decodeBytes((byte[])obj, sqlCharset);
                    }
                    this.wasNull_ = false;
                }
                catch (CharacterCodingException e) {
                    SQLMXException se = SQLMXMessages.createSQLException(this.connection_.ic_.t4props_, this.connection_.getLocale(), "translation_of_parameter_failed", "getLocalString", e.getMessage());
                    se.initCause(e);
                    throw se;
                }
                catch (UnsupportedCharsetException e) {
                    SQLMXException se = SQLMXMessages.createSQLException(this.connection_.ic_.t4props_, this.connection_.getLocale(), "unsupported_encoding", e.getCharsetName());
                    se.initCause(e);
                    throw se;
                }
                catch (UnsupportedEncodingException e) {
                    SQLMXException se = SQLMXMessages.createSQLException(this.connection_.ic_.t4props_, this.connection_.getLocale(), "unsupported_encoding", e.getMessage());
                    se.initCause(e);
                    throw se;
                }
            } else {
                data = obj.toString();
                this.wasNull_ = false;
            }
        }
        return data;
    }

    public String getProxySyntax() {
        return this.proxySyntax_;
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed_ || this.connection_.isClosed();
    }

    public boolean hasLOBColumns() {
        boolean ret = false;
        for (int i = 0; i < this.outputDesc_.length; ++i) {
            if (this.outputDesc_[i].dataType_ != 2005 && this.outputDesc_[i].dataType_ != 2004) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public long getSequenceNumber() {
        return this.seqNum_;
    }

    public boolean useOldDateFormat() {
        return this.useOldDateFormat_;
    }

    void closeErroredConnection(SQLMXException sme) {
        this.connection_.closeErroredConnection(sme);
    }

    SQLMXResultSet(SQLMXStatement stmt, SQLMXDesc[] outputDesc) throws SQLException {
        this(stmt, outputDesc, stmt.stmtLabel_, false);
    }

    SQLMXResultSet(SQLMXStatement stmt, SQLMXDesc[] outputDesc, String stmt_label, boolean spj_result_set) throws SQLException {
        if (stmt.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(stmt.connection_.props_, (Object)stmt, (Object)outputDesc, (Object)stmt_label, spj_result_set);
            stmt.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "", "", p);
        }
        if (stmt.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(stmt.connection_.props_, (Object)stmt, (Object)outputDesc, (Object)stmt_label, spj_result_set);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            stmt.connection_.props_.getLogWriter().println(temp);
        }
        this.stmt_ = stmt;
        this.outputDesc_ = outputDesc;
        this.connection_ = stmt.connection_;
        this.keepRawBuffer_ = this.connection_.props_.getKeepRawFetchBuffer();
        this.fetchSize_ = stmt.fetchSize_;
        this.fetchDirection_ = stmt.fetchDirection_;
        this.stmtLabel_ = stmt_label;
        this.cachedRows_ = new ArrayList();
        this.isBeforeFirst_ = true;
        this.holdability_ = stmt.resultSetHoldability_;
        this.spj_rs_ = spj_result_set;
        this.fetchComplete_ = false;
        this.checkJavaVersion();
        this.seqNum_ = seqCount_++;
        try {
            this.irs_ = new InterfaceResultSet(this);
        }
        catch (SQLException e) {
            this.performConnectionErrorChecks(e);
            throw e;
        }
    }

    SQLMXResultSet(SQLMXDatabaseMetaData dbMetaData, SQLMXDesc[] outputDesc, String stmtLabel, boolean oldDateFormat) throws SQLException {
        if (dbMetaData.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(dbMetaData.connection_.props_, (Object)dbMetaData, (Object)outputDesc, 0, (Object)stmtLabel);
            dbMetaData.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXResultSet", "", "", p);
        }
        if (dbMetaData.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(dbMetaData.connection_.props_, (Object)dbMetaData, (Object)outputDesc, 0, (Object)stmtLabel);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXResultSet");
            lr.setSourceMethodName("");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            dbMetaData.connection_.props_.getLogWriter().println(temp);
        }
        this.connection_ = dbMetaData.connection_;
        this.outputDesc_ = outputDesc;
        this.keepRawBuffer_ = this.connection_.props_.getKeepRawFetchBuffer();
        this.stmtLabel_ = stmtLabel;
        this.fetchSize_ = 1;
        this.fetchDirection_ = 1000;
        this.cachedRows_ = new ArrayList();
        this.isBeforeFirst_ = true;
        this.holdability_ = 2;
        this.spj_rs_ = false;
        this.useOldDateFormat_ = oldDateFormat;
        this.fetchComplete_ = false;
        this.checkJavaVersion();
        this.seqNum_ = seqCount_++;
        try {
            this.irs_ = new InterfaceResultSet(this);
        }
        catch (SQLException e) {
            this.performConnectionErrorChecks(e);
            throw e;
        }
    }

    private void checkJavaVersion() {
        this._javaVersion = Float.parseFloat(System.getProperty("java.specification.version"));
        if ((double)this._javaVersion >= 1.5) {
            try {
                this._toPlainString = BigDecimal.class.getMethod("toPlainString", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

