/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.InterfaceStatement;
import com.tandem.t4jdbc.Row;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXDesc;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXHandle;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXResultSet;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import com.tandem.t4jdbc.Utility;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.rmi.dgc.VMID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class SQLMXStatement
extends SQLMXHandle
implements Statement {
    public static final int NO_GENERATED_KEYS = 2;
    SQLMXConnection connection_;
    int resultSetType_;
    int resultSetConcurrency_;
    String sql_;
    int queryTimeout_;
    int maxRows_;
    int maxFieldSize_;
    int fetchSize_;
    int fetchDirection_;
    boolean escapeProcess_;
    boolean ExecuteBatchDone_ = false;
    String cursorName_;
    SQLMXResultSet[] resultSet_;
    int num_result_sets_;
    int result_set_offset;
    String stmtLabel_;
    short sqlStmtType_;
    boolean isClosed_;
    ArrayList batchCommands_;
    int[] batchRowCount_;
    WeakReference pRef_;
    int resultSetHoldability_;
    InterfaceStatement ist_;
    int inputParamsLength_;
    int outputParamsLength_;
    int inputDescLength_;
    int outputDescLength_;
    int inputParamCount_;
    int outputParamCount_;
    int roundingMode_ = 4;
    SQLMXDesc[] inputDesc_;
    SQLMXDesc[] outputDesc_;
    short operationID_;
    byte[] operationBuffer_;
    byte[] operationReply_;
    boolean usingRawRowset_;
    ByteBuffer rowwiseRowsetBuffer_;
    byte[] transactionToJoin;
    int _lastCount = -1;
    int hashCodeForStmt = -1;

    public void addBatch(String sql) throws SQLException {
        String temp;
        T4LogFormatter lf;
        Object[] p;
        LogRecord lr;
        if (this.connection_.props_.getLogWriter() != null) {
            lr = new LogRecord(Level.FINE, "");
            p = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("addBatch");
            lf = new T4LogFormatter();
            temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p2 = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "addBatch", "", p2);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            lr = new LogRecord(Level.FINE, "");
            p = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("addBatch");
            lf = new T4LogFormatter();
            temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.ExecuteBatchDone_) {
            this.batchCommands_.clear();
            this.ExecuteBatchDone_ = false;
        }
        if (this.batchCommands_ == null) {
            this.batchCommands_ = new ArrayList();
        }
        sql = this.scanSqlStr(sql);
        this.batchCommands_.add(sql);
    }

    public void cancel() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "cancel", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("cancel");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.ist_.t4statement_ != null && this.ist_.t4statement_.m_processing || this.resultSet_ != null && this.resultSet_[this.result_set_offset] != null && this.resultSet_[this.result_set_offset].irs_ != null && this.resultSet_[this.result_set_offset].irs_.t4resultSet_ != null && this.resultSet_[this.result_set_offset].irs_.t4resultSet_.m_processing) {
            this.ist_.cancel();
        }
    }

    public void clearBatch() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "clearBatch", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("clearBatch");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.batchCommands_ != null) {
            this.batchCommands_.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "close", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("close");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.isClosed_) {
            return;
        }
        try {
            if (!this.connection_._isClosed()) {
                for (int i = 0; i < this.num_result_sets_; ++i) {
                    if (this.resultSet_[i] == null) continue;
                    this.resultSet_[i].close(false);
                }
                this.ist_.close();
            }
        }
        finally {
            this.isClosed_ = true;
            this.connection_.removeElement(this.pRef_);
            this.initResultSets();
        }
    }

    void initResultSets() {
        this.num_result_sets_ = 1;
        this.result_set_offset = 0;
        this.resultSet_[this.result_set_offset] = null;
    }

    public boolean execute() throws SQLException {
        try {
            this.ist_.executeDirect(this.queryTimeout_, this);
        }
        catch (SQLException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return true;
    }

    public boolean execute(String sql) throws SQLException {
        String temp;
        T4LogFormatter lf;
        Object[] p;
        LogRecord lr;
        if (this.connection_.props_.getLogWriter() != null) {
            lr = new LogRecord(Level.FINE, "");
            p = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("execute");
            lf = new T4LogFormatter();
            temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p2 = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "execute", "", p2);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            lr = new LogRecord(Level.FINE, "");
            p = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("execute");
            lf = new T4LogFormatter();
            temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateExecDirectInvocation(sql);
        if (!this.connection_.getAutoCommit()) {
            this.connection_.isActiveTrans = true;
        }
        try {
            this.ist_.execute((short)3012, 0, 0, null, this.queryTimeout_, this.sql_, this);
            this.checkSQLWarningAndClose();
        }
        catch (SQLException se) {
            try {
                if (this.num_result_sets_ != 1 || this.resultSet_[this.result_set_offset] == null) {
                    // empty if block
                }
                this.internalClose();
            }
            catch (SQLException closeException) {
                se.setNextException(closeException);
            }
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return this.resultSet_[this.result_set_offset] != null;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, autoGeneratedKeys);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "execute", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, autoGeneratedKeys);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("execute");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (autoGeneratedKeys != 2) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "auto_generated_keys_not_supported", null);
        }
        boolean ret = this.execute(sql);
        return ret;
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean ret;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, (Object)columnIndexes);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "execute", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, (Object)columnIndexes);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("execute");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (columnIndexes == null) {
            ret = this.execute(sql);
        } else if (columnIndexes.length == 0) {
            ret = this.execute(sql);
        } else {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "auto_generated_keys_not_supported", null);
        }
        return ret;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean ret;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, (Object)columnNames);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "execute", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, (Object)columnNames);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("execute");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (columnNames == null) {
            ret = this.execute(sql);
        } else if (columnNames.length == 0) {
            ret = this.execute(sql);
        } else {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "auto_generated_keys_not_supported", null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException, BatchUpdateException {
        Object lf;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "executeBatch", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("executeBatch");
            lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        try {
            SQLMXException se;
            int i = 0;
            this.validateExecDirectInvocation();
            if (this.batchCommands_ == null || this.batchCommands_.isEmpty()) {
                lf = new int[]{};
                return lf;
            }
            this.batchRowCount_ = new int[this.batchCommands_.size()];
            for (i = 0; i < this.batchCommands_.size(); ++i) {
                String sql = (String)this.batchCommands_.get(i);
                if (sql == null) {
                    se = SQLMXMessages.createSQLException(this.connection_.props_, this.ist_.ic_.getLocale(), "batch_command_failed", "Invalid SQL String");
                    throw new BatchUpdateException(se.getMessage(), se.getSQLState(), new int[0]);
                }
                this.sqlStmtType_ = this.ist_.getSqlStmtType(sql);
                if (this.sqlStmtType_ == 1) {
                    se = SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "select_in_batch_not_supported", null);
                    throw new BatchUpdateException(se.getMessage(), se.getSQLState(), new int[0]);
                }
                if (this.sqlStmtType_ == 4096) {
                    se = SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "infostats_invalid_error", null);
                    throw new BatchUpdateException(se.getMessage(), se.getSQLState(), new int[0]);
                }
                if (this.sqlStmtType_ != 8192) continue;
                se = SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "config_cmd_invalid_error", null);
                throw new BatchUpdateException(se.getMessage(), se.getSQLState(), new int[0]);
            }
            if (!this.connection_.getAutoCommit()) {
                this.connection_.isActiveTrans = true;
            }
            Object[] commands = this.batchCommands_.toArray();
            int[] batchRowCount = new int[commands.length];
            int rowCount = 0;
            try {
                for (i = 0; i < commands.length; ++i) {
                    String sql = String.valueOf(commands[i]);
                    this.validateExecDirectInvocation(sql);
                    this.ist_.execute((short)3012, 0, 0, null, this.queryTimeout_, this.sql_, this);
                    this.checkSQLWarningAndClose();
                    batchRowCount[i] = this.connection_.props_.getExecuteBatchWithRowsAffected().equals("ON") ? (int)this.ist_.getRowCount() : this.batchRowCount_[0];
                    rowCount = (int)((long)rowCount + this.ist_.getRowCount());
                }
                if (commands.length < 1) {
                    batchRowCount = new int[]{};
                }
            }
            catch (SQLException e) {
                this.ist_.setRowCount(rowCount);
                this.batchRowCount_ = new int[i];
                System.arraycopy(batchRowCount, 0, this.batchRowCount_, 0, i);
                se = SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "batch_command_failed", null);
                BatchUpdateException be = new BatchUpdateException(se.getMessage(), se.getSQLState(), this.batchRowCount_);
                be.setNextException(e);
                try {
                    if (this.resultSet_[this.result_set_offset] == null) {
                        this.internalClose();
                    }
                }
                catch (SQLException closeException) {
                    be.setNextException(closeException);
                }
                this.performConnectionErrorChecks(e);
                throw be;
            }
            this.ist_.setRowCount(rowCount);
            this.batchRowCount_ = new int[i];
            System.arraycopy(batchRowCount, 0, this.batchRowCount_, 0, i);
            this.ExecuteBatchDone_ = true;
            int[] nArray = this.batchRowCount_;
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "executeQuery", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("executeQuery");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateExecDirectInvocation(sql);
        if (this.sqlStmtType_ != 1 && this.sqlStmtType_ != 4096) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "non_select_invalid", null);
        }
        if (!this.connection_.getAutoCommit()) {
            this.connection_.isActiveTrans = true;
        }
        try {
            this.ist_.execute((short)3012, 0, 0, null, this.queryTimeout_, this.sql_, this);
            this.checkSQLWarningAndClose();
        }
        catch (SQLException se) {
            try {
                if (this.resultSet_[this.result_set_offset] == null) {
                    this.internalClose();
                }
            }
            catch (SQLException closeException) {
                se.setNextException(closeException);
            }
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return this.resultSet_[this.result_set_offset];
    }

    public int executeUpdate(String sql) throws SQLException {
        long count = this.executeUpdate64(sql);
        if (count > Integer.MAX_VALUE) {
            this.setSQLWarning(null, "numeric_out_of_range", null);
        }
        return (int)count;
    }

    public long executeUpdate64(String sql) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "executeUpdate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("executeUpdate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.validateExecDirectInvocation(sql);
        if (this.sqlStmtType_ == 1 && !this.ist_.stmtIsLock) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "select_invalid", null);
        }
        if (!this.connection_.getAutoCommit()) {
            this.connection_.isActiveTrans = true;
        }
        try {
            this.ist_.execute((short)3012, 0, 0, null, this.queryTimeout_, this.sql_, this);
            this.checkSQLWarningAndClose();
        }
        catch (SQLException se) {
            try {
                if (this.resultSet_[this.result_set_offset] == null) {
                    this.internalClose();
                }
            }
            catch (SQLException closeException) {
                se.setNextException(closeException);
            }
            this.performConnectionErrorChecks(se);
            throw se;
        }
        return this.ist_.getRowCount();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, autoGeneratedKeys);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "executeUpdate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, autoGeneratedKeys);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("executeUpdate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (autoGeneratedKeys != 2) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "auto_generated_keys_not_supported", null);
        }
        int ret = this.executeUpdate(sql);
        return ret;
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int ret;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, (Object)columnIndexes);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "executeUpdate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, (Object)columnIndexes);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("executeUpdate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (columnIndexes == null) {
            ret = this.executeUpdate(sql);
        } else if (columnIndexes.length == 0) {
            ret = this.executeUpdate(sql);
        } else {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "auto_generated_keys_not_supported", null);
        }
        return ret;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int ret;
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, (Object)columnNames);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "executeUpdate", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, (Object)sql, (Object)columnNames);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("executeUpdate");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (columnNames == null) {
            ret = this.executeUpdate(sql);
        } else if (columnNames.length == 0) {
            ret = this.executeUpdate(sql);
        } else {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "auto_generated_keys_not_supported", null);
        }
        return ret;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getConnection", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getConnection");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.connection_;
    }

    public int getFetchDirection() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getFetchDirection", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getFetchDirection");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.fetchDirection_;
    }

    public int getFetchSize() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getFetchSize", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getFetchSize");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.fetchSize_;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getGeneratedKeys", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getGeneratedKeys");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "auto_generated_keys_not_supported", null);
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getMaxFieldSize", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getMaxFieldSize");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.maxFieldSize_;
    }

    public int getMaxRows() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getMaxRows", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getMaxRows");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.maxRows_;
    }

    public boolean getMoreResults() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getMoreResults", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getMoreResults");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.getMoreResults(1);
    }

    public boolean getMoreResults(int current) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, current);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getMoreResults", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, current);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getMoreResults");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        switch (current) {
            case 3: {
                for (int i = 0; i <= this.result_set_offset; ++i) {
                    if (this.resultSet_[i] == null) continue;
                    this.resultSet_[i].close();
                }
                break;
            }
            case 2: {
                break;
            }
            default: {
                if (this.resultSet_[this.result_set_offset] == null) break;
                this.resultSet_[this.result_set_offset].close();
            }
        }
        this.ist_.setRowCount(-1L);
        if (this.result_set_offset < this.num_result_sets_ - 1) {
            ++this.result_set_offset;
            return true;
        }
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getQueryTimeout", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getQueryTimeout");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.queryTimeout_;
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getResultSet", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getResultSet");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.resultSet_[this.result_set_offset];
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getResultSetConcurrency", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getResultSetConcurrency");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.resultSetConcurrency_;
    }

    public int getResultSetHoldability() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getResultSetHoldability", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getResultSetHoldability");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.resultSetHoldability_;
    }

    public int getResultSetType() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getResultSetType", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getResultSetType");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        return this.resultSetType_;
    }

    public int getUpdateCount() throws SQLException {
        long count = this.getUpdateCount64();
        if (count > Integer.MAX_VALUE) {
            this.setSQLWarning(null, "numeric_out_of_range", null);
        }
        return (int)count;
    }

    public long getUpdateCount64() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "getUpdateCount", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("getUpdateCount");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.ist_ == null) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_statement_handle", null);
        }
        long count = this.ist_.getRowCount();
        if (count == 0L && this.resultSet_ != null && this.resultSet_[this.result_set_offset] != null) {
            count = -1L;
        }
        return count;
    }

    public short getOperationID() throws SQLException {
        return this.operationID_;
    }

    public byte[] getOperationBuffer() throws SQLException {
        return this.operationBuffer_;
    }

    public byte[] getOperationReplyBuffer() throws SQLException {
        return this.operationReply_;
    }

    public void setCursorName(String name) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, name);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "setCursorName", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, name);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("setCursorName");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.cursorName_ = name;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, enable);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "setEscapeProcessing", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, enable);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("setEscapeProcessing");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        this.escapeProcess_ = enable;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, direction);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "setFetchDirection", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, direction);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("setFetchDirection");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        switch (direction) {
            case 1000: {
                this.fetchDirection_ = direction;
                break;
            }
            case 1001: 
            case 1002: {
                this.fetchDirection_ = 1000;
                break;
            }
            default: {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_fetch_direction", null);
            }
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, rows);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "setFetchSize", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, rows);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("setFetchSize");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (rows < 0) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_fetch_size", null);
        }
        this.fetchSize_ = rows == 0 ? 1 : rows;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, max);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "setMaxFieldSize", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, max);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("setMaxFieldSize");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (max < 0) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_maxFieldSize_value", null);
        }
        this.maxFieldSize_ = max;
    }

    public void setMaxRows(int max) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, max);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "setMaxRows", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, max);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("setMaxRows");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (max < 0) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_maxRows_value", null);
        }
        this.maxRows_ = max;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, seconds);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "setQueryTimeout", "", p);
        }
        if (this.connection_.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, seconds);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("setQueryTimeout");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.connection_.props_.getLogWriter().println(temp);
        }
        if (this.connection_.props_.getCloseConnectionUponQueryTimeout().equals("DEFAULT")) {
            SQLMXMessages.throwUnsupportedFeatureException(this.connection_.props_, this.connection_.getLocale(), "setQueryTimeout()");
            this.clearWarnings();
            if (seconds < 0) {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_queryTimeout_value", null);
            }
        } else if (this.connection_.props_.getCloseConnectionUponQueryTimeout().equals("IGNORE")) {
            this.clearWarnings();
            if (seconds < 0) {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_queryTimeout_value", null);
            }
        } else if (this.connection_.props_.getCloseConnectionUponQueryTimeout().equals("ON")) {
            this.clearWarnings();
            if (seconds < 0) {
                throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_queryTimeout_value", null);
            }
            this.queryTimeout_ = seconds;
        }
    }

    public void setOperationID(short opID) throws SQLException {
        this.operationID_ = opID;
    }

    public void setOperationBuffer(byte[] opBuffer) throws SQLException {
        this.operationBuffer_ = opBuffer;
    }

    String scanSqlStr(String sql) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "scanSqlStr", "", p);
        }
        int index = 0;
        int oldIndex = 0;
        StringBuffer newSql = null;
        boolean clobFound = false;
        boolean blobFound = false;
        String tempStr = sql.toUpperCase();
        int len = sql.length();
        try {
            String tempSql;
            while ((index = tempStr.indexOf("EMPTY_CLOB()", oldIndex)) != -1) {
                if (newSql == null) {
                    newSql = new StringBuffer(len);
                }
                newSql.append(sql.substring(oldIndex, index));
                newSql.append(Long.toString(this.connection_.getDataLocator(this.connection_.clobTableName_, false)));
                oldIndex = index + 12;
                clobFound = true;
            }
            if (clobFound) {
                newSql.append(sql.substring(oldIndex));
            }
            oldIndex = 0;
            if (clobFound) {
                tempSql = newSql.toString();
                tempStr = tempSql.toUpperCase();
            } else {
                tempSql = sql;
            }
            while ((index = tempStr.indexOf("EMPTY_BLOB()", oldIndex)) != -1) {
                if (newSql == null) {
                    newSql = new StringBuffer(len);
                } else if (!blobFound) {
                    newSql.setLength(0);
                }
                newSql.append(tempSql.substring(oldIndex, index));
                newSql.append(Long.toString(this.connection_.getDataLocator(this.connection_.blobTableName_, true)));
                blobFound = true;
                oldIndex = index + 12;
            }
            if (blobFound) {
                newSql.append(tempSql.substring(oldIndex));
            }
            if (clobFound || blobFound) {
                return newSql.toString();
            }
            return sql;
        }
        catch (SQLException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    void validateExecDirectInvocation(String sql) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, sql);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXStatement", "validateExecDirectInvocation", "", p);
        }
        this.validateExecDirectInvocation();
        this.sqlStmtType_ = this.ist_.getSqlStmtType(sql);
        this.sql_ = this.scanSqlStr(sql);
    }

    void validateExecDirectInvocation() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXStatement", "validateExecDirectInvocation", "", p);
        }
        this.ist_.setRowCount(-1L);
        this.clearWarnings();
        if (this.isClosed_) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_statement", null);
        }
        try {
            this.connection_.isConnectionOpen();
            for (int i = 0; i < this.num_result_sets_; ++i) {
                if (this.resultSet_[i] == null) continue;
                this.resultSet_[i].close();
            }
        }
        catch (SQLException se) {
            this.performConnectionErrorChecks(se);
            throw se;
        }
    }

    void internalClose() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXStatement", "internalClose", "", p);
        }
        if (!this.connection_._isClosed()) {
            this.ist_.close();
        }
    }

    private void setResultSet(SQLMXDesc[] outputDesc) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, outputDesc);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXStatement", "setResultSet", "", p);
        }
        this.initResultSets();
        this.resultSet_[this.result_set_offset] = outputDesc != null ? new SQLMXResultSet(this, outputDesc) : null;
    }

    public void setTransactionToJoin(byte[] txid) throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, txid);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXStatement", "setTransactionToJoin", "", p);
        }
        this.transactionToJoin = txid;
    }

    void setMultipleResultSets(int num_result_sets, SQLMXDesc[][] output_descriptors, String[] stmt_labels, String[] proxySyntax) throws SQLException {
        if (num_result_sets < 1) {
            return;
        }
        this.resultSet_ = new SQLMXResultSet[num_result_sets];
        this.num_result_sets_ = num_result_sets;
        for (int i = 0; i < num_result_sets; ++i) {
            SQLMXDesc[] desc = output_descriptors[i];
            if (desc == null) {
                this.resultSet_[i] = null;
                continue;
            }
            this.resultSet_[i] = new SQLMXResultSet(this, desc, stmt_labels[i], true);
            this.resultSet_[i].proxySyntax_ = proxySyntax[i];
        }
    }

    void setExecute2Outputs(byte[] values, short rowsAffected, boolean endOfData, String[] proxySyntax, SQLMXDesc[] desc) throws SQLException {
        this.num_result_sets_ = 1;
        this.result_set_offset = 0;
        if (desc != null) {
            this.outputDesc_ = desc;
        }
        this.resultSet_ = new SQLMXResultSet[this.num_result_sets_];
        if (this.outputDesc_ != null) {
            this.resultSet_[this.result_set_offset] = new SQLMXResultSet(this, this.outputDesc_);
            this.resultSet_[this.result_set_offset].proxySyntax_ = proxySyntax[this.result_set_offset];
            if (rowsAffected == 0) {
                if (endOfData) {
                    this.resultSet_[this.result_set_offset].setFetchOutputs(new Row[0], 0, true);
                }
            } else {
                if (this.resultSet_[this.result_set_offset].keepRawBuffer_) {
                    this.resultSet_[this.result_set_offset].rawBuffer_ = values;
                }
                this.resultSet_[this.result_set_offset].irs_.setExecute2FetchOutputs(this.resultSet_[this.result_set_offset], 1, true, values);
            }
        } else {
            this.resultSet_[this.result_set_offset] = null;
        }
    }

    SQLMXStatement() {
        if (T4Properties.t4GlobalLogger.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null);
            T4Properties.t4GlobalLogger.logp(Level.FINE, "SQLMXStatement", "<init>", "", p);
        }
        this.resultSet_ = new SQLMXResultSet[1];
        this.initResultSets();
    }

    SQLMXStatement(SQLMXConnection connection, String stmtLabel) throws SQLException {
        if (connection.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(connection.props_, (Object)connection, (Object)stmtLabel);
            connection.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "<init>", "", p);
        }
        if (connection.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(connection.props_, connection);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("Note, this constructor was called before the previous constructor");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            connection.props_.getLogWriter().println(temp);
        }
        this.connection_ = connection;
        this.operationID_ = (short)-1;
        this.resultSetType_ = 1003;
        this.resultSetConcurrency_ = 1007;
        this.resultSetHoldability_ = 2;
        this.queryTimeout_ = this.connection_.getServerHandle().getQueryTimeout();
        this.stmtLabel_ = stmtLabel;
        this.fetchSize_ = 1;
        this.maxRows_ = 0;
        this.fetchDirection_ = 1000;
        this.pRef_ = new WeakReference<SQLMXStatement>(this, this.connection_.refStmtQ_);
        this.ist_ = new InterfaceStatement(this);
        this.connection_.addElement(this.pRef_, this.stmtLabel_);
        this.resultSet_ = new SQLMXResultSet[1];
        this.initResultSets();
    }

    SQLMXStatement(SQLMXConnection connection) throws SQLException {
        this(connection, 1003, 1007, 2);
        if (connection.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(connection.props_, connection);
            connection.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "<init>", "Note, this constructor was called before the previous constructor", p);
        }
        if (connection.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(connection.props_, connection);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("<init>");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            connection.props_.getLogWriter().println(temp);
        }
        this.resultSet_ = new SQLMXResultSet[1];
        this.roundingMode_ = this.connection_.props_.getRoundingMode();
        this.initResultSets();
    }

    SQLMXStatement(SQLMXConnection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        this(connection, resultSetType, resultSetConcurrency, 2);
        if (connection.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(connection.props_, (Object)connection, resultSetType, resultSetConcurrency);
            connection.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "<init>", "Note, this constructor was called before the previous constructor", p);
        }
        if (connection.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(connection.props_, (Object)connection, resultSetType, resultSetConcurrency);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("<init>");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            connection.props_.getLogWriter().println(temp);
        }
        this.resultSet_ = new SQLMXResultSet[1];
        this.roundingMode_ = this.connection_.props_.getRoundingMode();
        this.initResultSets();
    }

    SQLMXStatement(SQLMXConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String stmtLabel) throws SQLException {
        if (connection.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(connection.props_, (Object)connection, resultSetType, resultSetConcurrency, resultSetHoldability);
            connection.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "<init>", "", p);
        }
        if (connection.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(connection.props_, (Object)connection, resultSetType, resultSetConcurrency, resultSetHoldability);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("<init>");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            connection.props_.getLogWriter().println(temp);
        }
        this.connection_ = connection;
        this.operationID_ = (short)-1;
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_resultset_type", null);
        }
        if (resultSetType == 1005) {
            this.resultSetType_ = 1004;
            this.connection_.setSQLWarning(null, "scrollResultSetChanged", null);
        } else {
            this.resultSetType_ = resultSetType;
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_resultset_concurrency", null);
        }
        if (resultSetHoldability != 2 && resultSetHoldability != 0) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_holdability", null);
        }
        this.resultSetConcurrency_ = resultSetConcurrency;
        this.resultSetHoldability_ = resultSetHoldability;
        this.queryTimeout_ = this.connection_.getServerHandle().getQueryTimeout();
        this.stmtLabel_ = stmtLabel;
        this.fetchSize_ = 1;
        this.maxRows_ = 0;
        this.fetchDirection_ = 1000;
        this.connection_.gcStmts();
        this.pRef_ = new WeakReference<SQLMXStatement>(this, this.connection_.refStmtQ_);
        this.ist_ = new InterfaceStatement(this);
        this.connection_.addElement(this.pRef_, this.stmtLabel_);
        this.roundingMode_ = this.connection_.props_.getRoundingMode();
        this.resultSet_ = new SQLMXResultSet[1];
    }

    SQLMXStatement(SQLMXConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (connection.props_.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(connection.props_, (Object)connection, resultSetType, resultSetConcurrency, resultSetHoldability);
            connection.props_.t4Logger_.logp(Level.FINE, "SQLMXStatement", "<init>", "", p);
        }
        if (connection.props_.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(connection.props_, (Object)connection, resultSetType, resultSetConcurrency, resultSetHoldability);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXStatement");
            lr.setSourceMethodName("<init>");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            connection.props_.getLogWriter().println(temp);
        }
        this.connection_ = connection;
        this.operationID_ = (short)-1;
        if (resultSetType != 1003 && resultSetType != 1004 && resultSetType != 1005) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_resultset_type", null);
        }
        if (resultSetType == 1005) {
            this.resultSetType_ = 1004;
            this.connection_.setSQLWarning(null, "scrollResultSetChanged", null);
        } else {
            this.resultSetType_ = resultSetType;
        }
        if (resultSetConcurrency != 1007 && resultSetConcurrency != 1008) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_resultset_concurrency", null);
        }
        if (resultSetHoldability != 2 && resultSetHoldability != 0) {
            throw SQLMXMessages.createSQLException(this.connection_.props_, this.connection_.getLocale(), "invalid_holdability", null);
        }
        this.resultSetConcurrency_ = resultSetConcurrency;
        this.resultSetHoldability_ = resultSetHoldability;
        this.queryTimeout_ = this.connection_.getServerHandle().getQueryTimeout();
        this.stmtLabel_ = this.generateStmtLabel();
        this.fetchSize_ = 1;
        this.maxRows_ = 0;
        this.fetchDirection_ = 1000;
        this.connection_.gcStmts();
        this.pRef_ = new WeakReference<SQLMXStatement>(this, this.connection_.refStmtQ_);
        this.ist_ = new InterfaceStatement(this);
        this.connection_.addElement(this.pRef_, this.stmtLabel_);
        this.resultSet_ = new SQLMXResultSet[1];
        this.roundingMode_ = this.connection_.props_.getRoundingMode();
        this.initResultSets();
    }

    private String generateUID() {
        MessageDigest md5 = null;
        BigInteger bid = null;
        VMID id = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            id = new VMID();
            md5.update((id.toString() + Long.toString(System.currentTimeMillis())).getBytes());
            bid = new BigInteger(1, md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            // empty catch block
        }
        id = null;
        return bid.toString();
    }

    synchronized String generateStmtLabel() throws SQLException {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXStatement", "generateStmtLabel", "", p);
        }
        String tmpLabel = null;
        if (this.stmtLabel_ == null) {
            DecimalFormat format = new DecimalFormat("00000000");
            if (this.hashCodeForStmt == -1) {
                this.hashCodeForStmt = this.connection_.incrementAndGetStmtLabelHandleCount();
            }
            if (this.hashCodeForStmt < 0) {
                this.hashCodeForStmt = -this.hashCodeForStmt;
            }
            if ((tmpLabel = "SQL_CUR_MFC" + System.currentTimeMillis() + this.generateUID() + format.format(this.hashCodeForStmt)).length() > 128) {
                tmpLabel = tmpLabel.substring(0, 128);
            }
            this.stmtLabel_ = tmpLabel;
        } else {
            tmpLabel = this.stmtLabel_;
        }
        return tmpLabel;
    }

    void checkSQLWarningAndClose() {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_);
            this.connection_.props_.t4Logger_.logp(Level.FINER, "SQLMXStatement", "checkSQLWarningAndClose", "", p);
        }
        if (this.sqlWarning_ != null && this.resultSet_[this.result_set_offset] == null) {
            try {
                this.internalClose();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void setRoundingMode(int roundingMode) {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, roundingMode);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setRoundingMode", "", p);
        }
        this.roundingMode_ = Utility.getRoundingMode(roundingMode);
    }

    public void setRoundingMode(String roundingMode) {
        if (this.connection_.props_.t4Logger_.isLoggable(Level.FINER)) {
            Object[] p = T4LoggingUtilities.makeParams(this.connection_.props_, roundingMode);
            this.connection_.props_.t4Logger_.logp(Level.FINE, "SQLMXPreparedStatement", "setRoundingMode", "", p);
        }
        this.roundingMode_ = Utility.getRoundingMode(roundingMode);
    }

    void closeErroredConnection(SQLMXException sme) {
        this.connection_.closeErroredConnection(sme);
    }

    public String getStatementLabel() {
        return new String(this.stmtLabel_);
    }

    public String getSQL() {
        return this.sql_;
    }

    public int getStmtHandle() {
        return this.ist_.stmtHandle_;
    }

    synchronized void removeMFCFromStmtLabel() throws SQLException {
        this.stmtLabel_ = this.stmtLabel_.replaceAll("MFC", "");
        this.ist_.setStmtLabel_(this.stmtLabel_);
        this.ist_.getT4statement_().setM_stmtLabel(this.stmtLabel_);
    }

    public int getInputParamsLength_() {
        return this.inputParamsLength_;
    }

    public int getOutputParamsLength_() {
        return this.outputParamsLength_;
    }
}

