/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import com.tandem.t4jdbc.T4XALogger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;

public class SQLMXTxConnection
implements Connection {
    private SQLMXConnection m_sqlmxConnection;
    private boolean m_xa_txnActive = false;
    private T4Properties m_t4props;
    private T4XALogger m_t4XALogger;
    private boolean m_isClosed = false;

    SQLMXTxConnection(SQLMXConnection p_sqlmxConnection) throws SQLException {
        this.m_sqlmxConnection = p_sqlmxConnection;
        this.m_t4props = this.m_sqlmxConnection.props_;
        this.m_t4XALogger = new T4XALogger(this.m_sqlmxConnection);
        this.m_t4XALogger.logAndIgnore("SQLMXTxConnection acquired.", Level.FINE, "SQLMXTxConnection", "Constructor", T4LoggingUtilities.makeParams(this.m_t4props, p_sqlmxConnection));
    }

    void setXA() {
        this.m_xa_txnActive = true;
        this.m_sqlmxConnection.m_isXA_ = true;
        this.m_sqlmxConnection.props_.setUseExternalTransaction("NO");
    }

    void reSetXA() {
        this.m_xa_txnActive = false;
        this.m_sqlmxConnection.m_isXA_ = false;
    }

    SQLMXConnection getSQLMXConnection() {
        return this.m_sqlmxConnection;
    }

    public Statement createStatement() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Creating Statement.", Level.FINE, "SQLMXTxConnection", "createStatement", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        Statement stmt = this.m_sqlmxConnection.createStatement();
        this.m_t4XALogger.logAndIgnore("Creating Statement.", Level.FINE, "SQLMXTxConnection", "createStatement", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        return stmt;
    }

    public PreparedStatement prepareStatement(String p_string) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Preparing Statement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        this.throwWhenConnectionClosed();
        PreparedStatement pstmt = this.m_sqlmxConnection.prepareStatement(p_string);
        this.m_t4XALogger.logAndIgnore("Prepared Statement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        return pstmt;
    }

    public CallableStatement prepareCall(String p_string) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Preparing a Callable Statement.", Level.FINE, "SQLMXTxConnection", "prepareCall", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        this.throwWhenConnectionClosed();
        CallableStatement cstmt = this.m_sqlmxConnection.prepareCall(p_string);
        this.m_t4XALogger.logAndIgnore("Preparing a Callable Statement.", Level.FINE, "SQLMXTxConnection", "prepareCall", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        return cstmt;
    }

    public String nativeSQL(String p_string) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Getting nativeSQL statement.", Level.FINE, "SQLMXTxConnection", "nativeSQL", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        this.throwWhenConnectionClosed();
        String nsql = this.m_sqlmxConnection.nativeSQL(p_string);
        this.m_t4XALogger.logAndIgnore("Got nativeSQL statement.", Level.FINE, "SQLMXTxConnection", "nativeSQL", T4LoggingUtilities.makeParams(this.m_t4props, nsql));
        return nsql;
    }

    public void setAutoCommit(boolean p_autoCommitMode) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Setting the autoCommit mode", Level.FINE, "SQLMXTxConnection", "setAutoCommit", T4LoggingUtilities.makeParams(this.m_t4props, p_autoCommitMode));
        this.throwWhenConnectionClosed();
        if (p_autoCommitMode) {
            this.checkXaAndThrowSqlException();
        }
        this.m_sqlmxConnection.setAutoCommit(p_autoCommitMode);
        this.m_t4XALogger.logAndIgnore("Set the autoCommit mode", Level.FINE, "SQLMXTxConnection", "setAutoCommit", T4LoggingUtilities.makeParams(this.m_t4props, p_autoCommitMode));
    }

    public boolean getAutoCommit() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Getting the autoCommit mode", Level.FINE, "SQLMXTxConnection", "getAutoCommit", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        boolean autocommit = this.m_sqlmxConnection.getAutoCommit();
        this.m_t4XALogger.logAndIgnore("Got the autoCommit mode", Level.FINE, "SQLMXTxConnection", "getAutoCommit", T4LoggingUtilities.makeParams(this.m_t4props, autocommit));
        return autocommit;
    }

    public void commit() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Committing the txn", Level.FINE, "SQLMXTxConnection", "commit", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        this.checkXaAndThrowSqlException();
        this.m_sqlmxConnection.commit();
        this.m_t4XALogger.logAndIgnore("Committed the txn", Level.FINE, "SQLMXTxConnection", "commit", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
    }

    public void rollback() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Rolling back txn.", Level.FINE, "SQLMXTxConnection", "rollback", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        this.checkXaAndThrowSqlException();
        this.m_sqlmxConnection.rollback();
        this.m_t4XALogger.logAndIgnore("Rolled back the txn.", Level.FINE, "SQLMXTxConnection", "rollback", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
    }

    public void close() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Closing TX connection", Level.FINE, "SQLMXTxConnection", "close", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.m_isClosed = true;
        this.reSetXA();
        this.m_t4XALogger.logAndIgnore("Closed TX connection", Level.FINE, "SQLMXTxConnection", "close", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
    }

    public synchronized boolean isClosed() throws SQLException {
        this.m_t4XALogger.logAndIgnore("", Level.FINE, "SQLMXTxConnection", "isClosed", T4LoggingUtilities.makeParams(this.m_t4props, this.m_isClosed));
        return this.m_isClosed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Get the database meta data.", Level.FINE, "SQLMXTxConnection", "getMetaData", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        DatabaseMetaData dbm = this.m_sqlmxConnection.getMetaData();
        this.m_t4XALogger.logAndIgnore("Got the database meta data.", Level.FINE, "SQLMXTxConnection", "getMetaData", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        return dbm;
    }

    public void setReadOnly(boolean p_readOnly) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Setting the connection read only.", Level.FINE, "SQLMXTxConnection", "setReadOnly", T4LoggingUtilities.makeParams(this.m_t4props, p_readOnly));
        this.throwWhenConnectionClosed();
        this.m_sqlmxConnection.setReadOnly(p_readOnly);
        this.m_t4XALogger.logAndIgnore("Set the connection read only.", Level.FINE, "SQLMXTxConnection", "setReadOnly", T4LoggingUtilities.makeParams(this.m_t4props, p_readOnly));
    }

    public boolean isReadOnly() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Check the connection is read only.", Level.FINE, "SQLMXTxConnection", "getReadOnly", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        boolean readOnly = this.m_sqlmxConnection.isReadOnly();
        this.m_t4XALogger.logAndIgnore("Checked the connection is read only setting.", Level.FINE, "SQLMXTxConnection", "getReadOnly", T4LoggingUtilities.makeParams(this.m_t4props, readOnly));
        return readOnly;
    }

    public void setCatalog(String p_catalog) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Setting the catalog for the connection.", Level.FINE, "SQLMXTxConnection", "setCatalog", T4LoggingUtilities.makeParams(this.m_t4props, p_catalog));
        this.throwWhenConnectionClosed();
        this.m_sqlmxConnection.setCatalog(p_catalog);
        this.m_t4XALogger.logAndIgnore("Set the catalog for the connection.", Level.FINE, "SQLMXTxConnection", "setCatalog", T4LoggingUtilities.makeParams(this.m_t4props, p_catalog));
    }

    public String getCatalog() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Get the catalog for the connection.", Level.FINE, "SQLMXTxConnection", "getCatalog", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        String catalog = this.m_sqlmxConnection.getCatalog();
        this.m_t4XALogger.logAndIgnore("Got the catalog for the connection.", Level.FINE, "SQLMXTxConnection", "getCatalog", T4LoggingUtilities.makeParams(this.m_t4props, catalog));
        return catalog;
    }

    public void setTransactionIsolation(int p_txn_isolation) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Setting the transaction isolation for the connection.", Level.FINE, "SQLMXTxConnection", "setTransactionIsolation", T4LoggingUtilities.makeParams(this.m_t4props, p_txn_isolation));
        this.throwWhenConnectionClosed();
        this.checkXaAndThrowSqlException();
        this.m_sqlmxConnection.setTransactionIsolation(p_txn_isolation);
        this.m_t4XALogger.logAndIgnore("Set the transaction isolation for the connection.", Level.FINE, "SQLMXTxConnection", "setTransactionIsolation", T4LoggingUtilities.makeParams(this.m_t4props, p_txn_isolation));
    }

    public int getTransactionIsolation() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Get the transaction isolation for the connection.", Level.FINE, "SQLMXTxConnection", "getTransactionIsolation", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        int isol = this.m_sqlmxConnection.getTransactionIsolation();
        this.m_t4XALogger.logAndIgnore("Got the transaction isolation for the connection.", Level.FINE, "SQLMXTxConnection", "getTransactionIsolation", T4LoggingUtilities.makeParams(this.m_t4props, isol));
        return isol;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Get the SQLWarnings.", Level.FINE, "SQLMXTxConnection", "getWarnings", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        SQLWarning warn = this.m_sqlmxConnection.getWarnings();
        this.m_t4XALogger.logAndIgnore("Got the SQLWarnings.", Level.FINE, "SQLMXTxConnection", "getWarnings", T4LoggingUtilities.makeParams(this.m_t4props, warn));
        return warn;
    }

    public void clearWarnings() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Clear the SQLWarnings.", Level.FINE, "SQLMXTxConnection", "clearWarnings", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.m_sqlmxConnection.clearWarnings();
        this.m_t4XALogger.logAndIgnore("Cleared the SQLWarnings.", Level.FINE, "SQLMXTxConnection", "clearWarnings", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
    }

    public Statement createStatement(int p_int0, int p_int1) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Create a new SQLStatement.", Level.FINE, "SQLMXTxConnection", "createStatement", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        Statement stmt = this.m_sqlmxConnection.createStatement(p_int0, p_int1);
        this.m_t4XALogger.logAndIgnore("Created a new SQLStatement.", Level.FINE, "SQLMXTxConnection", "createStatement", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        return stmt;
    }

    public PreparedStatement prepareStatement(String p_string, int p_int1, int p_int2) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Preparing SQL Statement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        this.throwWhenConnectionClosed();
        PreparedStatement pstmt = this.m_sqlmxConnection.prepareStatement(p_string, p_int1, p_int2);
        this.m_t4XALogger.logAndIgnore("Prepared SQL Statement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        return pstmt;
    }

    public CallableStatement prepareCall(String p_string, int p_int1, int p_int2) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Preparing callable SQL Statement.", Level.FINE, "SQLMXTxConnection", "prepareCall", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        CallableStatement cstmt = this.m_sqlmxConnection.prepareCall(p_string, p_int1, p_int2);
        this.m_t4XALogger.logAndIgnore("Prepared callable SQL Statement.", Level.FINE, "SQLMXTxConnection", "prepareCall", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        return cstmt;
    }

    public Map getTypeMap() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Get the Type Map.", Level.FINE, "SQLMXTxConnection", "getTypeMap", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        Map map = this.m_sqlmxConnection.getTypeMap();
        this.m_t4XALogger.logAndIgnore("Got the Type Map.", Level.FINE, "SQLMXTxConnection", "getTypeMap", T4LoggingUtilities.makeParams(this.m_t4props, map));
        return map;
    }

    public void setTypeMap(Map p_map) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Setting the Type Map.", Level.FINE, "SQLMXTxConnection", "setTypeMap", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        this.m_sqlmxConnection.setTypeMap(p_map);
        this.m_t4XALogger.logAndIgnore("Set the Type Map.", Level.FINE, "SQLMXTxConnection", "setTypeMap", T4LoggingUtilities.makeParams(this.m_t4props, p_map));
    }

    public void setHoldability(int p_int0) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Setting the Holdability.", Level.FINE, "SQLMXTxConnection", "setHoldability", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        this.m_sqlmxConnection.setHoldability(p_int0);
        this.m_t4XALogger.logAndIgnore("Set the Holdability.", Level.FINE, "SQLMXTxConnection", "setHoldability", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
    }

    public int getHoldability() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Get the Holdability.", Level.FINE, "SQLMXTxConnection", "getHoldability", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        int hold = this.m_sqlmxConnection.getHoldability();
        this.m_t4XALogger.logAndIgnore("Got the Holdability.", Level.FINE, "SQLMXTxConnection", "getHoldability", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        return hold;
    }

    public Savepoint setSavepoint() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Setting the Savepoint.", Level.FINE, "SQLMXTxConnection", "setSavepoint", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        Savepoint save = this.m_sqlmxConnection.setSavepoint();
        this.m_t4XALogger.logAndIgnore("Set the Savepoint.", Level.FINE, "SQLMXTxConnection", "setSavepoint", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        return save;
    }

    public Savepoint setSavepoint(String p_string) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Setting the Savepoint.", Level.FINE, "SQLMXTxConnection", "setSavepoint", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        this.throwWhenConnectionClosed();
        Savepoint save = this.m_sqlmxConnection.setSavepoint(p_string);
        this.m_t4XALogger.logAndIgnore("Set the Savepoint.", Level.FINE, "SQLMXTxConnection", "setSavepoint", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        return save;
    }

    public void rollback(Savepoint p_savepoint) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Rolling back to the Savepoint.", Level.FINE, "SQLMXTxConnection", "rollback", T4LoggingUtilities.makeParams(this.m_t4props, p_savepoint));
        this.throwWhenConnectionClosed();
        this.m_sqlmxConnection.rollback(p_savepoint);
        this.m_t4XALogger.logAndIgnore("Rolled lback to the Savepoint.", Level.FINE, "SQLMXTxConnection", "rollback", T4LoggingUtilities.makeParams(this.m_t4props, p_savepoint));
    }

    public void releaseSavepoint(Savepoint p_savepoint) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Releasing the Savepoint.", Level.FINE, "SQLMXTxConnection", "releaseSavepoint", T4LoggingUtilities.makeParams(this.m_t4props, p_savepoint));
        this.throwWhenConnectionClosed();
        this.m_sqlmxConnection.releaseSavepoint(p_savepoint);
        this.m_t4XALogger.logAndIgnore("Released the Savepoint.", Level.FINE, "SQLMXTxConnection", "releaseSavepoint", T4LoggingUtilities.makeParams(this.m_t4props, p_savepoint));
    }

    public Statement createStatement(int p_int0, int p_int1, int p_int2) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Creating the SQL statement.", Level.FINE, "SQLMXTxConnection", "createStatement", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        Statement stmt = this.m_sqlmxConnection.createStatement(p_int0, p_int1, p_int2);
        this.m_t4XALogger.logAndIgnore("Created the SQL statement.", Level.FINE, "SQLMXTxConnection", "createStatement", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        return stmt;
    }

    public PreparedStatement prepareStatement(String p_string, int p_int1, int p_int2, int p_int3) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Creating the PreparedStatement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        PreparedStatement pstmt = this.m_sqlmxConnection.prepareStatement(p_string, p_int1, p_int2, p_int3);
        this.m_t4XALogger.logAndIgnore("Created the PreparedStatement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        return pstmt;
    }

    public CallableStatement prepareCall(String p_string, int p_int1, int p_int2, int p_int3) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Creating the callable statement.", Level.FINE, "SQLMXTxConnection", "prepareCall", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        this.throwWhenConnectionClosed();
        CallableStatement cstmt = this.m_sqlmxConnection.prepareCall(p_string, p_int1, p_int2, p_int3);
        this.m_t4XALogger.logAndIgnore("Created the callable statement.", Level.FINE, "SQLMXTxConnection", "prepareCall", T4LoggingUtilities.makeParams(this.m_t4props, this.m_sqlmxConnection));
        return cstmt;
    }

    public PreparedStatement prepareStatement(String p_string, int p_int1) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Creating the prepared statement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        this.throwWhenConnectionClosed();
        PreparedStatement pstmt = this.m_sqlmxConnection.prepareStatement(p_string, p_int1);
        this.m_t4XALogger.logAndIgnore("Created the prepared statement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        return pstmt;
    }

    public PreparedStatement prepareStatement(String p_string, int[] p_intArray) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Creating the prepared statement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        this.throwWhenConnectionClosed();
        PreparedStatement pstmt = this.m_sqlmxConnection.prepareStatement(p_string, p_intArray);
        this.m_t4XALogger.logAndIgnore("Created the prepared statement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        return pstmt;
    }

    public PreparedStatement prepareStatement(String p_string, String[] p_stringArray) throws SQLException {
        this.m_t4XALogger.logAndIgnore("Create the prepared statement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        this.throwWhenConnectionClosed();
        PreparedStatement pstmt = this.m_sqlmxConnection.prepareStatement(p_string, p_stringArray);
        this.m_t4XALogger.logAndIgnore("Created the prepared statement.", Level.FINE, "SQLMXTxConnection", "prepareStatement", T4LoggingUtilities.makeParams(this.m_t4props, p_string));
        return pstmt;
    }

    private void checkXaAndThrowSqlException() throws SQLException {
        if (this.m_xa_txnActive) {
            throw SQLMXMessages.createSQLException(this.m_t4props, null, "invalid_tx_operation", null);
        }
    }

    private void throwWhenConnectionClosed() throws SQLException {
        if (this.m_isClosed) {
            throw SQLMXMessages.createSQLException(this.m_t4props, null, "invalid_tx_connection", null);
        }
    }
}

