/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXConnectionPoolDataSource;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXPooledConnection;
import com.tandem.t4jdbc.SQLMXTxConnection;
import com.tandem.t4jdbc.SQLMXXAMessages;
import com.tandem.t4jdbc.SQLMXXAResource;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import com.tandem.t4jdbc.T4XALogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class SQLMXXAConnection
extends SQLMXPooledConnection
implements XAConnection {
    private T4Properties m_t4props;
    private SQLMXTxConnection m_tx_connection;
    SQLMXConnection m_resource_connection;
    private SQLMXXAResource m_xa_res;
    private T4XALogger m_t4XALogger = new T4XALogger((SQLMXConnection)super.getConnection());
    private boolean is_xa_conn_closed = false;

    SQLMXXAConnection(SQLMXConnectionPoolDataSource p_cds, T4Properties t4props) throws SQLException {
        super(p_cds, t4props);
        this.m_t4props = t4props;
        this.m_tx_connection = null;
        this.m_resource_connection = super.getSQLMXConnectionReference();
        if (this.m_t4XALogger.isLoggable(Level.FINE)) {
            this.m_t4XALogger.logAndIgnore("Creating a XAConnection", Level.FINE, "SQLMXXAConnection", "constructor", T4LoggingUtilities.makeParams(this.m_t4props));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.m_t4XALogger.isLoggable(Level.FINE)) {
            this.m_t4XALogger.logAndIgnore("Closing the SQLMXXAConnection", Level.FINE, "SQLMXXAConnection", "close", T4LoggingUtilities.makeParams(this.m_t4props));
        }
        try {
            if (this.m_tx_connection != null && !this.m_tx_connection.isClosed()) {
                this.m_tx_connection.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.is_xa_conn_closed = true;
        }
        this.m_tx_connection = null;
        super.close();
        if (this.m_t4XALogger.isLoggable(Level.FINE)) {
            this.m_t4XALogger.logAndIgnore("Closed the SQLMXXAConnection", Level.FINE, "SQLMXXAConnection", "close", T4LoggingUtilities.makeParams(this.m_t4props));
        }
    }

    void setXA() {
        if (this.m_xa_res != null && this.m_tx_connection != null) {
            this.m_tx_connection.setXA();
        }
    }

    void reSetXA() {
        if (this.m_tx_connection != null) {
            this.m_tx_connection.reSetXA();
        }
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.m_t4XALogger.isLoggable(Level.FINE)) {
            this.m_t4XALogger.logAndIgnore("Acquiring a SQLMXTxConnection.", Level.FINE, "SQLMXXAConnection", "createTxConnection", T4LoggingUtilities.makeParams(this.m_t4props));
        }
        if (super.isClosed() || this.is_xa_conn_closed) {
            XAException xe = SQLMXXAMessages.createXAException(this.m_t4props, this.m_t4props.getLocale(), "invalid_connection", null);
            throw SQLMXMessages.createSQLException(this.m_t4props, this.m_t4props.getLocale(), "error_getting_xa_conn", xe.getMessage());
        }
        SQLMXConnection l_connection = (SQLMXConnection)super.getConnection();
        this.m_tx_connection = new SQLMXTxConnection(l_connection);
        this.setXA();
        if (this.m_t4XALogger.isLoggable(Level.FINE)) {
            this.m_t4XALogger.logAndIgnore("Acquired a SQLMXTxConnection.", Level.FINE, "SQLMXXAConnection", "createTxConnection", T4LoggingUtilities.makeParams(this.m_t4props));
        }
        return this.m_tx_connection;
    }

    public synchronized XAResource getXAResource() throws SQLException {
        this.m_t4XALogger.logAndIgnore("Acquiring a new SQLMXXAResource.", Level.FINE, "SQLMXXAConnection", "getXAResource", T4LoggingUtilities.makeParams(this.m_t4props));
        this.m_resource_connection = super.getSQLMXConnectionReference();
        try {
            this.m_xa_res = new SQLMXXAResource(this, this.m_t4props);
        }
        catch (XAException xaex) {
            SQLMXException sqlex = SQLMXMessages.createSQLException(this.m_t4props, this.m_t4props.getLocale(), "error_getting_XAResource", xaex);
            sqlex.setStackTrace(xaex.getStackTrace());
            throw sqlex;
        }
        this.m_t4XALogger.logAndIgnore("Acquired a new SQLMXXAResource.", Level.FINE, "SQLMXXAConnection", "getXAResource", T4LoggingUtilities.makeParams(this.m_t4props));
        return this.m_xa_res;
    }
}

