/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXConnectionPoolDataSource;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMXXAConnection;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class SQLMXXADataSource
extends SQLMXConnectionPoolDataSource
implements XADataSource {
    public SQLMXXADataSource() {
        try {
            if (this.t4Logger_.isLoggable(Level.FINE)) {
                Object[] p = T4LoggingUtilities.makeParams(null);
                this.t4Logger_.logp(Level.FINE, "SQLMXXADataSource", "Constructor", "", p);
            }
            if (this.getLogWriter() != null) {
                LogRecord lr = new LogRecord(Level.FINE, "");
                Object[] p = T4LoggingUtilities.makeParams(null);
                lr.setParameters(p);
                lr.setSourceClassName("SQLMXXADataSource");
                lr.setSourceMethodName("Constructor");
                T4LogFormatter lf = new T4LogFormatter();
                String temp = lf.format(lr);
                this.getLogWriter().println(temp);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized XAConnection getXAConnection() throws SQLException {
        Properties l_props;
        T4Properties l_t4props;
        if (this.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null);
            this.t4Logger_.logp(Level.FINE, "SQLMXXADataSource", "getXAConnection", "", p);
        }
        if (this.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(null);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXXADataSource");
            lr.setSourceMethodName("getXAConnection");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.getLogWriter().println(temp);
        }
        if ((l_t4props = new T4Properties(l_props = super.getProperties())).getMaxPoolSize() > -1) {
            throw SQLMXMessages.createSQLException(l_t4props, l_t4props.getLocale(), "xa_t4_connection_pool_not_supported", "T4 connection pooling is supported for XA connections. Set maxPoolSize to -1.");
        }
        return new SQLMXXAConnection(this, l_t4props);
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        if (this.t4Logger_.isLoggable(Level.FINE)) {
            Object[] p = T4LoggingUtilities.makeParams(null, (Object)user, (Object)"password=****");
            this.t4Logger_.logp(Level.FINE, "SQLMXXADataSource", "getXAConnection", "", p);
        }
        if (this.getLogWriter() != null) {
            LogRecord lr = new LogRecord(Level.FINE, "");
            Object[] p = T4LoggingUtilities.makeParams(null);
            lr.setParameters(p);
            lr.setSourceClassName("SQLMXXADataSource");
            lr.setSourceMethodName("getXAConnection");
            T4LogFormatter lf = new T4LogFormatter();
            String temp = lf.format(lr);
            this.getLogWriter().println(temp);
        }
        this.setUser(user);
        this.setPassword(password);
        return this.getXAConnection();
    }
}

