/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.BrkXaReply;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXXAConnection;
import com.tandem.t4jdbc.SQLMXXAConnectionState;
import com.tandem.t4jdbc.SQLMXXAMessages;
import com.tandem.t4jdbc.SQLMXXid;
import com.tandem.t4jdbc.StateAlreadyCommitted;
import com.tandem.t4jdbc.StateAlreadyRolledback;
import com.tandem.t4jdbc.StateCommit;
import com.tandem.t4jdbc.StateEnd;
import com.tandem.t4jdbc.StateJoin;
import com.tandem.t4jdbc.StatePrepare;
import com.tandem.t4jdbc.StateReadOnly;
import com.tandem.t4jdbc.StateRollback;
import com.tandem.t4jdbc.StateStart;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import com.tandem.t4jdbc.T4XAExecute;
import com.tandem.t4jdbc.T4XALogger;
import com.tandem.t4jdbc.XAInputOutputStateParameter;
import com.tandem.t4jdbc.XAResourceState;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SQLMXXAResource
implements XAResource {
    protected T4Properties m_t4props;
    String m_rmname;
    private BrkXaReply m_bxr_ = null;
    private int m_timeout = 0;
    private SQLMXConnection m_resource_connection;
    protected SQLMXXAConnection m_xaConnection;
    protected T4XALogger m_t4XALogger;
    protected T4XAExecute m_t4XAexe;
    static SQLMXXAConnectionState g_connection_state_obj;

    SQLMXXAResource(SQLMXXAConnection p_xaConnection, T4Properties t4props) throws XAException, SQLException {
        this.m_xaConnection = p_xaConnection;
        this.m_resource_connection = p_xaConnection.m_resource_connection;
        this.m_t4XALogger = new T4XALogger(this.m_resource_connection);
        this.m_t4props = t4props;
        StringBuffer tmpName = new StringBuffer(t4props.getServerDataSource());
        tmpName = tmpName.append('-');
        tmpName = tmpName.append(t4props.getUrl());
        tmpName = tmpName.append(t4props.getUser());
        this.m_rmname = new String(tmpName);
        SQLMXXAResource.setStateObj();
        try {
            if (this.m_resource_connection == null || this.m_resource_connection.isClosed()) {
                throw SQLMXXAMessages.createXAException(this.m_t4props, this.m_t4props.getLocale(), "xa_connection_closed", null);
            }
        }
        catch (SQLException se) {
            XAException xaex = new XAException("Error with connection to resource manager.");
            xaex.setStackTrace(se.getStackTrace());
            throw xaex;
        }
        this.m_t4XAexe = new T4XAExecute(this.m_t4props, this.m_resource_connection);
        this.m_t4XALogger.log("Acquired an XA resource.", Level.FINE, "SQLMXXAResource", "Constructor", T4LoggingUtilities.makeParams(this.m_t4props));
    }

    private static synchronized void setStateObj() {
        if (g_connection_state_obj == null) {
            g_connection_state_obj = new SQLMXXAConnectionState();
        }
    }

    public synchronized int prepare(Xid p_xid) throws XAException {
        SQLMXXid l_nsk_xid = new SQLMXXid(this.m_t4props, p_xid);
        this.m_t4XALogger.log("Entering prepare", Level.FINE, "SQLMXXAResource", "prepare", T4LoggingUtilities.makeParams(this.m_t4props, l_nsk_xid.toString()));
        int l_xarm_retval = 3;
        XAResourceState nextState = null;
        XAInputOutputStateParameter l_xaio = new XAInputOutputStateParameter(l_nsk_xid, this, XAResourceState.prepareState, -1);
        try {
            nextState = g_connection_state_obj.prepare(l_xaio);
        }
        catch (XAException xaex1) {
            this.m_t4XALogger.log("Cannot prepare XID = " + l_nsk_xid, Level.SEVERE, "SQLMXXAResource", "prepare", T4LoggingUtilities.makeParams(this.m_t4props, l_nsk_xid.toString()));
            g_connection_state_obj.removeState(l_xaio);
            XAException xaex = new XAException("Cannot prepare XID = " + l_nsk_xid);
            xaex.setStackTrace(xaex1.getStackTrace());
            throw xaex;
        }
        l_xaio = new XAInputOutputStateParameter(l_nsk_xid, this, XAResourceState.readOnlyState, -1);
        if (nextState instanceof StateReadOnly) {
            g_connection_state_obj.setPrepare(l_xaio);
            l_xarm_retval = 3;
        } else if (nextState instanceof StatePrepare) {
            this.m_bxr_ = this.m_t4XAexe.XAPREPARE(l_nsk_xid);
            l_xarm_retval = this.m_bxr_.getXARMretval();
            this.checkForXARMError(this.m_bxr_, l_xaio);
            g_connection_state_obj.setPrepare(l_xaio);
        }
        this.m_t4XALogger.log("Exiting prepare", Level.FINE, "SQLMXXAResource", "prepare", T4LoggingUtilities.makeParams(this.m_t4props, l_nsk_xid.toString()));
        return l_xarm_retval;
    }

    public synchronized void commit(Xid p_xid, boolean onePhase) throws XAException {
        SQLMXXid l_nsk_xid = new SQLMXXid(this.m_t4props, p_xid);
        this.m_t4XALogger.log("Entering commit", Level.FINE, "SQLMXXAResource", "commit", T4LoggingUtilities.makeParams(this.m_t4props, (Object)l_nsk_xid.toString(), onePhase));
        XAResourceState nextState = null;
        XAInputOutputStateParameter l_xaio = null;
        try {
            l_xaio = new XAInputOutputStateParameter(l_nsk_xid, this, XAResourceState.commitState, -1);
            nextState = g_connection_state_obj.commit(l_xaio);
        }
        catch (XAException xaex1) {
            this.m_t4XALogger.log("Cannot commit XID = " + l_nsk_xid, Level.SEVERE, "SQLMXXAResource", "commit", T4LoggingUtilities.makeParams(this.m_t4props, (Object)l_nsk_xid.toString(), onePhase));
            XAException xaex = new XAException("Cannot commit XID = " + l_nsk_xid.toString());
            xaex1.setStackTrace(xaex.getStackTrace());
            throw xaex1;
        }
        if (!(nextState instanceof StateAlreadyCommitted) && nextState instanceof StateCommit) {
            this.m_bxr_ = this.m_t4XAexe.XACOMMIT(l_nsk_xid, onePhase);
            this.checkForXARMError(this.m_bxr_, l_xaio);
            g_connection_state_obj.setCommit(l_xaio);
        }
        this.m_t4XALogger.log("Commited XID = " + l_nsk_xid, Level.FINE, "SQLMXXAResource", "commit", T4LoggingUtilities.makeParams(this.m_t4props, (Object)l_nsk_xid.toString(), onePhase));
    }

    public synchronized void rollback(Xid p_xid) throws XAException {
        XAResourceState nextState;
        SQLMXXid l_nsk_xid = new SQLMXXid(this.m_t4props, p_xid);
        this.m_t4XALogger.log("Entering rollback", Level.FINE, "SQLMXXAResource", "rollback", T4LoggingUtilities.makeParams(this.m_t4props, l_nsk_xid.toString()));
        XAInputOutputStateParameter l_xaio = new XAInputOutputStateParameter(l_nsk_xid, this, XAResourceState.rollbackState, -1);
        try {
            nextState = g_connection_state_obj.rollback(l_xaio);
        }
        catch (XAException xaex1) {
            this.m_t4XALogger.log("Cannot rollback XID = " + l_nsk_xid.toString(), Level.SEVERE, "SQLMXXAResource", "rollback", T4LoggingUtilities.makeParams(this.m_t4props, l_nsk_xid.toString()));
            XAException xaex = new XAException("Cannot rollback XID = " + p_xid);
            xaex.setStackTrace(xaex1.getStackTrace());
            throw xaex;
        }
        if (!(nextState instanceof StateAlreadyRolledback)) {
            if (nextState instanceof StateRollback) {
                this.m_bxr_ = this.m_t4XAexe.XAROLLBACK(l_nsk_xid);
                this.checkForXARMError(this.m_bxr_, l_xaio);
                g_connection_state_obj.setRollback(l_xaio);
            } else if (nextState instanceof StateEnd) {
                try {
                    this.end(p_xid, 0x20000000);
                }
                catch (XAException xaex) {
                    this.m_t4XALogger.log("End for Rollback failed.", Level.SEVERE, "SQLMXXAResource", "rollback", T4LoggingUtilities.makeParams(this.m_t4props, l_nsk_xid.toString()));
                }
                this.m_bxr_ = this.m_t4XAexe.XAROLLBACK(l_nsk_xid);
                try {
                    this.checkForXARMError(this.m_bxr_, l_xaio);
                }
                catch (XAException xaex) {
                    if (xaex.errorCode != -4) {
                        this.m_t4XALogger.log("Rollback failed.", Level.SEVERE, "SQLMXXAResource", "rollback", T4LoggingUtilities.makeParams(this.m_t4props, l_nsk_xid.toString()));
                    }
                    this.m_t4XALogger.log("Transaction already rolledback.", Level.WARNING, "SQLMXXAResource", "rollback", T4LoggingUtilities.makeParams(this.m_t4props, l_nsk_xid.toString()));
                }
                g_connection_state_obj.setRollback(l_xaio);
            }
        }
        this.m_t4XALogger.log("Exiting rollback.", Level.FINE, "SQLMXXAResource", "rollback", T4LoggingUtilities.makeParams(this.m_t4props, l_nsk_xid.toString()));
    }

    public synchronized void end(Xid p_xid, int flag) throws XAException {
        String s_xid = SQLMXXid.toString(p_xid);
        this.m_t4XALogger.log("Entering end", Level.FINE, "SQLMXXAResource", "end", T4LoggingUtilities.makeParams(this.m_t4props, (Object)s_xid, flag));
        SQLMXXid l_xid = new SQLMXXid(this.m_t4props, p_xid);
        this.m_bxr_ = null;
        XAResourceState nextState = null;
        XAInputOutputStateParameter l_xaio = new XAInputOutputStateParameter(l_xid, this, XAResourceState.endState, flag);
        switch (flag) {
            case 0x2000000: 
            case 0x4000000: 
            case 0x20000000: {
                try {
                    nextState = g_connection_state_obj.end(l_xaio);
                }
                catch (XAException xaex1) {
                    this.m_t4XALogger.log("Cannot end XID = " + l_xid.toString(), Level.SEVERE, "SQLMXXAResource", "end", T4LoggingUtilities.makeParams(this.m_t4props, (Object)l_xid.toString(), flag));
                    XAException xaex = new XAException("Cannot end XID = " + l_xid.toString());
                    xaex.setStackTrace(xaex1.getStackTrace());
                    throw xaex;
                }
                if (!(nextState instanceof StateEnd)) break;
                this.m_bxr_ = this.m_t4XAexe.XAEND(l_xid, flag);
                g_connection_state_obj.setEnd(l_xaio);
                this.checkForXARMError(this.m_bxr_, l_xaio);
                this.m_xaConnection.reSetXA();
                break;
            }
            default: {
                this.m_t4XALogger.log("XAException.XAER_INVAL error detected for XID = " + l_xid.toString(), Level.FINE, "SQLMXXAResource", "end", T4LoggingUtilities.makeParams(this.m_t4props, (Object)l_xid.toString(), flag));
                throw new XAException(-5);
            }
        }
        this.m_t4XALogger.log("Exiting end", Level.FINE, "SQLMXXAResource", "end", T4LoggingUtilities.makeParams(this.m_t4props, (Object)s_xid, flag));
    }

    public void forget(Xid p_xid) throws XAException {
        SQLMXXid l_xid = new SQLMXXid(this.m_t4props, p_xid);
        this.m_t4XALogger.log("Entering forget", Level.FINE, "SQLMXXAResource", "forget", T4LoggingUtilities.makeParams(this.m_t4props, l_xid.toString()));
        XAInputOutputStateParameter l_xaio = new XAInputOutputStateParameter(l_xid, this, XAResourceState.forgetState, -1);
        this.m_bxr_ = this.m_t4XAexe.XAFORGET(l_xid);
        this.checkForXARMError(this.m_bxr_, l_xaio);
        this.m_t4XALogger.log("Exiting forget", Level.FINE, "SQLMXXAResource", "forget", T4LoggingUtilities.makeParams(this.m_t4props, l_xid.toString()));
    }

    public int getTransactionTimeout() throws XAException {
        this.m_t4XALogger.log("Entering getTransactionTimeout", Level.FINE, "SQLMXXAResource", "getTransactionTimeout", T4LoggingUtilities.makeParams(this.m_t4props));
        if (this.m_timeout == 0) {
            this.m_bxr_ = this.m_t4XAexe.XAGET_TIMEOUT();
            this.m_timeout = this.m_bxr_.getXARMretval();
        }
        this.m_t4XALogger.log("Timeout is = " + this.m_timeout, Level.FINE, "SQLMXXAResource", "getTransactionTimeout", T4LoggingUtilities.makeParams(this.m_t4props));
        return this.m_timeout;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        this.m_t4XALogger.log("Entering isSameRM", Level.FINE, "SQLMXXAResource", "isSameRM", T4LoggingUtilities.makeParams(this.m_t4props, "this.rmname = " + this.m_rmname));
        boolean isSameRM = false;
        if (xares != null && xares instanceof SQLMXXAResource) {
            SQLMXXAResource sqlmxXAres = (SQLMXXAResource)xares;
            isSameRM = sqlmxXAres.m_rmname.equals(this.m_rmname);
        }
        this.m_t4XALogger.log("Exiting isSameRM", Level.FINE, "SQLMXXAResource", "isSameRM", T4LoggingUtilities.makeParams(this.m_t4props, isSameRM));
        return isSameRM;
    }

    public String toString() {
        return "Thread-hashcode = " + Thread.currentThread().getName() + "-" + this.hashCode();
    }

    public Xid[] recover(int flag) throws XAException {
        this.m_t4XALogger.log("Entering recover", Level.FINE, "SQLMXXAResource", "recover", T4LoggingUtilities.makeParams(this.m_t4props, flag));
        Xid[] l_xids = null;
        switch (flag) {
            case 0: 
            case 0x1000000: 
            case 0x1800000: {
                this.m_bxr_ = this.m_t4XAexe.XARECOVER(0x1800000);
                l_xids = this.m_bxr_.getXids();
                break;
            }
            case 0x800000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.m_t4XALogger.log("Exiting recover", Level.FINE, "SQLMXXAResource", "recover", T4LoggingUtilities.makeParams(this.m_t4props, flag));
        return l_xids;
    }

    public boolean setTransactionTimeout(int p_timeout) throws XAException {
        this.m_timeout = p_timeout;
        this.m_t4XALogger.log("Setting timeout", Level.FINE, "SQLMXXAResource", "setTransactionTimeout", T4LoggingUtilities.makeParams(this.m_t4props, p_timeout));
        boolean l_xarm_retval = this.m_t4XAexe.XASET_TIMEOUT(p_timeout);
        this.m_t4XALogger.log("Set timeout.", Level.FINE, "SQLMXXAResource", "setTransactionTimeout", T4LoggingUtilities.makeParams(this.m_t4props, p_timeout));
        return l_xarm_retval;
    }

    public synchronized void start(Xid p_xid, int p_flags) throws XAException {
        this.m_t4XALogger.log("Starting " + this.toString(), Level.FINE, "SQLMXXAResource", "start", T4LoggingUtilities.makeParams(this.m_t4props, (Object)SQLMXXid.toString(p_xid), p_flags));
        SQLMXXid l_xid = new SQLMXXid(this.m_t4props, p_xid);
        XAResourceState nextState = null;
        switch (p_flags) {
            case 0: 
            case 0x200000: 
            case 0x8000000: {
                try {
                    nextState = g_connection_state_obj.start(new XAInputOutputStateParameter(l_xid, this, XAResourceState.startState, p_flags));
                }
                catch (XAException xaex) {
                    this.m_t4XALogger.log("Cannot start XID = " + l_xid.toString(), Level.SEVERE, "SQLMXXAResource", "start", T4LoggingUtilities.makeParams(this.m_t4props, (Object)l_xid.toString(), p_flags));
                    XAException xaex1 = new XAException("Cannot start XID = " + l_xid.toString());
                    xaex1.setStackTrace(xaex.getStackTrace());
                    throw xaex1;
                }
                if (nextState instanceof StateReadOnly) {
                    g_connection_state_obj.setStart(new XAInputOutputStateParameter(l_xid, this, XAResourceState.startState, p_flags));
                    break;
                }
                if (nextState instanceof StateStart) {
                    this.startTransaction(p_xid, p_flags);
                    g_connection_state_obj.setStart(new XAInputOutputStateParameter(l_xid, this, XAResourceState.startState, p_flags));
                    break;
                }
                if (!(nextState instanceof StateJoin)) break;
                this.startTransaction(p_xid, 0x200000);
                g_connection_state_obj.setStart(new XAInputOutputStateParameter(l_xid, this, XAResourceState.startState, 0x200000));
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        this.m_t4XALogger.log("Started " + this.toString(), Level.FINE, "SQLMXXAResource", "start", T4LoggingUtilities.makeParams(this.m_t4props, (Object)l_xid.toString(), p_flags));
    }

    protected void startTransaction(Xid p_xid, int p_flags) throws XAException {
        SQLMXXid l_xid = new SQLMXXid(this.m_t4props, p_xid);
        XAInputOutputStateParameter l_xaio = new XAInputOutputStateParameter(l_xid, this, XAResourceState.startState, p_flags);
        this.m_bxr_ = this.m_t4XAexe.XASTART(l_xid, p_flags);
        this.checkForXARMError(this.m_bxr_, l_xaio);
    }

    int getTxnState() throws XAException {
        this.m_bxr_ = this.m_t4XAexe.XAGET_TXN_STATE();
        int l_gw_status = this.m_bxr_.getBrkStatus();
        return l_gw_status;
    }

    static String getXAStatusString(int p_xarm_retval) {
        String xa_exp_string = null;
        switch (p_xarm_retval) {
            case 0: 
            case 3: {
                break;
            }
            case 7: {
                xa_exp_string = "XA_HEURCOM: The transaction branch has been heuristically committed.";
                break;
            }
            case 8: {
                xa_exp_string = "XA_HEURHAZ: The transaction branch may have been heuristically completed.";
                break;
            }
            case 5: {
                xa_exp_string = "XA_HEURMIX: The transaction branch has been heuristically committed and rolled back.";
                break;
            }
            case 6: {
                xa_exp_string = "XA_HEURRB: The transaction branch has been heuristically rolled back.";
                break;
            }
            case 9: {
                xa_exp_string = "XA_NOMIGRATE: Resumption must occur where the suspension occurred.";
                break;
            }
            case 100: {
                xa_exp_string = "XA_RBBASE: The inclusive lower bound of the rollback codes.";
                break;
            }
            case 101: {
                xa_exp_string = "XA_RBCOMMFAIL: Indicates that the rollback was caused by a communication failure.";
                break;
            }
            case 102: {
                xa_exp_string = "XA_RBDEADLOCK: A deadlock was detected.";
                break;
            }
            case 107: {
                xa_exp_string = "XA_RBEND: The inclusive upper bound of the rollback error code.";
                break;
            }
            case 103: {
                xa_exp_string = "XA_RBINTEGRITY: A condition that violates the integrity of the resource was detected.";
                break;
            }
            case 104: {
                xa_exp_string = "XA_RBOTHER: The resource manager rolled back the transaction branch for a reason not on this list.";
                break;
            }
            case 105: {
                xa_exp_string = "XA_RBPROTO: A protocol error occurred in the resource manager.";
                break;
            }
            case 106: {
                xa_exp_string = "XA_RBTIMEOUT: A transaction branch took too long.";
                break;
            }
            case 4: {
                xa_exp_string = "XA_RETRY: Routine returned with no effect and may be reissued.";
                break;
            }
            case -2: {
                xa_exp_string = "XAER_ASYNC: There is an asynchronous operation already outstanding.";
                break;
            }
            case -8: {
                xa_exp_string = "XAER_DUPID: The XID already exists.";
                break;
            }
            case -5: {
                xa_exp_string = "XAER_INVAL: Invalid arguments were given.";
                break;
            }
            case -4: {
                xa_exp_string = "XAER_NOTA: The XID is not valid";
                break;
            }
            case -9: {
                xa_exp_string = "XAER_OUTSIDE: The resource manager is doing work outside a global transaction.";
                break;
            }
            case -6: {
                xa_exp_string = "XAER_PROTO: Routine was invoked in an inproper context.";
                break;
            }
            case -3: {
                xa_exp_string = "XAER_RMERR: NSK resource manager error has occurred in the transaction branch.";
                break;
            }
            case -7: {
                xa_exp_string = "XAER_RMFAIL: Resource manager is unavailable.";
                break;
            }
            default: {
                xa_exp_string = "Unknown value returned by the XARM";
            }
        }
        return xa_exp_string;
    }

    protected void checkForXARMError(BrkXaReply p_bxr, XAInputOutputStateParameter p_xaio) throws XAException {
        String xa_exp_string = null;
        int l_xarm_retval = p_bxr.getXARMretval();
        xa_exp_string = SQLMXXAResource.getXAStatusString(l_xarm_retval);
        if (xa_exp_string != null) {
            xa_exp_string = xa_exp_string + ". rmval = " + l_xarm_retval;
            this.m_t4XALogger.log("XAException occured = " + xa_exp_string, Level.SEVERE, "SQLMXXAResource", "checkForXARMError", T4LoggingUtilities.makeParams(this.m_t4props, p_bxr));
            switch (l_xarm_retval) {
                case -9: 
                case -7: 
                case -4: 
                case -3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 106: 
                case 107: {
                    g_connection_state_obj.removeState(p_xaio);
                    break;
                }
            }
            XAException xaexp1 = new XAException(xa_exp_string);
            xaexp1.errorCode = l_xarm_retval;
            throw xaexp1;
        }
    }
}

