/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.CONNECTION_CONTEXT_def;
import com.tandem.t4jdbc.ConnectMessage;
import com.tandem.t4jdbc.ConnectReply;
import com.tandem.t4jdbc.InputOutput;
import com.tandem.t4jdbc.InterfaceConnection;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4Address;
import com.tandem.t4jdbc.T4Properties;
import com.tandem.t4jdbc.USER_DESC_def;
import com.tandem.t4jdbc.Vproc;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;
import java.util.Locale;

class SQLMX_AssociationServer_Connect {
    SQLMX_AssociationServer_Connect() {
    }

    static ConnectReply getConnection(T4Properties t4props, InterfaceConnection ic_, CONNECTION_CONTEXT_def inContext, USER_DESC_def userDesc, int srvrType, short retryCount) throws SQLException {
        Locale locale = ic_.getLocale();
        if (inContext == null || userDesc == null) {
            SQLMXException se = SQLMXMessages.createSQLException(t4props, locale, "internal_error", null);
            SQLMXException se2 = SQLMXMessages.createSQLException(t4props, locale, "contact_hp_error", null);
            se.setNextException(se2);
            throw se;
        }
        try {
            LogicalByteArray wbuffer = ConnectMessage.marshal(inContext, userDesc, srvrType, retryCount, 0, 0, Vproc.getVproc(), ic_);
            T4Address address1 = new T4Address(t4props, locale, ic_.getUrl());
            InputOutput io1 = address1.getInputOutput();
            io1.openIO();
            io1.setTimeout(ic_.getLoginTimeout());
            io1.setConnectionIdleTimeout(ic_.getConnectionTimeout());
            LogicalByteArray rbuffer = io1.doIO((short)1019, wbuffer);
            ConnectReply cr1 = new ConnectReply(rbuffer, ic_);
            io1.setTimeout(ic_.t4props_.getLoginTimeout());
            io1.CloseIO(wbuffer);
            String name1 = null;
            if (address1.m_ipAddress != null) {
                name1 = address1.m_ipAddress;
            } else if (address1.m_machineName != null) {
                name1 = address1.m_machineName;
            }
            cr1.fixupSrvrObjRef(t4props, locale, name1);
            return cr1;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (CharacterCodingException e) {
            SQLMXException se = SQLMXMessages.createSQLException(ic_.t4props_, locale, "translation_of_parameter_failed", "ConnectMessage", e.getMessage());
            se.initCause(e);
            throw se;
        }
        catch (UnsupportedCharsetException e) {
            SQLMXException se = SQLMXMessages.createSQLException(ic_.t4props_, locale, "unsupported_encoding", e.getCharsetName());
            se.initCause(e);
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(t4props, locale, "as_connect_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }
}

