/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Address;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4Properties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;

final class T4Address
extends Address {
    private static final String t4ConnectionPrefix = "jdbc:t4sqlmx:";
    private static final String urlPrefix = "jdbc:t4sqlmx://";
    private static final int minT4ConnectionAddrLen = "jdbc:t4sqlmx:".length() + 4;
    private static final int AS_type = 1;

    T4Address(T4Properties t4props, Locale locale, String addr) throws SQLException {
        super(t4props, locale, addr);
        if (addr == null) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_null_error", null);
            throw se;
        }
        this.m_type = 1;
        if (!T4Address.acceptsURL(addr)) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_parsing_error", addr);
            SQLMXException se2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "unknown_prefix_error", null);
            se.setNextException(se2);
            throw se;
        }
        String IPorName = this.extractHostFromUrl(addr);
        if (this.isIPAddress(IPorName)) {
            this.m_ipAddress = IPorName;
        } else {
            this.m_machineName = IPorName;
        }
        this.m_portNumber = new Integer(this.extractPortFromUrl(addr));
        this.m_properties = this.extractPropertiesFromString(addr);
        this.m_url = this.recreateAddress();
        this.validateAddress();
        this.setInputOutput();
    }

    String recreateAddress() {
        String addr = null;
        addr = urlPrefix;
        if (this.m_machineName != null) {
            addr = addr + this.m_machineName;
        } else if (this.m_ipAddress != null) {
            addr = addr + this.m_ipAddress;
        }
        if (this.m_portNumber != null) {
            addr = addr + ":" + this.m_portNumber;
        }
        addr = addr + "/";
        return addr;
    }

    static boolean acceptsURL(String url) throws SQLException {
        try {
            return url.toLowerCase().startsWith(t4ConnectionPrefix);
        }
        catch (Exception ex) {
            throw new SQLException(ex.toString());
        }
    }

    String getUrl() {
        return urlPrefix + this.getIPorName() + ':' + this.getPort().toString() + "/:";
    }

    Properties getProps() {
        return this.m_properties;
    }

    private String extractHostFromUrl(String url) throws SQLException {
        if (url.length() < minT4ConnectionAddrLen) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_parsing_error", url);
            SQLMXException se2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "min_address_length_error", null);
            se.setNextException(se2);
            throw se;
        }
        int hostStartIndex = urlPrefix.length();
        int hostEndIndex = -1;
        hostEndIndex = this.isIPV6(url) ? url.lastIndexOf(93, hostStartIndex) : url.indexOf(58, hostStartIndex);
        if (hostEndIndex < 0) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_parsing_error", url);
            SQLMXException se2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_format_error", url);
            se.setNextException(se2);
            throw se;
        }
        String host = url.substring(hostStartIndex, hostEndIndex);
        if (host == null || host.length() == 0) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_parsing_error", url);
            SQLMXException se2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_format_error", null);
            SQLMXException se3 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "missing_ip_or_name_error", null);
            se.setNextException(se2);
            se2.setNextException(se3);
            throw se;
        }
        return host;
    }

    private String extractPortFromUrl(String url) throws SQLException {
        int asPort;
        String port;
        int portStartIndex = url.indexOf(58, urlPrefix.length()) + 1;
        int portEndIndex = url.indexOf(47, portStartIndex);
        if (portEndIndex < 0) {
            portEndIndex = url.length();
        }
        if ((port = url.substring(portStartIndex, portEndIndex)).length() < 1) {
            throw new SQLException("Incorrect port value in the URL.");
        }
        try {
            asPort = Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new SQLException("Incorrect port value in the URL.");
        }
        if (asPort < 0 || asPort > 65535) {
            throw new SQLException("Port value out of range in the URL.");
        }
        return port;
    }

    private boolean isIPV6(String url) throws SQLException {
        if (url == null) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_parsing_error", url);
            SQLMXException se2 = SQLMXMessages.createSQLException(this.m_t4props, this.m_locale, "address_format_2_error", null);
            se.setNextException(se2);
            throw se;
        }
        int hostStartIndex = urlPrefix.length();
        return url.charAt(hostStartIndex) == '[';
    }

    private Properties extractPropertiesFromString(String url) throws SQLException {
        int urLength = url.length();
        int hostStartIndex = urlPrefix.length();
        int propStartIndex = url.indexOf(47, hostStartIndex);
        if (propStartIndex < 0) {
            return null;
        }
        if (propStartIndex == urLength) {
            return null;
        }
        if (url.charAt(propStartIndex) == '/') {
            ++propStartIndex;
        }
        if (propStartIndex == urLength) {
            return null;
        }
        if (url.charAt(propStartIndex) == ':') {
            ++propStartIndex;
        }
        if (propStartIndex == urLength) {
            return null;
        }
        String propStr = url.substring(propStartIndex);
        if (propStr == null || propStr.length() == 0) {
            return null;
        }
        Properties props = new Properties();
        propStr = propStr.replace(';', '\n');
        ByteArrayInputStream byteArrIPStream = new ByteArrayInputStream(propStr.getBytes());
        try {
            props.load(byteArrIPStream);
        }
        catch (IOException ioex) {
            throw new SQLException(ioex.getMessage());
        }
        return props;
    }

    private boolean isIPAddress(String IPorName) {
        if (IPorName.length() < 7) {
            return false;
        }
        return Character.isDigit(IPorName.charAt(0)) || IPorName.charAt(1) == ':';
    }
}

