/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.CONNECTION_CONTEXT_def;
import com.tandem.t4jdbc.EndTransactionMessage;
import com.tandem.t4jdbc.EndTransactionReply;
import com.tandem.t4jdbc.GetSQLCatalogsMessage;
import com.tandem.t4jdbc.GetSQLCatalogsReply;
import com.tandem.t4jdbc.InitializeDialogueMessage;
import com.tandem.t4jdbc.InitializeDialogueReply;
import com.tandem.t4jdbc.InputOutput;
import com.tandem.t4jdbc.InterfaceConnection;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.MXCSAddress;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SetConnectionOptionMessage;
import com.tandem.t4jdbc.SetConnectionOptionReply;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import com.tandem.t4jdbc.TerminateDialogueMessage;
import com.tandem.t4jdbc.TerminateDialogueReply;
import com.tandem.t4jdbc.USER_DESC_def;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.Level;

class T4Connection {
    protected Locale m_locale;
    protected int m_dialogueId;
    protected MXCSAddress m_ncsAddress;
    private InputOutput m_io;
    private USER_DESC_def m_userDesc;
    private CONNECTION_CONTEXT_def m_inContext;
    private String m_sessionName;
    InterfaceConnection m_ic;
    static final long INCONTEXT_OPT1_SESSIONNAME = Integer.MIN_VALUE;
    static final long INCONTEXT_OPT1_FETCHAHEAD = 0x40000000L;

    T4Connection(InterfaceConnection ic) throws SQLException {
        if (ic == null) {
            this.throwInternalException();
        }
        this.m_ic = ic;
        this.m_locale = ic.getLocale();
        this.m_dialogueId = ic.getDialogueId();
        this.m_ncsAddress = ic.getMXCSAddress();
        this.m_userDesc = ic.getUserDescription();
        this.m_inContext = ic.getInContext();
        this.m_sessionName = ic.getSessionName();
        if (this.m_dialogueId < 1 || this.m_ncsAddress == null || this.m_userDesc == null || this.m_inContext == null) {
            this.throwInternalException();
        }
        this.m_io = this.m_ncsAddress.getInputOutput();
        if (this.m_io == null) {
            this.throwInternalException();
        }
        this.m_io.setDialogueId(this.m_dialogueId);
        this.m_io.setConnectionIdleTimeout(ic.getConnectionTimeout());
        this.m_io.setT4Connection(this);
        this.m_io.openIO();
        this.getInputOutput().setTimeout(ic.getLoginTimeout());
        this.checkConnectionIdleTimeout();
        this.resetConnectionIdleTimeout();
    }

    public void finalizer() {
        this.closeTimers();
    }

    protected int getDialogueId() {
        return this.m_dialogueId;
    }

    protected Locale getLocale() {
        return this.m_locale;
    }

    protected String getSessionName() {
        return this.m_sessionName;
    }

    protected MXCSAddress getNCSAddress() {
        return this.m_ncsAddress;
    }

    void closeTimers() {
        if (this.m_io != null) {
            this.m_io.closeTimers();
        }
    }

    protected void reuse() {
        this.resetConnectionIdleTimeout();
    }

    private void setConnectionIdleTimeout() {
        this.m_io.startConnectionIdleTimeout();
    }

    private void resetConnectionIdleTimeout() {
        this.m_io.resetConnectionIdleTimeout();
    }

    private void checkConnectionIdleTimeout() throws SQLException {
        if (this.m_io.checkConnectionIdleTimeout()) {
            try {
                this.m_ic.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "ids_s1_t00", null);
        }
    }

    protected boolean connectionIdleTimeoutOccured() {
        return this.m_io.checkConnectionIdleTimeout();
    }

    protected InputOutput getInputOutput() throws SQLException {
        this.checkConnectionIdleTimeout();
        this.resetConnectionIdleTimeout();
        return this.m_io;
    }

    protected void throwInternalException() throws SQLException {
        T4Properties tempP = null;
        if (this.m_ic != null) {
            tempP = this.m_ic.t4props_;
        }
        SQLMXException se = SQLMXMessages.createSQLException(tempP, this.m_locale, "internal_error", null);
        SQLMXException se2 = SQLMXMessages.createSQLException(tempP, this.m_locale, "contact_hp_error", null);
        se.setNextException(se2);
        throw se;
    }

    protected LogicalByteArray getReadBuffer(short odbcAPI, LogicalByteArray wbuffer) throws SQLException {
        if (this.m_ic.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
            Object[] p = T4LoggingUtilities.makeParams(this.m_ic.t4props_);
            String temp = "LogicalByteArray";
            this.m_ic.t4props_.t4Logger_.logp(Level.FINEST, "T4Connection", "getReadBuffer", temp, p);
        }
        LogicalByteArray rbuffer = this.m_io.doIO(odbcAPI, wbuffer);
        return rbuffer;
    }

    InitializeDialogueReply InitializeDialogue() throws SQLException {
        try {
            int optionFlags1 = 0;
            int optionFlags2 = 0;
            if (this.m_sessionName != null && this.m_sessionName.length() > 0) {
                optionFlags1 = (int)((long)optionFlags1 | Integer.MIN_VALUE);
            }
            if (this.m_ic.t4props_.getFetchAhead()) {
                optionFlags1 = (int)((long)optionFlags1 | 0x40000000L);
            }
            if (this.m_ic.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                Object[] p = T4LoggingUtilities.makeParams(this.m_ic.t4props_);
                String temp = "m_dialogueId=" + this.m_dialogueId;
                this.m_ic.t4props_.t4Logger_.logp(Level.FINEST, "T4Connection", "InitializeDialogue", temp, p);
            }
            LogicalByteArray wbuffer = InitializeDialogueMessage.marshal(this.m_userDesc, this.m_inContext, this.m_dialogueId, optionFlags1, optionFlags2, this.m_sessionName, this.m_ic);
            this.getInputOutput().setTimeout(this.m_ic.t4props_.getLoginTimeout());
            LogicalByteArray rbuffer = this.getReadBuffer((short)3001, wbuffer);
            InitializeDialogueReply idr1 = new InitializeDialogueReply(rbuffer, this.m_ncsAddress.getIPorName(), this.m_ic);
            return idr1;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (CharacterCodingException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "translation_of_parameter_failed", "InitializeDialogueMessage", e.getMessage());
            se.initCause(e);
            throw se;
        }
        catch (UnsupportedCharsetException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "unsupported_encoding", e.getCharsetName());
            se.initCause(e);
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "initialize_dialogue_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    TerminateDialogueReply TerminateDialogue() throws SQLException {
        try {
            if (this.m_ic.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                Object[] p = T4LoggingUtilities.makeParams(this.m_ic.t4props_);
                String temp = "m_dialogueId=" + this.m_dialogueId;
                this.m_ic.t4props_.t4Logger_.logp(Level.FINEST, "T4Connection", "TerminateDialogue", temp, p);
            }
            LogicalByteArray wbuffer = TerminateDialogueMessage.marshal(this.m_dialogueId, this.m_ic);
            this.m_io.setTimeout(this.m_ic.t4props_.getLoginTimeout());
            LogicalByteArray rbuffer = this.getReadBuffer((short)3002, wbuffer);
            TerminateDialogueReply tdr1 = new TerminateDialogueReply(rbuffer, this.m_ncsAddress.getIPorName(), this.m_ic);
            if (tdr1.m_p1.exception_nr == 0) {
                this.m_io.CloseIO(wbuffer);
            }
            this.closeTimers();
            return tdr1;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (CharacterCodingException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "translation_of_parameter_failed", "TerminateDialogMessage", e.getMessage());
            se.initCause(e);
            throw se;
        }
        catch (UnsupportedCharsetException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "unsupported_encoding", e.getCharsetName());
            se.initCause(e);
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "terminate_dialogue_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    SetConnectionOptionReply SetConnectionOption(short connectionOption, int optionValueNum, String optionValueStr) throws SQLException {
        if (optionValueStr == null) {
            this.throwInternalException();
        }
        try {
            LogicalByteArray wbuffer = SetConnectionOptionMessage.marshal(this.m_dialogueId, connectionOption, optionValueNum, optionValueStr, this.m_ic);
            this.getInputOutput().setTimeout(this.m_ic.t4props_.getNetworkTimeout());
            LogicalByteArray rbuffer = this.getReadBuffer((short)3003, wbuffer);
            SetConnectionOptionReply scor = new SetConnectionOptionReply(rbuffer, this.m_ncsAddress.getIPorName(), this.m_ic);
            return scor;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (CharacterCodingException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "translation_of_parameter_failed", "SetConnectionOptionReply", e.getMessage());
            se.initCause(e);
            throw se;
        }
        catch (UnsupportedCharsetException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "unsupported_encoding", e.getCharsetName());
            se.initCause(e);
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "set_connection_option_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    EndTransactionReply EndTransaction(short transactionOpt) throws SQLException {
        try {
            LogicalByteArray wbuffer = EndTransactionMessage.marshal(this.m_dialogueId, transactionOpt, this.m_ic);
            this.getInputOutput().setTimeout(this.m_ic.t4props_.getNetworkTimeout());
            LogicalByteArray rbuffer = this.getReadBuffer((short)3004, wbuffer);
            EndTransactionReply cr = new EndTransactionReply(rbuffer, this.m_ncsAddress.getIPorName(), this.m_ic);
            return cr;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (CharacterCodingException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "translation_of_parameter_failed", "EndTransactionMessage", e.getMessage());
            se.initCause(e);
            throw se;
        }
        catch (UnsupportedCharsetException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "unsupported_encoding", e.getCharsetName());
            se.initCause(e);
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "end_transaction_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    GetSQLCatalogsReply GetSQLCatalogs(String stmtLabel, short APIType, String catalogNm, String schemaNm, String tableNm, String tableTypeList, String columnNm, int columnType, int rowIdScope, int nullable, int uniqueness, int accuracy, short sqlType, int metadataId, String fkcatalogNm, String fkschemaNm, String fktableNm) throws SQLException {
        if (stmtLabel == null) {
            this.throwInternalException();
        }
        try {
            LogicalByteArray wbuffer = GetSQLCatalogsMessage.marshal(this.m_dialogueId, stmtLabel, APIType, catalogNm, schemaNm, tableNm, tableTypeList, columnNm, columnType, rowIdScope, nullable, uniqueness, accuracy, sqlType, metadataId, fkcatalogNm, fkschemaNm, fktableNm, this.m_ic);
            this.getInputOutput().setTimeout(this.m_ic.t4props_.getNetworkTimeout());
            LogicalByteArray rbuffer = this.getReadBuffer((short)3016, wbuffer);
            GetSQLCatalogsReply gscr = new GetSQLCatalogsReply(rbuffer, this.m_ncsAddress.getIPorName(), this.m_ic);
            return gscr;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (CharacterCodingException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "translation_of_parameter_failed", "GetSQLCatalogsMessage", e.getMessage());
            se.initCause(e);
            throw se;
        }
        catch (UnsupportedCharsetException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "unsupported_encoding", e.getCharsetName());
            se.initCause(e);
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "get_sql_catalogs_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }
}

