/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.T4Properties;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class T4LobAdmin {
    static PrintStream out_;
    static boolean doSql_;
    static String clobTableName_;
    static String blobTableName_;
    static T4Properties t4Props;
    static String url;
    static String usr;
    static String pwd;
    static String catalog;
    static String schema;

    public static void main(String[] args) {
        boolean create = false;
        boolean trigger = false;
        boolean drop = false;
        boolean unicode = false;
        boolean spj = false;
        String tableName = null;
        String fileName = null;
        boolean bigblock = false;
        System.err.println("Hewlett-Packard Type 4 Lob Admin Utility 1.0");
        System.err.println("(c) Copyright 2004 Hewlett-Packard Development Company, LP.");
        if (args.length == 0) {
            doSql_ = false;
        } else {
            for (int i = 0; i < args.length; ++i) {
                String s = args[i];
                if (s.equals("-exec")) {
                    doSql_ = true;
                    continue;
                }
                if (s.equals("-create")) {
                    create = true;
                    continue;
                }
                if (s.equals("-trigger")) {
                    trigger = true;
                    continue;
                }
                if (s.equals("-drop")) {
                    drop = true;
                    continue;
                }
                if (s.equals("-unicode")) {
                    unicode = true;
                    continue;
                }
                if (s.equals("-spj")) {
                    spj = true;
                    continue;
                }
                if (s.equals("-out")) {
                    if (++i >= args.length) continue;
                    fileName = args[i];
                    continue;
                }
                if (s.equals("-bigblock")) {
                    bigblock = true;
                    continue;
                }
                if (!s.startsWith("-")) {
                    tableName = s;
                    continue;
                }
                T4LobAdmin.displayHelp();
                return;
            }
        }
        try {
            if (create || trigger || drop) {
                Class.forName("com.tandem.t4jdbc.SQLMXDriver");
            }
            out_ = fileName != null ? new PrintStream(new FileOutputStream(fileName, true), true) : System.out;
        }
        catch (Exception e1) {
            System.out.println(e1.getMessage());
            return;
        }
        try {
            clobTableName_ = T4LobAdmin.getClobTableName();
            blobTableName_ = T4LobAdmin.getBlobTableName();
            out_.println("-- Script generated by Hewlett-Packard JDBC Type 4 Lob Admin Utility 1.0");
            out_.println("");
            if (create) {
                if (clobTableName_ == null && blobTableName_ == null) {
                    throw new SQLException("Either t4sqlmx.clobTableName or t4sqlmx.blobTableName or both properties should be set");
                }
                T4LobAdmin.createLobTable(clobTableName_, unicode, bigblock);
                T4LobAdmin.createLobTable(blobTableName_, false, bigblock);
            }
            if (trigger) {
                if (tableName == null) {
                    throw new SQLException("Table name containing the CLOB/BLOB column should be given when -trigger option is given");
                }
                T4LobAdmin.createTriggers(tableName);
            }
            if (drop) {
                if (tableName == null) {
                    throw new SQLException("Table name containing the CLOB/BLOB column should be given when -trigger option is given");
                }
                T4LobAdmin.dropTriggers(tableName);
            }
            if (spj) {
                T4LobAdmin.createSPJTables();
            }
        }
        catch (SQLException e) {
            SQLException nextException = e;
            do {
                System.out.println(nextException.getMessage());
                System.out.println("SQLState   " + nextException.getSQLState());
                System.out.println("Error Code " + nextException.getErrorCode());
            } while ((nextException = nextException.getNextException()) != null);
        }
    }

    private static void displayHelp() {
        System.err.println("java [<java_options>] T4LobAdmin [<prog_options>] [<table_name>]");
        System.err.println("");
        System.err.println("<java_options> is:");
        System.err.println("    [-Dt4sqlmx.properties=<properties file>]");
        System.err.println("where <properties file> has values for the following:");
        System.err.println("    clobTableName - CLOB table name");
        System.err.println("    blobTableName - BLOB table name");
        System.err.println("    url           - URL used for the Type 4 connection");
        System.err.println("    user          - User name for the Type 4 connection");
        System.err.println("    password      - Password for associated with the user");
        System.err.println("");
        System.err.println("<prog_options> is:");
        System.err.println("    [-exec] [-create] [-trigger] [-unicode] [-spj] [-help] [-drop] [-out <filename>] [-bigblock]");
        System.err.println("where -help    - Display this information.");
        System.err.println("      -exec      - Execute the SQL statements that are generated.");
        System.err.println("      -create    - Generate SQL statements to create LOB tables.");
        System.err.println("      -trigger   - Generate SQL statements to create triggers for <table_name>.");
        System.err.println("      -unicode   - Generate SQL statements to create unicode LOB tables (CLOB only).");
        System.err.println("      -spj       - Generate SQL statements to create and execute tables for SPJ LOB usage");
        System.err.println("      -drop      - Generate SQL statements to drop triggers for <table_name>.");
        System.err.println("      -out       - Write the SQL statements to <filename>.");
        System.err.println("      -bigblock  - Generates SQL Statement to create Lob column size of 24K bytes and attribute block size of 32K.");
        System.err.println("");
        System.err.println("<clobTableName> | <blobTableName> is:");
        System.err.println("    <catalogName>.<schemaName>.<lobTableName>");
        System.err.println("");
        System.err.println("<table_name> is:");
        System.err.println("    [<catalogName>.][<schemaName>.]<baseTableName>");
        System.err.println("");
        System.err.println("<baseTableName> is the table that contains LOB column(s).");
        System.err.println("<lobTableName> is the table that contains the LOB data.");
    }

    private static String getClobTableName() throws SQLException {
        int fromIndex = -1;
        String lobTableName = t4Props.getClobTableName();
        if (lobTableName != null) {
            int count;
            for (count = 0; (fromIndex = lobTableName.indexOf(46, fromIndex + 1)) != -1 && count < 2; ++count) {
            }
            if (count < 2) {
                throw new SQLException("ClobTableName is not of the format catalog.schema.tablename");
            }
        }
        return lobTableName;
    }

    private static String getBlobTableName() throws SQLException {
        int fromIndex = -1;
        String lobTableName = t4Props.getBlobTableName();
        int tempIndex = 0;
        if (lobTableName != null) {
            int count;
            for (count = 0; (fromIndex = lobTableName.indexOf(46, fromIndex + 1)) != -1 && count < 2; ++count) {
                if (count == 0) {
                    catalog = lobTableName.substring(0, fromIndex);
                    tempIndex = fromIndex;
                }
                if (count != 1) continue;
                schema = lobTableName.substring(tempIndex + 1, fromIndex);
            }
            if (count < 2) {
                throw new SQLException("BlobTableName is not of the format catalog.schema.tablename");
            }
        }
        return lobTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createLobTable(String lobTableName, boolean isUnicode, boolean isBigBlock) throws SQLException {
        Connection conn = null;
        if (lobTableName == null) {
            return;
        }
        StringBuffer sqlString = new StringBuffer();
        out_.println("-- SQL statement to create LOB table " + lobTableName);
        out_.println("");
        String s = "CREATE TABLE " + lobTableName;
        out_.println(s);
        sqlString.append(s);
        s = isUnicode ? " (table_name VARCHAR(128) NOT NULL NOT DROPPABLE," : " (table_name CHAR(128) NOT NULL NOT DROPPABLE,";
        out_.println(s);
        sqlString.append(s);
        s = " data_locator LARGEINT NOT NULL NOT DROPPABLE,";
        out_.println(s);
        sqlString.append(s);
        s = " chunk_no INT NOT NULL NOT DROPPABLE,";
        out_.println(s);
        sqlString.append(s);
        s = !isUnicode ? (isBigBlock ? " lob_data VARCHAR(24000)," : " lob_data VARCHAR(3880),") : (isBigBlock ? " lob_data VARCHAR(12000) CHARACTER SET UCS2," : " lob_data VARCHAR(1939) CHARACTER SET UCS2,");
        out_.println(s);
        sqlString.append(s);
        s = " PRIMARY KEY(table_name, data_locator, chunk_no)) ";
        out_.println(s);
        sqlString.append(s);
        s = !isBigBlock ? " ATTRIBUTES EXTENT(1024), MAXEXTENTS 768 ;" : " ATTRIBUTES blocksize 32768, MAXEXTENTS 768 ;";
        out_.println(s);
        sqlString.append(s);
        out_.println("");
        if (doSql_) {
            try {
                conn = DriverManager.getConnection(url, t4Props.getProperties());
                Statement stmt = conn.createStatement();
                stmt.executeUpdate(sqlString.toString());
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTriggers(String baseTableName) throws SQLException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url, t4Props.getProperties());
            PreparedStatement pstmt = conn.prepareStatement("select * from " + baseTableName);
            ResultSetMetaData rsmd = pstmt.getMetaData();
            int columnCount = rsmd.getColumnCount();
            if (doSql_) {
                stmt = conn.createStatement();
            }
            String catalogName = rsmd.getCatalogName(1);
            String tableName = rsmd.getTableName(1);
            String schemaName = rsmd.getSchemaName(1);
            out_.println("-- Create triggers for " + tableName);
            out_.println("");
            int j = 1;
            for (int i = 1; i <= columnCount; ++i) {
                String lobTableName;
                int columnType = rsmd.getColumnType(i);
                String columnName = rsmd.getColumnName(i);
                if (columnType != 2005 && columnType != 2004) continue;
                if (columnType == 2005) {
                    if (clobTableName_ == null) {
                        throw new SQLException("t4sqlmx.clobTableName property is not set");
                    }
                    lobTableName = clobTableName_;
                } else {
                    if (blobTableName_ == null) {
                        throw new SQLException("t4sqlmx.blobTableName property is not set");
                    }
                    lobTableName = blobTableName_;
                }
                StringBuffer sqlString = new StringBuffer();
                out_.println("-- Trigger for update of column " + columnName + " of " + tableName);
                out_.println("");
                String s = "CREATE TRIGGER " + catalogName + "." + schemaName + "." + "zzlobupd_" + tableName + "_" + j;
                out_.println(s);
                sqlString.append(s);
                s = " AFTER UPDATE OF (" + columnName + ") ON " + baseTableName;
                out_.println(s);
                sqlString.append(s);
                s = " REFERENCING OLD AS old_base, NEW AS new_base FOR EACH ROW";
                out_.println(s);
                sqlString.append(s);
                s = " WHEN (old_base." + columnName + " != new_base." + columnName + ")";
                out_.println(s);
                sqlString.append(s);
                s = " DELETE FROM " + lobTableName + " WHERE table_name = '" + tableName + "'";
                out_.println(s);
                sqlString.append(s);
                s = " AND data_locator = old_base." + columnName + " ;";
                out_.println(s);
                sqlString.append(s);
                out_.println("");
                if (doSql_) {
                    stmt.executeUpdate(sqlString.toString());
                }
                sqlString = new StringBuffer();
                out_.println("-- Trigger for delete row for column " + columnName + " of " + tableName);
                out_.println("");
                s = "CREATE TRIGGER " + catalogName + "." + schemaName + "." + "zzlobdel_" + tableName + "_" + j;
                out_.println(s);
                sqlString.append(s);
                s = " AFTER DELETE ON " + baseTableName;
                out_.println(s);
                sqlString.append(s);
                s = " REFERENCING OLD AS old_base FOR EACH ROW";
                out_.println(s);
                sqlString.append(s);
                s = " DELETE FROM " + lobTableName + " WHERE table_name = '" + tableName + "'";
                out_.println(s);
                sqlString.append(s);
                s = " AND data_locator = old_base." + columnName + " ;";
                out_.println(s);
                sqlString.append(s);
                out_.println("");
                if (doSql_) {
                    stmt.executeUpdate(sqlString.toString());
                }
                ++j;
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropTriggers(String baseTableName) throws SQLException {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(url, t4Props.getProperties());
            PreparedStatement pstmt = conn.prepareStatement("select * from " + baseTableName);
            ResultSetMetaData rsmd = pstmt.getMetaData();
            int columnCount = rsmd.getColumnCount();
            if (doSql_) {
                stmt = conn.createStatement();
            }
            String catalogName = rsmd.getCatalogName(1);
            String tableName = rsmd.getTableName(1);
            String schemaName = rsmd.getSchemaName(1);
            out_.println("-- Drop triggers for " + tableName);
            out_.println("");
            int j = 1;
            for (int i = 1; i <= columnCount; ++i) {
                int columnType = rsmd.getColumnType(i);
                if (columnType != 2005 && columnType != 2004) continue;
                String s = "DROP TRIGGER " + catalogName + "." + schemaName + "." + "zzlobupd_" + tableName + "_" + j + " ;";
                out_.println(s);
                out_.println("");
                if (doSql_) {
                    stmt.executeUpdate(s);
                }
                s = "DROP TRIGGER " + catalogName + "." + schemaName + "." + "zzlobdel_" + tableName + "_" + j + " ;";
                out_.println(s);
                out_.println("");
                if (doSql_) {
                    stmt.executeUpdate(s);
                }
                ++j;
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSPJTables() throws SQLException {
        String spjBaseTableName_ = null;
        String spjLobTableName_ = null;
        Connection conn = null;
        Statement stmt = null;
        spjBaseTableName_ = "SPJCAT.SPJSCH.SPJ_BASE_TABLE";
        spjLobTableName_ = "SPJCAT.SPJSCH.SPJ_TABLE";
        String createspjcat = "CREATE CATALOG SPJCAT";
        String createspjsch = "CREATE SCHEMA SPJCAT.SPJSCH";
        String createBase = "create table " + spjBaseTableName_ + " (BLOB_COL BLOB , CLOB_COL CLOB) ";
        try {
            conn = DriverManager.getConnection(url, t4Props.getProperties());
            stmt = conn.createStatement();
            stmt.execute(createspjcat);
            out_.println(createspjcat);
            stmt.execute(createspjsch);
            out_.println(createspjsch);
            out_.println("");
        }
        catch (SQLException e) {
            if (e.getErrorCode() != 1022 || e.getErrorCode() != 1035) {
                System.out.println("Catalog/Schema already exist !");
            }
            e.printStackTrace();
        }
        try {
            stmt.execute("control query default jdbc_process 'true'");
            stmt.executeUpdate(createBase);
            out_.println(createBase);
            out_.println("");
            StringBuffer sqlString = new StringBuffer();
            out_.println("-- SQL statement to create SPJ LOB table " + spjLobTableName_);
            out_.println("");
            String s = "CREATE TABLE " + spjLobTableName_;
            out_.println(s);
            sqlString.append(s);
            s = " (table_name CHAR(128) NOT NULL NOT DROPPABLE,";
            out_.println(s);
            sqlString.append(s);
            s = " data_locator LARGEINT NOT NULL NOT DROPPABLE,";
            out_.println(s);
            sqlString.append(s);
            s = " chunk_no INT NOT NULL NOT DROPPABLE,";
            out_.println(s);
            sqlString.append(s);
            s = " lob_data VARCHAR(3880),";
            out_.println(s);
            sqlString.append(s);
            s = " PRIMARY KEY(table_name, data_locator, chunk_no)) ";
            out_.println(s);
            sqlString.append(s);
            s = " ATTRIBUTES EXTENT(1024), MAXEXTENTS 768 ;";
            out_.println(s);
            sqlString.append(s);
            out_.println("");
            stmt = conn.createStatement();
            stmt.executeUpdate(sqlString.toString());
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void loadprops() {
        try {
            String propFile = System.getProperty("t4sqlmx.properties");
            if (propFile != null) {
                t4Props = new T4Properties();
                url = t4Props.getUrl();
                usr = t4Props.getUser();
                pwd = t4Props.getPassword();
            } else {
                System.out.println("Error: t4sqlmx.properties is not set. Exiting.");
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        try {
            Class.forName("com.tandem.t4jdbc.SQLMXDriver");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            System.exit(0);
        }
    }

    static {
        T4LobAdmin.loadprops();
    }
}

