/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.CloseMessage;
import com.tandem.t4jdbc.CloseReply;
import com.tandem.t4jdbc.FetchMessage;
import com.tandem.t4jdbc.FetchReply;
import com.tandem.t4jdbc.InterfaceResultSet;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4Connection;
import java.net.SocketTimeoutException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;

final class T4ResultSet
extends T4Connection {
    private String m_stmtLabel;
    private String closeConnectionUponQueryTimeout = "DEFAULT";
    static final short SQL_CLOSE = 0;
    boolean m_processing = false;

    T4ResultSet(InterfaceResultSet ir, String closeConnectionUponQueryTimeout) throws SQLException {
        super(ir.ic_);
        this.m_stmtLabel = ir.stmtLabel_;
        this.closeConnectionUponQueryTimeout = closeConnectionUponQueryTimeout;
        if (this.m_stmtLabel == null) {
            this.throwInternalException();
        }
    }

    FetchReply Fetch(int sqlAsyncEnable, int queryTimeout, int stmtHandle, int stmtCharset, int maxRowCnt, String cursorName, int cursorCharset, String stmtOptions) throws SQLException {
        try {
            if (this.closeConnectionUponQueryTimeout.equals("ON")) {
                this.getInputOutput().setTimeout(queryTimeout);
            } else {
                this.getInputOutput().setTimeout(this.m_ic.t4props_.getNetworkTimeout());
            }
            LogicalByteArray wbuffer = FetchMessage.marshal(this.m_dialogueId, sqlAsyncEnable, queryTimeout, stmtHandle, this.m_stmtLabel, stmtCharset, maxRowCnt, 0, cursorName, cursorCharset, stmtOptions, this.m_ic);
            LogicalByteArray rbuffer = null;
            try {
                rbuffer = this.getReadBuffer((short)3009, wbuffer);
            }
            catch (SQLMXException e) {
                if (e.getCause() instanceof SocketTimeoutException) {
                    throw (SocketTimeoutException)e.getCause();
                }
                throw e;
            }
            FetchReply frr = new FetchReply(rbuffer, this.m_ic);
            return frr;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (CharacterCodingException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "translation_of_parameter_failed", "FetchMessage", e.getMessage());
            se.initCause(e);
            throw se;
        }
        catch (UnsupportedCharsetException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "unsupported_encoding", e.getCharsetName());
            se.initCause(e);
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "fetch_perf_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    CloseReply Close() throws SQLException {
        try {
            this.getInputOutput().setTimeout(this.m_ic.t4props_.getNetworkTimeout());
            LogicalByteArray wbuffer = CloseMessage.marshal(this.m_dialogueId, this.m_stmtLabel, (short)0, this.m_ic);
            LogicalByteArray rbuffer = this.getReadBuffer((short)3015, wbuffer);
            CloseReply cr = new CloseReply(rbuffer, this.m_ncsAddress.getIPorName(), this.m_ic);
            return cr;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (CharacterCodingException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "translation_of_parameter_failed", "CloseMessage", e.getMessage());
            se.initCause(e);
            throw se;
        }
        catch (UnsupportedCharsetException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "unsupported_encoding", e.getCharsetName());
            se.initCause(e);
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "close_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    protected LogicalByteArray getReadBuffer(short odbcAPI, LogicalByteArray wbuffer) throws SQLException {
        LogicalByteArray buf = null;
        try {
            this.m_processing = true;
            buf = super.getReadBuffer(odbcAPI, wbuffer);
            this.m_processing = false;
        }
        catch (SQLException se) {
            this.m_processing = false;
            throw se;
        }
        return buf;
    }
}

