/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.Bytes;
import com.tandem.t4jdbc.CancelReply;
import com.tandem.t4jdbc.CloseMessage;
import com.tandem.t4jdbc.CloseReply;
import com.tandem.t4jdbc.ExecuteMessage;
import com.tandem.t4jdbc.ExecuteReply;
import com.tandem.t4jdbc.GenericMessage;
import com.tandem.t4jdbc.GenericReply;
import com.tandem.t4jdbc.InterfaceStatement;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.PrepareMessage;
import com.tandem.t4jdbc.PrepareReply;
import com.tandem.t4jdbc.SQLMXException;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.SQLMX_AssociationServer_Cancel;
import com.tandem.t4jdbc.SQLValueList_def;
import com.tandem.t4jdbc.SQL_DataValue_def;
import com.tandem.t4jdbc.T4Connection;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.tmf.ControlRef;
import com.tandem.tmf.Current;
import com.tandem.util.FSException;
import java.net.SocketTimeoutException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.sql.SQLException;
import java.util.logging.Level;

final class T4Statement
extends T4Connection {
    public int m_queryTimeout;
    private String m_stmtLabel;
    private String m_stmtExplainLabel;
    private static short EXTERNAL_STMT = 0;
    boolean m_processing = false;
    private String closeConnectionUponQueryTimeout = "DEFAULT";

    T4Statement(InterfaceStatement is, String closeConnectionUponQueryTimeout) throws SQLException {
        super(is.ic_);
        this.m_queryTimeout = is.queryTimeout_;
        this.setM_stmtLabel(is.getStmtLabel_());
        this.m_stmtExplainLabel = "";
        this.closeConnectionUponQueryTimeout = closeConnectionUponQueryTimeout;
        if (this.getM_stmtLabel() == null) {
            this.throwInternalException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ExecuteReply Execute(short executeAPI, int sqlAsyncEnable, int inputRowCnt, int maxRowsetSize, int sqlStmtType, int stmtHandle, String sqlString, int sqlStringCharset, String cursorName, int cursorNameCharset, String stmtLabel, int stmtLabelCharset, SQL_DataValue_def inputDataValue, SQLValueList_def inputValueList, byte[] txId, boolean userBuffer) throws SQLException {
        try {
            if (this.closeConnectionUponQueryTimeout.equals("ON")) {
                this.getInputOutput().setTimeout(this.m_queryTimeout);
            } else {
                this.getInputOutput().setTimeout(this.m_ic.t4props_.getNetworkTimeout());
            }
            short[] tmfHandle = null;
            byte[] ret = null;
            String os = System.getProperty("os.name");
            if (os.equalsIgnoreCase("NONSTOP_KERNEL") && this.m_ic.t4props_.getUseExternalTransaction().equalsIgnoreCase("YES")) {
                try {
                    Current txn = new Current();
                    ControlRef cref = txn.get_control();
                    if (cref == null) {
                        throw SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "txn_error", null);
                    }
                    tmfHandle = cref.getTransactionHandle();
                    ret = new byte[tmfHandle.length * 2];
                    for (int i = 0; i < tmfHandle.length; ++i) {
                        Bytes.insertShort(ret, i * 2, tmfHandle[i], false);
                    }
                    if (this.m_ic.t4props_.t4Logger_.isLoggable(Level.FINEST)) {
                        Object[] p = T4LoggingUtilities.makeParams(this.m_ic.t4props_);
                        String temp = "Transaction handle obtained";
                        this.m_ic.t4props_.t4Logger_.logp(Level.FINEST, "T4Statement", "Execute", temp, p);
                    }
                }
                catch (Exception e) {
                    if (e instanceof FSException) {
                        SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "nsj_error", "Execute", e.getMessage());
                        se.initCause(e);
                        throw se;
                    }
                    if (e instanceof SQLException) {
                        throw e;
                    }
                    SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "nsj_internal_error", "Execute", e.getMessage());
                    throw se;
                }
            }
            LogicalByteArray wbuffer = ExecuteMessage.marshal(this.m_dialogueId, sqlAsyncEnable, this.m_queryTimeout, inputRowCnt, maxRowsetSize, sqlStmtType, stmtHandle, EXTERNAL_STMT, sqlString, sqlStringCharset, cursorName, cursorNameCharset, stmtLabel, stmtLabelCharset, this.m_stmtExplainLabel, inputDataValue, inputValueList, txId, userBuffer, this.m_ic, ret);
            LogicalByteArray rbuffer = this.getReadBuffer(executeAPI, wbuffer);
            return new ExecuteReply(rbuffer, this.m_ic);
        }
        catch (SQLException e) {
            if (!this.m_ic.t4props_.getCloseConnectionUponQueryTimeout().equals("ON")) throw e;
            if (!(e.getCause() instanceof SocketTimeoutException)) throw e;
            if (!e.getCause().getMessage().equals("Read timed out")) throw e;
            CancelReply cr_ = null;
            cr_ = SQLMX_AssociationServer_Cancel.cancel(this.m_ic.t4props_, this.m_ic, this.m_ic.getDialogueId(), 2, this.m_ic.mxcsAddr_.m_url + "", 0);
            SQLMXException ex = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_ic.getLocale(), "AS_API_STOPSRVR", null);
            this.m_ic.setIsClosed(true);
            ex.initCause(e.getCause());
            throw ex;
        }
        catch (CharacterCodingException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "translation_of_parameter_failed", "ExecuteMessage", e.getMessage());
            se.initCause(e);
            throw se;
        }
        catch (UnsupportedCharsetException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "unsupported_encoding", e.getCharsetName());
            se.initCause(e);
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "execute_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    GenericReply ExecuteGeneric(short executeAPI, byte[] messageBuffer) throws SQLException {
        LogicalByteArray wbuffer = null;
        LogicalByteArray rbuffer = null;
        GenericReply gr = null;
        try {
            if (this.closeConnectionUponQueryTimeout.equals("ON")) {
                this.getInputOutput().setTimeout(this.m_queryTimeout);
            } else {
                this.getInputOutput().setTimeout(this.m_ic.t4props_.getNetworkTimeout());
            }
            wbuffer = GenericMessage.marshal(this.m_locale, messageBuffer, this.m_ic);
            rbuffer = this.getReadBuffer(executeAPI, wbuffer);
            gr = new GenericReply(this.m_locale, rbuffer);
            return gr;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "execute_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    PrepareReply Prepare(int sqlAsyncEnable, short stmtType, int sqlStmtType, String stmtLabel, int stmtLabelCharset, String cursorName, int cursorNameCharset, String moduleName, int moduleNameCharset, long moduleTimestamp, String sqlString, int sqlStringCharset, String stmtOptions, int maxRowsetSize, byte[] txId) throws SQLException {
        if (sqlString == null) {
            this.throwInternalException();
        }
        try {
            this.getInputOutput().setTimeout(this.m_ic.t4props_.getNetworkTimeout());
            LogicalByteArray wbuffer = PrepareMessage.marshal(this.m_dialogueId, sqlAsyncEnable, this.m_queryTimeout, stmtType, sqlStmtType, stmtLabel, stmtLabelCharset, cursorName, cursorNameCharset, moduleName, moduleNameCharset, moduleTimestamp, sqlString, sqlStringCharset, stmtOptions, this.m_stmtExplainLabel, maxRowsetSize, txId, this.m_ic);
            LogicalByteArray rbuffer = this.getReadBuffer((short)3005, wbuffer);
            PrepareReply pr = new PrepareReply(rbuffer, this.m_ic);
            return pr;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (CharacterCodingException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "translation_of_parameter_failed", "PrepareMessage", e.getMessage());
            se.initCause(e);
            throw se;
        }
        catch (UnsupportedCharsetException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "unsupported_encoding", e.getCharsetName());
            se.initCause(e);
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "prepare_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    CloseReply Close() throws SQLException {
        try {
            LogicalByteArray wbuffer = CloseMessage.marshal(this.m_dialogueId, this.m_stmtLabel, (short)1, this.m_ic);
            this.getInputOutput().setTimeout(this.m_ic.t4props_.getNetworkTimeout());
            LogicalByteArray rbuffer = this.getReadBuffer((short)3015, wbuffer);
            CloseReply cr = new CloseReply(rbuffer, this.m_ncsAddress.getIPorName(), this.m_ic);
            return cr;
        }
        catch (SQLException se) {
            throw se;
        }
        catch (CharacterCodingException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "translation_of_parameter_failed", "CloseMessage", e.getMessage());
            se.initCause(e);
            throw se;
        }
        catch (UnsupportedCharsetException e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "unsupported_encoding", e.getCharsetName());
            se.initCause(e);
            throw se;
        }
        catch (Exception e) {
            SQLMXException se = SQLMXMessages.createSQLException(this.m_ic.t4props_, this.m_locale, "close_message_error", e.getMessage());
            se.initCause(e);
            throw se;
        }
    }

    protected LogicalByteArray getReadBuffer(short odbcAPI, LogicalByteArray wbuffer) throws SQLException {
        LogicalByteArray buf = null;
        try {
            this.m_processing = true;
            buf = super.getReadBuffer(odbcAPI, wbuffer);
            this.m_processing = false;
        }
        catch (SQLException se) {
            this.m_processing = false;
            throw se;
        }
        return buf;
    }

    public synchronized void setM_stmtLabel(String m_stmtLabel) {
        this.m_stmtLabel = m_stmtLabel;
    }

    public String getM_stmtLabel() {
        return this.m_stmtLabel;
    }
}

