/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.BrkXaMessage;
import com.tandem.t4jdbc.BrkXaRecoverRequest;
import com.tandem.t4jdbc.BrkXaReply;
import com.tandem.t4jdbc.BrkXaRequest;
import com.tandem.t4jdbc.BrkXaStartRequest;
import com.tandem.t4jdbc.BrkXaTimeoutRequest;
import com.tandem.t4jdbc.BrkXaTxnRequest;
import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.SQLMXXAResource;
import com.tandem.t4jdbc.SQLMXXid;
import com.tandem.t4jdbc.T4Connection;
import com.tandem.t4jdbc.T4LoggingUtilities;
import com.tandem.t4jdbc.T4Properties;
import com.tandem.t4jdbc.T4XALogger;
import java.sql.SQLException;
import java.util.Locale;
import java.util.logging.Level;
import javax.transaction.xa.XAException;

class T4XAExecute
extends T4Connection {
    private Locale m_locale;
    private BrkXaMessage m_xaMessage;
    private final int rmid = 0;
    private T4Properties m_t4props;
    private T4XALogger m_t4XALogger;
    private int m_timeout = 0;
    static final int XA_BASE = 3032;
    static final int SRVR_API_XASTART = 3032;
    static final int SRVR_API_XAEND = 3033;
    static final int SRVR_API_XACOMMIT = 3034;
    static final int SRVR_API_XAFORGET = 3035;
    static final int SRVR_API_XAPREPARE = 3036;
    static final int SRVR_API_XARECOVER = 3037;
    static final int SRVR_API_XAROLLBACK = 3038;
    static final int SRVR_API_XAGET_TIMEOUT = 3039;
    static final int SRVR_API_XASET_TIMEOUT = 3040;
    static final int SRVR_API_XAGET_TRANSACTION_STATE = 3041;

    T4XAExecute(T4Properties t4props, SQLMXConnection p_sqlmxConnection) throws SQLException {
        super(p_sqlmxConnection.ic_);
        this.m_t4props = t4props;
        this.m_locale = t4props.getLocale();
        this.m_xaMessage = new BrkXaMessage(this.m_t4props, p_sqlmxConnection.getDialogueId());
        this.m_t4XALogger = new T4XALogger(p_sqlmxConnection);
    }

    private static XAException mapXAExceptionFromSQLException(SQLException sqlEx) {
        int l_errorCode = sqlEx.getErrorCode();
        String l_xaMessage = SQLMXXAResource.getXAStatusString(l_errorCode);
        if (l_xaMessage == null) {
            l_errorCode = -3;
        }
        XAException xAException = new XAException(l_errorCode);
        xAException.initCause(sqlEx);
        xAException.setStackTrace(sqlEx.getStackTrace());
        return xAException;
    }

    private LogicalByteArray getReadBuffer(int command, LogicalByteArray wbuffer) throws SQLException {
        return super.getReadBuffer((short)command, wbuffer);
    }

    BrkXaReply XASTART(SQLMXXid p_xid, int p_flags) throws XAException {
        if (this.m_t4XALogger.isLoggable(Level.FINER)) {
            this.m_t4XALogger.log("", Level.FINER, "T4XAExecute", "XASTART", T4LoggingUtilities.makeParams(this.m_t4props, (Object)p_xid, p_flags));
        }
        try {
            BrkXaStartRequest txnRequest = new BrkXaStartRequest(this.m_t4props, 8, 0, p_xid, p_flags, this.m_timeout);
            LogicalByteArray wbuffer = this.m_xaMessage.marshal(txnRequest, p_xid, 0, p_flags, 8);
            LogicalByteArray rbuffer = this.getReadBuffer(3032, wbuffer);
            return new BrkXaReply(rbuffer, this.m_t4props);
        }
        catch (SQLException sqlex) {
            if (this.m_t4XALogger.isLoggable(Level.SEVERE)) {
                this.m_t4XALogger.log("Exception in XASTART = " + sqlex.getMessage(), Level.SEVERE, "T4XAExecute", "XASTART", T4LoggingUtilities.makeParams(this.m_t4props, (Object)p_xid, p_flags));
            }
            throw T4XAExecute.mapXAExceptionFromSQLException(sqlex);
        }
    }

    BrkXaReply XACOMMIT(SQLMXXid p_xid, boolean onePhase) throws XAException {
        if (this.m_t4XALogger.isLoggable(Level.FINER)) {
            this.m_t4XALogger.log("", Level.FINER, "T4XAExecute", "XACOMMIT", T4LoggingUtilities.makeParams(this.m_t4props, (Object)p_xid, onePhase));
        }
        try {
            int flag = 0;
            flag = onePhase ? 0x40000000 : 0;
            BrkXaTxnRequest txnRequest = new BrkXaTxnRequest(this.m_t4props, 2, 0, p_xid, flag);
            LogicalByteArray wbuffer = this.m_xaMessage.marshal(txnRequest, p_xid, 0, flag, 2);
            LogicalByteArray rbuffer = this.getReadBuffer(3034, wbuffer);
            return new BrkXaReply(rbuffer, this.m_t4props);
        }
        catch (SQLException sqlex) {
            if (this.m_t4XALogger.isLoggable(Level.SEVERE)) {
                this.m_t4XALogger.log("Exception in XACOMMIT = " + sqlex.getMessage(), Level.SEVERE, "T4XAExecute", "XACOMMIT", T4LoggingUtilities.makeParams(this.m_t4props, (Object)p_xid, onePhase));
            }
            throw T4XAExecute.mapXAExceptionFromSQLException(sqlex);
        }
    }

    BrkXaReply XAEND(SQLMXXid p_xid, int p_flags) throws XAException {
        if (this.m_t4XALogger.isLoggable(Level.FINER)) {
            this.m_t4XALogger.log("", Level.FINER, "T4XAExecute", "XAEND", T4LoggingUtilities.makeParams(this.m_t4props, (Object)p_xid, p_flags));
        }
        try {
            BrkXaTxnRequest txnRequest = new BrkXaTxnRequest(this.m_t4props, 10, 0, p_xid, p_flags);
            LogicalByteArray wbuffer = this.m_xaMessage.marshal(txnRequest, p_xid, 0, p_flags, 10);
            LogicalByteArray rbuffer = this.getReadBuffer(3033, wbuffer);
            return new BrkXaReply(rbuffer, this.m_t4props);
        }
        catch (SQLException sqlex) {
            if (this.m_t4XALogger.isLoggable(Level.SEVERE)) {
                this.m_t4XALogger.log("Exception in XAEND = " + sqlex.getMessage(), Level.SEVERE, "T4XAExecute", "XAEND", T4LoggingUtilities.makeParams(this.m_t4props, (Object)p_xid, p_flags));
            }
            throw T4XAExecute.mapXAExceptionFromSQLException(sqlex);
        }
    }

    BrkXaReply XAPREPARE(SQLMXXid p_xid) throws XAException {
        if (this.m_t4XALogger.isLoggable(Level.FINER)) {
            this.m_t4XALogger.log("", Level.FINER, "T4XAExecute", "XAPREPARE", T4LoggingUtilities.makeParams(this.m_t4props, p_xid));
        }
        try {
            BrkXaTxnRequest txnRequest = new BrkXaTxnRequest(this.m_t4props, 5, 0, p_xid, 0);
            LogicalByteArray wbuffer = this.m_xaMessage.marshal(txnRequest, p_xid, 0, 0, 5);
            LogicalByteArray rbuffer = this.getReadBuffer(3036, wbuffer);
            return new BrkXaReply(rbuffer, this.m_t4props);
        }
        catch (SQLException sqlex) {
            if (this.m_t4XALogger.isLoggable(Level.SEVERE)) {
                this.m_t4XALogger.log("Exception in XAPREPARE = " + sqlex.getMessage(), Level.SEVERE, "T4XAExecute", "XAPREPARE", T4LoggingUtilities.makeParams(this.m_t4props, p_xid));
            }
            throw T4XAExecute.mapXAExceptionFromSQLException(sqlex);
        }
    }

    BrkXaReply XARECOVER(int p_flag) throws XAException {
        if (this.m_t4XALogger.isLoggable(Level.FINER)) {
            this.m_t4XALogger.log("", Level.FINER, "T4XAExecute", "XARECOVER", T4LoggingUtilities.makeParams(this.m_t4props, p_flag));
        }
        try {
            int count = 0;
            BrkXaRecoverRequest txnRequest = new BrkXaRecoverRequest(this.m_t4props, count, 0, p_flag);
            LogicalByteArray wbuffer = this.m_xaMessage.marshal(txnRequest, null, 0, p_flag, 6);
            LogicalByteArray rbuffer = this.getReadBuffer(3037, wbuffer);
            return new BrkXaReply(rbuffer, this.m_t4props);
        }
        catch (SQLException sqlex) {
            if (this.m_t4XALogger.isLoggable(Level.SEVERE)) {
                this.m_t4XALogger.log("Exception in XARECOVER = " + sqlex.getMessage(), Level.SEVERE, "T4XAExecute", "XARECOVER", T4LoggingUtilities.makeParams(this.m_t4props, p_flag));
            }
            throw T4XAExecute.mapXAExceptionFromSQLException(sqlex);
        }
    }

    BrkXaReply XAROLLBACK(SQLMXXid p_xid) throws XAException {
        if (this.m_t4XALogger.isLoggable(Level.FINER)) {
            this.m_t4XALogger.log("", Level.FINER, "T4XAExecute", "XAROLLBACK", T4LoggingUtilities.makeParams(this.m_t4props, p_xid));
        }
        try {
            BrkXaTxnRequest txnRequest = new BrkXaTxnRequest(this.m_t4props, 7, 0, p_xid, 0);
            LogicalByteArray wbuffer = this.m_xaMessage.marshal(txnRequest, p_xid, 0, 0, 7);
            LogicalByteArray rbuffer = this.getReadBuffer(3038, wbuffer);
            return new BrkXaReply(rbuffer, this.m_t4props);
        }
        catch (SQLException sqlex) {
            if (this.m_t4XALogger.isLoggable(Level.SEVERE)) {
                this.m_t4XALogger.log("Exception in XAROLLBACK = " + sqlex.getMessage(), Level.SEVERE, "T4XAExecute", "XAROLLBACK", T4LoggingUtilities.makeParams(this.m_t4props, p_xid));
            }
            throw T4XAExecute.mapXAExceptionFromSQLException(sqlex);
        }
    }

    BrkXaReply XAFORGET(SQLMXXid p_xid) throws XAException {
        if (this.m_t4XALogger.isLoggable(Level.FINER)) {
            this.m_t4XALogger.log("", Level.FINER, "T4XAExecute", "XAFORGET", T4LoggingUtilities.makeParams(this.m_t4props, p_xid));
        }
        try {
            BrkXaTxnRequest txnRequest = new BrkXaTxnRequest(this.m_t4props, 3, 0, p_xid, 0);
            LogicalByteArray wbuffer = this.m_xaMessage.marshal(txnRequest, p_xid, 0, 0, 3);
            LogicalByteArray rbuffer = this.getReadBuffer(3035, wbuffer);
            return new BrkXaReply(rbuffer, this.m_t4props);
        }
        catch (SQLException sqlex) {
            if (this.m_t4XALogger.isLoggable(Level.SEVERE)) {
                this.m_t4XALogger.log("Exception in XAFORGET = " + sqlex.getMessage(), Level.SEVERE, "T4XAExecute", "XAFORGET", T4LoggingUtilities.makeParams(this.m_t4props, p_xid));
            }
            throw T4XAExecute.mapXAExceptionFromSQLException(sqlex);
        }
    }

    BrkXaReply XAGET_TIMEOUT() throws XAException {
        if (this.m_t4XALogger.isLoggable(Level.FINER)) {
            this.m_t4XALogger.log("", Level.FINER, "T4XAExecute", "XAGET_TIMEOUT", T4LoggingUtilities.makeParams(this.m_t4props));
        }
        try {
            BrkXaTimeoutRequest txnRequest = new BrkXaTimeoutRequest(this.m_t4props, 0);
            LogicalByteArray wbuffer = this.m_xaMessage.marshal(txnRequest, null, 0, 0, 13);
            LogicalByteArray rbuffer = this.getReadBuffer(3039, wbuffer);
            return new BrkXaReply(rbuffer, this.m_t4props);
        }
        catch (SQLException sqlex) {
            if (this.m_t4XALogger.isLoggable(Level.SEVERE)) {
                this.m_t4XALogger.log("Exception in XAGET_TIMEOUT = " + sqlex.getMessage(), Level.SEVERE, "T4XAExecute", "XAGET_TIMEOUT", T4LoggingUtilities.makeParams(this.m_t4props));
            }
            throw T4XAExecute.mapXAExceptionFromSQLException(sqlex);
        }
    }

    boolean XASET_TIMEOUT(int seconds) throws XAException {
        if (this.m_t4XALogger.isLoggable(Level.FINER)) {
            this.m_t4XALogger.log("", Level.FINER, "T4XAExecute", "XASET_TIMEOUT", T4LoggingUtilities.makeParams(this.m_t4props, (Object)this, seconds));
        }
        this.m_timeout = seconds;
        return true;
    }

    BrkXaReply XAGET_TXN_STATE() throws XAException {
        if (this.m_t4XALogger.isLoggable(Level.FINER)) {
            this.m_t4XALogger.log("", Level.FINER, "T4XAExecute", "XAGET_TXN_STATE", T4LoggingUtilities.makeParams(this.m_t4props));
        }
        try {
            BrkXaRequest txnRequest = new BrkXaRequest(this.m_t4props);
            LogicalByteArray wbuffer = this.m_xaMessage.marshal(txnRequest, null, 0, 0, 14);
            LogicalByteArray rbuffer = this.getReadBuffer(3041, wbuffer);
            return new BrkXaReply(rbuffer, this.m_t4props);
        }
        catch (SQLException sqlex) {
            if (this.m_t4XALogger.isLoggable(Level.SEVERE)) {
                this.m_t4XALogger.log("Exception in GET_TXN_STATE = " + sqlex.getMessage(), Level.SEVERE, "T4XAExecute", "XAGET_TXN_STATE", T4LoggingUtilities.makeParams(this.m_t4props));
            }
            throw T4XAExecute.mapXAExceptionFromSQLException(sqlex);
        }
    }
}

