/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXConnection;
import com.tandem.t4jdbc.T4LogFormatter;
import com.tandem.t4jdbc.T4Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;

public class T4XALogger {
    private Logger m_t4logger;
    private T4Properties m_t4props;
    private T4LogFormatter m_lf;

    T4XALogger(SQLMXConnection p_mxconn) {
        this.m_t4props = p_mxconn.props_;
        this.m_t4logger = this.m_t4props.getLogger();
        this.m_lf = new T4LogFormatter();
    }

    void logAndIgnore(String p_logContent, Level p_level, String className, String methodName, Object[] params) {
        try {
            this.log(p_logContent, p_level, className, methodName, params);
        }
        catch (XAException xaex) {
            // empty catch block
        }
    }

    boolean isLoggable(Level p_level) {
        try {
            return this.m_t4logger.isLoggable(p_level) || this.m_t4props.getLogWriter() != null;
        }
        catch (Exception e) {
            return this.m_t4logger.isLoggable(p_level);
        }
    }

    void log(String p_logContent, Level p_level, String className, String methodName, Object[] params) throws XAException {
        try {
            if (this.m_t4logger.isLoggable(p_level)) {
                this.m_t4logger.logp(Level.FINE, className, methodName, p_logContent, params);
            }
            if (this.m_t4props.getLogWriter() != null) {
                LogRecord lr = new LogRecord(p_level, "");
                lr.setParameters(params);
                lr.setSourceClassName(className);
                lr.setSourceMethodName(methodName);
                lr.setMessage(p_logContent);
                String temp = this.m_lf.format(lr);
                this.m_t4props.getLogWriter().println(temp);
            }
        }
        catch (Exception ex) {
            throw new XAException(ex.getMessage());
        }
    }
}

