/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.SQLMXMessages;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.util.Locale;

class Utility {
    private static final byte[] key = Utility.UnicodeToAscii("ci4mg04-3;b,hl;y'd1qx8ngp93nGpoOp4HlD7vm>o(fHoPdkdkhp1`gl0hgqERIFdlIFlw48fgljksg3oi5980rfd4t8u9dfvkl");
    static final BigDecimal long_maxbd = BigDecimal.valueOf(Long.MAX_VALUE);
    static final BigDecimal long_minbd = BigDecimal.valueOf(Long.MIN_VALUE);

    Utility() {
    }

    static byte[] UnicodeToAscii(String original) {
        try {
            byte[] utf8Bytes = original.getBytes("UTF8");
            return utf8Bytes;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    static boolean Encryption(byte[] inBuffer, byte[] outBuffer, int inLength) {
        if (outBuffer != inBuffer) {
            System.arraycopy(outBuffer, 0, inBuffer, 0, inLength);
        }
        int i = 0;
        while (i < inLength) {
            int j = i % 100;
            int n = i++;
            outBuffer[n] = (byte)(outBuffer[n] ^ key[j]);
        }
        return true;
    }

    static void checkFloatBoundary(Locale locale, BigDecimal inbd) throws SQLException {
        double indbl = inbd.doubleValue();
        if (indbl > 3.4028234663852886E38) {
            throw SQLMXMessages.createSQLException(null, locale, "numeric_out_of_range", inbd.toString());
        }
    }

    static void checkDoubleBoundary(Locale locale, BigDecimal inbd) throws SQLException {
        BigDecimal maxbd = new BigDecimal(Double.MAX_VALUE);
        if (inbd.compareTo(maxbd) > 0) {
            throw SQLMXMessages.createSQLException(null, locale, "numeric_out_of_range", inbd.toString());
        }
    }

    static void checkIntegerBoundary(Locale locale, BigDecimal inbd) throws SQLException {
        long inlong = inbd.longValue();
        if (inlong > Integer.MAX_VALUE || inlong < Integer.MIN_VALUE) {
            throw SQLMXMessages.createSQLException(null, locale, "numeric_out_of_range", String.valueOf(inlong));
        }
    }

    static void checkSignedLongBoundary(Locale locale, BigDecimal inbd) throws SQLException {
        long inlong = inbd.longValue();
        BigDecimal maxbd = new BigDecimal(Long.MAX_VALUE);
        maxbd = maxbd.add(maxbd);
        if (inlong < 0L || inbd.compareTo(maxbd) > 0) {
            throw SQLMXMessages.createSQLException(null, locale, "numeric_out_of_range", String.valueOf(inlong));
        }
    }

    static void checkSignedShortBoundary(Locale locale, BigDecimal inbd) throws SQLException {
        long inlong = inbd.longValue();
        long maxushort = 65535L;
        if (inlong < 0L || inlong > maxushort) {
            throw SQLMXMessages.createSQLException(null, locale, "numeric_out_of_range", String.valueOf(inlong));
        }
    }

    static void checkUnsignedIntegerBoundary(Locale locale, BigDecimal inbd) throws SQLException {
        long inlong = inbd.longValue();
        long maxuint = 0xFFFFFFFFL;
        if (inlong < 0L || inlong > maxuint) {
            throw SQLMXMessages.createSQLException(null, locale, "numeric_out_of_range", String.valueOf(inlong));
        }
    }

    static void checkTinyintBoundary(Locale locale, BigDecimal inbd) throws SQLException {
        long inlong = inbd.longValue();
        if (inlong > 127L || inlong < -128L) {
            throw SQLMXMessages.createSQLException(null, locale, "numeric_out_of_range", String.valueOf(inlong));
        }
    }

    static void checkShortBoundary(Locale locale, BigDecimal inbd) throws SQLException {
        long inlong = inbd.longValue();
        if (inlong > 32767L || inlong < -32768L) {
            throw SQLMXMessages.createSQLException(null, locale, "numeric_out_of_range", String.valueOf(inlong));
        }
    }

    static BigDecimal getBigDecimalValue(Locale locale, Object paramValue) throws SQLException {
        BigDecimal tmpbd;
        if (paramValue instanceof Long) {
            tmpbd = BigDecimal.valueOf((Long)paramValue);
        } else if (paramValue instanceof Integer) {
            tmpbd = BigDecimal.valueOf(((Integer)paramValue).longValue());
        } else if (paramValue instanceof BigDecimal) {
            tmpbd = (BigDecimal)paramValue;
        } else if (paramValue instanceof String) {
            String sVal = (String)paramValue;
            if (sVal.equals("true")) {
                sVal = "1";
            } else if (sVal.equals("false")) {
                sVal = "0";
            }
            tmpbd = new BigDecimal(sVal);
        } else if (paramValue instanceof Float) {
            tmpbd = new BigDecimal(paramValue.toString());
        } else if (paramValue instanceof Double) {
            tmpbd = new BigDecimal(((Double)paramValue).toString());
        } else if (paramValue instanceof Boolean) {
            tmpbd = BigDecimal.valueOf((Boolean)paramValue == true ? 1 : 0);
        } else if (paramValue instanceof Byte) {
            tmpbd = BigDecimal.valueOf(((Byte)paramValue).longValue());
        } else if (paramValue instanceof Short) {
            tmpbd = BigDecimal.valueOf(((Short)paramValue).longValue());
        } else if (paramValue instanceof Integer) {
            tmpbd = BigDecimal.valueOf(((Integer)paramValue).longValue());
        } else {
            throw SQLMXMessages.createSQLException(null, locale, "object_type_not_supported", paramValue);
        }
        return tmpbd;
    }

    static void checkDecimalBoundary(Locale locale, BigDecimal inbd, int precision) throws SQLException {
        if (precision > 0) {
            BigDecimal maxbd = new BigDecimal(Math.pow(10.0, precision));
            BigDecimal minbd = maxbd.negate();
            if (inbd.compareTo(maxbd) >= 0 || inbd.compareTo(minbd) < 0) {
                throw SQLMXMessages.createSQLException(null, locale, "numeric_out_of_range", inbd.toString());
            }
        }
    }

    private static int getExtraLen(String s) {
        int extra = 0;
        int inx = s.indexOf(".");
        if (inx != -1) {
            char ch;
            int len = s.length();
            for (int i = len - 1; i > inx && (ch = s.charAt(i)) == '0'; --i) {
                ++extra;
            }
        }
        if (s.startsWith("0.") || s.startsWith("-0.")) {
            ++extra;
        }
        return extra;
    }

    static void checkDecimalTruncation(int parameterIndex, Locale locale, BigDecimal inbd, int precision, int scale) throws SQLException {
        if (precision <= 0) {
            return;
        }
        int expectedLen = precision;
        if (scale > 0) {
            expectedLen = precision + 1;
        }
        if (inbd.signum() == -1) {
            ++expectedLen;
        }
        int actualLen = 0;
        expectedLen += Utility.getExtraLen(inbd.toString());
        actualLen = inbd.toString().length();
        if (precision > 0) {
            BigDecimal maxbd = new BigDecimal(Math.pow(10.0, precision - scale));
            BigDecimal minbd = maxbd.negate();
            if (inbd.compareTo(maxbd) >= 0 || inbd.compareTo(minbd) < 0) {
                DataTruncation dt = new DataTruncation(parameterIndex, true, false, actualLen, expectedLen);
                dt.setNextException(new SQLException("DataTruncation", "22003", -8411));
                throw dt;
            }
        }
    }

    static void checkLongBoundary(Locale locale, BigDecimal inbd) throws SQLException {
        if (inbd.compareTo(long_maxbd) > 0 || inbd.compareTo(long_minbd) < 0) {
            throw SQLMXMessages.createSQLException(null, locale, "numeric_out_of_range", inbd.toString());
        }
    }

    static void checkLongTruncation(int parameterindex, BigDecimal inbd) throws SQLException {
        double indbl;
        long inlong = inbd.longValue();
        if ((double)inlong != (indbl = inbd.doubleValue())) {
            int sizeLong = String.valueOf(inlong).length();
            int sizeDbl = String.valueOf(indbl).length();
            DataTruncation dt = new DataTruncation(parameterindex, true, false, sizeLong, sizeDbl);
            dt.setNextException(new SQLException("DataTruncation", "22003", -8411));
            throw dt;
        }
    }

    static int getRoundingMode(String roundMode) {
        int op_roundMode = 4;
        if (roundMode == null) {
            op_roundMode = 4;
        } else if (roundMode.equals("ROUND_CEILING")) {
            op_roundMode = 2;
        } else if (roundMode.equals("ROUND_DOWN")) {
            op_roundMode = 1;
        } else if (roundMode.equals("ROUND_FLOOR")) {
            op_roundMode = 3;
        } else if (roundMode.equals("ROUND_HALF_UP")) {
            op_roundMode = 4;
        } else if (roundMode.equals("ROUND_UNNECESSARY")) {
            op_roundMode = 7;
        } else if (roundMode.equals("ROUND_HALF_EVEN")) {
            op_roundMode = 6;
        } else if (roundMode.equals("ROUND_HALF_DOWN")) {
            op_roundMode = 5;
        } else if (roundMode.equals("ROUND_UP")) {
            op_roundMode = 0;
        } else {
            try {
                op_roundMode = Utility.getRoundingMode(Integer.parseInt(roundMode));
            }
            catch (Exception ex) {
                op_roundMode = 4;
            }
        }
        return op_roundMode;
    }

    static int getRoundingMode(int roundMode) {
        if (roundMode == 2 || roundMode == 1 || roundMode == 0 || roundMode == 3 || roundMode == 4 || roundMode == 7 || roundMode == 6 || roundMode == 5) {
            return roundMode;
        }
        return 4;
    }

    static BigDecimal setScale(BigDecimal tmpbd, int scale, int roundingMode) throws SQLException {
        try {
            if (scale > -1) {
                tmpbd = tmpbd.setScale(scale, roundingMode);
            }
        }
        catch (ArithmeticException aex) {
            throw new SQLException(aex.getMessage());
        }
        return tmpbd;
    }
}

