/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

import com.tandem.t4jdbc.LogicalByteArray;
import com.tandem.t4jdbc.SQLMXMessages;
import com.tandem.t4jdbc.T4Properties;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Locale;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XID_def
implements Xid {
    static final int XIDDATASIZE = 128;
    private int formatID;
    int gtrid_length;
    int bqual_length;
    private byte[] data;
    private T4Properties m_t4props;
    private int hashCode = 0;

    int sizeof() {
        return 140;
    }

    int dataLength() {
        return 128;
    }

    private void initializeData() {
        this.data = new byte[this.dataLength()];
        Arrays.fill(this.data, (byte)0);
    }

    public XID_def(T4Properties t4props, LogicalByteArray buffer1, int index1) {
        buffer1.setLocation(index1);
        this.m_t4props = t4props;
        this.formatID = buffer1.extractInt();
        index1 += 4;
        this.gtrid_length = buffer1.extractInt();
        index1 += 4;
        this.bqual_length = buffer1.extractInt();
        index1 += 4;
        this.data = buffer1.extractByteArray(this.dataLength());
        index1 += this.dataLength();
        this.hashCode = this.toString().hashCode();
    }

    public XID_def(T4Properties t4props, Xid xid) throws XAException {
        this.m_t4props = t4props;
        if (xid == null) {
            XAException xaex = new XAException(-5);
            XAException xaex1 = new XAException("Invalid Xid. Xid is null");
            xaex.setStackTrace(xaex1.getStackTrace());
            throw xaex;
        }
        this.formatID = xid.getFormatId();
        if (this.formatID < 0) {
            XAException xaex = new XAException(-5);
            XAException xaex1 = new XAException("Invalid Xid. FormatID is null");
            xaex.setStackTrace(xaex1.getStackTrace());
            throw xaex;
        }
        byte[] gtrid = xid.getGlobalTransactionId();
        if (gtrid == null) {
            XAException xaex = new XAException(-5);
            XAException xaex1 = new XAException("Invalid Xid. Global Transaction ID is null");
            xaex.setStackTrace(xaex1.getStackTrace());
            throw xaex;
        }
        this.gtrid_length = gtrid.length;
        if (this.gtrid_length < 1 || this.gtrid_length > 64) {
            XAException xaex = new XAException(-5);
            XAException xaex1 = new XAException("Invalid Xid. Incorrect Global Transaction Id length.");
            xaex.setStackTrace(xaex1.getStackTrace());
            throw xaex;
        }
        byte[] bqual = xid.getBranchQualifier();
        if (bqual == null) {
            XAException xaex = new XAException(-5);
            XAException xaex1 = new XAException("Invalid Xid. Branch Qualifier is null");
            xaex.setStackTrace(xaex1.getStackTrace());
            throw xaex;
        }
        this.bqual_length = bqual.length;
        if (this.bqual_length < 1 || this.bqual_length > 64) {
            XAException xaex = new XAException(-5);
            XAException xaex1 = new XAException("Invalid Xid. Incorrect Branch Qualifier length.");
            xaex.setStackTrace(xaex1.getStackTrace());
            throw xaex;
        }
        this.initializeData();
        System.arraycopy(gtrid, 0, this.data, 0, this.gtrid_length);
        System.arraycopy(bqual, 0, this.data, this.gtrid_length, this.bqual_length);
        this.hashCode = this.toString().hashCode();
    }

    public XID_def(T4Properties t4props, int p_formatId, String p_gtrid, String p_bqual) {
        this.m_t4props = t4props;
        this.formatID = p_formatId;
        byte[] gtrid = p_gtrid.getBytes();
        this.gtrid_length = gtrid.length;
        byte[] bqual = p_bqual.getBytes();
        this.bqual_length = bqual.length;
        this.initializeData();
        System.arraycopy(gtrid, 0, this.data, 0, this.gtrid_length);
        System.arraycopy(bqual, 0, this.data, this.gtrid_length, this.bqual_length);
        this.hashCode = this.toString().hashCode();
    }

    int extractFromByteArray(LogicalByteArray buffer1, int index1, int hIndex, Locale locale, String addr) throws SQLException {
        buffer1.setLocation(index1);
        this.formatID = buffer1.extractInt();
        index1 += 4;
        this.gtrid_length = buffer1.extractInt();
        index1 += 4;
        this.bqual_length = buffer1.extractInt();
        index1 += 4;
        this.data = buffer1.extractByteArray(this.dataLength());
        return index1 += this.dataLength();
    }

    void printObject(String indent) {
        String newIndent = indent + "  ";
        System.out.println(indent + "XID_def");
        System.out.println(newIndent + "formatID = " + this.formatID);
        System.out.println(newIndent + "gtrid_length = " + this.gtrid_length);
        System.out.println(newIndent + "bqual_length = " + this.bqual_length);
        System.out.println(newIndent + "data = " + this.data);
    }

    String toString(String indent) {
        String temp1 = "";
        String newIndent = indent + "  ";
        temp1 = temp1 + indent + "XID_def" + "\n";
        temp1 = temp1 + newIndent + "formatID = " + this.formatID + "\n";
        temp1 = temp1 + newIndent + "gtrid_length = " + this.gtrid_length + "\n";
        temp1 = temp1 + newIndent + "bqual_length = " + this.bqual_length + "\n";
        temp1 = temp1 + newIndent + "data = " + this.data + "\n";
        return temp1;
    }

    public int getFormatId() {
        return this.formatID;
    }

    public byte[] getGlobalTransactionId() {
        byte[] gtrid = new byte[this.gtrid_length];
        System.arraycopy(this.data, 0, gtrid, 0, this.gtrid_length);
        return gtrid;
    }

    public byte[] getBranchQualifier() {
        byte[] bqual = new byte[this.bqual_length];
        System.arraycopy(this.data, this.gtrid_length, bqual, 0, this.bqual_length);
        return bqual;
    }

    public void checkSize() throws SQLException {
        if (this.gtrid_length > 64 || this.bqual_length > 64 || this.data.length > 128) {
            SQLMXMessages.createSQLException(this.m_t4props, this.m_t4props == null ? null : this.m_t4props.getLocale(), "xid_size_incorrect", "XID size is incorrect.");
        }
    }

    static String getGlobalIdAsString(Xid p_xid) {
        String l_xid = null;
        try {
            byte[] gtrid = p_xid.getGlobalTransactionId();
            int lengthAsString = 0;
            if (gtrid != null) {
                lengthAsString += 2 * gtrid.length;
            }
            StringBuffer asString = new StringBuffer(lengthAsString);
            if (gtrid != null) {
                for (int i = 0; i < gtrid.length; ++i) {
                    String asHex = Integer.toHexString(gtrid[i] & 0xFF);
                    if (asHex.length() == 1) {
                        asString.append("0");
                    }
                    asString.append(asHex);
                }
            }
            l_xid = asString.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l_xid;
    }

    static String toString(Xid p_xid) {
        String l_xid = null;
        try {
            String asHex;
            int i;
            byte[] gtrid = p_xid.getGlobalTransactionId();
            byte[] btrid = p_xid.getBranchQualifier();
            int lengthAsString = 1;
            if (gtrid != null) {
                lengthAsString += 2 * gtrid.length;
            }
            if (btrid != null) {
                lengthAsString += 2 * btrid.length;
            }
            StringBuffer asString = new StringBuffer(lengthAsString);
            if (gtrid != null) {
                for (i = 0; i < gtrid.length; ++i) {
                    asHex = Integer.toHexString(gtrid[i] & 0xFF);
                    if (asHex.length() == 1) {
                        asString.append("0");
                    }
                    asString.append(asHex);
                }
            }
            if (btrid != null) {
                asString.append(".");
                for (i = 0; i < btrid.length; ++i) {
                    asHex = Integer.toHexString(btrid[i] & 0xFF);
                    if (asHex.length() == 1) {
                        asString.append("0");
                    }
                    asString.append(asHex);
                }
            }
            l_xid = asString.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l_xid;
    }

    public String toString() {
        return XID_def.toString(this);
    }

    public boolean equals(Object p_x1) {
        boolean l_isEqual = false;
        if (p_x1 instanceof XID_def) {
            l_isEqual = this.equals((Xid)p_x1);
        } else if (p_x1 instanceof Xid) {
            l_isEqual = this.equals((Xid)p_x1);
        }
        return l_isEqual;
    }

    private boolean equals(Xid x1) {
        if (x1 == null) {
            return false;
        }
        if (x1.getFormatId() != this.getFormatId()) {
            return false;
        }
        if (!Arrays.equals(x1.getGlobalTransactionId(), this.getGlobalTransactionId())) {
            return false;
        }
        return Arrays.equals(x1.getBranchQualifier(), this.getBranchQualifier());
    }

    public int hashCode() {
        return this.hashCode;
    }
}

