/*
 * Decompiled with CFR 0.152.
 */
package com.tandem.t4jdbc;

class toByte {
    toByte() {
    }

    static int fromShort(byte[] buffer, int index, short value) {
        buffer[index + 1] = (byte)(value & 0xFF);
        buffer[index + 0] = (byte)(value >>> 8 & 0xFF);
        return index + 2;
    }

    static int fromInt(byte[] buffer, int index, int value) {
        buffer[index + 3] = (byte)(value & 0xFF);
        buffer[index + 2] = (byte)(value >>> 8 & 0xFF);
        buffer[index + 1] = (byte)(value >>> 16 & 0xFF);
        buffer[index + 0] = (byte)(value >>> 24 & 0xFF);
        return index + 4;
    }

    static int fromLong(byte[] buffer, int index, long value) {
        buffer[index + 7] = (byte)(value & 0xFFL);
        buffer[index + 6] = (byte)(value >>> 8 & 0xFFL);
        buffer[index + 5] = (byte)(value >>> 16 & 0xFFL);
        buffer[index + 4] = (byte)(value >>> 24 & 0xFFL);
        buffer[index + 3] = (byte)(value >>> 32 & 0xFFL);
        buffer[index + 2] = (byte)(value >>> 40 & 0xFFL);
        buffer[index + 1] = (byte)(value >>> 48 & 0xFFL);
        buffer[index + 0] = (byte)(value >>> 56 & 0xFFL);
        return index + 8;
    }

    static int fromChar(byte[] buffer, int index, char value) {
        buffer[index] = (byte)(value & 0xFF);
        return index + 1;
    }

    static short read_short(byte[] buffer, int index) {
        int lv_return = buffer[index + 1] & 0xFF | buffer[index + 0] << 8 & 0xFF00;
        return (short)lv_return;
    }

    static int read_unsigned_short(byte[] buffer, int index) {
        int lv_return = buffer[index + 1] & 0xFF | buffer[index + 0] << 8 & 0xFF00;
        return lv_return;
    }

    static int read_int(byte[] buffer, int index) {
        int lv_return = buffer[index + 3] & 0xFF | buffer[index + 2] << 8 & 0xFF00 | buffer[index + 1] << 16 & 0xFF0000 | buffer[index + 0] << 24 & 0xFF000000;
        return lv_return;
    }

    static long read_unsigned_int(byte[] buffer, int index) {
        long lv_l1 = 0L;
        lv_l1 = 0L;
        long lv_l2 = buffer[index + 0] << 24 & 0xFF000000 | buffer[index + 1] << 16 & 0xFF0000 | buffer[index + 2] << 8 & 0xFF00 | buffer[index + 3] & 0xFF;
        long lv_return = lv_l1 << 32 | lv_l2 & 0xFFFFFFFFL;
        return lv_return;
    }

    static long read_long(byte[] buffer, int index) {
        long lv_l1 = buffer[index + 0] << 24 & 0xFF000000 | buffer[index + 1] << 16 & 0xFF0000 | buffer[index + 2] << 8 & 0xFF00 | buffer[index + 3] & 0xFF;
        long lv_l2 = buffer[index + 4] << 24 & 0xFF000000 | buffer[index + 5] << 16 & 0xFF0000 | buffer[index + 6] << 8 & 0xFF00 | buffer[index + 7] & 0xFF;
        long lv_return = lv_l1 << 32 | lv_l2 & 0xFFFFFFFFL;
        return lv_return;
    }

    static char read_char(byte b1) {
        char la_char = (char)(b1 & 0xFF);
        return la_char;
    }

    static char read_char(byte[] buffer, int index) {
        return toByte.read_char(buffer[index]);
    }

    static char[] read_chars(byte[] buffer, int index) {
        int len = 0;
        while (buffer[index + len] != 0) {
            ++len;
        }
        char[] temp1 = toByte.read_chars(buffer, index, len);
        return temp1;
    }

    static char[] read_chars(byte[] buffer, int index, int tLen) {
        int len = tLen;
        if (len == -1) {
            int ii = index;
            while (buffer[ii] != 0) {
                ++ii;
            }
            len = ii - index;
        }
        char[] la_chars = new char[len];
        int i = 0;
        while (i < len) {
            la_chars[i] = (char)(buffer[index] & 0xFF);
            ++i;
            ++index;
        }
        return la_chars;
    }

    static byte[] write_short(int pv_short) {
        byte[] ibuffer = new byte[]{(byte)(pv_short >>> 8 & 0xFF), (byte)(pv_short & 0xFF)};
        return ibuffer;
    }

    static byte[] write_int(int pv_int) {
        byte[] ibuffer = new byte[]{(byte)(pv_int >>> 24 & 0xFF), (byte)(pv_int >>> 16 & 0xFF), (byte)(pv_int >>> 8 & 0xFF), (byte)(pv_int & 0xFF)};
        return ibuffer;
    }

    static byte[] write_long(long pv_long) {
        byte[] ibuffer = new byte[]{(byte)(pv_long >>> 56 & 0xFFL), (byte)(pv_long >>> 48 & 0xFFL), (byte)(pv_long >>> 40 & 0xFFL), (byte)(pv_long >>> 32 & 0xFFL), (byte)(pv_long >>> 24 & 0xFFL), (byte)(pv_long >>> 16 & 0xFFL), (byte)(pv_long >>> 8 & 0xFFL), (byte)(pv_long & 0xFFL)};
        return ibuffer;
    }
}

