/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jgrapht.graph.MaskFunctor;
import org.jgrapht.util.PrefetchIterator;
import org.jgrapht.util.TypeUtil;

class MaskVertexSet<V, E>
extends AbstractSet<V> {
    private MaskFunctor<V, E> mask;
    private Set<V> vertexSet;
    private transient TypeUtil<V> vertexTypeDecl = null;

    public MaskVertexSet(Set<V> vertexSet, MaskFunctor<V, E> mask) {
        this.vertexSet = vertexSet;
        this.mask = mask;
    }

    @Override
    public boolean contains(Object o) {
        Object v = o;
        return this.vertexSet.contains(v) && !this.mask.isVertexMasked(v);
    }

    @Override
    public Iterator<V> iterator() {
        return new PrefetchIterator(new MaskVertexSetNextElementFunctor());
    }

    @Override
    public int size() {
        return (int)this.vertexSet.stream().filter(v -> this.contains(v)).count();
    }

    private class MaskVertexSetNextElementFunctor
    implements PrefetchIterator.NextElementFunctor<V> {
        private Iterator<V> iter;

        public MaskVertexSetNextElementFunctor() {
            this.iter = MaskVertexSet.this.vertexSet.iterator();
        }

        @Override
        public V nextElement() throws NoSuchElementException {
            Object element = this.iter.next();
            while (MaskVertexSet.this.mask.isVertexMasked(element)) {
                element = this.iter.next();
            }
            return element;
        }
    }
}

