/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.list;

import java.io.Externalizable;
import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.multimap.list.ImmutableListMultimap;
import org.eclipse.collections.api.multimap.list.MutableListMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.AbstractSynchronizedPutMultimap;
import org.eclipse.collections.impl.multimap.bag.HashBagMultimap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.multimap.list.ImmutableListMultimapImpl;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;

public final class SynchronizedPutFastListMultimap<K, V>
extends AbstractSynchronizedPutMultimap<K, V, MutableList<V>>
implements MutableListMultimap<K, V>,
Externalizable {
    private static final long serialVersionUID = 42L;

    public SynchronizedPutFastListMultimap() {
    }

    public SynchronizedPutFastListMultimap(int initialCapacity) {
        super(ConcurrentHashMap.newMap(initialCapacity));
    }

    public SynchronizedPutFastListMultimap(Multimap<? extends K, ? extends V> multimap) {
        this.putAll(multimap);
    }

    public SynchronizedPutFastListMultimap(Pair<K, V> ... pairs) {
        this();
        ArrayIterate.forEach(pairs, (Procedure & Serializable)pair -> this.put(pair.getOne(), pair.getTwo()));
    }

    public SynchronizedPutFastListMultimap(Iterable<Pair<K, V>> inputIterable) {
        this();
        Iterate.forEach(inputIterable, arg_0 -> this.add(arg_0));
    }

    public static <K, V> SynchronizedPutFastListMultimap<K, V> newMultimap() {
        return new SynchronizedPutFastListMultimap<K, V>();
    }

    public static <K, V> SynchronizedPutFastListMultimap<K, V> newMultimap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new SynchronizedPutFastListMultimap<K, V>(initialCapacity);
    }

    public static <K, V> SynchronizedPutFastListMultimap<K, V> newMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new SynchronizedPutFastListMultimap<K, V>(multimap);
    }

    public static <K, V> SynchronizedPutFastListMultimap<K, V> newMultimap(Pair<K, V> ... pairs) {
        return new SynchronizedPutFastListMultimap<K, V>(pairs);
    }

    public static <K, V> SynchronizedPutFastListMultimap<K, V> newMultimap(Iterable<Pair<K, V>> inputIterable) {
        return new SynchronizedPutFastListMultimap<K, V>(inputIterable);
    }

    @Override
    protected MutableList<V> createCollection() {
        return FastList.newList(1);
    }

    public SynchronizedPutFastListMultimap<K, V> newEmpty() {
        return new SynchronizedPutFastListMultimap<K, V>();
    }

    public MutableListMultimap<K, V> toMutable() {
        return new SynchronizedPutFastListMultimap<K, V>(this);
    }

    public ImmutableListMultimap<K, V> toImmutable() {
        UnifiedMap map = UnifiedMap.newMap();
        this.map.forEachKeyValue((Procedure2 & Serializable)(key, list) -> {
            ImmutableList cfr_ignored_0 = (ImmutableList)map.put(key, list.toImmutable());
        });
        return new ImmutableListMultimapImpl(map);
    }

    public MutableBagMultimap<V, K> flip() {
        return Iterate.flip(this);
    }

    public FastListMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return this.selectKeysValues(predicate, FastListMultimap.newMultimap());
    }

    public FastListMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        return this.rejectKeysValues(predicate, FastListMultimap.newMultimap());
    }

    public FastListMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return this.selectKeysMultiValues(predicate, FastListMultimap.newMultimap());
    }

    public FastListMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        return this.rejectKeysMultiValues(predicate, FastListMultimap.newMultimap());
    }

    public <K2, V2> HashBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        return this.collectKeysValues(function, HashBagMultimap.newMultimap());
    }

    public <V2> FastListMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        return this.collectValues(function, FastListMultimap.newMultimap());
    }

    public MutableListMultimap<K, V> asSynchronized() {
        throw new UnsupportedOperationException("Cannot call asSynchronized() on " + this.getClass().getSimpleName());
    }
}

