/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSChannel;
import com.microsoft.sqlserver.jdbc.TDSType;
import com.microsoft.sqlserver.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

final class TDSWriter {
    private static Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.TDS.Writer");
    private final TDSChannel tdsChannel;
    private final SQLServerConnection con;
    private boolean dataIsLoggable = true;
    private byte tdsMessageType;
    private static final byte TDS_MESSAGE_STATUS_NORMAL = 0;
    private static final byte TDS_MESSAGE_STATUS_EOM = 1;
    private static final byte TDS_MESSAGE_STATUS_ATTENTION = 2;
    private static final byte TDS_MESSAGE_STATUS_RESET_CONN = 8;
    private boolean atEOM = false;
    private volatile boolean attentionRaised = false;
    private volatile int sendResetConnection = 0;
    private SQLServerException attentionReason = null;
    private int currentPacketSize = 0;
    private static final int TDS_PACKET_HEADER_SIZE = 8;
    private static final byte[] placeholderHeader = new byte[8];
    private byte[] valueBytes = new byte[256];
    private int packetNum = 0;
    private ByteBuffer stagingBuffer;
    private ByteBuffer socketBuffer;
    private ByteBuffer logBuffer;

    public final String toString() {
        return "TDSWriter@" + Integer.toHexString(this.hashCode()) + " (" + this.con.toString() + ")";
    }

    void setDataLoggable(boolean bl) {
        this.dataIsLoggable = bl;
    }

    TDSWriter(TDSChannel tDSChannel, SQLServerConnection sQLServerConnection) {
        this.tdsChannel = tDSChannel;
        this.con = sQLServerConnection;
    }

    void preparePacket() throws SQLServerException {
        if (this.atEOM) {
            return;
        }
        if (this.tdsChannel.isLoggingPackets()) {
            Arrays.fill(this.logBuffer.array(), (byte)-2);
            this.logBuffer.clear();
        }
        this.writeBytes(placeholderHeader);
    }

    void writeMessageHeader() throws SQLServerException {
        if ((1 == this.tdsMessageType || 14 == this.tdsMessageType || 3 == this.tdsMessageType) && this.con.isYukonOrLater()) {
            this.writeInt(22);
            this.writeInt(18);
            this.writeShort((short)2);
            this.writeBytes(this.con.getTransactionDescriptor());
            this.writeInt(1);
        }
    }

    TDSWriter startMessage(byte by) throws SQLServerException {
        this.tdsMessageType = by;
        this.atEOM = false;
        if (6 != by) {
            this.attentionRaised = false;
            this.attentionReason = null;
        }
        this.packetNum = 0;
        this.dataIsLoggable = true;
        int n = this.con.getTDSPacketSize();
        if (this.currentPacketSize != n) {
            this.socketBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            this.stagingBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            this.logBuffer = ByteBuffer.allocate(n).order(ByteOrder.LITTLE_ENDIAN);
            this.currentPacketSize = n;
        }
        this.socketBuffer.position(this.socketBuffer.limit());
        this.stagingBuffer.clear();
        this.preparePacket();
        this.writeMessageHeader();
        return this;
    }

    final void endMessage() throws SQLServerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " Finishing TDS message");
        }
        this.writePacket(1);
    }

    final void raiseAttention(SQLServerException sQLServerException) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " Raising attention reason:" + sQLServerException.getMessage());
        }
        assert (1 == sQLServerException.getDriverErrorCode());
        this.attentionReason = sQLServerException;
        this.attentionRaised = true;
    }

    final void resetPooledConnection() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " resetPooledConnection");
        }
        this.sendResetConnection = 8;
    }

    void writeByte(byte by) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 1) {
            this.stagingBuffer.put(by);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(by);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 1);
                }
            }
        } else {
            this.valueBytes[0] = by;
            this.writeWrappedBytes(this.valueBytes, 1);
        }
    }

    void writeChar(char c) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putChar(c);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putChar(c);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            Util.writeShort((short)c, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeShort(short s) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 2) {
            this.stagingBuffer.putShort(s);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putShort(s);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 2);
                }
            }
        } else {
            Util.writeShort(s, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 2);
        }
    }

    void writeInt(int n) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 4) {
            this.stagingBuffer.putInt(n);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putInt(n);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 4);
                }
            }
        } else {
            Util.writeInt(n, this.valueBytes, 0);
            this.writeWrappedBytes(this.valueBytes, 4);
        }
    }

    void writeLong(long l) throws SQLServerException {
        if (this.stagingBuffer.remaining() >= 8) {
            this.stagingBuffer.putLong(l);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.putLong(l);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + 8);
                }
            }
        } else {
            this.valueBytes[0] = (byte)(l >> 0 & 0xFFL);
            this.valueBytes[1] = (byte)(l >> 8 & 0xFFL);
            this.valueBytes[2] = (byte)(l >> 16 & 0xFFL);
            this.valueBytes[3] = (byte)(l >> 24 & 0xFFL);
            this.valueBytes[4] = (byte)(l >> 32 & 0xFFL);
            this.valueBytes[5] = (byte)(l >> 40 & 0xFFL);
            this.valueBytes[6] = (byte)(l >> 48 & 0xFFL);
            this.valueBytes[7] = (byte)(l >> 56 & 0xFFL);
            this.writeWrappedBytes(this.valueBytes, 8);
        }
    }

    void writeBytes(byte[] byArray) throws SQLServerException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    void writeBytes(byte[] byArray, int n, int n2) throws SQLServerException {
        int n3;
        assert (n2 <= byArray.length);
        int n4 = 0;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + " Writing " + n2 + " bytes");
        }
        while ((n3 = n2 - n4) > 0) {
            if (0 == this.stagingBuffer.remaining()) {
                this.writePacket(0);
            }
            if (n3 > this.stagingBuffer.remaining()) {
                n3 = this.stagingBuffer.remaining();
            }
            this.stagingBuffer.put(byArray, n + n4, n3);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, n + n4, n3);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n3);
                }
            }
            n4 += n3;
        }
    }

    void writeWrappedBytes(byte[] byArray, int n) throws SQLServerException {
        assert (n <= byArray.length);
        assert (this.stagingBuffer.remaining() < n);
        assert (n <= this.stagingBuffer.capacity());
        int n2 = this.stagingBuffer.remaining();
        if (n2 > 0) {
            this.stagingBuffer.put(byArray, 0, n2);
            if (this.tdsChannel.isLoggingPackets()) {
                if (this.dataIsLoggable) {
                    this.logBuffer.put(byArray, 0, n2);
                } else {
                    this.logBuffer.position(this.logBuffer.position() + n2);
                }
            }
        }
        this.writePacket(0);
        this.stagingBuffer.put(byArray, n2, n - n2);
        if (this.tdsChannel.isLoggingPackets()) {
            if (this.dataIsLoggable) {
                this.logBuffer.put(byArray, n2, n - n2);
            } else {
                this.logBuffer.position(this.logBuffer.position() + n2);
            }
        }
    }

    void writeString(String string) throws SQLServerException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = 2 * (n2 - n);
            if (n3 > this.valueBytes.length) {
                n3 = this.valueBytes.length;
            }
            int n4 = 0;
            while (n4 < n3) {
                char c = string.charAt(n++);
                this.valueBytes[n4++] = (byte)(c >> 0 & 0xFF);
                this.valueBytes[n4++] = (byte)(c >> 8 & 0xFF);
            }
            this.writeBytes(this.valueBytes, 0, n4);
        }
    }

    void writeStream(InputStream inputStream, long l, boolean bl) throws SQLServerException {
        MessageFormat messageFormat;
        Object[] objectArray;
        int n;
        assert (-1L == l || l >= 0L);
        long l2 = 0L;
        byte[] byArray = new byte[4 * this.currentPacketSize];
        int n2 = 0;
        do {
            for (n = 0; -1 != n2 && n < byArray.length; n += n2) {
                try {
                    n2 = inputStream.read(byArray, n, byArray.length - n);
                }
                catch (IOException iOException) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                    Object[] objectArray2 = new Object[]{iOException.toString()};
                    this.error(objectArray.format(objectArray2));
                }
                if (-1 == n2) break;
                if (n2 >= 0 && n2 <= byArray.length - n) continue;
                messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                objectArray = new Object[]{SQLServerException.getErrString("R_streamReadReturnedInvalidValue")};
                this.error(messageFormat.format(objectArray));
            }
            if (bl) {
                this.writeInt(n);
            }
            this.writeBytes(byArray, 0, n);
            l2 += (long)n;
        } while (-1 != n2 || n > 0);
        if (-1L != l && l2 != l) {
            messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            objectArray = new Object[]{l, l2};
            this.error(messageFormat.format(objectArray));
        }
    }

    void writeReader(Reader reader, long l, boolean bl) throws SQLServerException {
        Object[] objectArray;
        int n;
        assert (-1L == l || l >= 0L);
        long l2 = 0L;
        char[] cArray = new char[2 * this.currentPacketSize];
        byte[] byArray = new byte[4 * this.currentPacketSize];
        int n2 = 0;
        do {
            for (n = 0; -1 != n2 && n < cArray.length; n += n2) {
                try {
                    n2 = reader.read(cArray, n, cArray.length - n);
                }
                catch (IOException iOException) {
                    objectArray = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                    Object[] objectArray2 = new Object[]{iOException.toString()};
                    this.error(objectArray.format(objectArray2));
                }
                if (-1 == n2) break;
                if (n2 >= 0 && n2 <= cArray.length - n) continue;
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_errorReadingStream"));
                objectArray = new Object[]{SQLServerException.getErrString("R_streamReadReturnedInvalidValue")};
                this.error(messageFormat.format(objectArray));
            }
            if (bl) {
                this.writeInt(2 * n);
            }
            for (int i = 0; i < n; ++i) {
                byArray[2 * i] = (byte)(cArray[i] >> 0 & 0xFF);
                byArray[2 * i + 1] = (byte)(cArray[i] >> 8 & 0xFF);
            }
            this.writeBytes(byArray, 0, 2 * n);
            l2 += (long)n;
        } while (-1 != n2 || n > 0);
        if (-1L != l && l2 != l) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_mismatchedStreamLength"));
            objectArray = new Object[]{l, l2};
            this.error(messageFormat.format(objectArray));
        }
    }

    final void error(String string) throws SQLServerException {
        this.raiseAttention(SQLServerException.makeInterruptException(string));
        this.endMessage();
    }

    private final void writePacket(int n) throws SQLServerException {
        if (this.atEOM) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": Dropping packet...");
            }
            return;
        }
        if (6 != this.tdsMessageType && this.attentionRaised) {
            if (0 != this.packetNum) {
                ++this.tdsChannel.numMsgsSent;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(this.toString() + ": throwing interrupt exception, reason=" + this.attentionReason.getMessage());
            }
            throw this.attentionReason;
        }
        this.writePacketHeader(n | this.sendResetConnection);
        this.sendResetConnection = 0;
        this.flush();
        if (this.atEOM) {
            this.flush();
            ++this.tdsChannel.numMsgsSent;
        }
        if (16 == this.tdsMessageType && 1 == this.packetNum && 0 == this.con.getNegotiatedEncryptionLevel()) {
            this.tdsChannel.disableSSL();
        }
    }

    final boolean sendAttention() throws SQLServerException {
        if (0 == this.packetNum) {
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + ": sending attention signal to server");
        }
        this.startMessage((byte)6).endMessage();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.toString() + ": sent attention signal to server");
        }
        return true;
    }

    private final void writePacketHeader(int n) {
        int n2 = this.stagingBuffer.position();
        ++this.packetNum;
        this.stagingBuffer.put(0, this.tdsMessageType);
        this.stagingBuffer.put(1, (byte)n);
        this.stagingBuffer.put(2, (byte)(n2 >> 8 & 0xFF));
        this.stagingBuffer.put(3, (byte)(n2 >> 0 & 0xFF));
        this.stagingBuffer.put(4, (byte)(this.tdsChannel.getSPID() >> 8 & 0xFF));
        this.stagingBuffer.put(5, (byte)(this.tdsChannel.getSPID() >> 0 & 0xFF));
        this.stagingBuffer.put(6, (byte)(this.packetNum % 256));
        this.stagingBuffer.put(7, (byte)0);
        if (this.tdsChannel.isLoggingPackets()) {
            this.logBuffer.put(0, this.tdsMessageType);
            this.logBuffer.put(1, (byte)n);
            this.logBuffer.put(2, (byte)(n2 >> 8 & 0xFF));
            this.logBuffer.put(3, (byte)(n2 >> 0 & 0xFF));
            this.logBuffer.put(4, (byte)(this.tdsChannel.getSPID() >> 8 & 0xFF));
            this.logBuffer.put(5, (byte)(this.tdsChannel.getSPID() >> 0 & 0xFF));
            this.logBuffer.put(6, (byte)(this.packetNum % 256));
            this.logBuffer.put(7, (byte)0);
        }
        if (1 == (1 & n)) {
            this.atEOM = true;
        }
    }

    void flush() throws SQLServerException {
        this.tdsChannel.write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
        this.socketBuffer.position(this.socketBuffer.limit());
        if (this.stagingBuffer.position() >= 8) {
            ByteBuffer byteBuffer = this.stagingBuffer;
            this.stagingBuffer = this.socketBuffer;
            this.socketBuffer = byteBuffer;
            this.socketBuffer.flip();
            this.stagingBuffer.clear();
            if (this.tdsChannel.isLoggingPackets()) {
                this.tdsChannel.logPacket(this.logBuffer.array(), 0, this.socketBuffer.limit(), this.toString() + " sending packet (" + this.socketBuffer.limit() + " bytes)");
            }
            this.preparePacket();
            this.tdsChannel.write(this.socketBuffer.array(), this.socketBuffer.position(), this.socketBuffer.remaining());
            this.socketBuffer.position(this.socketBuffer.limit());
        }
    }

    private void writeRPCNameValType(String string, boolean bl, TDSType tDSType) throws SQLServerException {
        int n = 0;
        if (null != string) {
            n = string.length() + 1;
        }
        this.writeByte((byte)n);
        if (n > 0) {
            this.writeChar('@');
            this.writeString(string);
        }
        this.writeByte((byte)(bl ? 1 : 0));
        this.writeByte(tDSType.byteValue());
    }

    void writeRPCBit(String string, Boolean bl, boolean bl2) throws SQLServerException {
        this.writeRPCNameValType(string, bl2, TDSType.BITN);
        this.writeByte((byte)1);
        if (null == bl) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeByte((byte)(bl != false ? 1 : 0));
        }
    }

    void writeRPCByte(String string, Byte by, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)1);
        if (null == by) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)1);
            this.writeByte(by);
        }
    }

    void writeRPCShort(String string, Short s, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)2);
        if (null == s) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)2);
            this.writeShort(s);
        }
    }

    void writeRPCInt(String string, Integer n, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)4);
        if (null == n) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)4);
            this.writeInt(n);
        }
    }

    void writeRPCLong(String string, Long l, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.INTN);
        this.writeByte((byte)8);
        if (null == l) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)8);
            this.writeLong(l);
        }
    }

    void writeRPCReal(String string, Float f, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.FLOATN);
        if (null == f) {
            this.writeByte((byte)4);
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)4);
            this.writeByte((byte)4);
            this.writeInt(Float.floatToRawIntBits(f.floatValue()));
        }
    }

    void writeRPCDouble(String string, Double d, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.FLOATN);
        int n = 8;
        this.writeByte((byte)n);
        if (null == d) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)n);
            long l = Double.doubleToLongBits(d);
            long l2 = 255L;
            int n2 = 0;
            for (int i = 0; i < 8; ++i) {
                this.writeByte((byte)((l & l2) >> n2));
                n2 += 8;
                l2 <<= 8;
            }
        }
    }

    void writeRPCBigDecimal(String string, BigDecimal bigDecimal, int n, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.DECIMALN);
        this.writeByte((byte)17);
        this.writeByte((byte)38);
        byte[] byArray = DDC.convertBigDecimalToBytes(bigDecimal, n);
        this.writeBytes(byArray, 0, byArray.length);
    }

    void writeVMaxHeader(long l, boolean bl, SQLCollation sQLCollation) throws SQLServerException {
        this.writeShort((short)-1);
        if (null != sQLCollation) {
            sQLCollation.writeCollation(this);
        }
        if (bl) {
            this.writeLong(-1L);
        } else if (-1L == l) {
            this.writeLong(-2L);
        } else {
            this.writeLong(l);
        }
    }

    void writeRPCStringUnicode(String string) throws SQLServerException {
        this.writeRPCStringUnicode(null, string, false, null);
    }

    void writeRPCStringUnicode(String string, String string2, boolean bl, SQLCollation sQLCollation) throws SQLServerException {
        boolean bl2;
        boolean bl3;
        boolean bl4 = string2 == null;
        int n = bl4 ? 0 : 2 * string2.length();
        boolean bl5 = bl3 = n <= 8000;
        if (null == sQLCollation) {
            sQLCollation = this.con.getDatabaseCollation();
        }
        boolean bl6 = bl2 = this.con.isYukonOrLater() && (!bl3 || bl);
        if (bl2) {
            this.writeRPCNameValType(string, bl, TDSType.NVARCHAR);
            this.writeVMaxHeader(n, bl4, sQLCollation);
            if (!bl4) {
                if (n > 0) {
                    this.writeInt(n);
                    this.writeString(string2);
                }
                this.writeInt(0);
            }
        } else {
            if (bl3) {
                this.writeRPCNameValType(string, bl, TDSType.NVARCHAR);
                this.writeShort((short)8000);
            } else {
                this.writeRPCNameValType(string, bl, TDSType.NTEXT);
                this.writeInt(Integer.MAX_VALUE);
            }
            sQLCollation.writeCollation(this);
            if (bl4) {
                this.writeShort((short)-1);
            } else {
                if (bl3) {
                    this.writeShort((short)n);
                } else {
                    this.writeInt(n);
                }
                if (0 != n) {
                    this.writeString(string2);
                }
            }
        }
    }

    void writeRPCByteArray(String string, byte[] byArray, boolean bl, JDBCType jDBCType, SQLCollation sQLCollation) throws SQLServerException {
        TDSType tDSType;
        boolean bl2 = byArray == null;
        int n = bl2 ? 0 : byArray.length;
        boolean bl3 = n <= 8000;
        boolean bl4 = this.con.isYukonOrLater() && (!bl3 || bl);
        switch (jDBCType) {
            default: {
                tDSType = bl3 || bl4 ? TDSType.BIGVARBINARY : TDSType.IMAGE;
                sQLCollation = null;
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case LONGVARCHAR: 
            case CLOB: {
                TDSType tDSType2 = tDSType = bl3 || bl4 ? TDSType.BIGVARCHAR : TDSType.TEXT;
                if (null != sQLCollation) break;
                sQLCollation = this.con.getDatabaseCollation();
                break;
            }
            case NCHAR: 
            case NVARCHAR: 
            case LONGNVARCHAR: 
            case NCLOB: {
                TDSType tDSType3 = tDSType = bl3 || bl4 ? TDSType.NVARCHAR : TDSType.NTEXT;
                if (null != sQLCollation) break;
                sQLCollation = this.con.getDatabaseCollation();
            }
        }
        this.writeRPCNameValType(string, bl, tDSType);
        if (bl4) {
            this.writeVMaxHeader(n, bl2, sQLCollation);
            if (!bl2) {
                if (n > 0) {
                    this.writeInt(n);
                    this.writeBytes(byArray);
                }
                this.writeInt(0);
            }
        } else {
            if (bl3) {
                this.writeShort((short)8000);
            } else {
                this.writeInt(Integer.MAX_VALUE);
            }
            if (null != sQLCollation) {
                sQLCollation.writeCollation(this);
            }
            if (bl2) {
                this.writeShort((short)-1);
            } else {
                if (bl3) {
                    this.writeShort((short)n);
                } else {
                    this.writeInt(n);
                }
                if (0 != n) {
                    this.writeBytes(byArray);
                }
            }
        }
    }

    void writeRPCTimestamp(String string, Calendar calendar, boolean bl) throws SQLServerException {
        this.writeRPCNameValType(string, bl, TDSType.DATETIMEN);
        this.writeByte((byte)8);
        if (null == calendar) {
            this.writeByte((byte)0);
        } else {
            this.writeByte((byte)8);
            Util.writeTimestamp(calendar, this);
        }
    }

    void writeRPCInputStream(String string, InputStream inputStream, long l, boolean bl, JDBCType jDBCType, SQLCollation sQLCollation) throws SQLServerException {
        boolean bl2;
        assert (null != inputStream);
        assert (-1L == l || l >= 0L);
        boolean bl3 = bl2 = this.con.isYukonOrLater() && (-1L == l || l > 8000L);
        if (bl2) {
            assert (-1L == l || l <= Integer.MAX_VALUE);
            this.writeRPCNameValType(string, bl, jDBCType.isTextual() ? TDSType.BIGVARCHAR : TDSType.BIGVARBINARY);
            this.writeVMaxHeader(l, false, jDBCType.isTextual() ? sQLCollation : null);
        } else {
            boolean bl4;
            if (-1L == l) {
                Object object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8000);
                long l2 = 65535L * (long)this.con.getTDSPacketSize();
                try {
                    int n;
                    object = new byte[8000];
                    for (l = 0L; l < l2 && -1 != (n = inputStream.read((byte[])object, 0, ((byte[])object).length)); l += (long)n) {
                        byteArrayOutputStream.write((byte[])object);
                    }
                }
                catch (IOException iOException) {
                    SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
                }
                if (l >= l2) {
                    object = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
                    Object[] objectArray = new Object[]{l};
                    SQLServerException.makeFromDriverError(null, null, ((Format)object).format(objectArray), "", true);
                }
                assert (l <= Integer.MAX_VALUE);
                inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray(), 0, (int)l);
            }
            assert (0L <= l && l <= Integer.MAX_VALUE);
            boolean bl5 = bl4 = l <= 8000L;
            this.writeRPCNameValType(string, bl, jDBCType.isTextual() ? (bl4 ? TDSType.BIGVARCHAR : TDSType.TEXT) : (bl4 ? TDSType.BIGVARBINARY : TDSType.IMAGE));
            if (bl4) {
                this.writeShort((short)8000);
                if (jDBCType.isTextual()) {
                    sQLCollation.writeCollation(this);
                }
                this.writeShort((short)l);
            } else {
                this.writeInt(Integer.MAX_VALUE);
                if (jDBCType.isTextual()) {
                    sQLCollation.writeCollation(this);
                }
                this.writeInt((int)l);
            }
        }
        this.writeStream(inputStream, l, bl2);
    }

    void writeRPCReaderUnicode(String string, Reader reader, long l, boolean bl, SQLCollation sQLCollation) throws SQLServerException {
        boolean bl2;
        assert (null != reader);
        assert (-1L == l || l >= 0L);
        if (null == sQLCollation) {
            sQLCollation = this.con.getDatabaseCollation();
        }
        boolean bl3 = bl2 = this.con.isYukonOrLater() && (-1L == l || l > 4000L);
        if (bl2) {
            assert (-1L == l || l <= 0x3FFFFFFFL);
            this.writeRPCNameValType(string, bl, TDSType.NVARCHAR);
            this.writeVMaxHeader(-1L == l ? -1L : 2L * l, false, sQLCollation);
        } else {
            assert (0L <= l && l <= 0x3FFFFFFFL);
            boolean bl4 = l <= 4000L;
            this.writeRPCNameValType(string, bl, bl4 ? TDSType.NVARCHAR : TDSType.NTEXT);
            if (bl4) {
                this.writeShort((short)8000);
                sQLCollation.writeCollation(this);
                this.writeShort((short)(2L * l));
            } else {
                this.writeInt(0x3FFFFFFF);
                sQLCollation.writeCollation(this);
                this.writeInt((int)(2L * l));
            }
        }
        this.writeReader(reader, l, bl2);
    }
}

