/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.diagonalization;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.diagonalization.BiDiagonalization;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.BidiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.VectorFactory;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.stats.random.rng.multivariate.IID;
import com.numericalmethod.suanshu.stats.random.rng.univariate.RandomLongGenerator;
import com.numericalmethod.suanshu.stats.random.rng.univariate.uniform.UniformRNG;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BiDiagonalizationByGolubKahanLanczos
implements BiDiagonalization {
    private final int do;
    private BidiagonalMatrix long;
    private Matrix super;
    private final RandomLongGenerator char;
    private Matrix new;
    private final int const;
    private final double case;
    private final int false;
    private final Matrix enum;

    public BiDiagonalizationByGolubKahanLanczos(Matrix A2, double epsilon, RandomLongGenerator rlg) {
        this.enum = A2;
        this.do = A2.nRows();
        this.false = A2.nCols();
        this.const = Math.min(this.do, this.false);
        this.case = epsilon;
        this.char = rlg;
        if (MatrixPropertyUtils.isUpperBidiagonal(A2, epsilon)) {
            double[] a2 = VectorFactory.diagonal(A2).toArray();
            double[] a3 = this.false > 1 ? VectorFactory.superDiagonal(A2).toArray() : null;
            this.long = new BidiagonalMatrix(new double[][]{a3, a2});
            this.super = MatrixFactory.identity(this.do, this.do);
            this.new = MatrixFactory.identity(this.false, this.false);
        } else {
            this.do();
        }
    }

    @Override
    public Matrix V() {
        return this.new.deepCopy();
    }

    public BiDiagonalizationByGolubKahanLanczos(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2), new UniformRNG(1234567890L));
    }

    private Vector break() {
        BiDiagonalizationByGolubKahanLanczos a2;
        IID a3 = new IID(a2.char, a2.false);
        DenseVector a4 = new DenseVector(a3.nextVector());
        return a4.scaled(1.0 / a4.norm());
    }

    private Matrix byte(Vector[] a2, int a3) {
        BiDiagonalizationByGolubKahanLanczos a4;
        ArrayList<Vector> a5 = new ArrayList<Vector>(a4.false);
        for (int a6 = 1; a6 < a3; ++a6) {
            a5.add(a2[a6]);
        }
        a4.do(a5, a4.false);
        return MatrixFactory.cbind(a5);
    }

    private List<Vector> do(List<Vector> a2, int a3) {
        int a4 = a3 - a2.size();
        int a5 = 1;
        for (int a6 = 0; a6 < a4; ++a6) {
            boolean a7 = false;
            do {
                BiDiagonalizationByGolubKahanLanczos a8;
                Vector a9 = new DenseVector(a3);
                a9.set(a5++, 1.0);
                for (Vector a10 : a2) {
                    a9 = a9.minus(a10.scaled(a9.innerProduct(a10)));
                }
                if (DoubleUtils.isZero(a9.norm(), a8.case)) continue;
                a9 = a9.scaled(1.0 / a9.norm());
                a2.add(a9);
                a7 = true;
            } while (!a7 && a5 <= a3);
            if (a7) continue;
            throw new RuntimeException(String.format("failed to complete space of dimension %d", a3));
        }
        return a2;
    }

    @Override
    public Matrix U() {
        return this.super.deepCopy();
    }

    @Override
    public BidiagonalMatrix B() {
        return this.long.deepCopy();
    }

    private Matrix break(Vector[] a2, int a3) {
        BiDiagonalizationByGolubKahanLanczos a4;
        ArrayList<Vector> a5 = new ArrayList<Vector>(a4.do);
        for (int a6 = 1; a6 < a3; ++a6) {
            a5.add(a2[a6]);
        }
        a4.do(a5, a4.do);
        return MatrixFactory.cbind(a5);
    }

    public BiDiagonalizationByGolubKahanLanczos(Matrix A2, RandomLongGenerator rlg) {
        this(A2, PrecisionUtils.autoEpsilon(A2), rlg);
    }

    private void do(Vector[] a2, int a3) {
        for (int a4 = 1; a4 < a3; ++a4) {
            a2[a3] = a2[a3].minus(a2[a4].scaled(a2[a3].innerProduct(a2[a4])));
        }
    }

    private void do() {
        int a2;
        BiDiagonalizationByGolubKahanLanczos a3;
        Matrix a4 = a3.enum.t();
        Vector[] a5 = new Vector[a3.const + 1];
        Vector[] a6 = new Vector[a3.const + 2];
        a5[0] = new DenseVector(a3.do);
        a6[1] = a3.break();
        double[] a7 = new double[a3.const + 1];
        double[] a8 = new double[a3.const + 1];
        a7[0] = 0.0;
        boolean a9 = false;
        boolean a10 = false;
        for (a2 = 1; a2 <= a3.const; ++a2) {
            a5[a2] = a3.enum.multiply(a6[a2]).minus(a5[a2 - 1].scaled(a7[a2 - 1]));
            double a11 = a5[a2].norm();
            if (DoubleUtils.isZero(a11, a3.case)) {
                a9 = true;
                break;
            }
            a3.do(a5, a2);
            a8[a2] = a5[a2].norm();
            a5[a2] = a5[a2].scaled(1.0 / a8[a2]);
            a6[a2 + 1] = a4.multiply(a5[a2]).minus(a6[a2].scaled(a8[a2]));
            double a12 = a6[a2 + 1].norm();
            if (DoubleUtils.isZero(a12, a3.case)) {
                a10 = true;
                break;
            }
            a3.do(a6, a2 + 1);
            a7[a2] = a6[a2 + 1].norm();
            a6[a2 + 1] = a6[a2 + 1].scaled(1.0 / a7[a2]);
        }
        double[] a13 = Arrays.copyOfRange(a7, 1, a3.const);
        double[] a14 = Arrays.copyOfRange(a8, 1, a3.const + 1);
        a3.long = new BidiagonalMatrix(new double[][]{a13, a14});
        a3.super = a3.break(a5, a9 ? a2 : (a10 ? a2 + 1 : a2));
        a3.new = a3.byte(a6, a9 || a10 ? a2 + 1 : a2);
    }
}

