/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.diagonalization;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.ImmutableMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.Hessenberg;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.SubMatrixRef;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder.HouseholderContext;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder.HouseholderInPlace;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.SubVectorRef;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SymmetricTridiagonalDecomposition {
    private volatile Matrix const = null;
    private final int case;
    private final HouseholderContext[] false;
    private final TridiagonalMatrix enum;

    public SymmetricTridiagonalDecomposition(Matrix A2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "symmetric tridiagonal decomposition algorithm applies only to square matrix", new Object[0]);
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(A2, 0.0), "symmetric tridiagonal decomposition algorithm applies only to symmetric matrix", new Object[0]);
        int a2 = this.case = A2.nRows();
        if (Hessenberg.isHessenberg(A2, 0.0)) {
            this.enum = new TridiagonalMatrix(A2);
            this.const = A2.ONE();
            this.false = null;
            return;
        }
        this.enum = new TridiagonalMatrix(a2);
        DenseMatrix a3 = new DenseMatrix(A2);
        this.false = new HouseholderContext[a2 - 1];
        for (int a4 = 1; a4 <= a2 - 2; ++a4) {
            HouseholderContext a5;
            this.enum.set(a4, a4, a3.get(a4, a4));
            SubVectorRef a6 = new SubVectorRef(a3.getColumn(a4), a4 + 1, a2);
            this.false[a4] = a5 = HouseholderContext.getContext(a6);
            if (a5.lambda == 0.0) continue;
            Vector a7 = a5.v;
            double a8 = a5.beta;
            SubMatrixRef a9 = new SubMatrixRef(a3, a4 + 1, a2, a4 + 1, a2);
            Vector a10 = a9.multiply(a7).scaled(a8);
            double a11 = a8 / 2.0 * a7.innerProduct(a10);
            Vector a12 = a10.minus(a7.scaled(a11));
            this.enum.set(a4 + 1, a4, a5.lambda);
            this.enum.set(a4, a4 + 1, a5.lambda);
            SymmetricTridiagonalDecomposition.do(a3, a4, a7, a12);
        }
        this.enum.set(a2 - 1, a2 - 1, a3.get(a2 - 1, a2 - 1));
        double a13 = a3.get(a2 - 1, a2);
        this.enum.set(a2 - 1, a2, a13);
        this.enum.set(a2, a2 - 1, a13);
        this.enum.set(a2, a2, a3.get(a2, a2));
    }

    private static void do(final DenseMatrix a2, final int a3, final Vector a4, final Vector a5) {
        final int a6 = a2.nRows();
        try {
            ParallelExecutor.getSharedInstance().forLoop(a3 + 1, a6 + 1, new LoopBody(){

                @Override
                public void run(int i) throws Exception {
                    int a22 = i - a3;
                    int a32 = 1;
                    for (int a42 = a3 + 1; a42 <= a6; ++a42) {
                        double a52 = a2.get(i, a42) - a4.get(a22) * a5.get(a32) - a4.get(a32) * a5.get(a22);
                        a2.set(i, a42, a52);
                        ++a32;
                    }
                }
                {
                    1 a22;
                }
            });
        }
        catch (MultipleExecutionException a7) {
            throw new RuntimeException("error during rank-2 update", a7);
        }
    }

    public Matrix Q() {
        if (this.const == null) {
            this.const = this.do();
        }
        return new ImmutableMatrix(this.const);
    }

    private Matrix do() {
        SymmetricTridiagonalDecomposition a2;
        HouseholderInPlace a3 = new HouseholderInPlace(a2.case, a2.case);
        for (int a4 = a2.case - 2; a4 >= 1; --a4) {
            HouseholderInPlace.Householder a5 = HouseholderInPlace.Householder.fromContext(a2.false[a4], a4 + 1);
            a3.reflect(a5, a4 + 1, a2.case);
        }
        return a3.getTransformedMatrix();
    }

    public TridiagonalMatrix T() {
        return this.enum.deepCopy();
    }
}

