/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.Spectrum;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import com.numericalmethod.suanshu.analysis.function.polynomial.Polynomial;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.PolyRoot;
import com.numericalmethod.suanshu.analysis.function.polynomial.root.QuadraticRoot;
import com.numericalmethod.suanshu.misc.Constants;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CharacteristicPolynomial
implements Spectrum {
    private final Matrix false;
    private final Polynomial enum;

    public String toString() {
        return this.enum.toString();
    }

    public List<Number> getEigenvalues() {
        ArrayList<Number> a2 = new ArrayList<Number>();
        switch (this.false.nRows()) {
            case 1: {
                a2.add(new Double(this.false.get(1, 1)));
                break;
            }
            case 2: {
                QuadraticRoot a3 = new QuadraticRoot();
                double[] a4 = this.enum.getCoefficients();
                double a5 = a4[1];
                double a6 = a4[2];
                double a7 = Math.min(Math.abs(a5), Math.abs(a6)) * Math.sqrt(2.0) * Constants.EPSILON * 10.0;
                List<Number> a8 = a3.solve(this.enum, a7);
                a2.addAll(a8);
                break;
            }
            case 3: 
            case 4: {
                a2.addAll(new PolyRoot().solve(this.enum));
                break;
            }
            default: {
                throw new IllegalArgumentException("by Abel-Ruffini theorem, a general polynomial of order n\u2008>\u20084 cannot be solved by a finite sequence of arithmetic operations and radicals");
            }
        }
        return a2;
    }

    public Polynomial getCharacteristicPolynomial() {
        switch (this.false.nRows()) {
            case 1: {
                return new Polynomial(1.0, -this.false.get(1, 1));
            }
            case 2: {
                return new Polynomial(1.0, -MatrixMeasure.tr(this.false), MatrixMeasure.det(this.false));
            }
            case 3: {
                return null;
            }
            case 4: {
                return null;
            }
        }
        return null;
    }

    public CharacteristicPolynomial(Matrix A2) {
        if (!DimensionCheck.isSquare(A2)) {
            throw new IllegalArgumentException("Eigenvalue decomposition applies only to square matrix");
        }
        this.false = A2;
        this.enum = this.getCharacteristicPolynomial();
    }
}

