/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.CharacteristicPolynomial;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.ComplexEigenvalueComparator;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.EigenProperty;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.EigenvectorByLookup;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.EigenvectorBySystemOfEquations;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.EigenvectorProvider;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.RealEigenvalueComparator;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.Spectrum;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.mr3.SymmetricEigenByMR3;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.QRAlgorithm;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.SymmetricQRAlgorithm;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.number.DoubleUtils;
import com.numericalmethod.suanshu.number.NumberUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Eigen
implements Spectrum {
    private final boolean case;
    private final double false;
    private final SortedMap<Number, EigenProperty> enum;

    public Eigen(Matrix A2, double epsilon) {
        this(A2, Method.QR, epsilon);
    }

    private Map.Entry<Number, EigenProperty> do(int a2) {
        Eigen a3;
        Iterator<Map.Entry<Number, EigenProperty>> a4 = a3.enum.entrySet().iterator();
        for (int a5 = 0; a5 < a2; ++a5) {
            a4.next();
        }
        return a4.next();
    }

    public int size() {
        return this.enum.size();
    }

    public Number getEigenvalue(int i) {
        return this.do(i).getKey();
    }

    private static boolean do(List<Number> a2) {
        for (Number a3 : a2) {
            if (NumberUtils.isReal(a3)) continue;
            return false;
        }
        return true;
    }

    public Eigen(Matrix A2, Method method) {
        this(A2, method, PrecisionUtils.autoEpsilon(A2));
    }

    public double[] getRealEigenvalues() {
        if (this.case) {
            return DoubleUtils.collection2DoubleArray(this.enum.keySet());
        }
        ArrayList<Number> a2 = new ArrayList<Number>();
        for (Number a3 : this.enum.keySet()) {
            if (!NumberUtils.isReal(a3)) continue;
            a2.add(a3);
        }
        Collections.sort(a2, new RealEigenvalueComparator(this.false));
        return DoubleUtils.collection2DoubleArray(a2);
    }

    public Eigen(Matrix A2, Method method, double epsilon) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "eigen decomposition applies only to square matrix", new Object[0]);
        EigenProvider a2 = method.newProvider(A2, epsilon);
        Spectrum a3 = a2.getSpectrum();
        List<Number> a4 = a3.getEigenvalues();
        this.case = Eigen.do(a4);
        Comparator<Number> a5 = this.case ? new RealEigenvalueComparator(epsilon) : new ComplexEigenvalueComparator(epsilon);
        TreeMap<Number, Integer> a6 = new TreeMap<Number, Integer>(a5);
        for (Number a7 : a4) {
            Integer a8 = (Integer)a6.get(a7);
            if (a8 == null) {
                a8 = 0;
            }
            a6.put(a7, a8 + 1);
        }
        this.enum = new TreeMap<Number, EigenProperty>(a5);
        for (Number a7 : a4) {
            this.enum.put(a7, new EigenProperty(a7, (Integer)a6.get(a7), a2.getEigenvectorProvider()));
        }
        this.false = epsilon;
    }

    public EigenProperty getProperty(int i) {
        return this.do(i).getValue();
    }

    public EigenProperty getProperty(Number eigenvalue) {
        return (EigenProperty)this.enum.get(eigenvalue);
    }

    public Eigen(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2));
    }

    public List<Number> getEigenvalues() {
        ArrayList<Number> a2 = new ArrayList<Number>(this.enum.keySet());
        return a2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Method {
        CHARACTERISTIC_POLYNOMIAL{

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                1 a4;
                return new EigenProvider(){
                    private final EigenvectorProvider false;
                    private final Spectrum enum;

                    @Override
                    public Spectrum getSpectrum() {
                        return this.enum;
                    }
                    {
                        Method.1 a22;
                        a22.enum = new CharacteristicPolynomial(a22.a2);
                        a22.false = new EigenvectorBySystemOfEquations(a22.a2, a22.a3);
                    }

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.false;
                    }
                };
            }
            {
                1 a2;
            }
        }
        ,
        MR3{

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                2 a4;
                return new EigenProvider(){
                    private final EigenvectorProvider false;
                    private final SymmetricEigenByMR3 enum;

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.false;
                    }

                    @Override
                    public Spectrum getSpectrum() {
                        return this.enum;
                    }
                    {
                        Method.1 a22;
                        a22.enum = new SymmetricEigenByMR3(a22.a2, true, a22.a3);
                        a22.false = new EigenvectorByLookup(a22.enum.getEigenvalues(), new EigenvectorByLookup.EigenvectorListProvider(){
                            {
                                Method.1 a2;
                            }

                            @Override
                            public List<Vector> getAllEigenvectors() {
                                return enum.getEigenvectors();
                            }
                        }, a22.a3);
                    }
                };
            }
            {
                2 a2;
            }
        }
        ,
        QR_SYMMETRIC{
            {
                3 a2;
            }

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                3 a4;
                return new EigenProvider(){
                    private final EigenvectorProvider false;
                    private final SymmetricQRAlgorithm enum;

                    @Override
                    public Spectrum getSpectrum() {
                        return this.enum;
                    }
                    {
                        Method.1 a22;
                        a22.enum = new SymmetricQRAlgorithm(a22.a2, a22.a3);
                        a22.false = new EigenvectorByLookup(a22.enum.getEigenvalues(), new EigenvectorByLookup.EigenvectorListProvider(){

                            @Override
                            public List<Vector> getAllEigenvectors() {
                                return enum.getEigenvectors();
                            }
                            {
                                Method.1 a2;
                            }
                        }, a22.a3);
                    }

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.false;
                    }
                };
            }
        }
        ,
        SYMMETRY{
            {
                4 a2;
            }

            @Override
            EigenProvider newProvider(Matrix a2, double a3) {
                return MR3.newProvider(a2, a3);
            }
        }
        ,
        QR{

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                5 a4;
                if (MatrixPropertyUtils.isSymmetric(a2, 0.0)) {
                    Matrix a5 = a2 instanceof SymmetricMatrix ? a2 : new SymmetricMatrix(a2, true);
                    return QR_SYMMETRIC.newProvider(a5, a3);
                }
                return new EigenProvider(){
                    private final EigenvectorProvider false;
                    private final Spectrum enum;

                    @Override
                    public Spectrum getSpectrum() {
                        return this.enum;
                    }
                    {
                        Method.1 a22;
                        a22.enum = new QRAlgorithm(a22.a2, a22.a3);
                        a22.false = new EigenvectorBySystemOfEquations(a22.a2, a22.a3);
                    }

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.false;
                    }
                };
            }
            {
                5 a2;
            }
        };


        abstract EigenProvider newProvider(Matrix var1, double var2);

        private Method() {
            Method a2;
        }
    }

    private static interface EigenProvider {
        public EigenvectorProvider getEigenvectorProvider();

        public Spectrum getSpectrum();
    }
}

