/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.EigenProperty;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EigenDecomposition {
    private final Eigen false;
    private final int enum;

    public EigenDecomposition(Matrix A2, double epsilon) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "eigen decomposition applies only to square matrices", new Object[0]);
        this.enum = A2.nRows();
        Eigen.Method a2 = MatrixPropertyUtils.isSymmetric(A2, epsilon) ? Eigen.Method.MR3 : Eigen.Method.QR;
        this.false = new Eigen(A2, a2, epsilon);
    }

    public DiagonalMatrix D() {
        double[] a2 = new double[this.enum];
        int a3 = 0;
        for (int a4 = 0; a4 < this.false.size(); ++a4) {
            EigenProperty a5 = this.false.getProperty(a4);
            for (int a6 = 0; a6 < a5.algebraicMultiplicity(); ++a6) {
                a2[a3++] = a5.eigenvalue().doubleValue();
            }
        }
        return new DiagonalMatrix(a2);
    }

    public Matrix Qt() {
        return this.Q().t();
    }

    public EigenDecomposition(Matrix A2) {
        this(A2, 1000.0 * PrecisionUtils.autoEpsilon(A2));
    }

    public Matrix Q() {
        ArrayList<Vector> a2 = new ArrayList<Vector>();
        for (int a3 = 0; a3 < this.false.size(); ++a3) {
            EigenProperty a4 = this.false.getProperty(a3);
            a2.addAll(a4.eigenbasis());
        }
        return MatrixFactory.cbind(a2);
    }
}

