/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.CharacteristicPolynomial;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.Spectrum;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.EigenvalueExtracter;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.Hessenberg;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.HessenbergReduction4AsymmetricMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.QRAlgorithmSkeleton;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.eigen.qr.SchurTransformation4HessenbergMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QRAlgorithm
implements Spectrum {
    private final QRAlgorithmSkeleton.Result enum;

    public Matrix T() {
        return this.enum.T().deepCopy();
    }

    public List<Matrix> Qs() {
        SchurTransformation4HessenbergMatrix.SchurDecomposition4HessenbergMatrix a2 = (SchurTransformation4HessenbergMatrix.SchurDecomposition4HessenbergMatrix)this.enum.getRealSchurCanonicalFormDecomposition();
        return a2.Qs();
    }

    public QRAlgorithm(Matrix A2, double epsilon) {
        this(A2, epsilon, Integer.MAX_VALUE);
    }

    public QRAlgorithm(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2), Integer.MAX_VALUE);
    }

    public QRAlgorithm(Matrix A2, final double epsilon, int maxIterations) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "Eigenvalue decomposition applies only to square matrix", new Object[0]);
        QRAlgorithmSkeleton a2 = new QRAlgorithmSkeleton(new HessenbergReduction4AsymmetricMatrix(), new SchurTransformation4HessenbergMatrix(epsilon, maxIterations), new EigenvalueExtracter(){
            {
                1 a2;
            }

            @Override
            public List<? extends Number> extract(Matrix T2) {
                int a2 = T2.nRows();
                ArrayList<Number> a3 = new ArrayList<Number>(a2);
                Hessenberg a4 = new Hessenberg();
                int a5 = 1;
                while (a5 <= a2) {
                    Matrix a6;
                    if (a5 == a2 || a4.deflationCriterion.isNegligible(T2, a5 + 1, a5, epsilon)) {
                        a6 = MatrixFactory.subMatrix(T2, a5, a5, a5, a5);
                        ++a5;
                    } else {
                        a6 = MatrixFactory.subMatrix(T2, a5, a5 + 1, a5, a5 + 1);
                        a5 += 2;
                    }
                    CharacteristicPolynomial a7 = new CharacteristicPolynomial(a6);
                    List<Number> a8 = a7.getEigenvalues();
                    a3.addAll(a8);
                }
                return a3;
            }
        });
        this.enum = a2.process(A2);
    }

    public Matrix Q() {
        return this.enum.Q().deepCopy();
    }

    public List<Vector> getEigenVectors() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public List<Number> getEigenvalues() {
        List<Number> a2 = this.enum.getEigenvalues();
        return a2;
    }
}

