/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.qr;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.qr.QRDecomposition;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixFactory;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.Basis;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.Projection;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GramSchmidt
implements QRDecomposition {
    private PermutationMatrix long;
    private final int super;
    private Matrix char;
    private final int new;
    private UpperTriangularMatrix const;
    private final double case;
    private int false;
    private final DenseVector enum;

    @Override
    public Matrix Q() {
        return this.char.deepCopy();
    }

    @Override
    public UpperTriangularMatrix R() {
        return new UpperTriangularMatrix(this.const);
    }

    @Override
    public PermutationMatrix P() {
        return new PermutationMatrix(this.long);
    }

    public GramSchmidt(Matrix A2) {
        this(A2, true, PrecisionUtils.autoEpsilon(A2));
    }

    public GramSchmidt(Matrix A2, boolean pad0Cols, double epsilon) {
        this.new = A2.nRows();
        this.super = A2.nCols();
        this.case = epsilon;
        this.const = new UpperTriangularMatrix(this.super);
        this.const.set(1, 1, 0.0);
        this.long = new PermutationMatrix(this.super);
        this.false = 0;
        this.enum = new DenseVector(this.new);
        Vector[] a2 = new Vector[this.super];
        a2[0] = new DenseVector(this.new);
        for (int a3 = 1; a3 <= this.super; ++a3) {
            Vector a4 = A2.getColumn(a3);
            for (int a5 = 1; a5 <= 2; ++a5) {
                for (int a6 = 1; a6 <= a3 - 1; ++a6) {
                    if (a2[a6 - 1] == null) continue;
                    Projection a7 = new Projection(a4, a2[a6 - 1]);
                    a4 = a7.getOrthogonalVector();
                    this.const.set(a6, a3, a7.getProjectionLength(0) + this.const.get(a6, a3));
                }
            }
            if (!MatrixPropertyUtils.isZero(a4, epsilon)) {
                double a8 = a4.norm();
                this.const.set(a3, a3, a8);
                a2[a3 - 1] = a4.scaled(1.0 / a8);
                ++this.false;
                continue;
            }
            if (pad0Cols) {
                a2[a3 - 1] = this.enum;
            }
            this.const.set(a3, a3, 0.0);
            this.long.moveColumn2End(a3);
        }
        this.char = MatrixFactory.cbind(a2);
    }

    @Override
    public int rank() {
        return this.false;
    }

    @Override
    public Matrix tallR() {
        UpperTriangularMatrix a2 = this.R();
        if (this.new < this.super) {
            return MatrixFactory.subMatrix(a2, 1, this.new, 1, this.super);
        }
        Matrix a3 = new DenseMatrix(this.new, this.super).ZERO();
        MatrixFactory.replaceInPlace(a3, 1, Math.min(this.super, this.new), 1, this.super, a2);
        return a3;
    }

    @Override
    public Matrix squareQ() {
        if (this.char.nRows() == this.false) {
            if (this.char.nCols() <= this.char.nRows()) {
                return this.Q();
            }
            Matrix a2 = MatrixFactory.subMatrix(this.char, 1, this.new, 1, this.new);
            return a2;
        }
        if (this.char.nCols() > this.char.nRows()) {
            Matrix a3 = MatrixFactory.subMatrix(this.char, 1, this.new, 1, this.new);
            return a3;
        }
        ArrayList<Vector> a4 = new ArrayList<Vector>();
        for (int a5 = 1; a5 <= this.false; ++a5) {
            a4.add(this.char.getColumn(a5));
        }
        List<Vector> a6 = Basis.getBasis(this.new, this.new);
        a4.addAll(a6);
        Matrix a7 = MatrixFactory.cbind(a4);
        GramSchmidt a8 = new GramSchmidt(a7, false, this.case);
        Matrix a9 = a8.Q();
        a9 = MatrixFactory.subMatrix(a9, 1, this.new, 1, this.new);
        return a9;
    }
}

