/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.qr;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.qr.QRDecomposition;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder.Householder4SubVector;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder.Householder4ZeroGenerator;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder.HouseholderContext;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder.HouseholderInPlace;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.householder.HouseholderReflection;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HouseholderQR
implements QRDecomposition {
    private final double new;
    private final HouseholderInPlace const;
    private final int case;
    private final HouseholderInPlace.Householder[] false;
    private final int enum;

    public HouseholderQR(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2));
    }

    @Override
    public Matrix Q() {
        HouseholderInPlace a2 = new HouseholderInPlace(this.enum, this.case);
        for (int a3 = this.false.length - 1; a3 >= 0; --a3) {
            a2.reflect(this.false[a3], a3 + 1, this.case);
        }
        return a2.getTransformedMatrix();
    }

    @Override
    public UpperTriangularMatrix R() {
        Matrix a2 = this.const.getTransformedMatrix();
        double[][] a3 = new double[this.case][];
        for (int a4 = 1; a4 <= this.case; ++a4) {
            double[] a5 = new double[this.case - a4 + 1];
            int a6 = a4;
            int a7 = 0;
            while (a6 <= this.case) {
                a5[a7] = a2.get(a4, a6);
                ++a6;
                ++a7;
            }
            a3[a4 - 1] = a5;
        }
        return new UpperTriangularMatrix(a3);
    }

    @Override
    public int rank() {
        int a2 = 0;
        for (int a3 = 1; a3 <= this.case; ++a3) {
            if (DoubleUtils.isZero(this.const.get(a3, a3), this.new)) continue;
            ++a2;
        }
        return a2;
    }

    public HouseholderReflection[] getHouseholderMatrices() {
        HouseholderReflection[] a2 = new HouseholderReflection[this.false.length];
        for (int a3 = 0; a3 < this.false.length; ++a3) {
            HouseholderContext a4 = HouseholderInPlace.Householder.toContext(this.false[a3]);
            a2[a3] = DoubleUtils.isZero(a4.lambda, this.new) ? new Householder4ZeroGenerator(this.enum) : new Householder4SubVector(this.enum, a4);
        }
        return a2;
    }

    @Override
    public PermutationMatrix P() {
        return new PermutationMatrix(this.case);
    }

    @Override
    public Matrix squareQ() {
        return this.const.U().t();
    }

    @Override
    public Matrix tallR() {
        return this.const.getTransformedMatrix();
    }

    public HouseholderQR(Matrix A2, double epsilon) {
        this.enum = A2.nRows();
        this.case = A2.nCols();
        ArgumentAssertion.assertTrue(this.enum >= this.case, "QR decomposition by Householder Reflection applies to matrix where the number of rows >= the number of columns", new Object[0]);
        this.new = epsilon;
        this.const = new HouseholderInPlace(A2, epsilon);
        int a2 = Math.min(this.case, this.enum - 1);
        ArrayList<HouseholderInPlace.Householder> a3 = new ArrayList<HouseholderInPlace.Householder>(a2);
        for (int a4 = 1; a4 <= a2; ++a4) {
            HouseholderInPlace.Householder a5 = this.const.generateAndReflectColumns(a4, this.case, a4, this.enum);
            a3.add(a5);
        }
        this.false = a3.toArray(new HouseholderInPlace.Householder[a2]);
    }
}

