/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle;

import com.numericalmethod.suanshu.algebra.linear.matrix.MatrixSingularityException;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.triangle.LUDecomposition;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.PermutationMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.operation.MatrixUtils;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.misc.datastructure.DimensionCheck;
import com.numericalmethod.suanshu.misc.parallel.LoopBody;
import com.numericalmethod.suanshu.misc.parallel.MultipleExecutionException;
import com.numericalmethod.suanshu.misc.parallel.ParallelExecutor;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Doolittle
implements LUDecomposition {
    private final LowerTriangularMatrix super;
    private final UpperTriangularMatrix char;
    private static final int new = 100;
    private final double const;
    private final boolean case;
    private final PermutationMatrix false;
    private static final ParallelExecutor enum = ParallelExecutor.getSharedInstance();

    private int do(double[][] a2, double[] a3, int a4, int a5) {
        int a6;
        int a7 = a6 = a5;
        double a8 = Double.NEGATIVE_INFINITY;
        for (int a9 = a6; a9 < a4; ++a9) {
            double a10 = a3[a9] * Math.abs(a2[a9][a6]);
            if (!(a10 > a8)) continue;
            a8 = a10;
            a7 = a9;
        }
        return a7;
    }

    @Override
    public UpperTriangularMatrix U() {
        return this.char.deepCopy();
    }

    public Doolittle(Matrix A2, double epsilon) {
        this(A2, true, epsilon);
    }

    public Doolittle(Matrix A2, boolean usePivoting) {
        this(A2, usePivoting, PrecisionUtils.autoEpsilon(A2));
    }

    @Override
    public LowerTriangularMatrix L() {
        return this.super.deepCopy();
    }

    @Override
    public PermutationMatrix P() {
        return this.false.deepCopy();
    }

    public Doolittle(Matrix A2) {
        this(A2, true);
    }

    private void do(double[][] a2, int a3, int a4, int a5) {
        for (int a6 = 0; a6 < a3; ++a6) {
            double a7 = a2[a5][a6];
            a2[a5][a6] = a2[a4][a6];
            a2[a4][a6] = a7;
        }
    }

    public Doolittle(Matrix A2, boolean usePivoting, double epsilon) {
        int a2;
        if (!DimensionCheck.isSquare(A2)) {
            throw new IllegalArgumentException("the LU decomposition applies to square matrix only");
        }
        this.case = usePivoting;
        this.const = epsilon;
        int a3 = A2.nRows();
        double[][] a4 = MatrixUtils.to2DArray(A2);
        int[] a5 = this.do(a4);
        double[][] a6 = new double[a3][];
        for (int a7 = 0; a7 < a3; ++a7) {
            a6[a7] = Arrays.copyOf(a4[a7], a7 + 1);
            a6[a7][a7] = 1.0;
        }
        this.super = new LowerTriangularMatrix(a6);
        double[][] a8 = new double[a3][];
        for (a2 = 0; a2 < a3; ++a2) {
            a8[a2] = Arrays.copyOfRange(a4[a2], a2, a3);
        }
        this.char = new UpperTriangularMatrix(a8);
        this.false = new PermutationMatrix(a3);
        for (a2 = 0; a2 < a3; ++a2) {
            if (a2 == a5[a2]) continue;
            this.false.swapRow(a2 + 1, a5[a2] + 1);
        }
    }

    private int[] do(final double[][] a2) {
        final int a3 = a2.length;
        int[] a4 = new int[a3];
        final double[] a5 = new double[a3];
        try {
            Doolittle a6;
            enum.conditionalForLoop(a3 >= 100, 0, a3, new LoopBody(){

                @Override
                public void run(int i) throws Exception {
                    double a22 = 0.0;
                    for (int a32 = 0; a32 < a3; ++a32) {
                        double a4 = Math.abs(a2[i][a32]);
                        if (!(a4 > a22)) continue;
                        a22 = a4;
                    }
                    a5[i] = DoubleUtils.compare(a22, 0.0, Doolittle.this.const) == 0 ? 1.0 : 1.0 / a22;
                }
                {
                    1 a22;
                }
            });
            for (int a7 = 0; a7 < a3; ++a7) {
                int a8;
                int n = a8 = a6.case ? a6.do(a2, a5, a3, a7) : a7;
                if (a7 != a8) {
                    a6.do(a2, a3, a7, a8);
                    a5[a8] = a5[a7];
                }
                a4[a7] = a8;
                final double a9 = a2[a7][a7];
                final boolean a10 = DoubleUtils.compare(a9, 0.0, a6.const) == 0;
                final int a11 = a7;
                enum.conditionalForLoop(a3 - a7 >= 100, a7 + 1, a3, new LoopBody(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run(int i) throws Exception {
                        if (a10) {
                            if (DoubleUtils.compare(a2[i][a11], 0.0, Doolittle.this.const) != 0) throw new MatrixSingularityException(String.format("singularity detected during the LU decomposition: column %d is almost zero (or try a bigger epsilon)", a11));
                            a2[i][a11] = 1.0;
                        } else {
                            double[] dArray = a2[i];
                            int n = a11;
                            dArray[n] = dArray[n] / a9;
                        }
                        double a22 = a2[i][a11];
                        for (int a32 = a11 + 1; a32 < a3; ++a32) {
                            double[] dArray = a2[i];
                            int n = a32;
                            dArray[n] = dArray[n] - a22 * a2[a11][a32];
                        }
                    }
                    {
                        2 a22;
                    }
                });
            }
        }
        catch (MultipleExecutionException a12) {
            for (ExecutionException a13 : a12.getExceptions()) {
                if (a13 == null || !(a13.getCause() instanceof MatrixSingularityException)) continue;
                throw (MatrixSingularityException)a13.getCause();
            }
            throw new RuntimeException("error occurred during LU decomposition", a12);
        }
        return a4;
    }
}

