/*
 * Decompiled with CFR 0.152.
 */
package com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem;

import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.Matrix;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.factorization.svd.SVD;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.Kernel;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import com.numericalmethod.suanshu.algebra.linear.matrix.doubles.linearsystem.LUSolver;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.Vector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.dense.DenseVector;
import com.numericalmethod.suanshu.algebra.linear.vector.doubles.operation.VectorFactory;
import com.numericalmethod.suanshu.misc.ArgumentAssertion;
import com.numericalmethod.suanshu.misc.PrecisionUtils;
import com.numericalmethod.suanshu.number.DoubleUtils;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LinearSystemSolver {
    private final double enum;

    public Solution solve(final Matrix A0) {
        return new Solution(){
            SVD svd;
            Matrix A;
            Kernel nullspace;
            boolean isFullRank;
            List<Vector> basis;
            Matrix U;
            Matrix T;
            {
                1 a2;
                a2.A = a2.A0;
                a2.svd = null;
                if (a2.A0.nRows() > a2.A0.nCols()) {
                    a2.svd = new SVD(a2.A, true, PrecisionUtils.autoEpsilon(a2.A), SVD.Method.GOLUB_KAHAN);
                    a2.A = a2.svd.D().multiply(a2.svd.V().t());
                }
                ArgumentAssertion.assertTrue(a2.A.nRows() <= a2.A.nCols(), "Ax = b is an over-determined system. Please consider using the OLS method", new Object[0]);
                a2.nullspace = new Kernel(a2.A, Kernel.Method.QR, a2.LinearSystemSolver.this.enum);
                a2.isFullRank = a2.nullspace.isZero();
                a2.basis = a2.nullspace.basis();
                a2.T = a2.nullspace.T();
                a2.U = a2.nullspace.U();
            }

            @Override
            public List<Vector> getHomogeneousSoln() {
                return Collections.unmodifiableList(this.basis);
            }

            @Override
            public Vector getParticularSolution(Vector b2) {
                Vector a2;
                Vector a3 = b2;
                if (this.svd != null) {
                    a3 = this.svd.Ut().multiply(b2);
                }
                ArgumentAssertion.assertEqual(this.A.nRows(), a3.size(), "A's dimension ", "b's length (after row reduction)");
                if (this.isFullRank) {
                    LUSolver a4 = new LUSolver();
                    a2 = a4.solve(new LSProblem(this.A, a3));
                } else if (MatrixPropertyUtils.isZero(a3, LinearSystemSolver.this.enum)) {
                    a2 = new DenseVector(this.A.nCols()).ZERO();
                } else {
                    a2 = this.T.multiply(a3);
                    for (int a5 = 1; a5 <= a2.size(); ++a5) {
                        if (!MatrixPropertyUtils.isZero(this.U.getRow(a5), LinearSystemSolver.this.enum) || DoubleUtils.compare(a2.get(a5), 0.0, LinearSystemSolver.this.enum) == 0) continue;
                        throw new NoSolution("the system of linear equation is inconsistent");
                    }
                    if (this.A.nCols() > a2.size()) {
                        a2 = VectorFactory.concat(a2, new DenseVector(DoubleUtils.rep(0.0, this.A.nCols() - a2.size())));
                    }
                }
                return a2;
            }
        };
    }

    public LinearSystemSolver(double epsilon) {
        this.enum = epsilon;
    }

    public static interface Solution {
        public List<Vector> getHomogeneousSoln();

        public Vector getParticularSolution(Vector var1);
    }

    public static class NoSolution
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NoSolution(String msg) {
            super(msg);
        }
    }
}

